/*
 * Decompiled with CFR 0.152.
 */
package com.menecats.polybool.models.geojson;

import java.util.List;

public abstract class Geometry<T> {
    private T coordinates;

    protected Geometry(T coordinates) {
        this.setCoordinates(coordinates);
    }

    public abstract String getType();

    public T getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(T coordinates) {
        this.coordinates = coordinates;
    }

    public static final class MultiPolygonGeometry
    extends Geometry<List<List<List<double[]>>>> {
        public MultiPolygonGeometry() {
            this(null);
        }

        public MultiPolygonGeometry(List<List<List<double[]>>> coordinates) {
            super(coordinates);
        }

        @Override
        public String getType() {
            return "MultiPolygon";
        }
    }

    public static final class PolygonGeometry
    extends Geometry<List<List<double[]>>> {
        public PolygonGeometry() {
            this(null);
        }

        public PolygonGeometry(List<List<double[]>> coordinates) {
            super(coordinates);
        }

        @Override
        public String getType() {
            return "Polygon";
        }
    }
}

