/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.bitmap;

import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.bitmap.WrappedBitSetBitmap;
import com.metamx.collections.bitmap.WrappedImmutableBitSetBitmap;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class BitSetBitmapFactory
implements BitmapFactory {
    @Override
    public MutableBitmap makeEmptyMutableBitmap() {
        return new WrappedBitSetBitmap();
    }

    @Override
    public ImmutableBitmap makeEmptyImmutableBitmap() {
        return this.makeEmptyMutableBitmap();
    }

    @Override
    public ImmutableBitmap makeImmutableBitmap(MutableBitmap mutableBitmap) {
        return mutableBitmap;
    }

    @Override
    public ImmutableBitmap mapImmutableBitmap(ByteBuffer b) {
        return new WrappedBitSetBitmap(BitSet.valueOf(b.array()));
    }

    @Override
    public ImmutableBitmap union(Iterable<ImmutableBitmap> b) {
        WrappedImmutableBitSetBitmap newSet = null;
        for (ImmutableBitmap bm : b) {
            if (null == newSet) {
                newSet = new WrappedBitSetBitmap(((WrappedBitSetBitmap)bm).cloneBitSet());
                continue;
            }
            newSet.union(bm);
        }
        return newSet;
    }

    @Override
    public ImmutableBitmap intersection(Iterable<ImmutableBitmap> b) {
        WrappedImmutableBitSetBitmap newSet = null;
        for (ImmutableBitmap bm : b) {
            if (null == newSet) {
                newSet = new WrappedBitSetBitmap(((WrappedBitSetBitmap)bm).cloneBitSet());
                continue;
            }
            newSet.intersection(bm);
        }
        return newSet;
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b) {
        BitSet bitSet = ((WrappedBitSetBitmap)b).cloneBitSet();
        bitSet.flip(0, bitSet.size());
        return new WrappedBitSetBitmap(bitSet);
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b, int length) {
        return null;
    }
}

