/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.CosmosDatabase;
import com.azure.data.cosmos.DatabaseAccount;
import com.azure.data.cosmos.internal.AsyncDocumentClient;
import com.azure.data.cosmos.internal.DocumentCollection;
import reactor.core.publisher.Mono;

public class CosmosBridgeInternal {
    public static DocumentCollection toDocumentCollection(CosmosContainerProperties cosmosContainerProperties) {
        return new DocumentCollection(cosmosContainerProperties.toJson());
    }

    public static AsyncDocumentClient getAsyncDocumentClient(CosmosClient client) {
        return client.getDocClientWrapper();
    }

    public static CosmosDatabase getCosmosDatabaseWithNewClient(CosmosDatabase cosmosDatabase, CosmosClient client) {
        return new CosmosDatabase(cosmosDatabase.id(), client);
    }

    public static CosmosContainer getCosmosContainerWithNewClient(CosmosContainer cosmosContainer, CosmosDatabase cosmosDatabase, CosmosClient client) {
        return new CosmosContainer(cosmosContainer.id(), CosmosBridgeInternal.getCosmosDatabaseWithNewClient(cosmosDatabase, client));
    }

    public static Mono<DatabaseAccount> getDatabaseAccount(CosmosClient client) {
        return client.readDatabaseAccount();
    }

    public static AsyncDocumentClient getContextClient(CosmosDatabase database) {
        return database.getClient().getContextClient();
    }

    public static AsyncDocumentClient getContextClient(CosmosContainer container) {
        return container.getDatabase().getClient().getContextClient();
    }
}

