/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.CosmosDatabase;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.ResourceResponse;

public class CosmosContainerResponse
extends CosmosResponse<CosmosContainerProperties> {
    private CosmosContainer container;

    CosmosContainerResponse(ResourceResponse<DocumentCollection> response, CosmosDatabase database) {
        super(response);
        if (response.getResource() == null) {
            super.resourceSettings(null);
        } else {
            super.resourceSettings(new CosmosContainerProperties(response));
            this.container = new CosmosContainer(((CosmosContainerProperties)this.resourceSettings()).id(), database);
        }
    }

    public long indexTransformationProgress() {
        return this.resourceResponseWrapper.getIndexTransformationProgress();
    }

    long lazyIndexingProgress() {
        return this.resourceResponseWrapper.getLazyIndexingProgress();
    }

    public CosmosContainerProperties properties() {
        return (CosmosContainerProperties)this.resourceSettings();
    }

    public CosmosContainer container() {
        return this.container;
    }
}

