/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosDatabase;
import com.azure.data.cosmos.CosmosDatabaseProperties;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.internal.Database;
import com.azure.data.cosmos.internal.ResourceResponse;

public class CosmosDatabaseResponse
extends CosmosResponse<CosmosDatabaseProperties> {
    private CosmosDatabase database;

    CosmosDatabaseResponse(ResourceResponse<Database> response, CosmosClient client) {
        super(response);
        if (response.getResource() == null) {
            super.resourceSettings(null);
        } else {
            super.resourceSettings(new CosmosDatabaseProperties(response));
            this.database = new CosmosDatabase(((CosmosDatabaseProperties)this.resourceSettings()).id(), client);
        }
    }

    public CosmosDatabase database() {
        return this.database;
    }

    public CosmosDatabaseProperties properties() {
        return (CosmosDatabaseProperties)this.resourceSettings();
    }

    public long databaseQuota() {
        return this.resourceResponseWrapper.getDatabaseQuota();
    }

    public long databaseUsage() {
        return this.resourceResponseWrapper.getDatabaseUsage();
    }
}

