/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.CosmosTriggerProperties;
import com.azure.data.cosmos.CosmosTriggerResponse;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.Trigger;
import reactor.core.publisher.Mono;

public class CosmosTrigger {
    private CosmosContainer container;
    private String id;

    CosmosTrigger(String id, CosmosContainer container) {
        this.id = id;
        this.container = container;
    }

    public String id() {
        return this.id;
    }

    CosmosTrigger id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosTriggerResponse> read() {
        return this.container.getDatabase().getDocClientWrapper().readTrigger(this.getLink(), null).map(response -> new CosmosTriggerResponse((ResourceResponse<Trigger>)response, this.container)).single();
    }

    public Mono<CosmosTriggerResponse> replace(CosmosTriggerProperties triggerSettings) {
        return this.container.getDatabase().getDocClientWrapper().replaceTrigger(new Trigger(triggerSettings.toJson()), null).map(response -> new CosmosTriggerResponse((ResourceResponse<Trigger>)response, this.container)).single();
    }

    public Mono<CosmosResponse> delete() {
        return this.container.getDatabase().getDocClientWrapper().deleteTrigger(this.getLink(), null).map(response -> new CosmosResponse(response.getResource())).single();
    }

    String URIPathSegment() {
        return "triggers";
    }

    String parentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

