/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.HashIndex;
import com.azure.data.cosmos.Index;
import com.azure.data.cosmos.IndexKind;
import com.azure.data.cosmos.JsonSerializable;
import com.azure.data.cosmos.RangeIndex;
import com.azure.data.cosmos.SpatialIndex;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class IncludedPath
extends JsonSerializable {
    private Collection<Index> indexes;

    public IncludedPath() {
    }

    public IncludedPath(String jsonString) {
        super(jsonString);
    }

    public String path() {
        return super.getString("path");
    }

    public IncludedPath path(String path) {
        super.set("path", path);
        return this;
    }

    public Collection<Index> indexes() {
        if (this.indexes == null) {
            this.indexes = this.indexCollection();
            if (this.indexes == null) {
                this.indexes = new ArrayList<Index>();
            }
        }
        return this.indexes;
    }

    public IncludedPath indexes(Collection<Index> indexes) {
        this.indexes = indexes;
        return this;
    }

    private Collection<Index> indexCollection() {
        if (this.propertyBag != null && this.propertyBag.has("indexes")) {
            ArrayNode jsonArray = (ArrayNode)this.propertyBag.get("indexes");
            ArrayList<Index> result = new ArrayList<Index>();
            block5: for (int i = 0; i < jsonArray.size(); ++i) {
                JsonNode jsonObject = jsonArray.get(i);
                IndexKind indexKind = IndexKind.valueOf(StringUtils.upperCase((String)jsonObject.get("kind").asText()));
                switch (indexKind) {
                    case HASH: {
                        result.add(new HashIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case RANGE: {
                        result.add(new RangeIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case SPATIAL: {
                        result.add(new SpatialIndex(jsonObject.toString()));
                    }
                }
            }
            return result;
        }
        return null;
    }

    @Override
    void populatePropertyBag() {
        if (this.indexes != null) {
            for (Index index : this.indexes) {
                index.populatePropertyBag();
            }
            super.set("indexes", this.indexes);
        }
    }
}

