/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.DataType;
import com.azure.data.cosmos.Index;
import com.azure.data.cosmos.IndexKind;
import org.apache.commons.lang3.StringUtils;

public final class RangeIndex
extends Index {
    public RangeIndex(DataType dataType) {
        super(IndexKind.RANGE);
        this.dataType(dataType);
    }

    public RangeIndex(DataType dataType, int precision) {
        super(IndexKind.RANGE);
        this.dataType(dataType);
        this.precision(precision);
    }

    RangeIndex(String jsonString) {
        super(jsonString, IndexKind.RANGE);
        if (this.dataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType dataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase((String)super.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID index dataType value {}.", (Object)super.getString("dataType"));
        }
        return result;
    }

    public RangeIndex dataType(DataType dataType) {
        super.set("dataType", dataType.toString());
        return this;
    }

    public int precision() {
        return super.getInt("precision");
    }

    public RangeIndex precision(int precision) {
        super.set("precision", precision);
        return this;
    }

    boolean hasPrecision() {
        return super.has("precision");
    }
}

