/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.SqlParameter;
import com.azure.data.cosmos.SqlParameterList;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.Database;
import com.azure.data.cosmos.internal.ResourceResponse;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class DatabaseForTest {
    private static Logger logger = LoggerFactory.getLogger(DatabaseForTest.class);
    public static final String SHARED_DB_ID_PREFIX = "RxJava.SDKTest.SharedDatabase";
    private static final Duration CLEANUP_THRESHOLD_DURATION = Duration.ofHours(2L);
    private static final String DELIMITER = "_";
    private static DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
    public LocalDateTime createdTime;
    public Database createdDatabase;

    private DatabaseForTest(Database db, LocalDateTime createdTime) {
        this.createdDatabase = db;
        this.createdTime = createdTime;
    }

    private boolean isStale() {
        return this.isOlderThan(CLEANUP_THRESHOLD_DURATION);
    }

    private boolean isOlderThan(Duration dur) {
        return this.createdTime.isBefore(LocalDateTime.now().minus(dur));
    }

    public static String generateId() {
        return "RxJava.SDKTest.SharedDatabase_" + TIME_FORMATTER.format(LocalDateTime.now()) + DELIMITER + RandomStringUtils.randomAlphabetic((int)3);
    }

    private static DatabaseForTest from(Database db) {
        if (db == null || db.id() == null || db.selfLink() == null) {
            return null;
        }
        String id = db.id();
        if (id == null) {
            return null;
        }
        String[] parts = StringUtils.split((String)id, (String)DELIMITER);
        if (parts.length != 3) {
            return null;
        }
        if (!StringUtils.equals((CharSequence)parts[0], (CharSequence)SHARED_DB_ID_PREFIX)) {
            return null;
        }
        try {
            LocalDateTime parsedTime = LocalDateTime.parse(parts[1], TIME_FORMATTER);
            return new DatabaseForTest(db, parsedTime);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DatabaseForTest create(DatabaseManager client) {
        Database dbDef = new Database();
        dbDef.id(DatabaseForTest.generateId());
        Database db = (Database)((ResourceResponse)client.createDatabase(dbDef).single().block()).getResource();
        DatabaseForTest dbForTest = DatabaseForTest.from(db);
        assert (dbForTest != null);
        return dbForTest;
    }

    public static void cleanupStaleTestDatabases(DatabaseManager client) {
        logger.info("Cleaning stale test databases ...");
        List dbs = (List)client.queryDatabases(new SqlQuerySpec("SELECT * FROM c WHERE STARTSWITH(c.id, @PREFIX)", new SqlParameterList(new SqlParameter("@PREFIX", SHARED_DB_ID_PREFIX)))).flatMap(page -> Flux.fromIterable(page.results())).collectList().block();
        for (Database db : dbs) {
            assert (db.id().startsWith(SHARED_DB_ID_PREFIX));
            DatabaseForTest dbForTest = DatabaseForTest.from(db);
            if (db == null || !dbForTest.isStale()) continue;
            logger.info("Deleting database {}", (Object)db.id());
            client.deleteDatabase(db.id()).single().block();
        }
    }

    public static interface DatabaseManager {
        public Flux<FeedResponse<Database>> queryDatabases(SqlQuerySpec var1);

        public Flux<ResourceResponse<Database>> createDatabase(Database var1);

        public Flux<ResourceResponse<Database>> deleteDatabase(String var1);
    }
}

