/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.internal.QueryMetricsUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;

public final class QueryPreparationTimes {
    static final QueryPreparationTimes ZERO = new QueryPreparationTimes(Duration.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO);
    private final Duration queryCompilationTime;
    private final Duration logicalPlanBuildTime;
    private final Duration physicalPlanBuildTime;
    private final Duration queryOptimizationTime;

    QueryPreparationTimes(Duration queryCompilationTime, Duration logicalPlanBuildTime, Duration physicalPlanBuildTime, Duration queryOptimizationTime) {
        if (queryCompilationTime == null) {
            throw new NullPointerException("queryCompilationTime");
        }
        if (logicalPlanBuildTime == null) {
            throw new NullPointerException("logicalPlanBuildTime");
        }
        if (physicalPlanBuildTime == null) {
            throw new NullPointerException("physicalPlanBuildTime");
        }
        if (queryOptimizationTime == null) {
            throw new NullPointerException("queryOptimizationTime");
        }
        this.queryCompilationTime = queryCompilationTime;
        this.logicalPlanBuildTime = logicalPlanBuildTime;
        this.physicalPlanBuildTime = physicalPlanBuildTime;
        this.queryOptimizationTime = queryOptimizationTime;
    }

    public Duration getQueryCompilationTime() {
        return this.queryCompilationTime;
    }

    public Duration getLogicalPlanBuildTime() {
        return this.logicalPlanBuildTime;
    }

    public Duration getPhysicalPlanBuildTime() {
        return this.physicalPlanBuildTime;
    }

    public Duration getQueryOptimizationTime() {
        return this.queryOptimizationTime;
    }

    static QueryPreparationTimes createFromCollection(Collection<QueryPreparationTimes> queryPreparationTimesCollection) {
        if (queryPreparationTimesCollection == null) {
            throw new NullPointerException("queryPreparationTimesCollection");
        }
        Duration queryCompilationTime = Duration.ZERO;
        Duration logicalPlanBuildTime = Duration.ZERO;
        Duration physicalPlanBuildTime = Duration.ZERO;
        Duration queryOptimizationTime = Duration.ZERO;
        for (QueryPreparationTimes queryPreparationTimes : queryPreparationTimesCollection) {
            if (queryPreparationTimes == null) {
                throw new NullPointerException("queryPreparationTimesList can not have a null element");
            }
            queryCompilationTime = queryCompilationTime.plus(queryPreparationTimes.queryCompilationTime);
            logicalPlanBuildTime = logicalPlanBuildTime.plus(queryPreparationTimes.logicalPlanBuildTime);
            physicalPlanBuildTime = physicalPlanBuildTime.plus(queryPreparationTimes.physicalPlanBuildTime);
            queryOptimizationTime = queryOptimizationTime.plus(queryPreparationTimes.queryOptimizationTime);
        }
        return new QueryPreparationTimes(queryCompilationTime, logicalPlanBuildTime, physicalPlanBuildTime, queryOptimizationTime);
    }

    static QueryPreparationTimes createFromDelimitedString(String delimitedString) {
        HashMap<String, Double> metrics = QueryMetricsUtils.parseDelimitedString(delimitedString);
        return new QueryPreparationTimes(QueryMetricsUtils.durationFromMetrics(metrics, "queryCompileTimeInMs"), QueryMetricsUtils.durationFromMetrics(metrics, "queryLogicalPlanBuildTimeInMs"), QueryMetricsUtils.durationFromMetrics(metrics, "queryPhysicalPlanBuildTimeInMs"), QueryMetricsUtils.durationFromMetrics(metrics, "queryOptimizationTimeInMs"));
    }

    String toDelimitedString() {
        String formatString = "%s=%.2f;%s=%.2f;%s=%.2f;%s=%.2f";
        return String.format(formatString, "queryCompileTimeInMs", this.queryCompilationTime.toMillis(), "queryLogicalPlanBuildTimeInMs", this.logicalPlanBuildTime.toMillis(), "queryPhysicalPlanBuildTimeInMs", this.physicalPlanBuildTime.toMillis(), "queryOptimizationTimeInMs", this.queryOptimizationTime.toMillis());
    }

    String toTextString(int indentLevel) {
        if (indentLevel == Integer.MAX_VALUE) {
            throw new NumberFormatException("indentLevel input must be less than Integer.MaxValue");
        }
        StringBuilder stringBuilder = new StringBuilder();
        QueryMetricsUtils.appendHeaderToStringBuilder(stringBuilder, "Query Preparation Times", indentLevel);
        QueryMetricsUtils.appendNanosecondsToStringBuilder(stringBuilder, "Query Compilation Time", this.queryCompilationTime.toNanos(), indentLevel + 1);
        QueryMetricsUtils.appendNanosecondsToStringBuilder(stringBuilder, "Logical Plan Build Time", this.logicalPlanBuildTime.toNanos(), indentLevel + 1);
        QueryMetricsUtils.appendNanosecondsToStringBuilder(stringBuilder, "Physical Plan Build Time", this.physicalPlanBuildTime.toNanos(), indentLevel + 1);
        QueryMetricsUtils.appendNanosecondsToStringBuilder(stringBuilder, "Query Optimization Time", this.queryOptimizationTime.toNanos(), indentLevel + 1);
        return stringBuilder.toString();
    }
}

