/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.ConnectionPolicy;
import com.azure.data.cosmos.RetryOptions;
import com.azure.data.cosmos.internal.ClientRetryPolicy;
import com.azure.data.cosmos.internal.GlobalEndpointManager;
import com.azure.data.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.data.cosmos.internal.IRetryPolicyFactory;

public class RetryPolicy
implements IRetryPolicyFactory {
    private final GlobalEndpointManager globalEndpointManager;
    private final boolean enableEndpointDiscovery;
    private final RetryOptions retryOptions;

    public RetryPolicy(GlobalEndpointManager globalEndpointManager, ConnectionPolicy connectionPolicy) {
        this.enableEndpointDiscovery = connectionPolicy.enableEndpointDiscovery();
        this.globalEndpointManager = globalEndpointManager;
        this.retryOptions = connectionPolicy.retryOptions();
    }

    @Override
    public IDocumentClientRetryPolicy getRequestPolicy() {
        ClientRetryPolicy clientRetryPolicy = new ClientRetryPolicy(this.globalEndpointManager, this.enableEndpointDiscovery, this.retryOptions);
        return clientRetryPolicy;
    }
}

