/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.http.HttpHeaders;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error("failed to encode {}", (Object)url, (Object)e);
            throw new IllegalArgumentException("failed to encode url " + url, e);
        }
    }

    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url.replaceAll("\\+", "%2b"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("failed to decode {}", (Object)url, (Object)e);
            throw new IllegalArgumentException("failed to decode url " + url, e);
        }
    }

    public static URI toURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (Exception e) {
            log.error("failed to parse {}", (Object)uri, (Object)e);
            throw new IllegalArgumentException("failed to parse uri " + uri, e);
        }
    }

    public static Map<String, String> asMap(HttpHeaders headers) {
        if (headers == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>(headers.size());
        for (Map.Entry<String, String> entry : headers.toMap().entrySet()) {
            if (entry.getKey().equals("x-ms-alt-content-path")) {
                map.put(entry.getKey(), HttpUtils.urlDecode(entry.getValue()));
                continue;
            }
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static String getDateHeader(Map<String, String> headerValues) {
        if (headerValues == null) {
            return "";
        }
        String date = headerValues.get("x-ms-date");
        if (Strings.isNullOrEmpty(date)) {
            date = headerValues.get("date");
        }
        return date != null ? date : "";
    }

    public static List<Map.Entry<String, String>> unescape(Set<Map.Entry<String, String>> headers) {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>(headers.size());
        for (Map.Entry<String, String> entry : headers) {
            if (entry.getKey().equals("x-ms-alt-content-path")) {
                String unescapedUrl = HttpUtils.urlDecode(entry.getValue());
                entry = new AbstractMap.SimpleEntry<String, String>(entry.getKey(), unescapedUrl);
            }
            result.add(entry);
        }
        return result;
    }
}

