/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdClientChannelHandler;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdClientChannelHealthChecker;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdHealthCheckRequest;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdReporter;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestManager;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdServiceEndpoint;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdClientChannelPool
extends SimpleChannelPool {
    private static final TimeoutException ACQUISITION_TIMEOUT = (TimeoutException)ThrowableUtil.unknownStackTrace((Throwable)new TimeoutException("Acquisition took longer than the configured maximum time"), RntbdClientChannelPool.class, (String)"<init>");
    private static final ClosedChannelException CHANNEL_CLOSED_ON_ACQUIRE = (ClosedChannelException)ThrowableUtil.unknownStackTrace((Throwable)new ClosedChannelException(), RntbdClientChannelPool.class, (String)"acquire0(...)");
    private static final IllegalStateException POOL_CLOSED_ON_ACQUIRE = (IllegalStateException)ThrowableUtil.unknownStackTrace((Throwable)new IllegalStateException("RntbdClientChannelPool was closed"), RntbdClientChannelPool.class, (String)"acquire0");
    private static final IllegalStateException POOL_CLOSED_ON_RELEASE = (IllegalStateException)ThrowableUtil.unknownStackTrace((Throwable)new IllegalStateException("RntbdClientChannelPool was closed"), RntbdClientChannelPool.class, (String)"release");
    private static final IllegalStateException TOO_MANY_PENDING_ACQUISITIONS = (IllegalStateException)ThrowableUtil.unknownStackTrace((Throwable)new IllegalStateException("Too many outstanding acquire operations"), RntbdClientChannelPool.class, (String)"acquire0");
    private static final Logger logger = LoggerFactory.getLogger(RntbdClientChannelPool.class);
    private final long acquisitionTimeoutNanos;
    private final PooledByteBufAllocatorMetric allocatorMetric;
    private final EventExecutor executor;
    private final ScheduledFuture<?> idleStateDetectionScheduledFuture;
    private final int maxChannels;
    private final int maxPendingAcquisitions;
    private final int maxRequestsPerChannel;
    private final Queue<AcquireTask> pendingAcquisitionQueue = new ArrayDeque<AcquireTask>();
    private final Runnable acquisitionTimeoutTask;
    private final AtomicInteger acquiredChannelCount = new AtomicInteger();
    private final AtomicInteger availableChannelCount = new AtomicInteger();
    private final AtomicBoolean closed = new AtomicBoolean();

    RntbdClientChannelPool(RntbdServiceEndpoint endpoint, Bootstrap bootstrap, RntbdEndpoint.Config config) {
        this(endpoint, bootstrap, config, new RntbdClientChannelHealthChecker(config));
    }

    private RntbdClientChannelPool(RntbdServiceEndpoint endpoint, Bootstrap bootstrap, RntbdEndpoint.Config config, RntbdClientChannelHealthChecker healthChecker) {
        super(bootstrap, (ChannelPoolHandler)new RntbdClientChannelHandler(config, healthChecker), (ChannelHealthChecker)healthChecker, true, true);
        this.allocatorMetric = config.allocator().metric();
        this.executor = bootstrap.config().group().next();
        this.maxChannels = config.maxChannelsPerEndpoint();
        this.maxPendingAcquisitions = Integer.MAX_VALUE;
        this.maxRequestsPerChannel = config.maxRequestsPerChannel();
        Enum acquisitionTimeoutAction = null;
        long acquisitionTimeoutNanos = -1L;
        if (acquisitionTimeoutAction == null) {
            this.acquisitionTimeoutNanos = -1L;
            this.acquisitionTimeoutTask = null;
        } else {
            this.acquisitionTimeoutNanos = -1L;
            switch (3.$SwitchMap$com$azure$data$cosmos$internal$directconnectivity$rntbd$RntbdClientChannelPool$AcquisitionTimeoutAction[acquisitionTimeoutAction.ordinal()]) {
                case 1: {
                    this.acquisitionTimeoutTask = new AcquireTimeoutTask(this){

                        @Override
                        public void onTimeout(AcquireTask task) {
                            task.promise.setFailure((Throwable)ACQUISITION_TIMEOUT);
                        }
                    };
                    break;
                }
                case 2: {
                    this.acquisitionTimeoutTask = new AcquireTimeoutTask(this){

                        @Override
                        public void onTimeout(AcquireTask task) {
                            task.acquired();
                            RntbdClientChannelPool.super.acquire(task.promise);
                        }
                    };
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        long idleEndpointTimeout = config.idleEndpointTimeoutInNanos();
        this.idleStateDetectionScheduledFuture = this.executor.scheduleAtFixedRate(() -> {
            long lastRequestTime;
            long currentTime = System.nanoTime();
            long elapsedTime = currentTime - (lastRequestTime = endpoint.lastRequestTime());
            if (elapsedTime > idleEndpointTimeout) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} closing due to inactivity (time elapsed since last request: {} > idleEndpointTimeout: {})", new Object[]{endpoint, Duration.ofNanos(elapsedTime), Duration.ofNanos(idleEndpointTimeout)});
                }
                endpoint.close();
            }
        }, idleEndpointTimeout, idleEndpointTimeout, TimeUnit.NANOSECONDS);
    }

    public int channelsAcquired() {
        return this.acquiredChannelCount.get();
    }

    public int channelsAvailable() {
        return this.availableChannelCount.get();
    }

    public int maxChannels() {
        return this.maxChannels;
    }

    public int maxRequestsPerChannel() {
        return this.maxRequestsPerChannel;
    }

    public SocketAddress remoteAddress() {
        return this.bootstrap().config().remoteAddress();
    }

    public int requestQueueLength() {
        return this.pendingAcquisitionQueue.size();
    }

    public long usedDirectMemory() {
        return this.allocatorMetric.usedDirectMemory();
    }

    public long usedHeapMemory() {
        return this.allocatorMetric.usedHeapMemory();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        this.throwIfClosed();
        try {
            if (this.executor.inEventLoop()) {
                this.acquire0(promise);
            } else {
                this.executor.execute(() -> this.acquire0(promise));
            }
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
        return promise;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.executor.inEventLoop()) {
                this.close0();
            } else {
                this.executor.submit(this::close0).awaitUninterruptibly();
            }
        }
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        super.release(channel, this.executor.newPromise().addListener((GenericFutureListener)((FutureListener)future -> {
            Preconditions.checkState((boolean)this.executor.inEventLoop());
            if (this.isClosed()) {
                promise.setFailure((Throwable)POOL_CLOSED_ON_RELEASE);
                channel.close();
                return;
            }
            if (future.isSuccess()) {
                this.decrementAndRunTaskQueue();
                promise.setSuccess(null);
            } else {
                Throwable cause = future.cause();
                if (!(cause instanceof IllegalArgumentException)) {
                    this.decrementAndRunTaskQueue();
                }
                promise.setFailure(cause);
            }
        })));
        return promise;
    }

    public String toString() {
        return RntbdObjectMapper.toString((Object)this);
    }

    protected boolean offerChannel(Channel channel) {
        if (super.offerChannel(channel)) {
            this.availableChannelCount.incrementAndGet();
            return true;
        }
        return false;
    }

    protected Channel pollChannel() {
        Channel first = super.pollChannel();
        if (first == null) {
            return null;
        }
        if (this.isClosed()) {
            return first;
        }
        if (this.isServiceableOrInactiveChannel(first)) {
            return this.decrementAvailableChannelCountAndAccept(first);
        }
        super.offerChannel(first);
        Channel next = super.pollChannel();
        while (next != first) {
            if (this.isServiceableOrInactiveChannel(next)) {
                return this.decrementAvailableChannelCountAndAccept(next);
            }
            super.offerChannel(next);
            next = super.pollChannel();
        }
        super.offerChannel(first);
        return null;
    }

    private void acquire0(Promise<Channel> promise) {
        Preconditions.checkState((boolean)this.executor.inEventLoop());
        if (this.isClosed()) {
            promise.setFailure((Throwable)POOL_CLOSED_ON_ACQUIRE);
            return;
        }
        if (this.acquiredChannelCount.get() < this.maxChannels) {
            Preconditions.checkState((this.acquiredChannelCount.get() >= 0 ? 1 : 0) != 0);
            AcquireListener l = new AcquireListener(this, promise);
            l.acquired();
            Promise p = this.executor.newPromise();
            p.addListener((GenericFutureListener)l);
            super.acquire(p);
        } else {
            if (this.pendingAcquisitionQueue.size() >= this.maxPendingAcquisitions) {
                promise.setFailure((Throwable)TOO_MANY_PENDING_ACQUISITIONS);
            } else {
                AcquireTask task = new AcquireTask(this, promise);
                if (this.pendingAcquisitionQueue.offer(task)) {
                    if (this.acquisitionTimeoutTask != null) {
                        task.timeoutFuture = this.executor.schedule(this.acquisitionTimeoutTask, this.acquisitionTimeoutNanos, TimeUnit.NANOSECONDS);
                    }
                } else {
                    promise.setFailure((Throwable)TOO_MANY_PENDING_ACQUISITIONS);
                }
            }
            Preconditions.checkState((this.pendingAcquisitionQueue.size() > 0 ? 1 : 0) != 0);
        }
    }

    private void close0() {
        AcquireTask task;
        Preconditions.checkState((boolean)this.executor.inEventLoop());
        this.idleStateDetectionScheduledFuture.cancel(false);
        this.acquiredChannelCount.set(0);
        this.availableChannelCount.set(0);
        while ((task = this.pendingAcquisitionQueue.poll()) != null) {
            ScheduledFuture<?> timeoutFuture = task.timeoutFuture;
            if (timeoutFuture != null) {
                timeoutFuture.cancel(false);
            }
            task.promise.setFailure((Throwable)new ClosedChannelException());
        }
        GlobalEventExecutor.INSTANCE.execute(() -> RntbdClientChannelPool.super.close());
    }

    private void decrementAndRunTaskQueue() {
        Preconditions.checkState((this.acquiredChannelCount.decrementAndGet() >= 0 ? 1 : 0) != 0);
        this.runTaskQueue();
    }

    private Channel decrementAvailableChannelCountAndAccept(Channel first) {
        this.availableChannelCount.decrementAndGet();
        return first;
    }

    private boolean isServiceableOrInactiveChannel(Channel channel) {
        if (!channel.isActive()) {
            return true;
        }
        RntbdRequestManager requestManager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
        if (requestManager == null) {
            RntbdReporter.reportIssueUnless(logger, !channel.isActive(), channel, "active with no request manager", new Object[0]);
            return true;
        }
        return requestManager.isServiceable(1);
    }

    private void runTaskQueue() {
        AcquireTask task;
        while (this.acquiredChannelCount.get() < this.maxChannels && (task = this.pendingAcquisitionQueue.poll()) != null) {
            ScheduledFuture<?> timeoutFuture = task.timeoutFuture;
            if (timeoutFuture != null) {
                timeoutFuture.cancel(false);
            }
            task.acquired();
            super.acquire(task.promise);
        }
        Preconditions.checkState((this.acquiredChannelCount.get() >= 0 ? 1 : 0) != 0);
    }

    private void throwIfClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (String)"%s is closed", (Object)((Object)this));
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdClientChannelPool> {
        JsonSerializer() {
            super(RntbdClientChannelPool.class);
        }

        public void serialize(RntbdClientChannelPool value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            RntbdClientChannelHealthChecker healthChecker = (RntbdClientChannelHealthChecker)value.healthChecker();
            generator.writeStartObject();
            generator.writeBooleanField("isClosed", value.isClosed());
            generator.writeObjectFieldStart("configuration");
            generator.writeNumberField("maxChannels", value.maxChannels());
            generator.writeNumberField("maxRequestsPerChannel", value.maxRequestsPerChannel());
            generator.writeNumberField("idleConnectionTimeout", healthChecker.idleConnectionTimeoutInNanos());
            generator.writeNumberField("readDelayLimit", healthChecker.readDelayLimitInNanos());
            generator.writeNumberField("writeDelayLimit", healthChecker.writeDelayLimitInNanos());
            generator.writeEndObject();
            generator.writeObjectFieldStart("state");
            generator.writeNumberField("channelsAcquired", value.channelsAcquired());
            generator.writeNumberField("channelsAvailable", value.channelsAvailable());
            generator.writeNumberField("requestQueueLength", value.requestQueueLength());
            generator.writeNumberField("usedDirectMemory", value.usedDirectMemory());
            generator.writeNumberField("usedHeapMemory", value.usedHeapMemory());
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    private static abstract class AcquireTimeoutTask
    implements Runnable {
        final RntbdClientChannelPool pool;

        public AcquireTimeoutTask(RntbdClientChannelPool pool) {
            this.pool = pool;
        }

        public abstract void onTimeout(AcquireTask var1);

        @Override
        public final void run() {
            AcquireTask task;
            Preconditions.checkState((boolean)this.pool.executor.inEventLoop());
            long nanoTime = System.nanoTime();
            while ((task = (AcquireTask)this.pool.pendingAcquisitionQueue.peek()) != null && nanoTime - task.expireNanoTime >= 0L) {
                this.pool.pendingAcquisitionQueue.remove();
                this.onTimeout(task);
            }
        }
    }

    private static final class AcquireTask
    extends AcquireListener {
        final long expireNanoTime;
        final Promise<Channel> promise;
        ScheduledFuture<?> timeoutFuture;

        AcquireTask(RntbdClientChannelPool pool, Promise<Channel> promise) {
            super(pool, promise);
            this.promise = pool.executor.newPromise().addListener((GenericFutureListener)this);
            this.expireNanoTime = System.nanoTime() + pool.acquisitionTimeoutNanos;
        }
    }

    private static class AcquireListener
    implements FutureListener<Channel> {
        private final Promise<Channel> originalPromise;
        private final RntbdClientChannelPool pool;
        private boolean acquired;

        AcquireListener(RntbdClientChannelPool pool, Promise<Channel> originalPromise) {
            this.originalPromise = originalPromise;
            this.pool = pool;
        }

        public void acquired() {
            if (this.acquired) {
                return;
            }
            this.pool.acquiredChannelCount.incrementAndGet();
            this.acquired = true;
        }

        public void operationComplete(Future<Channel> future) {
            Preconditions.checkState((boolean)this.pool.executor.inEventLoop());
            if (this.pool.isClosed()) {
                if (future.isSuccess()) {
                    ((Channel)future.getNow()).close();
                }
                this.originalPromise.setFailure((Throwable)POOL_CLOSED_ON_ACQUIRE);
                return;
            }
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                channel.eventLoop().execute(() -> {
                    if (!channel.isActive()) {
                        this.fail(CHANNEL_CLOSED_ON_ACQUIRE);
                        return;
                    }
                    ChannelPipeline pipeline = channel.pipeline();
                    Preconditions.checkState((pipeline != null ? 1 : 0) != 0);
                    RntbdRequestManager requestManager = (RntbdRequestManager)pipeline.get(RntbdRequestManager.class);
                    Preconditions.checkState((requestManager != null ? 1 : 0) != 0);
                    if (requestManager.hasRequestedRntbdContext()) {
                        this.originalPromise.setSuccess((Object)channel);
                    } else {
                        channel.writeAndFlush((Object)RntbdHealthCheckRequest.MESSAGE).addListener(completed -> {
                            if (completed.isSuccess()) {
                                RntbdReporter.reportIssueUnless(logger, this.acquired && requestManager.hasRntbdContext(), channel, "acquired: {}, rntbdContext: {}", this.acquired, requestManager.rntbdContext());
                                this.originalPromise.setSuccess((Object)channel);
                            } else {
                                logger.warn("Channel({}) health check request failed due to:", (Object)channel, (Object)completed.cause());
                                this.fail(completed.cause());
                            }
                        });
                    }
                });
            } else {
                logger.warn("channel acquisition failed due to:", future.cause());
                this.fail(future.cause());
            }
        }

        private void fail(Throwable cause) {
            if (this.acquired) {
                this.pool.decrementAndRunTaskQueue();
            } else {
                this.pool.runTaskQueue();
            }
            this.originalPromise.setFailure(cause);
        }
    }

    private static enum AcquisitionTimeoutAction {
        NEW,
        FAIL;

    }
}

