/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdConstants;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdTokenType;
import com.azure.data.cosmos.internal.guava27.Strings;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;

@JsonPropertyOrder(value={"id", "name", "type", "present", "required", "value"})
final class RntbdToken {
    private static final int HEADER_LENGTH = 3;
    private final RntbdConstants.RntbdHeader header;
    private int length;
    private Object value;

    private RntbdToken(RntbdConstants.RntbdHeader header) {
        Preconditions.checkNotNull((Object)header, (Object)"header");
        this.header = header;
        this.value = null;
        this.length = Integer.MIN_VALUE;
    }

    @JsonProperty
    public short getId() {
        return this.header.id();
    }

    @JsonProperty
    public String getName() {
        return this.header.name();
    }

    @JsonProperty
    public RntbdTokenType getTokenType() {
        return this.header.type();
    }

    @JsonProperty
    public Object getValue() {
        RntbdTokenType.Codec codec = this.header.type().codec();
        if (this.value == null) {
            return codec.defaultValue();
        }
        if (this.value instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)this.value;
            try {
                this.value = codec.defaultValue();
                this.value = codec.read(buffer);
            }
            catch (CorruptedFrameException error) {
                String message = Strings.lenientFormat("failed to read %s value: %s", this.getName(), error.getMessage());
                throw new CorruptedFrameException(message);
            }
        } else {
            this.value = codec.convert(this.value);
        }
        return this.value;
    }

    public <T> T getValue(Class<T> cls) {
        return cls.cast(this.getValue());
    }

    @JsonProperty
    public void setValue(Object value) {
        this.ensureValid(value);
        this.value = value;
        this.length = Integer.MIN_VALUE;
    }

    @JsonIgnore
    public final Class<?> getValueType() {
        return this.header.type().codec().valueType();
    }

    @JsonProperty
    public boolean isPresent() {
        return this.value != null;
    }

    @JsonProperty
    public boolean isRequired() {
        return this.header.isRequired();
    }

    public int computeLength() {
        if (!this.isPresent()) {
            return 0;
        }
        if (this.value instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)this.value;
            Preconditions.checkState((buffer.readerIndex() == 0 ? 1 : 0) != 0);
            return 3 + buffer.readableBytes();
        }
        if (this.length == Integer.MIN_VALUE) {
            this.length = 3 + this.header.type().codec().computeLength(this.value);
        }
        return this.length;
    }

    public static RntbdToken create(RntbdConstants.RntbdHeader header) {
        return new RntbdToken(header);
    }

    public void decode(ByteBuf in) {
        Preconditions.checkNotNull((Object)in, (Object)"expected non-null in");
        this.value = this.header.type().codec().readSlice(in);
    }

    public void encode(ByteBuf out) {
        Preconditions.checkNotNull((Object)out, (Object)"out");
        if (!this.isPresent()) {
            if (this.isRequired()) {
                String message = Strings.lenientFormat("Missing value for required header: %s", this);
                throw new IllegalStateException(message);
            }
            return;
        }
        out.writeShortLE((int)this.getId());
        out.writeByte((int)this.getTokenType().id());
        if (this.value instanceof ByteBuf) {
            out.writeBytes((ByteBuf)this.value);
        } else {
            this.ensureValid(this.value);
            this.header.type().codec().write(this.value, out);
        }
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private void ensureValid(Object value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"expected non-null value");
        Preconditions.checkArgument((boolean)this.header.type().codec().isValid(value), (String)"invalid value: %s = %s", (Object)value.getClass().getName(), (Object)value);
    }

    static {
        RntbdObjectMapper.registerPropertyFilter(RntbdToken.class, PropertyFilter.class);
    }

    static class PropertyFilter
    extends SimpleBeanPropertyFilter {
        PropertyFilter() {
        }

        public void serializeAsField(Object object, JsonGenerator generator, SerializerProvider provider, PropertyWriter writer) throws Exception {
            Object value;
            if (generator.canOmitFields() && (value = writer.getMember().getValue(object)) instanceof RntbdToken && !((RntbdToken)value).isPresent()) {
                return;
            }
            writer.serializeAsField(object, generator, provider);
        }
    }
}

