/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosStoredProcedure;
import com.azure.data.cosmos.CosmosStoredProcedureProperties;
import com.azure.data.cosmos.CosmosStoredProcedureRequestOptions;
import com.azure.data.cosmos.sync.CosmosSyncContainer;
import com.azure.data.cosmos.sync.CosmosSyncResponse;
import com.azure.data.cosmos.sync.CosmosSyncStoredProcedureResponse;

public class CosmosSyncStoredProcedure {
    private final String id;
    private final CosmosSyncContainer container;
    private final CosmosStoredProcedure storedProcedure;

    public CosmosSyncStoredProcedure(String id, CosmosSyncContainer container, CosmosStoredProcedure storedProcedure) {
        this.id = id;
        this.container = container;
        this.storedProcedure = storedProcedure;
    }

    public String id() {
        return this.id;
    }

    public CosmosSyncStoredProcedureResponse read() throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.read());
    }

    public CosmosSyncStoredProcedureResponse read(CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.read(options));
    }

    public CosmosSyncResponse delete() throws CosmosClientException {
        return this.container.getScripts().mapDeleteResponseAndBlock(this.storedProcedure.delete());
    }

    CosmosSyncResponse delete(CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.container.getScripts().mapDeleteResponseAndBlock(this.storedProcedure.delete(options));
    }

    public CosmosSyncStoredProcedureResponse execute(Object[] procedureParams, CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.execute(procedureParams, options));
    }

    public CosmosSyncStoredProcedureResponse replace(CosmosStoredProcedureProperties storedProcedureSettings) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.replace(storedProcedureSettings));
    }

    public CosmosSyncStoredProcedureResponse replace(CosmosStoredProcedureProperties storedProcedureSettings, CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.replace(storedProcedureSettings, options));
    }
}

