/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.entityoperations;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidParameterException;

public class EntityUnlinkOperation
extends DefaultDeleteOperation {
    private final String primaryEntitySet;
    private final String primaryEntityId;
    private final String secondaryEntitySet;
    private final String secondaryEntityId;

    public EntityUnlinkOperation(String primaryEntitySet, String primaryEntityId, String secondaryEntitySet, String secondaryEntityId) {
        super(primaryEntitySet, primaryEntityId);
        this.primaryEntitySet = primaryEntitySet;
        this.primaryEntityId = primaryEntityId;
        this.secondaryEntitySet = secondaryEntitySet;
        this.secondaryEntityId = secondaryEntityId;
    }

    @Override
    public String getUri() {
        String escapedSecondaryEntityId;
        String escapedPrimaryEntityId;
        try {
            escapedPrimaryEntityId = URLEncoder.encode(this.primaryEntityId, "UTF-8");
            escapedSecondaryEntityId = URLEncoder.encode(this.secondaryEntityId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterException("UTF-8 encoding is not supported.");
        }
        return String.format("%s('%s')/$links/%s('%s')", this.primaryEntitySet, escapedPrimaryEntityId, this.secondaryEntitySet, escapedSecondaryEntityId);
    }
}

