/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import java.util.EnumSet;

public enum AssetDeliveryProtocol {
    None(0),
    SmoothStreaming(1),
    Dash(2),
    HLS(4),
    Hds(8),
    All(65535);

    private int falgValue;

    private AssetDeliveryProtocol(int falgValue) {
        this.falgValue = falgValue;
    }

    public int getFlagValue() {
        return this.falgValue;
    }

    public static EnumSet<AssetDeliveryProtocol> protocolsFromBits(int bits) {
        EnumSet<AssetDeliveryProtocol> perms = EnumSet.of(None);
        for (AssetDeliveryProtocol p : AssetDeliveryProtocol.values()) {
            if ((bits & p.getFlagValue()) != p.getFlagValue()) continue;
            perms.remove((Object)None);
            perms.add(p);
        }
        return perms;
    }

    public static int bitsFromProtocols(EnumSet<AssetDeliveryProtocol> protos) {
        int result = 0;
        for (AssetDeliveryProtocol p : protos) {
            result |= p.getFlagValue();
        }
        return result;
    }
}

