/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for GeoFilterActions.
 */
public enum GeoFilterActions {
    /** Enum value Block. */
    BLOCK("Block"),

    /** Enum value Allow. */
    ALLOW("Allow");

    /** The actual serialized value for a GeoFilterActions instance. */
    private String value;

    GeoFilterActions(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a GeoFilterActions instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed GeoFilterActions object, or null if unable to parse.
     */
    @JsonCreator
    public static GeoFilterActions fromString(String value) {
        GeoFilterActions[] items = GeoFilterActions.values();
        for (GeoFilterActions item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
