/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for CustomHttpsProvisioningState.
 */
public final class CustomHttpsProvisioningState {
    /** Static value Enabling for CustomHttpsProvisioningState. */
    public static final CustomHttpsProvisioningState ENABLING = new CustomHttpsProvisioningState("Enabling");

    /** Static value Enabled for CustomHttpsProvisioningState. */
    public static final CustomHttpsProvisioningState ENABLED = new CustomHttpsProvisioningState("Enabled");

    /** Static value Disabling for CustomHttpsProvisioningState. */
    public static final CustomHttpsProvisioningState DISABLING = new CustomHttpsProvisioningState("Disabling");

    /** Static value Disabled for CustomHttpsProvisioningState. */
    public static final CustomHttpsProvisioningState DISABLED = new CustomHttpsProvisioningState("Disabled");

    /** Static value Failed for CustomHttpsProvisioningState. */
    public static final CustomHttpsProvisioningState FAILED = new CustomHttpsProvisioningState("Failed");

    private String value;

    /**
     * Creates a custom value for CustomHttpsProvisioningState.
     * @param value the custom value
     */
    public CustomHttpsProvisioningState(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CustomHttpsProvisioningState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CustomHttpsProvisioningState rhs = (CustomHttpsProvisioningState) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
