/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.DiskVolumeType;
import com.microsoft.azure.management.compute.LinuxVMDiskEncryptionConfiguration;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineEncryption;
import com.microsoft.azure.management.compute.WindowsVMDiskEncryptionConfiguration;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.LinuxDiskVolumeEncryptionMonitorImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineEncryptionHelper;
import com.microsoft.azure.management.compute.implementation.WindowsVolumeEncryptionMonitorImpl;
import rx.Observable;

class VirtualMachineEncryptionImpl
implements VirtualMachineEncryption {
    private final VirtualMachine virtualMachine;
    private final VirtualMachineEncryptionHelper virtualMachineEncryptionHelper;

    VirtualMachineEncryptionImpl(VirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
        this.virtualMachineEncryptionHelper = new VirtualMachineEncryptionHelper(virtualMachine);
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> enableAsync(String keyVaultId, String aadClientId, String aadSecret) {
        if (this.virtualMachine.osType() == OperatingSystemTypes.LINUX) {
            return this.enableAsync(new LinuxVMDiskEncryptionConfiguration(keyVaultId, aadClientId, aadSecret));
        }
        return this.enableAsync(new WindowsVMDiskEncryptionConfiguration(keyVaultId, aadClientId, aadSecret));
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> enableAsync(WindowsVMDiskEncryptionConfiguration encryptionSettings) {
        return this.virtualMachineEncryptionHelper.enableEncryptionAsync(encryptionSettings);
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> enableAsync(LinuxVMDiskEncryptionConfiguration encryptionSettings) {
        return this.virtualMachineEncryptionHelper.enableEncryptionAsync(encryptionSettings);
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> disableAsync(DiskVolumeType volumeType) {
        return this.virtualMachineEncryptionHelper.disableEncryptionAsync(volumeType);
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> getMonitorAsync() {
        if (this.virtualMachine.osType() == OperatingSystemTypes.LINUX) {
            return new LinuxDiskVolumeEncryptionMonitorImpl(this.virtualMachine.id(), (ComputeManager)((Object)this.virtualMachine.manager())).refreshAsync();
        }
        return new WindowsVolumeEncryptionMonitorImpl(this.virtualMachine.id(), (ComputeManager)((Object)this.virtualMachine.manager())).refreshAsync();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(String keyVaultId, String aadClientId, String aadSecret) {
        return (DiskVolumeEncryptionMonitor)this.enableAsync(keyVaultId, aadClientId, aadSecret).toBlocking().last();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(WindowsVMDiskEncryptionConfiguration encryptionSettings) {
        return (DiskVolumeEncryptionMonitor)this.enableAsync(encryptionSettings).toBlocking().last();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(LinuxVMDiskEncryptionConfiguration encryptionSettings) {
        return (DiskVolumeEncryptionMonitor)this.enableAsync(encryptionSettings).toBlocking().last();
    }

    @Override
    public DiskVolumeEncryptionMonitor disable(DiskVolumeType volumeType) {
        return (DiskVolumeEncryptionMonitor)this.disableAsync(volumeType).toBlocking().last();
    }

    @Override
    public DiskVolumeEncryptionMonitor getMonitor() {
        return (DiskVolumeEncryptionMonitor)this.getMonitorAsync().toBlocking().last();
    }
}

