/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AccessLevel;
import com.microsoft.azure.management.compute.Disk;
import com.microsoft.azure.management.compute.Disks;
import com.microsoft.azure.management.compute.implementation.AccessUriInner;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.DiskImpl;
import com.microsoft.azure.management.compute.implementation.DiskInner;
import com.microsoft.azure.management.compute.implementation.DisksInner;
import com.microsoft.azure.management.compute.implementation.GrantAccessDataInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class DisksImpl
extends TopLevelModifiableResourcesImpl<Disk, DiskImpl, DiskInner, DisksInner, ComputeManager>
implements Disks {
    DisksImpl(ComputeManager computeManager) {
        super((InnerSupportsListing)((ComputeManagementClientImpl)((Object)computeManager.inner())).disks(), (ManagerBase)computeManager);
    }

    @Override
    public String grantAccess(String resourceGroupName, String diskName, AccessLevel accessLevel, int accessDuration) {
        return (String)this.grantAccessAsync(resourceGroupName, diskName, accessLevel, accessDuration).toBlocking().last();
    }

    @Override
    public Observable<String> grantAccessAsync(String resourceGroupName, String diskName, AccessLevel accessLevel, int accessDuration) {
        GrantAccessDataInner grantAccessDataInner = new GrantAccessDataInner();
        grantAccessDataInner.withAccess(accessLevel).withDurationInSeconds(accessDuration);
        return ((DisksInner)this.inner()).grantAccessAsync(resourceGroupName, diskName, grantAccessDataInner).map((Func1)new Func1<AccessUriInner, String>(){

            public String call(AccessUriInner accessUriInner) {
                return accessUriInner.accessSAS();
            }
        });
    }

    @Override
    public ServiceFuture<String> grantAccessAsync(String resourceGroupName, String diskName, AccessLevel accessLevel, int accessDuration, ServiceCallback<String> callback) {
        return ServiceFuture.fromBody(this.grantAccessAsync(resourceGroupName, diskName, accessLevel, accessDuration), callback);
    }

    @Override
    public void revokeAccess(String resourceGroupName, String diskName) {
        ((DisksInner)this.inner()).revokeAccess(resourceGroupName, diskName);
    }

    @Override
    public Completable revokeAccessAsync(String resourceGroupName, String diskName) {
        return ((DisksInner)this.inner()).revokeAccessAsync(resourceGroupName, diskName).toCompletable();
    }

    @Override
    public ServiceFuture<Void> revokeAccessAsync(String resourceGroupName, String diskName, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.revokeAccessAsync(resourceGroupName, diskName), callback);
    }

    protected DiskImpl wrapModel(String name) {
        return new DiskImpl(name, new DiskInner(), (ComputeManager)this.manager());
    }

    protected DiskImpl wrapModel(DiskInner inner) {
        if (inner == null) {
            return null;
        }
        return new DiskImpl(inner.name(), inner, (ComputeManager)this.manager());
    }

    public Disk.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }
}

