/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineIdentity;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.resources.fluentcore.dag.IndexableTaskItem;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.dag.VoidIndexable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
class VirtualMachineMsiHandler
extends RoleAssignmentHelper {
    private final VirtualMachineImpl virtualMachine;
    private MSIExtensionInstaller msiExtensionInstaller;
    private List<String> creatableIdentityKeys;

    VirtualMachineMsiHandler(GraphRbacManager rbacManager, VirtualMachineImpl virtualMachine) {
        super(rbacManager, virtualMachine.taskGroup(), virtualMachine.idProvider());
        this.virtualMachine = virtualMachine;
        this.msiExtensionInstaller = null;
        this.creatableIdentityKeys = new ArrayList<String>();
    }

    VirtualMachineMsiHandler withLocalManagedServiceIdentity() {
        return this.withLocalManagedServiceIdentity(null);
    }

    VirtualMachineMsiHandler withLocalManagedServiceIdentity(Integer port) {
        this.initVMIdentity(ResourceIdentityType.SYSTEM_ASSIGNED);
        this.scheduleMSIExtensionInstallation(port);
        return this;
    }

    VirtualMachineMsiHandler withNewExternalManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.initVMIdentity(ResourceIdentityType.USER_ASSIGNED);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)creatableIdentity;
        Objects.requireNonNull(dependency);
        this.virtualMachine.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        this.scheduleMSIExtensionInstallation(null);
        return this;
    }

    VirtualMachineMsiHandler withExistingExternalManagedServiceIdentity(Identity identity) {
        this.initVMIdentity(ResourceIdentityType.USER_ASSIGNED);
        Utils.addToListIfNotExists(((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().identityIds(), (String)identity.id());
        this.scheduleMSIExtensionInstallation(null);
        return this;
    }

    VirtualMachineMsiHandler withoutExternalManagedServiceIdentity(String identityId) {
        VirtualMachineInner virtualMachineInner = (VirtualMachineInner)((Object)this.virtualMachine.inner());
        if (virtualMachineInner.identity() != null && virtualMachineInner.identity().identityIds() != null) {
            Utils.removeFromList(((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().identityIds(), (String)identityId);
        }
        return this;
    }

    void handleExternalIdentitySettings() {
        for (String key : this.creatableIdentityKeys) {
            Identity identity = (Identity)this.virtualMachine.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            Utils.addToListIfNotExists(((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().identityIds(), (String)identity.id());
        }
        this.creatableIdentityKeys.clear();
    }

    void clear() {
        if (this.msiExtensionInstaller != null) {
            this.msiExtensionInstaller.clear();
            this.msiExtensionInstaller = null;
        }
    }

    private void initVMIdentity(ResourceIdentityType identityType) {
        if (!identityType.equals((Object)ResourceIdentityType.USER_ASSIGNED) && !identityType.equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            throw new IllegalArgumentException("Invalid argument: " + (Object)((Object)identityType));
        }
        VirtualMachineInner virtualMachineInner = (VirtualMachineInner)((Object)this.virtualMachine.inner());
        if (virtualMachineInner.identity() == null) {
            virtualMachineInner.withIdentity(new VirtualMachineIdentity());
        }
        if (virtualMachineInner.identity().type() == null || virtualMachineInner.identity().type().equals((Object)ResourceIdentityType.NONE) || virtualMachineInner.identity().type().equals((Object)identityType)) {
            virtualMachineInner.identity().withType(identityType);
        } else {
            virtualMachineInner.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
        }
        if (virtualMachineInner.identity().identityIds() == null && (identityType.equals((Object)ResourceIdentityType.USER_ASSIGNED) || identityType.equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED))) {
            virtualMachineInner.identity().withIdentityIds(new ArrayList<String>());
        }
    }

    private void scheduleMSIExtensionInstallation(Integer port) {
        if (this.msiExtensionInstaller == null) {
            this.msiExtensionInstaller = new MSIExtensionInstaller(this.virtualMachine);
            this.msiExtensionInstaller.withTokenPort(port);
            this.virtualMachine.taskGroup().addPostRunDependent((TaskGroup.HasTaskGroup)this.msiExtensionInstaller);
        }
    }

    private static class MSIExtensionInstaller
    extends IndexableTaskItem {
        private static final int DEFAULT_TOKEN_PORT = 50342;
        private static final String MSI_EXTENSION_PUBLISHER_NAME = "Microsoft.ManagedIdentity";
        private static final String LINUX_MSI_EXTENSION = "ManagedIdentityExtensionForLinux";
        private static final String WINDOWS_MSI_EXTENSION = "ManagedIdentityExtensionForWindows";
        private final String msiExtensionTypeName;
        private Integer tokenPort = null;
        private final VirtualMachineImpl virtualMachine;

        MSIExtensionInstaller(VirtualMachineImpl virtualMachine) {
            this.virtualMachine = virtualMachine;
            OperatingSystemTypes osType = virtualMachine.osType();
            if (osType == null) {
                throw new IllegalStateException("MSIExtensionInstaller: Unable to resolve the operating system type");
            }
            this.msiExtensionTypeName = osType == OperatingSystemTypes.LINUX ? LINUX_MSI_EXTENSION : WINDOWS_MSI_EXTENSION;
        }

        MSIExtensionInstaller withTokenPort(Integer tokenPort) {
            this.tokenPort = tokenPort;
            return this;
        }

        public Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
            return Observable.defer((Func0)new Func0<Observable<Indexable>>(){

                public Observable<Indexable> call() {
                    return MSIExtensionInstaller.this.getMSIExtensionAsync();
                }
            }).flatMap((Func1)new Func1<Indexable, Observable<Indexable>>(){

                public Observable<Indexable> call(Indexable extension) {
                    return MSIExtensionInstaller.this.updateMSIExtensionAsync((VirtualMachineExtension)extension);
                }
            }).switchIfEmpty(Observable.defer((Func0)new Func0<Observable<Indexable>>(){

                public Observable<Indexable> call() {
                    return MSIExtensionInstaller.this.installMSIExtensionAsync();
                }
            }));
        }

        private Observable<Indexable> getMSIExtensionAsync() {
            return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.virtualMachine.manager()).inner())).virtualMachineExtensions().getAsync(this.virtualMachine.resourceGroupName(), this.virtualMachine.name(), this.msiExtensionTypeName).map((Func1)new Func1<VirtualMachineExtensionInner, Indexable>(){

                public Indexable call(VirtualMachineExtensionInner inner) {
                    if (inner == null) {
                        return MSIExtensionInstaller.this.voidIndexable();
                    }
                    return new VirtualMachineExtensionImpl(MSIExtensionInstaller.this.msiExtensionTypeName, MSIExtensionInstaller.this.virtualMachine, inner, ((ComputeManagementClientImpl)((Object)((ComputeManager)MSIExtensionInstaller.this.virtualMachine.manager()).inner())).virtualMachineExtensions());
                }
            }).filter((Func1)new Func1<Indexable, Boolean>(){

                public Boolean call(Indexable e) {
                    if (e instanceof VoidIndexable) {
                        return false;
                    }
                    VirtualMachineExtension extension = (VirtualMachineExtension)e;
                    return extension.publisherName().equalsIgnoreCase(MSIExtensionInstaller.MSI_EXTENSION_PUBLISHER_NAME) && extension.typeName().equalsIgnoreCase(MSIExtensionInstaller.this.msiExtensionTypeName);
                }
            });
        }

        private Observable<Indexable> updateMSIExtensionAsync(VirtualMachineExtension extension) {
            Integer tokenPortToUse;
            Integer currentTokenPort = this.objectToInteger(extension.publicSettings().get("port"));
            if (this.tokenPort != null) {
                tokenPortToUse = this.tokenPort;
            } else if (currentTokenPort == null) {
                tokenPortToUse = 50342;
            } else {
                return this.voidObservable();
            }
            HashMap<String, Integer> settings = new HashMap<String, Integer>();
            settings.put("port", tokenPortToUse);
            ((VirtualMachineExtensionInner)((Object)extension.inner())).withSettings(settings);
            return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.virtualMachine.manager()).inner())).virtualMachineExtensions().createOrUpdateAsync(this.virtualMachine.resourceGroupName(), this.virtualMachine.name(), this.msiExtensionTypeName, (VirtualMachineExtensionInner)((Object)extension.inner())).map((Func1)new Func1<VirtualMachineExtensionInner, Indexable>(){

                public Indexable call(VirtualMachineExtensionInner inner) {
                    return new VirtualMachineExtensionImpl(MSIExtensionInstaller.this.msiExtensionTypeName, MSIExtensionInstaller.this.virtualMachine, inner, ((ComputeManagementClientImpl)((Object)((ComputeManager)MSIExtensionInstaller.this.virtualMachine.manager()).inner())).virtualMachineExtensions());
                }
            });
        }

        private Observable<Indexable> installMSIExtensionAsync() {
            Integer tokenPortToUse = this.tokenPort != null ? this.tokenPort : 50342;
            VirtualMachineExtensionInner extensionParameter = new VirtualMachineExtensionInner();
            extensionParameter.withPublisher(MSI_EXTENSION_PUBLISHER_NAME).withVirtualMachineExtensionType(this.msiExtensionTypeName).withTypeHandlerVersion("1.0").withAutoUpgradeMinorVersion(true).withLocation(this.virtualMachine.regionName());
            HashMap<String, Integer> settings = new HashMap<String, Integer>();
            settings.put("port", tokenPortToUse);
            extensionParameter.withSettings(settings);
            extensionParameter.withProtectedSettings(null);
            return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.virtualMachine.manager()).inner())).virtualMachineExtensions().createOrUpdateAsync(this.virtualMachine.resourceGroupName(), this.virtualMachine.name(), this.msiExtensionTypeName, extensionParameter).map((Func1)new Func1<VirtualMachineExtensionInner, Indexable>(){

                public Indexable call(VirtualMachineExtensionInner inner) {
                    return new VirtualMachineExtensionImpl(MSIExtensionInstaller.this.msiExtensionTypeName, MSIExtensionInstaller.this.virtualMachine, inner, ((ComputeManagementClientImpl)((Object)((ComputeManager)MSIExtensionInstaller.this.virtualMachine.manager()).inner())).virtualMachineExtensions());
                }
            });
        }

        private Integer objectToInteger(Object obj) {
            Integer result = null;
            if (obj != null) {
                result = obj instanceof Integer ? (Integer)obj : Integer.valueOf((String)obj);
            }
            return result;
        }
    }
}

