/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetExtension;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetIdentity;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@LangDefinition
class VirtualMachineScaleSetMsiHandler
extends RoleAssignmentHelper {
    private static final int DEFAULT_TOKEN_PORT = 50342;
    private static final String MSI_EXTENSION_PUBLISHER_NAME = "Microsoft.ManagedIdentity";
    private static final String LINUX_MSI_EXTENSION = "ManagedIdentityExtensionForLinux";
    private static final String WINDOWS_MSI_EXTENSION = "ManagedIdentityExtensionForWindows";
    private final VirtualMachineScaleSetImpl scaleSet;
    private Integer tokenPort;
    private boolean scheduleMSIExtensionInstallation;
    private List<String> creatableIdentityKeys;

    VirtualMachineScaleSetMsiHandler(GraphRbacManager rbacManager, VirtualMachineScaleSetImpl scaleSet) {
        super(rbacManager, scaleSet.taskGroup(), scaleSet.idProvider());
        this.scaleSet = scaleSet;
        this.creatableIdentityKeys = new ArrayList<String>();
    }

    VirtualMachineScaleSetMsiHandler withLocalManagedServiceIdentity() {
        return this.withLocalManagedServiceIdentity(null);
    }

    VirtualMachineScaleSetMsiHandler withLocalManagedServiceIdentity(Integer port) {
        this.initVMSSIdentity(ResourceIdentityType.SYSTEM_ASSIGNED);
        this.tokenPort = port;
        this.scheduleMSIExtensionInstallation = true;
        return this;
    }

    VirtualMachineScaleSetMsiHandler withNewExternalManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.initVMSSIdentity(ResourceIdentityType.USER_ASSIGNED);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)creatableIdentity;
        Objects.requireNonNull(dependency);
        this.scaleSet.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        this.scheduleMSIExtensionInstallation = true;
        return this;
    }

    VirtualMachineScaleSetMsiHandler withExistingExternalManagedServiceIdentity(Identity identity) {
        this.initVMSSIdentity(ResourceIdentityType.USER_ASSIGNED);
        Utils.addToListIfNotExists(((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().identityIds(), (String)identity.id());
        this.scheduleMSIExtensionInstallation = true;
        return this;
    }

    VirtualMachineScaleSetMsiHandler withoutExternalManagedServiceIdentity(String identityId) {
        VirtualMachineScaleSetInner scaleSetInner = (VirtualMachineScaleSetInner)((Object)this.scaleSet.inner());
        if (scaleSetInner.identity() != null && scaleSetInner.identity().identityIds() != null) {
            Utils.removeFromList(scaleSetInner.identity().identityIds(), (String)identityId);
        }
        return this;
    }

    void handleExternalIdentitySettings() {
        for (String key : this.creatableIdentityKeys) {
            Identity identity = (Identity)this.scaleSet.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            Utils.addToListIfNotExists(((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().identityIds(), (String)identity.id());
        }
        this.creatableIdentityKeys.clear();
    }

    void addOrUpdateMSIExtension(VirtualMachineScaleSetImpl scaleSetImpl) {
        if (!this.scheduleMSIExtensionInstallation) {
            return;
        }
        String msiExtensionType = this.msiExtensionType(scaleSetImpl.osTypeIntern());
        VirtualMachineScaleSetExtension msiExtension = this.getMSIExtension(scaleSetImpl.extensions(), msiExtensionType);
        if (msiExtension != null) {
            Object currentTokenPortObj = msiExtension.publicSettings().get("port");
            Integer currentTokenPort = this.objectToInteger(currentTokenPortObj);
            Integer newPort = this.tokenPort != null ? this.tokenPort : (currentTokenPort != null ? currentTokenPort : Integer.valueOf(50342));
            VirtualMachineScaleSetImpl appliableVMSS = scaleSetImpl;
            appliableVMSS.updateExtension(msiExtension.name()).withPublicSetting("port", newPort).parent();
        } else {
            Integer port = this.tokenPort != null ? this.tokenPort : Integer.valueOf(50342);
            if (scaleSetImpl.isInCreateMode()) {
                VirtualMachineScaleSetImpl creatableVMSS = scaleSetImpl;
                creatableVMSS.defineNewExtension(msiExtensionType).withPublisher(MSI_EXTENSION_PUBLISHER_NAME).withType(msiExtensionType).withVersion("1.0").withMinorVersionAutoUpgrade().withPublicSetting("port", port).attach();
            } else {
                VirtualMachineScaleSetImpl appliableVMSS = scaleSetImpl;
                appliableVMSS.defineNewExtension(msiExtensionType).withPublisher(MSI_EXTENSION_PUBLISHER_NAME).withType(msiExtensionType).withVersion("1.0").withMinorVersionAutoUpgrade().withPublicSetting("port", port).attach();
            }
        }
        this.tokenPort = null;
        this.scheduleMSIExtensionInstallation = false;
    }

    private String msiExtensionType(OperatingSystemTypes osType) {
        return osType == OperatingSystemTypes.LINUX ? LINUX_MSI_EXTENSION : WINDOWS_MSI_EXTENSION;
    }

    private VirtualMachineScaleSetExtension getMSIExtension(Map<String, VirtualMachineScaleSetExtension> extensions, String typeName) {
        for (VirtualMachineScaleSetExtension extension : extensions.values()) {
            if (!extension.publisherName().equalsIgnoreCase(MSI_EXTENSION_PUBLISHER_NAME) || !extension.typeName().equalsIgnoreCase(typeName)) continue;
            return extension;
        }
        return null;
    }

    private Integer objectToInteger(Object obj) {
        Integer result = null;
        if (obj != null) {
            result = obj instanceof Integer ? (Integer)obj : Integer.valueOf((String)obj);
        }
        return result;
    }

    private void initVMSSIdentity(ResourceIdentityType identityType) {
        if (!identityType.equals((Object)ResourceIdentityType.USER_ASSIGNED) && !identityType.equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            throw new IllegalArgumentException("Invalid argument: " + (Object)((Object)identityType));
        }
        VirtualMachineScaleSetInner scaleSetInner = (VirtualMachineScaleSetInner)((Object)this.scaleSet.inner());
        if (scaleSetInner.identity() == null) {
            scaleSetInner.withIdentity(new VirtualMachineScaleSetIdentity());
        }
        if (scaleSetInner.identity().type() == null || scaleSetInner.identity().type().equals((Object)ResourceIdentityType.NONE) || scaleSetInner.identity().type().equals((Object)identityType)) {
            scaleSetInner.identity().withType(identityType);
        } else {
            scaleSetInner.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
        }
        if (scaleSetInner.identity().identityIds() == null && (identityType.equals((Object)ResourceIdentityType.USER_ASSIGNED) || identityType.equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED))) {
            scaleSetInner.identity().withIdentityIds(new ArrayList<String>());
        }
    }
}

