/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.keyvault;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for CertificatePermissions.
 */
public final class CertificatePermissions {
    /** Static value all for CertificatePermissions. */
    public static final CertificatePermissions ALL = new CertificatePermissions("all");

    /** Static value get for CertificatePermissions. */
    public static final CertificatePermissions GET = new CertificatePermissions("get");

    /** Static value list for CertificatePermissions. */
    public static final CertificatePermissions LIST = new CertificatePermissions("list");

    /** Static value delete for CertificatePermissions. */
    public static final CertificatePermissions DELETE = new CertificatePermissions("delete");

    /** Static value create for CertificatePermissions. */
    public static final CertificatePermissions CREATE = new CertificatePermissions("create");

    /** Static value import for CertificatePermissions. */
    public static final CertificatePermissions IMPORT = new CertificatePermissions("import");

    /** Static value update for CertificatePermissions. */
    public static final CertificatePermissions UPDATE = new CertificatePermissions("update");

    /** Static value managecontacts for CertificatePermissions. */
    public static final CertificatePermissions MANAGECONTACTS = new CertificatePermissions("managecontacts");

    /** Static value getissuers for CertificatePermissions. */
    public static final CertificatePermissions GETISSUERS = new CertificatePermissions("getissuers");

    /** Static value listissuers for CertificatePermissions. */
    public static final CertificatePermissions LISTISSUERS = new CertificatePermissions("listissuers");

    /** Static value setissuers for CertificatePermissions. */
    public static final CertificatePermissions SETISSUERS = new CertificatePermissions("setissuers");

    /** Static value deleteissuers for CertificatePermissions. */
    public static final CertificatePermissions DELETEISSUERS = new CertificatePermissions("deleteissuers");

    /** Static value manageissuers for CertificatePermissions. */
    public static final CertificatePermissions MANAGEISSUERS = new CertificatePermissions("manageissuers");

    private String value;

    /**
     * Creates a custom value for CertificatePermissions.
     * @param value the custom value
     */
    public CertificatePermissions(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CertificatePermissions)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CertificatePermissions rhs = (CertificatePermissions) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
