/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.keyvault;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for KeyPermissions.
 */
public final class KeyPermissions {
    /** Static value all for KeyPermissions. */
    public static final KeyPermissions ALL = new KeyPermissions("all");

    /** Static value encrypt for KeyPermissions. */
    public static final KeyPermissions ENCRYPT = new KeyPermissions("encrypt");

    /** Static value decrypt for KeyPermissions. */
    public static final KeyPermissions DECRYPT = new KeyPermissions("decrypt");

    /** Static value wrapKey for KeyPermissions. */
    public static final KeyPermissions WRAP_KEY = new KeyPermissions("wrapKey");

    /** Static value unwrapKey for KeyPermissions. */
    public static final KeyPermissions UNWRAP_KEY = new KeyPermissions("unwrapKey");

    /** Static value sign for KeyPermissions. */
    public static final KeyPermissions SIGN = new KeyPermissions("sign");

    /** Static value verify for KeyPermissions. */
    public static final KeyPermissions VERIFY = new KeyPermissions("verify");

    /** Static value get for KeyPermissions. */
    public static final KeyPermissions GET = new KeyPermissions("get");

    /** Static value list for KeyPermissions. */
    public static final KeyPermissions LIST = new KeyPermissions("list");

    /** Static value create for KeyPermissions. */
    public static final KeyPermissions CREATE = new KeyPermissions("create");

    /** Static value update for KeyPermissions. */
    public static final KeyPermissions UPDATE = new KeyPermissions("update");

    /** Static value import for KeyPermissions. */
    public static final KeyPermissions IMPORT = new KeyPermissions("import");

    /** Static value delete for KeyPermissions. */
    public static final KeyPermissions DELETE = new KeyPermissions("delete");

    /** Static value backup for KeyPermissions. */
    public static final KeyPermissions BACKUP = new KeyPermissions("backup");

    /** Static value restore for KeyPermissions. */
    public static final KeyPermissions RESTORE = new KeyPermissions("restore");

    private String value;

    /**
     * Creates a custom value for KeyPermissions.
     * @param value the custom value
     */
    public KeyPermissions(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof KeyPermissions)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        KeyPermissions rhs = (KeyPermissions) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
