/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.keyvault.implementation;

import java.util.Map;
import com.microsoft.azure.management.keyvault.VaultProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters for creating or updating a vault.
 */
public class VaultCreateOrUpdateParametersInner {
    /**
     * The supported Azure location where the key vault should be created.
     */
    @JsonProperty(value = "location", required = true)
    private String location;

    /**
     * The tags that will be assigned to the key vault.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Properties of the vault.
     */
    @JsonProperty(value = "properties", required = true)
    private VaultProperties properties;

    /**
     * Get the location value.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location value.
     *
     * @param location the location value to set
     * @return the VaultCreateOrUpdateParametersInner object itself.
     */
    public VaultCreateOrUpdateParametersInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the tags value.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags value.
     *
     * @param tags the tags value to set
     * @return the VaultCreateOrUpdateParametersInner object itself.
     */
    public VaultCreateOrUpdateParametersInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties value.
     *
     * @return the properties value
     */
    public VaultProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties value.
     *
     * @param properties the properties value to set
     * @return the VaultCreateOrUpdateParametersInner object itself.
     */
    public VaultCreateOrUpdateParametersInner withProperties(VaultProperties properties) {
        this.properties = properties;
        return this;
    }

}
