/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.ApplicationGatewayOperations;
import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.models.ApplicationGateway;
import com.microsoft.azure.management.network.models.ApplicationGatewayBackendAddress;
import com.microsoft.azure.management.network.models.ApplicationGatewayBackendAddressPool;
import com.microsoft.azure.management.network.models.ApplicationGatewayBackendHttpSettings;
import com.microsoft.azure.management.network.models.ApplicationGatewayFrontendIPConfiguration;
import com.microsoft.azure.management.network.models.ApplicationGatewayFrontendPort;
import com.microsoft.azure.management.network.models.ApplicationGatewayGetResponse;
import com.microsoft.azure.management.network.models.ApplicationGatewayHttpListener;
import com.microsoft.azure.management.network.models.ApplicationGatewayIPConfiguration;
import com.microsoft.azure.management.network.models.ApplicationGatewayListResponse;
import com.microsoft.azure.management.network.models.ApplicationGatewayPutResponse;
import com.microsoft.azure.management.network.models.ApplicationGatewayRequestRoutingRule;
import com.microsoft.azure.management.network.models.ApplicationGatewaySku;
import com.microsoft.azure.management.network.models.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayPutResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class ApplicationGatewayOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
ApplicationGatewayOperations {
    private NetworkResourceProviderClientImpl client;

    ApplicationGatewayOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<ApplicationGatewayPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String applicationGatewayName, final ApplicationGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ApplicationGatewayPutResponse>(){

            @Override
            public ApplicationGatewayPutResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, applicationGatewayName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationGatewayPutResponse beginCreateOrUpdating(String resourceGroupName, String applicationGatewayName, ApplicationGateway parameters) throws IOException, ServiceException {
        ApplicationGatewayPutResponse applicationGatewayPutResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode applicationGatewayJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = applicationGatewayJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        applicationGatewayJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getSku() != null) {
            ObjectNode skuValue = objectMapper.createObjectNode();
            propertiesValue.put("sku", (JsonNode)skuValue);
            if (parameters.getSku().getName() != null) {
                skuValue.put("name", parameters.getSku().getName());
            }
            if (parameters.getSku().getTier() != null) {
                skuValue.put("tier", parameters.getSku().getTier());
            }
            skuValue.put("capacity", parameters.getSku().getCapacity());
        }
        if (parameters.getOperationalState() != null) {
            propertiesValue.put("operationalState", parameters.getOperationalState());
        }
        if (parameters.getGatewayIPConfigurations() != null && (!(parameters.getGatewayIPConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getGatewayIPConfigurations()).isInitialized())) {
            ArrayNode gatewayIPConfigurationsArray = objectMapper.createArrayNode();
            for (ApplicationGatewayIPConfiguration applicationGatewayIPConfiguration : parameters.getGatewayIPConfigurations()) {
                ObjectNode applicationGatewayIPConfigurationJsonFormatValue = objectMapper.createObjectNode();
                gatewayIPConfigurationsArray.add((JsonNode)applicationGatewayIPConfigurationJsonFormatValue);
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                applicationGatewayIPConfigurationJsonFormatValue.put("properties", (JsonNode)propertiesValue2);
                if (applicationGatewayIPConfiguration.getSubnet() != null) {
                    ObjectNode subnetValue = objectMapper.createObjectNode();
                    propertiesValue2.put("subnet", (JsonNode)subnetValue);
                    if (applicationGatewayIPConfiguration.getSubnet().getId() != null) {
                        subnetValue.put("id", applicationGatewayIPConfiguration.getSubnet().getId());
                    }
                }
                if (applicationGatewayIPConfiguration.getProvisioningState() != null) {
                    propertiesValue2.put("provisioningState", applicationGatewayIPConfiguration.getProvisioningState());
                }
                if (applicationGatewayIPConfiguration.getName() != null) {
                    applicationGatewayIPConfigurationJsonFormatValue.put("name", applicationGatewayIPConfiguration.getName());
                }
                if (applicationGatewayIPConfiguration.getEtag() != null) {
                    applicationGatewayIPConfigurationJsonFormatValue.put("etag", applicationGatewayIPConfiguration.getEtag());
                }
                if (applicationGatewayIPConfiguration.getId() == null) continue;
                applicationGatewayIPConfigurationJsonFormatValue.put("id", applicationGatewayIPConfiguration.getId());
            }
            propertiesValue.put("gatewayIPConfigurations", (JsonNode)gatewayIPConfigurationsArray);
        }
        if (parameters.getSslCertificates() != null && (!(parameters.getSslCertificates() instanceof LazyCollection) || ((LazyCollection)parameters.getSslCertificates()).isInitialized())) {
            ArrayNode sslCertificatesArray = objectMapper.createArrayNode();
            for (ApplicationGatewaySslCertificate applicationGatewaySslCertificate : parameters.getSslCertificates()) {
                ObjectNode applicationGatewaySslCertificateJsonFormatValue = objectMapper.createObjectNode();
                sslCertificatesArray.add((JsonNode)applicationGatewaySslCertificateJsonFormatValue);
                ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                applicationGatewaySslCertificateJsonFormatValue.put("properties", (JsonNode)propertiesValue3);
                if (applicationGatewaySslCertificate.getData() != null) {
                    propertiesValue3.put("data", applicationGatewaySslCertificate.getData());
                }
                if (applicationGatewaySslCertificate.getPassword() != null) {
                    propertiesValue3.put("password", applicationGatewaySslCertificate.getPassword());
                }
                if (applicationGatewaySslCertificate.getPublicCertData() != null) {
                    propertiesValue3.put("publicCertData", applicationGatewaySslCertificate.getPublicCertData());
                }
                if (applicationGatewaySslCertificate.getProvisioningState() != null) {
                    propertiesValue3.put("provisioningState", applicationGatewaySslCertificate.getProvisioningState());
                }
                if (applicationGatewaySslCertificate.getName() != null) {
                    applicationGatewaySslCertificateJsonFormatValue.put("name", applicationGatewaySslCertificate.getName());
                }
                if (applicationGatewaySslCertificate.getEtag() != null) {
                    applicationGatewaySslCertificateJsonFormatValue.put("etag", applicationGatewaySslCertificate.getEtag());
                }
                if (applicationGatewaySslCertificate.getId() == null) continue;
                applicationGatewaySslCertificateJsonFormatValue.put("id", applicationGatewaySslCertificate.getId());
            }
            propertiesValue.put("sslCertificates", (JsonNode)sslCertificatesArray);
        }
        if (parameters.getFrontendIPConfigurations() != null && (!(parameters.getFrontendIPConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getFrontendIPConfigurations()).isInitialized())) {
            ArrayNode frontendIPConfigurationsArray = objectMapper.createArrayNode();
            for (ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfiguration : parameters.getFrontendIPConfigurations()) {
                ObjectNode applicationGatewayFrontendIPConfigurationJsonFormatValue = objectMapper.createObjectNode();
                frontendIPConfigurationsArray.add((JsonNode)applicationGatewayFrontendIPConfigurationJsonFormatValue);
                ObjectNode propertiesValue4 = objectMapper.createObjectNode();
                applicationGatewayFrontendIPConfigurationJsonFormatValue.put("properties", (JsonNode)propertiesValue4);
                if (applicationGatewayFrontendIPConfiguration.getPrivateIPAddress() != null) {
                    propertiesValue4.put("privateIPAddress", applicationGatewayFrontendIPConfiguration.getPrivateIPAddress());
                }
                if (applicationGatewayFrontendIPConfiguration.getPrivateIPAllocationMethod() != null) {
                    propertiesValue4.put("privateIPAllocationMethod", applicationGatewayFrontendIPConfiguration.getPrivateIPAllocationMethod());
                }
                if (applicationGatewayFrontendIPConfiguration.getSubnet() != null) {
                    ObjectNode subnetValue2 = objectMapper.createObjectNode();
                    propertiesValue4.put("subnet", (JsonNode)subnetValue2);
                    if (applicationGatewayFrontendIPConfiguration.getSubnet().getId() != null) {
                        subnetValue2.put("id", applicationGatewayFrontendIPConfiguration.getSubnet().getId());
                    }
                }
                if (applicationGatewayFrontendIPConfiguration.getPublicIPAddress() != null) {
                    ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                    propertiesValue4.put("publicIPAddress", (JsonNode)publicIPAddressValue);
                    if (applicationGatewayFrontendIPConfiguration.getPublicIPAddress().getId() != null) {
                        publicIPAddressValue.put("id", applicationGatewayFrontendIPConfiguration.getPublicIPAddress().getId());
                    }
                }
                if (applicationGatewayFrontendIPConfiguration.getProvisioningState() != null) {
                    propertiesValue4.put("provisioningState", applicationGatewayFrontendIPConfiguration.getProvisioningState());
                }
                if (applicationGatewayFrontendIPConfiguration.getName() != null) {
                    applicationGatewayFrontendIPConfigurationJsonFormatValue.put("name", applicationGatewayFrontendIPConfiguration.getName());
                }
                if (applicationGatewayFrontendIPConfiguration.getEtag() != null) {
                    applicationGatewayFrontendIPConfigurationJsonFormatValue.put("etag", applicationGatewayFrontendIPConfiguration.getEtag());
                }
                if (applicationGatewayFrontendIPConfiguration.getId() == null) continue;
                applicationGatewayFrontendIPConfigurationJsonFormatValue.put("id", applicationGatewayFrontendIPConfiguration.getId());
            }
            propertiesValue.put("frontendIPConfigurations", (JsonNode)frontendIPConfigurationsArray);
        }
        if (parameters.getFrontendPorts() != null && (!(parameters.getFrontendPorts() instanceof LazyCollection) || ((LazyCollection)parameters.getFrontendPorts()).isInitialized())) {
            ArrayNode frontendPortsArray = objectMapper.createArrayNode();
            for (ApplicationGatewayFrontendPort applicationGatewayFrontendPort : parameters.getFrontendPorts()) {
                ObjectNode applicationGatewayFrontendPortJsonFormatValue = objectMapper.createObjectNode();
                frontendPortsArray.add((JsonNode)applicationGatewayFrontendPortJsonFormatValue);
                ObjectNode propertiesValue5 = objectMapper.createObjectNode();
                applicationGatewayFrontendPortJsonFormatValue.put("properties", (JsonNode)propertiesValue5);
                propertiesValue5.put("port", applicationGatewayFrontendPort.getPort());
                if (applicationGatewayFrontendPort.getProvisioningState() != null) {
                    propertiesValue5.put("provisioningState", applicationGatewayFrontendPort.getProvisioningState());
                }
                if (applicationGatewayFrontendPort.getName() != null) {
                    applicationGatewayFrontendPortJsonFormatValue.put("name", applicationGatewayFrontendPort.getName());
                }
                if (applicationGatewayFrontendPort.getEtag() != null) {
                    applicationGatewayFrontendPortJsonFormatValue.put("etag", applicationGatewayFrontendPort.getEtag());
                }
                if (applicationGatewayFrontendPort.getId() == null) continue;
                applicationGatewayFrontendPortJsonFormatValue.put("id", applicationGatewayFrontendPort.getId());
            }
            propertiesValue.put("frontendPorts", (JsonNode)frontendPortsArray);
        }
        if (parameters.getBackendAddressPools() != null && (!(parameters.getBackendAddressPools() instanceof LazyCollection) || ((LazyCollection)parameters.getBackendAddressPools()).isInitialized())) {
            ArrayNode backendAddressPoolsArray = objectMapper.createArrayNode();
            for (ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPool : parameters.getBackendAddressPools()) {
                ObjectNode applicationGatewayBackendAddressPoolJsonFormatValue = objectMapper.createObjectNode();
                backendAddressPoolsArray.add((JsonNode)applicationGatewayBackendAddressPoolJsonFormatValue);
                ObjectNode propertiesValue6 = objectMapper.createObjectNode();
                applicationGatewayBackendAddressPoolJsonFormatValue.put("properties", (JsonNode)propertiesValue6);
                if (applicationGatewayBackendAddressPool.getBackendIPConfigurations() != null && (!(applicationGatewayBackendAddressPool.getBackendIPConfigurations() instanceof LazyCollection) || ((LazyCollection)applicationGatewayBackendAddressPool.getBackendIPConfigurations()).isInitialized())) {
                    ArrayNode backendIPConfigurationsArray = objectMapper.createArrayNode();
                    for (ResourceId backendIPConfigurationsItem : applicationGatewayBackendAddressPool.getBackendIPConfigurations()) {
                        ObjectNode resourceIdValue = objectMapper.createObjectNode();
                        backendIPConfigurationsArray.add((JsonNode)resourceIdValue);
                        if (backendIPConfigurationsItem.getId() == null) continue;
                        resourceIdValue.put("id", backendIPConfigurationsItem.getId());
                    }
                    propertiesValue6.put("backendIPConfigurations", (JsonNode)backendIPConfigurationsArray);
                }
                if (applicationGatewayBackendAddressPool.getBackendAddresses() != null && (!(applicationGatewayBackendAddressPool.getBackendAddresses() instanceof LazyCollection) || ((LazyCollection)applicationGatewayBackendAddressPool.getBackendAddresses()).isInitialized())) {
                    ArrayNode backendAddressesArray = objectMapper.createArrayNode();
                    for (ApplicationGatewayBackendAddress backendAddressesItem : applicationGatewayBackendAddressPool.getBackendAddresses()) {
                        ObjectNode applicationGatewayBackendAddressValue = objectMapper.createObjectNode();
                        backendAddressesArray.add((JsonNode)applicationGatewayBackendAddressValue);
                        if (backendAddressesItem.getFqdn() != null) {
                            applicationGatewayBackendAddressValue.put("fqdn", backendAddressesItem.getFqdn());
                        }
                        if (backendAddressesItem.getIpAddress() == null) continue;
                        applicationGatewayBackendAddressValue.put("ipAddress", backendAddressesItem.getIpAddress());
                    }
                    propertiesValue6.put("backendAddresses", (JsonNode)backendAddressesArray);
                }
                if (applicationGatewayBackendAddressPool.getProvisioningState() != null) {
                    propertiesValue6.put("provisioningState", applicationGatewayBackendAddressPool.getProvisioningState());
                }
                if (applicationGatewayBackendAddressPool.getName() != null) {
                    applicationGatewayBackendAddressPoolJsonFormatValue.put("name", applicationGatewayBackendAddressPool.getName());
                }
                if (applicationGatewayBackendAddressPool.getEtag() != null) {
                    applicationGatewayBackendAddressPoolJsonFormatValue.put("etag", applicationGatewayBackendAddressPool.getEtag());
                }
                if (applicationGatewayBackendAddressPool.getId() == null) continue;
                applicationGatewayBackendAddressPoolJsonFormatValue.put("id", applicationGatewayBackendAddressPool.getId());
            }
            propertiesValue.put("backendAddressPools", (JsonNode)backendAddressPoolsArray);
        }
        if (parameters.getBackendHttpSettingsCollection() != null && (!(parameters.getBackendHttpSettingsCollection() instanceof LazyCollection) || ((LazyCollection)parameters.getBackendHttpSettingsCollection()).isInitialized())) {
            ArrayNode backendHttpSettingsCollectionArray = objectMapper.createArrayNode();
            for (ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettings : parameters.getBackendHttpSettingsCollection()) {
                ObjectNode applicationGatewayBackendHttpSettingsJsonFormatValue = objectMapper.createObjectNode();
                backendHttpSettingsCollectionArray.add((JsonNode)applicationGatewayBackendHttpSettingsJsonFormatValue);
                ObjectNode propertiesValue7 = objectMapper.createObjectNode();
                applicationGatewayBackendHttpSettingsJsonFormatValue.put("properties", (JsonNode)propertiesValue7);
                propertiesValue7.put("port", applicationGatewayBackendHttpSettings.getPort());
                if (applicationGatewayBackendHttpSettings.getProtocol() != null) {
                    propertiesValue7.put("protocol", applicationGatewayBackendHttpSettings.getProtocol());
                }
                if (applicationGatewayBackendHttpSettings.getCookieBasedAffinity() != null) {
                    propertiesValue7.put("cookieBasedAffinity", applicationGatewayBackendHttpSettings.getCookieBasedAffinity());
                }
                if (applicationGatewayBackendHttpSettings.getProvisioningState() != null) {
                    propertiesValue7.put("provisioningState", applicationGatewayBackendHttpSettings.getProvisioningState());
                }
                if (applicationGatewayBackendHttpSettings.getName() != null) {
                    applicationGatewayBackendHttpSettingsJsonFormatValue.put("name", applicationGatewayBackendHttpSettings.getName());
                }
                if (applicationGatewayBackendHttpSettings.getEtag() != null) {
                    applicationGatewayBackendHttpSettingsJsonFormatValue.put("etag", applicationGatewayBackendHttpSettings.getEtag());
                }
                if (applicationGatewayBackendHttpSettings.getId() == null) continue;
                applicationGatewayBackendHttpSettingsJsonFormatValue.put("id", applicationGatewayBackendHttpSettings.getId());
            }
            propertiesValue.put("backendHttpSettingsCollection", (JsonNode)backendHttpSettingsCollectionArray);
        }
        if (parameters.getHttpListeners() != null && (!(parameters.getHttpListeners() instanceof LazyCollection) || ((LazyCollection)parameters.getHttpListeners()).isInitialized())) {
            ArrayNode httpListenersArray = objectMapper.createArrayNode();
            for (ApplicationGatewayHttpListener applicationGatewayHttpListener : parameters.getHttpListeners()) {
                ObjectNode applicationGatewayHttpListenerJsonFormatValue = objectMapper.createObjectNode();
                httpListenersArray.add((JsonNode)applicationGatewayHttpListenerJsonFormatValue);
                ObjectNode propertiesValue8 = objectMapper.createObjectNode();
                applicationGatewayHttpListenerJsonFormatValue.put("properties", (JsonNode)propertiesValue8);
                if (applicationGatewayHttpListener.getFrontendIPConfiguration() != null) {
                    ObjectNode frontendIPConfigurationValue = objectMapper.createObjectNode();
                    propertiesValue8.put("frontendIPConfiguration", (JsonNode)frontendIPConfigurationValue);
                    if (applicationGatewayHttpListener.getFrontendIPConfiguration().getId() != null) {
                        frontendIPConfigurationValue.put("id", applicationGatewayHttpListener.getFrontendIPConfiguration().getId());
                    }
                }
                if (applicationGatewayHttpListener.getFrontendPort() != null) {
                    ObjectNode frontendPortValue = objectMapper.createObjectNode();
                    propertiesValue8.put("frontendPort", (JsonNode)frontendPortValue);
                    if (applicationGatewayHttpListener.getFrontendPort().getId() != null) {
                        frontendPortValue.put("id", applicationGatewayHttpListener.getFrontendPort().getId());
                    }
                }
                if (applicationGatewayHttpListener.getProtocol() != null) {
                    propertiesValue8.put("protocol", applicationGatewayHttpListener.getProtocol());
                }
                if (applicationGatewayHttpListener.getSslCertificate() != null) {
                    ObjectNode sslCertificateValue = objectMapper.createObjectNode();
                    propertiesValue8.put("sslCertificate", (JsonNode)sslCertificateValue);
                    if (applicationGatewayHttpListener.getSslCertificate().getId() != null) {
                        sslCertificateValue.put("id", applicationGatewayHttpListener.getSslCertificate().getId());
                    }
                }
                if (applicationGatewayHttpListener.getProvisioningState() != null) {
                    propertiesValue8.put("provisioningState", applicationGatewayHttpListener.getProvisioningState());
                }
                if (applicationGatewayHttpListener.getName() != null) {
                    applicationGatewayHttpListenerJsonFormatValue.put("name", applicationGatewayHttpListener.getName());
                }
                if (applicationGatewayHttpListener.getEtag() != null) {
                    applicationGatewayHttpListenerJsonFormatValue.put("etag", applicationGatewayHttpListener.getEtag());
                }
                if (applicationGatewayHttpListener.getId() == null) continue;
                applicationGatewayHttpListenerJsonFormatValue.put("id", applicationGatewayHttpListener.getId());
            }
            propertiesValue.put("httpListeners", (JsonNode)httpListenersArray);
        }
        if (parameters.getRequestRoutingRules() != null && (!(parameters.getRequestRoutingRules() instanceof LazyCollection) || ((LazyCollection)parameters.getRequestRoutingRules()).isInitialized())) {
            ArrayNode requestRoutingRulesArray = objectMapper.createArrayNode();
            for (ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRule : parameters.getRequestRoutingRules()) {
                ObjectNode applicationGatewayRequestRoutingRuleJsonFormatValue = objectMapper.createObjectNode();
                requestRoutingRulesArray.add((JsonNode)applicationGatewayRequestRoutingRuleJsonFormatValue);
                ObjectNode propertiesValue9 = objectMapper.createObjectNode();
                applicationGatewayRequestRoutingRuleJsonFormatValue.put("properties", (JsonNode)propertiesValue9);
                if (applicationGatewayRequestRoutingRule.getRuleType() != null) {
                    propertiesValue9.put("ruleType", applicationGatewayRequestRoutingRule.getRuleType());
                }
                if (applicationGatewayRequestRoutingRule.getBackendAddressPool() != null) {
                    ObjectNode backendAddressPoolValue = objectMapper.createObjectNode();
                    propertiesValue9.put("backendAddressPool", (JsonNode)backendAddressPoolValue);
                    if (applicationGatewayRequestRoutingRule.getBackendAddressPool().getId() != null) {
                        backendAddressPoolValue.put("id", applicationGatewayRequestRoutingRule.getBackendAddressPool().getId());
                    }
                }
                if (applicationGatewayRequestRoutingRule.getBackendHttpSettings() != null) {
                    ObjectNode backendHttpSettingsValue = objectMapper.createObjectNode();
                    propertiesValue9.put("backendHttpSettings", (JsonNode)backendHttpSettingsValue);
                    if (applicationGatewayRequestRoutingRule.getBackendHttpSettings().getId() != null) {
                        backendHttpSettingsValue.put("id", applicationGatewayRequestRoutingRule.getBackendHttpSettings().getId());
                    }
                }
                if (applicationGatewayRequestRoutingRule.getHttpListener() != null) {
                    ObjectNode httpListenerValue = objectMapper.createObjectNode();
                    propertiesValue9.put("httpListener", (JsonNode)httpListenerValue);
                    if (applicationGatewayRequestRoutingRule.getHttpListener().getId() != null) {
                        httpListenerValue.put("id", applicationGatewayRequestRoutingRule.getHttpListener().getId());
                    }
                }
                if (applicationGatewayRequestRoutingRule.getProvisioningState() != null) {
                    propertiesValue9.put("provisioningState", applicationGatewayRequestRoutingRule.getProvisioningState());
                }
                if (applicationGatewayRequestRoutingRule.getName() != null) {
                    applicationGatewayRequestRoutingRuleJsonFormatValue.put("name", applicationGatewayRequestRoutingRule.getName());
                }
                if (applicationGatewayRequestRoutingRule.getEtag() != null) {
                    applicationGatewayRequestRoutingRuleJsonFormatValue.put("etag", applicationGatewayRequestRoutingRule.getEtag());
                }
                if (applicationGatewayRequestRoutingRule.getId() == null) continue;
                applicationGatewayRequestRoutingRuleJsonFormatValue.put("id", applicationGatewayRequestRoutingRule.getId());
            }
            propertiesValue.put("requestRoutingRules", (JsonNode)requestRoutingRulesArray);
        }
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            applicationGatewayJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            applicationGatewayJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            applicationGatewayJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            applicationGatewayJsonFormatValue.put("type", parameters.getType());
        }
        applicationGatewayJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            applicationGatewayJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var17_34 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ApplicationGatewayPutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new ApplicationGatewayPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue10;
                    JsonNode idValue19;
                    JsonNode etagValue9;
                    ApplicationGateway applicationGatewayInstance = new ApplicationGateway();
                    result.setApplicationGateway(applicationGatewayInstance);
                    JsonNode propertiesValue10 = responseDoc.get("properties");
                    if (propertiesValue10 != null && !(propertiesValue10 instanceof NullNode)) {
                        JsonNode provisioningStateValue9;
                        JsonNode requestRoutingRulesArray2;
                        JsonNode httpListenersArray2;
                        JsonNode backendHttpSettingsCollectionArray2;
                        JsonNode backendAddressPoolsArray2;
                        JsonNode frontendPortsArray2;
                        JsonNode frontendIPConfigurationsArray2;
                        JsonNode sslCertificatesArray2;
                        JsonNode gatewayIPConfigurationsArray2;
                        JsonNode operationalStateValue;
                        JsonNode skuValue2 = propertiesValue10.get("sku");
                        if (skuValue2 != null && !(skuValue2 instanceof NullNode)) {
                            JsonNode capacityValue;
                            Iterator tierValue;
                            ApplicationGatewaySku skuInstance = new ApplicationGatewaySku();
                            applicationGatewayInstance.setSku(skuInstance);
                            JsonNode nameValue = skuValue2.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                skuInstance.setName(nameInstance);
                            }
                            if ((tierValue = skuValue2.get("tier")) != null && !(tierValue instanceof NullNode)) {
                                String tierInstance = tierValue.getTextValue();
                                skuInstance.setTier(tierInstance);
                            }
                            if ((capacityValue = skuValue2.get("capacity")) != null && !(capacityValue instanceof NullNode)) {
                                int capacityInstance = capacityValue.getIntValue();
                                skuInstance.setCapacity(capacityInstance);
                            }
                        }
                        if ((operationalStateValue = propertiesValue10.get("operationalState")) != null && !(operationalStateValue instanceof NullNode)) {
                            String operationalStateInstance = operationalStateValue.getTextValue();
                            applicationGatewayInstance.setOperationalState(operationalStateInstance);
                        }
                        if ((gatewayIPConfigurationsArray2 = propertiesValue10.get("gatewayIPConfigurations")) != null && !(gatewayIPConfigurationsArray2 instanceof NullNode)) {
                            for (Iterator gatewayIPConfigurationsValue : (ArrayNode)gatewayIPConfigurationsArray2) {
                                JsonNode idValue2;
                                JsonNode etagValue;
                                JsonNode nameValue2;
                                ApplicationGatewayIPConfiguration applicationGatewayIPConfigurationJsonFormatInstance = new ApplicationGatewayIPConfiguration();
                                applicationGatewayInstance.getGatewayIPConfigurations().add(applicationGatewayIPConfigurationJsonFormatInstance);
                                JsonNode propertiesValue11 = gatewayIPConfigurationsValue.get("properties");
                                if (propertiesValue11 != null && !(propertiesValue11 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode subnetValue3 = propertiesValue11.get("subnet");
                                    if (subnetValue3 != null && !(subnetValue3 instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue3.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue11.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue2 = gatewayIPConfigurationsValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setName(nameInstance2);
                                }
                                if ((etagValue = gatewayIPConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue2 = gatewayIPConfigurationsValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                String idInstance2 = idValue2.getTextValue();
                                applicationGatewayIPConfigurationJsonFormatInstance.setId(idInstance2);
                            }
                        }
                        if ((sslCertificatesArray2 = propertiesValue10.get("sslCertificates")) != null && !(sslCertificatesArray2 instanceof NullNode)) {
                            for (JsonNode sslCertificatesValue : (ArrayNode)sslCertificatesArray2) {
                                JsonNode idValue3;
                                JsonNode etagValue2;
                                JsonNode nameValue3;
                                ApplicationGatewaySslCertificate applicationGatewaySslCertificateJsonFormatInstance = new ApplicationGatewaySslCertificate();
                                applicationGatewayInstance.getSslCertificates().add(applicationGatewaySslCertificateJsonFormatInstance);
                                JsonNode propertiesValue12 = sslCertificatesValue.get("properties");
                                if (propertiesValue12 != null && !(propertiesValue12 instanceof NullNode)) {
                                    JsonNode provisioningStateValue2;
                                    JsonNode publicCertDataValue;
                                    JsonNode passwordValue;
                                    JsonNode dataValue = propertiesValue12.get("data");
                                    if (dataValue != null && !(dataValue instanceof NullNode)) {
                                        String dataInstance = dataValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setData(dataInstance);
                                    }
                                    if ((passwordValue = propertiesValue12.get("password")) != null && !(passwordValue instanceof NullNode)) {
                                        String passwordInstance = passwordValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setPassword(passwordInstance);
                                    }
                                    if ((publicCertDataValue = propertiesValue12.get("publicCertData")) != null && !(publicCertDataValue instanceof NullNode)) {
                                        String publicCertDataInstance = publicCertDataValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setPublicCertData(publicCertDataInstance);
                                    }
                                    if ((provisioningStateValue2 = propertiesValue12.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                if ((nameValue3 = sslCertificatesValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                    String nameInstance3 = nameValue3.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setName(nameInstance3);
                                }
                                if ((etagValue2 = sslCertificatesValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                    String etagInstance2 = etagValue2.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setEtag(etagInstance2);
                                }
                                if ((idValue3 = sslCertificatesValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                applicationGatewaySslCertificateJsonFormatInstance.setId(idInstance3);
                            }
                        }
                        if ((frontendIPConfigurationsArray2 = propertiesValue10.get("frontendIPConfigurations")) != null && !(frontendIPConfigurationsArray2 instanceof NullNode)) {
                            for (Iterator frontendIPConfigurationsValue : (ArrayNode)frontendIPConfigurationsArray2) {
                                JsonNode idValue6;
                                JsonNode etagValue3;
                                JsonNode nameValue4;
                                ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfigurationJsonFormatInstance = new ApplicationGatewayFrontendIPConfiguration();
                                applicationGatewayInstance.getFrontendIPConfigurations().add(applicationGatewayFrontendIPConfigurationJsonFormatInstance);
                                JsonNode propertiesValue13 = frontendIPConfigurationsValue.get("properties");
                                if (propertiesValue13 != null && !(propertiesValue13 instanceof NullNode)) {
                                    JsonNode provisioningStateValue3;
                                    JsonNode publicIPAddressValue2;
                                    JsonNode subnetValue4;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue13.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue13.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue4 = propertiesValue13.get("subnet")) != null && !(subnetValue4 instanceof NullNode)) {
                                        ResourceId subnetInstance2 = new ResourceId();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setSubnet(subnetInstance2);
                                        JsonNode idValue4 = subnetValue4.get("id");
                                        if (idValue4 != null && !(idValue4 instanceof NullNode)) {
                                            String idInstance4 = idValue4.getTextValue();
                                            subnetInstance2.setId(idInstance4);
                                        }
                                    }
                                    if ((publicIPAddressValue2 = propertiesValue13.get("publicIPAddress")) != null && !(publicIPAddressValue2 instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPublicIPAddress(publicIPAddressInstance);
                                        JsonNode idValue5 = publicIPAddressValue2.get("id");
                                        if (idValue5 != null && !(idValue5 instanceof NullNode)) {
                                            String idInstance5 = idValue5.getTextValue();
                                            publicIPAddressInstance.setId(idInstance5);
                                        }
                                    }
                                    if ((provisioningStateValue3 = propertiesValue13.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                        String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                    }
                                }
                                if ((nameValue4 = frontendIPConfigurationsValue.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                    String nameInstance4 = nameValue4.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setName(nameInstance4);
                                }
                                if ((etagValue3 = frontendIPConfigurationsValue.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                    String etagInstance3 = etagValue3.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setEtag(etagInstance3);
                                }
                                if ((idValue6 = frontendIPConfigurationsValue.get("id")) == null || idValue6 instanceof NullNode) continue;
                                String idInstance6 = idValue6.getTextValue();
                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setId(idInstance6);
                            }
                        }
                        if ((frontendPortsArray2 = propertiesValue10.get("frontendPorts")) != null && !(frontendPortsArray2 instanceof NullNode)) {
                            for (Iterator frontendPortsValue : (ArrayNode)frontendPortsArray2) {
                                Object idValue7;
                                JsonNode etagValue4;
                                JsonNode nameValue5;
                                ApplicationGatewayFrontendPort applicationGatewayFrontendPortJsonFormatInstance = new ApplicationGatewayFrontendPort();
                                applicationGatewayInstance.getFrontendPorts().add(applicationGatewayFrontendPortJsonFormatInstance);
                                JsonNode propertiesValue14 = frontendPortsValue.get("properties");
                                if (propertiesValue14 != null && !(propertiesValue14 instanceof NullNode)) {
                                    JsonNode provisioningStateValue4;
                                    JsonNode portValue = propertiesValue14.get("port");
                                    if (portValue != null && !(portValue instanceof NullNode)) {
                                        int portInstance = portValue.getIntValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setPort(portInstance);
                                    }
                                    if ((provisioningStateValue4 = propertiesValue14.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                        String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                    }
                                }
                                if ((nameValue5 = frontendPortsValue.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                    String nameInstance5 = nameValue5.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setName(nameInstance5);
                                }
                                if ((etagValue4 = frontendPortsValue.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                    String etagInstance4 = etagValue4.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setEtag(etagInstance4);
                                }
                                if ((idValue7 = frontendPortsValue.get("id")) == null || idValue7 instanceof NullNode) continue;
                                String idInstance7 = idValue7.getTextValue();
                                applicationGatewayFrontendPortJsonFormatInstance.setId(idInstance7);
                            }
                        }
                        if ((backendAddressPoolsArray2 = propertiesValue10.get("backendAddressPools")) != null && !(backendAddressPoolsArray2 instanceof NullNode)) {
                            for (Iterator backendAddressPoolsValue : (ArrayNode)backendAddressPoolsArray2) {
                                JsonNode idValue9;
                                JsonNode etagValue5;
                                JsonNode nameValue6;
                                ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPoolJsonFormatInstance = new ApplicationGatewayBackendAddressPool();
                                applicationGatewayInstance.getBackendAddressPools().add(applicationGatewayBackendAddressPoolJsonFormatInstance);
                                JsonNode propertiesValue15 = backendAddressPoolsValue.get("properties");
                                if (propertiesValue15 != null && !(propertiesValue15 instanceof NullNode)) {
                                    JsonNode provisioningStateValue5;
                                    JsonNode backendAddressesArray2;
                                    JsonNode backendIPConfigurationsArray2 = propertiesValue15.get("backendIPConfigurations");
                                    if (backendIPConfigurationsArray2 != null && !(backendIPConfigurationsArray2 instanceof NullNode)) {
                                        for (Iterator backendIPConfigurationsValue : (ArrayNode)backendIPConfigurationsArray2) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendIPConfigurations().add(resourceIdInstance);
                                            JsonNode idValue8 = backendIPConfigurationsValue.get("id");
                                            if (idValue8 == null || idValue8 instanceof NullNode) continue;
                                            String idInstance8 = idValue8.getTextValue();
                                            resourceIdInstance.setId(idInstance8);
                                        }
                                    }
                                    if ((backendAddressesArray2 = propertiesValue15.get("backendAddresses")) != null && !(backendAddressesArray2 instanceof NullNode)) {
                                        Iterator backendIPConfigurationsValue;
                                        backendIPConfigurationsValue = ((ArrayNode)backendAddressesArray2).iterator();
                                        while (backendIPConfigurationsValue.hasNext()) {
                                            JsonNode ipAddressValue;
                                            JsonNode backendAddressesValue = (JsonNode)backendIPConfigurationsValue.next();
                                            ApplicationGatewayBackendAddress applicationGatewayBackendAddressInstance = new ApplicationGatewayBackendAddress();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendAddresses().add(applicationGatewayBackendAddressInstance);
                                            JsonNode fqdnValue = backendAddressesValue.get("fqdn");
                                            if (fqdnValue != null && !(fqdnValue instanceof NullNode)) {
                                                String fqdnInstance = fqdnValue.getTextValue();
                                                applicationGatewayBackendAddressInstance.setFqdn(fqdnInstance);
                                            }
                                            if ((ipAddressValue = backendAddressesValue.get("ipAddress")) == null || ipAddressValue instanceof NullNode) continue;
                                            String ipAddressInstance = ipAddressValue.getTextValue();
                                            applicationGatewayBackendAddressInstance.setIpAddress(ipAddressInstance);
                                        }
                                    }
                                    if ((provisioningStateValue5 = propertiesValue15.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                        String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        applicationGatewayBackendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                    }
                                }
                                if ((nameValue6 = backendAddressPoolsValue.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                                    String nameInstance6 = nameValue6.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setName(nameInstance6);
                                }
                                if ((etagValue5 = backendAddressPoolsValue.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                    String etagInstance5 = etagValue5.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setEtag(etagInstance5);
                                }
                                if ((idValue9 = backendAddressPoolsValue.get("id")) == null || idValue9 instanceof NullNode) continue;
                                String idInstance9 = idValue9.getTextValue();
                                applicationGatewayBackendAddressPoolJsonFormatInstance.setId(idInstance9);
                            }
                        }
                        if ((backendHttpSettingsCollectionArray2 = propertiesValue10.get("backendHttpSettingsCollection")) != null && !(backendHttpSettingsCollectionArray2 instanceof NullNode)) {
                            for (Iterator backendHttpSettingsCollectionValue : (ArrayNode)backendHttpSettingsCollectionArray2) {
                                JsonNode idValue10;
                                JsonNode etagValue6;
                                JsonNode nameValue7;
                                ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettingsJsonFormatInstance = new ApplicationGatewayBackendHttpSettings();
                                applicationGatewayInstance.getBackendHttpSettingsCollection().add(applicationGatewayBackendHttpSettingsJsonFormatInstance);
                                JsonNode propertiesValue16 = backendHttpSettingsCollectionValue.get("properties");
                                if (propertiesValue16 != null && !(propertiesValue16 instanceof NullNode)) {
                                    JsonNode provisioningStateValue6;
                                    JsonNode cookieBasedAffinityValue;
                                    JsonNode protocolValue;
                                    JsonNode portValue2 = propertiesValue16.get("port");
                                    if (portValue2 != null && !(portValue2 instanceof NullNode)) {
                                        int portInstance2 = portValue2.getIntValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setPort(portInstance2);
                                    }
                                    if ((protocolValue = propertiesValue16.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                        String protocolInstance = protocolValue.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    if ((cookieBasedAffinityValue = propertiesValue16.get("cookieBasedAffinity")) != null && !(cookieBasedAffinityValue instanceof NullNode)) {
                                        String cookieBasedAffinityInstance = cookieBasedAffinityValue.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setCookieBasedAffinity(cookieBasedAffinityInstance);
                                    }
                                    if ((provisioningStateValue6 = propertiesValue16.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                                        String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                    }
                                }
                                if ((nameValue7 = backendHttpSettingsCollectionValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                    String nameInstance7 = nameValue7.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setName(nameInstance7);
                                }
                                if ((etagValue6 = backendHttpSettingsCollectionValue.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                                    String etagInstance6 = etagValue6.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setEtag(etagInstance6);
                                }
                                if ((idValue10 = backendHttpSettingsCollectionValue.get("id")) == null || idValue10 instanceof NullNode) continue;
                                String idInstance10 = idValue10.getTextValue();
                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setId(idInstance10);
                            }
                        }
                        if ((httpListenersArray2 = propertiesValue10.get("httpListeners")) != null && !(httpListenersArray2 instanceof NullNode)) {
                            for (Iterator httpListenersValue : (ArrayNode)httpListenersArray2) {
                                JsonNode idValue14;
                                JsonNode etagValue7;
                                JsonNode nameValue8;
                                ApplicationGatewayHttpListener applicationGatewayHttpListenerJsonFormatInstance = new ApplicationGatewayHttpListener();
                                applicationGatewayInstance.getHttpListeners().add(applicationGatewayHttpListenerJsonFormatInstance);
                                JsonNode propertiesValue17 = httpListenersValue.get("properties");
                                if (propertiesValue17 != null && !(propertiesValue17 instanceof NullNode)) {
                                    JsonNode provisioningStateValue7;
                                    JsonNode sslCertificateValue2;
                                    JsonNode protocolValue2;
                                    JsonNode frontendPortValue2;
                                    JsonNode frontendIPConfigurationValue2 = propertiesValue17.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue2 != null && !(frontendIPConfigurationValue2 instanceof NullNode)) {
                                        ResourceId frontendIPConfigurationInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                        JsonNode idValue11 = frontendIPConfigurationValue2.get("id");
                                        if (idValue11 != null && !(idValue11 instanceof NullNode)) {
                                            String idInstance11 = idValue11.getTextValue();
                                            frontendIPConfigurationInstance.setId(idInstance11);
                                        }
                                    }
                                    if ((frontendPortValue2 = propertiesValue17.get("frontendPort")) != null && !(frontendPortValue2 instanceof NullNode)) {
                                        ResourceId frontendPortInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                        JsonNode idValue12 = frontendPortValue2.get("id");
                                        if (idValue12 != null && !(idValue12 instanceof NullNode)) {
                                            String idInstance12 = idValue12.getTextValue();
                                            frontendPortInstance.setId(idInstance12);
                                        }
                                    }
                                    if ((protocolValue2 = propertiesValue17.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                        String protocolInstance2 = protocolValue2.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setProtocol(protocolInstance2);
                                    }
                                    if ((sslCertificateValue2 = propertiesValue17.get("sslCertificate")) != null && !(sslCertificateValue2 instanceof NullNode)) {
                                        ResourceId sslCertificateInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setSslCertificate(sslCertificateInstance);
                                        JsonNode idValue13 = sslCertificateValue2.get("id");
                                        if (idValue13 != null && !(idValue13 instanceof NullNode)) {
                                            String idInstance13 = idValue13.getTextValue();
                                            sslCertificateInstance.setId(idInstance13);
                                        }
                                    }
                                    if ((provisioningStateValue7 = propertiesValue17.get("provisioningState")) != null && !(provisioningStateValue7 instanceof NullNode)) {
                                        String provisioningStateInstance7 = provisioningStateValue7.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setProvisioningState(provisioningStateInstance7);
                                    }
                                }
                                if ((nameValue8 = httpListenersValue.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                                    String nameInstance8 = nameValue8.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setName(nameInstance8);
                                }
                                if ((etagValue7 = httpListenersValue.get("etag")) != null && !(etagValue7 instanceof NullNode)) {
                                    String etagInstance7 = etagValue7.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setEtag(etagInstance7);
                                }
                                if ((idValue14 = httpListenersValue.get("id")) == null || idValue14 instanceof NullNode) continue;
                                String idInstance14 = idValue14.getTextValue();
                                applicationGatewayHttpListenerJsonFormatInstance.setId(idInstance14);
                            }
                        }
                        if ((requestRoutingRulesArray2 = propertiesValue10.get("requestRoutingRules")) != null && !(requestRoutingRulesArray2 instanceof NullNode)) {
                            for (JsonNode requestRoutingRulesValue : (ArrayNode)requestRoutingRulesArray2) {
                                JsonNode idValue18;
                                JsonNode etagValue8;
                                JsonNode nameValue9;
                                ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRuleJsonFormatInstance = new ApplicationGatewayRequestRoutingRule();
                                applicationGatewayInstance.getRequestRoutingRules().add(applicationGatewayRequestRoutingRuleJsonFormatInstance);
                                JsonNode propertiesValue18 = requestRoutingRulesValue.get("properties");
                                if (propertiesValue18 != null && !(propertiesValue18 instanceof NullNode)) {
                                    JsonNode provisioningStateValue8;
                                    JsonNode httpListenerValue2;
                                    JsonNode backendHttpSettingsValue2;
                                    JsonNode backendAddressPoolValue2;
                                    JsonNode ruleTypeValue = propertiesValue18.get("ruleType");
                                    if (ruleTypeValue != null && !(ruleTypeValue instanceof NullNode)) {
                                        String ruleTypeInstance = ruleTypeValue.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setRuleType(ruleTypeInstance);
                                    }
                                    if ((backendAddressPoolValue2 = propertiesValue18.get("backendAddressPool")) != null && !(backendAddressPoolValue2 instanceof NullNode)) {
                                        ResourceId backendAddressPoolInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                        JsonNode idValue15 = backendAddressPoolValue2.get("id");
                                        if (idValue15 != null && !(idValue15 instanceof NullNode)) {
                                            String idInstance15 = idValue15.getTextValue();
                                            backendAddressPoolInstance.setId(idInstance15);
                                        }
                                    }
                                    if ((backendHttpSettingsValue2 = propertiesValue18.get("backendHttpSettings")) != null && !(backendHttpSettingsValue2 instanceof NullNode)) {
                                        ResourceId backendHttpSettingsInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendHttpSettings(backendHttpSettingsInstance);
                                        JsonNode idValue16 = backendHttpSettingsValue2.get("id");
                                        if (idValue16 != null && !(idValue16 instanceof NullNode)) {
                                            String idInstance16 = idValue16.getTextValue();
                                            backendHttpSettingsInstance.setId(idInstance16);
                                        }
                                    }
                                    if ((httpListenerValue2 = propertiesValue18.get("httpListener")) != null && !(httpListenerValue2 instanceof NullNode)) {
                                        ResourceId httpListenerInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setHttpListener(httpListenerInstance);
                                        JsonNode idValue17 = httpListenerValue2.get("id");
                                        if (idValue17 != null && !(idValue17 instanceof NullNode)) {
                                            String idInstance17 = idValue17.getTextValue();
                                            httpListenerInstance.setId(idInstance17);
                                        }
                                    }
                                    if ((provisioningStateValue8 = propertiesValue18.get("provisioningState")) != null && !(provisioningStateValue8 instanceof NullNode)) {
                                        String provisioningStateInstance8 = provisioningStateValue8.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance8);
                                    }
                                }
                                if ((nameValue9 = requestRoutingRulesValue.get("name")) != null && !(nameValue9 instanceof NullNode)) {
                                    String nameInstance9 = nameValue9.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setName(nameInstance9);
                                }
                                if ((etagValue8 = requestRoutingRulesValue.get("etag")) != null && !(etagValue8 instanceof NullNode)) {
                                    String etagInstance8 = etagValue8.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setEtag(etagInstance8);
                                }
                                if ((idValue18 = requestRoutingRulesValue.get("id")) == null || idValue18 instanceof NullNode) continue;
                                String idInstance18 = idValue18.getTextValue();
                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setId(idInstance18);
                            }
                        }
                        if ((provisioningStateValue9 = propertiesValue10.get("provisioningState")) != null && !(provisioningStateValue9 instanceof NullNode)) {
                            String provisioningStateInstance9 = provisioningStateValue9.getTextValue();
                            applicationGatewayInstance.setProvisioningState(provisioningStateInstance9);
                        }
                    }
                    if ((etagValue9 = responseDoc.get("etag")) != null && !(etagValue9 instanceof NullNode)) {
                        String etagInstance9 = etagValue9.getTextValue();
                        applicationGatewayInstance.setEtag(etagInstance9);
                    }
                    if ((idValue19 = responseDoc.get("id")) != null && !(idValue19 instanceof NullNode)) {
                        String idInstance19 = idValue19.getTextValue();
                        applicationGatewayInstance.setId(idInstance19);
                    }
                    if ((nameValue10 = responseDoc.get("name")) != null && !(nameValue10 instanceof NullNode)) {
                        String nameInstance10 = nameValue10.getTextValue();
                        applicationGatewayInstance.setName(nameInstance10);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        applicationGatewayInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        applicationGatewayInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            applicationGatewayInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)closeableHttpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            applicationGatewayPutResponse = result;
        }
        catch (Throwable throwable) {
            if (var17_34 != null && var17_34.getEntity() != null) {
                var17_34.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return applicationGatewayPutResponse;
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.beginDeleting(resourceGroupName, applicationGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String applicationGatewayName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkGatewayPutResponse> beginStartAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayPutResponse>(){

            @Override
            public VirtualNetworkGatewayPutResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.beginStart(resourceGroupName, applicationGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayPutResponse beginStart(String resourceGroupName, String applicationGatewayName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginStartAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        url = url + "/start";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayPutResponse result = null;
            result = new VirtualNetworkGatewayPutResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkGatewayPutResponse virtualNetworkGatewayPutResponse = result;
            return virtualNetworkGatewayPutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkGatewayPutResponse> beginStopAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayPutResponse>(){

            @Override
            public VirtualNetworkGatewayPutResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.beginStop(resourceGroupName, applicationGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayPutResponse beginStop(String resourceGroupName, String applicationGatewayName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginStopAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        url = url + "/stop";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayPutResponse result = null;
            result = new VirtualNetworkGatewayPutResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkGatewayPutResponse virtualNetworkGatewayPutResponse = result;
            return virtualNetworkGatewayPutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String applicationGatewayName, final ApplicationGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.createOrUpdate(resourceGroupName, applicationGatewayName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String applicationGatewayName, ApplicationGateway parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            ApplicationGatewayPutResponse response = client2.getApplicationGatewaysOperations().beginCreateOrUpdatingAsync(resourceGroupName, applicationGatewayName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.delete(resourceGroupName, applicationGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String applicationGatewayName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getApplicationGatewaysOperations().beginDeletingAsync(resourceGroupName, applicationGatewayName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<ApplicationGatewayGetResponse> getAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<ApplicationGatewayGetResponse>(){

            @Override
            public ApplicationGatewayGetResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.get(resourceGroupName, applicationGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationGatewayGetResponse get(String resourceGroupName, String applicationGatewayName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ApplicationGatewayGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ApplicationGatewayGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue10;
                    JsonNode idValue19;
                    JsonNode etagValue9;
                    ApplicationGateway applicationGatewayInstance = new ApplicationGateway();
                    result.setApplicationGateway(applicationGatewayInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue9;
                        JsonNode requestRoutingRulesArray;
                        JsonNode httpListenersArray;
                        JsonNode backendHttpSettingsCollectionArray;
                        JsonNode backendAddressPoolsArray;
                        JsonNode frontendPortsArray;
                        JsonNode frontendIPConfigurationsArray;
                        JsonNode sslCertificatesArray;
                        JsonNode gatewayIPConfigurationsArray;
                        JsonNode operationalStateValue;
                        JsonNode skuValue = propertiesValue.get("sku");
                        if (skuValue != null && !(skuValue instanceof NullNode)) {
                            JsonNode capacityValue;
                            Iterator tierValue;
                            ApplicationGatewaySku skuInstance = new ApplicationGatewaySku();
                            applicationGatewayInstance.setSku(skuInstance);
                            JsonNode nameValue = skuValue.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                skuInstance.setName(nameInstance);
                            }
                            if ((tierValue = skuValue.get("tier")) != null && !(tierValue instanceof NullNode)) {
                                String tierInstance = tierValue.getTextValue();
                                skuInstance.setTier(tierInstance);
                            }
                            if ((capacityValue = skuValue.get("capacity")) != null && !(capacityValue instanceof NullNode)) {
                                int capacityInstance = capacityValue.getIntValue();
                                skuInstance.setCapacity(capacityInstance);
                            }
                        }
                        if ((operationalStateValue = propertiesValue.get("operationalState")) != null && !(operationalStateValue instanceof NullNode)) {
                            String operationalStateInstance = operationalStateValue.getTextValue();
                            applicationGatewayInstance.setOperationalState(operationalStateInstance);
                        }
                        if ((gatewayIPConfigurationsArray = propertiesValue.get("gatewayIPConfigurations")) != null && !(gatewayIPConfigurationsArray instanceof NullNode)) {
                            for (Iterator gatewayIPConfigurationsValue : (ArrayNode)gatewayIPConfigurationsArray) {
                                JsonNode idValue2;
                                JsonNode etagValue;
                                JsonNode nameValue2;
                                ApplicationGatewayIPConfiguration applicationGatewayIPConfigurationJsonFormatInstance = new ApplicationGatewayIPConfiguration();
                                applicationGatewayInstance.getGatewayIPConfigurations().add(applicationGatewayIPConfigurationJsonFormatInstance);
                                JsonNode propertiesValue2 = gatewayIPConfigurationsValue.get("properties");
                                if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode subnetValue = propertiesValue2.get("subnet");
                                    if (subnetValue != null && !(subnetValue instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue2 = gatewayIPConfigurationsValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setName(nameInstance2);
                                }
                                if ((etagValue = gatewayIPConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue2 = gatewayIPConfigurationsValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                String idInstance2 = idValue2.getTextValue();
                                applicationGatewayIPConfigurationJsonFormatInstance.setId(idInstance2);
                            }
                        }
                        if ((sslCertificatesArray = propertiesValue.get("sslCertificates")) != null && !(sslCertificatesArray instanceof NullNode)) {
                            for (JsonNode sslCertificatesValue : (ArrayNode)sslCertificatesArray) {
                                JsonNode idValue3;
                                JsonNode etagValue2;
                                JsonNode nameValue3;
                                ApplicationGatewaySslCertificate applicationGatewaySslCertificateJsonFormatInstance = new ApplicationGatewaySslCertificate();
                                applicationGatewayInstance.getSslCertificates().add(applicationGatewaySslCertificateJsonFormatInstance);
                                JsonNode propertiesValue3 = sslCertificatesValue.get("properties");
                                if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                    JsonNode provisioningStateValue2;
                                    JsonNode publicCertDataValue;
                                    JsonNode passwordValue;
                                    JsonNode dataValue = propertiesValue3.get("data");
                                    if (dataValue != null && !(dataValue instanceof NullNode)) {
                                        String dataInstance = dataValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setData(dataInstance);
                                    }
                                    if ((passwordValue = propertiesValue3.get("password")) != null && !(passwordValue instanceof NullNode)) {
                                        String passwordInstance = passwordValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setPassword(passwordInstance);
                                    }
                                    if ((publicCertDataValue = propertiesValue3.get("publicCertData")) != null && !(publicCertDataValue instanceof NullNode)) {
                                        String publicCertDataInstance = publicCertDataValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setPublicCertData(publicCertDataInstance);
                                    }
                                    if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                if ((nameValue3 = sslCertificatesValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                    String nameInstance3 = nameValue3.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setName(nameInstance3);
                                }
                                if ((etagValue2 = sslCertificatesValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                    String etagInstance2 = etagValue2.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setEtag(etagInstance2);
                                }
                                if ((idValue3 = sslCertificatesValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                applicationGatewaySslCertificateJsonFormatInstance.setId(idInstance3);
                            }
                        }
                        if ((frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations")) != null && !(frontendIPConfigurationsArray instanceof NullNode)) {
                            for (Iterator frontendIPConfigurationsValue : (ArrayNode)frontendIPConfigurationsArray) {
                                JsonNode idValue6;
                                JsonNode etagValue3;
                                JsonNode nameValue4;
                                ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfigurationJsonFormatInstance = new ApplicationGatewayFrontendIPConfiguration();
                                applicationGatewayInstance.getFrontendIPConfigurations().add(applicationGatewayFrontendIPConfigurationJsonFormatInstance);
                                JsonNode propertiesValue4 = frontendIPConfigurationsValue.get("properties");
                                if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                    JsonNode provisioningStateValue3;
                                    JsonNode publicIPAddressValue;
                                    JsonNode subnetValue2;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue2 = propertiesValue4.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                        ResourceId subnetInstance2 = new ResourceId();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setSubnet(subnetInstance2);
                                        JsonNode idValue4 = subnetValue2.get("id");
                                        if (idValue4 != null && !(idValue4 instanceof NullNode)) {
                                            String idInstance4 = idValue4.getTextValue();
                                            subnetInstance2.setId(idInstance4);
                                        }
                                    }
                                    if ((publicIPAddressValue = propertiesValue4.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPublicIPAddress(publicIPAddressInstance);
                                        JsonNode idValue5 = publicIPAddressValue.get("id");
                                        if (idValue5 != null && !(idValue5 instanceof NullNode)) {
                                            String idInstance5 = idValue5.getTextValue();
                                            publicIPAddressInstance.setId(idInstance5);
                                        }
                                    }
                                    if ((provisioningStateValue3 = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                        String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                    }
                                }
                                if ((nameValue4 = frontendIPConfigurationsValue.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                    String nameInstance4 = nameValue4.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setName(nameInstance4);
                                }
                                if ((etagValue3 = frontendIPConfigurationsValue.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                    String etagInstance3 = etagValue3.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setEtag(etagInstance3);
                                }
                                if ((idValue6 = frontendIPConfigurationsValue.get("id")) == null || idValue6 instanceof NullNode) continue;
                                String idInstance6 = idValue6.getTextValue();
                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setId(idInstance6);
                            }
                        }
                        if ((frontendPortsArray = propertiesValue.get("frontendPorts")) != null && !(frontendPortsArray instanceof NullNode)) {
                            for (Iterator frontendPortsValue : (ArrayNode)frontendPortsArray) {
                                Object idValue7;
                                JsonNode etagValue4;
                                JsonNode nameValue5;
                                ApplicationGatewayFrontendPort applicationGatewayFrontendPortJsonFormatInstance = new ApplicationGatewayFrontendPort();
                                applicationGatewayInstance.getFrontendPorts().add(applicationGatewayFrontendPortJsonFormatInstance);
                                JsonNode propertiesValue5 = frontendPortsValue.get("properties");
                                if (propertiesValue5 != null && !(propertiesValue5 instanceof NullNode)) {
                                    JsonNode provisioningStateValue4;
                                    JsonNode portValue = propertiesValue5.get("port");
                                    if (portValue != null && !(portValue instanceof NullNode)) {
                                        int portInstance = portValue.getIntValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setPort(portInstance);
                                    }
                                    if ((provisioningStateValue4 = propertiesValue5.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                        String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                    }
                                }
                                if ((nameValue5 = frontendPortsValue.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                    String nameInstance5 = nameValue5.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setName(nameInstance5);
                                }
                                if ((etagValue4 = frontendPortsValue.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                    String etagInstance4 = etagValue4.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setEtag(etagInstance4);
                                }
                                if ((idValue7 = frontendPortsValue.get("id")) == null || idValue7 instanceof NullNode) continue;
                                String idInstance7 = idValue7.getTextValue();
                                applicationGatewayFrontendPortJsonFormatInstance.setId(idInstance7);
                            }
                        }
                        if ((backendAddressPoolsArray = propertiesValue.get("backendAddressPools")) != null && !(backendAddressPoolsArray instanceof NullNode)) {
                            for (Iterator backendAddressPoolsValue : (ArrayNode)backendAddressPoolsArray) {
                                JsonNode idValue9;
                                JsonNode etagValue5;
                                JsonNode nameValue6;
                                ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPoolJsonFormatInstance = new ApplicationGatewayBackendAddressPool();
                                applicationGatewayInstance.getBackendAddressPools().add(applicationGatewayBackendAddressPoolJsonFormatInstance);
                                JsonNode propertiesValue6 = backendAddressPoolsValue.get("properties");
                                if (propertiesValue6 != null && !(propertiesValue6 instanceof NullNode)) {
                                    JsonNode provisioningStateValue5;
                                    JsonNode backendAddressesArray;
                                    JsonNode backendIPConfigurationsArray = propertiesValue6.get("backendIPConfigurations");
                                    if (backendIPConfigurationsArray != null && !(backendIPConfigurationsArray instanceof NullNode)) {
                                        for (Iterator backendIPConfigurationsValue : (ArrayNode)backendIPConfigurationsArray) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendIPConfigurations().add(resourceIdInstance);
                                            JsonNode idValue8 = backendIPConfigurationsValue.get("id");
                                            if (idValue8 == null || idValue8 instanceof NullNode) continue;
                                            String idInstance8 = idValue8.getTextValue();
                                            resourceIdInstance.setId(idInstance8);
                                        }
                                    }
                                    if ((backendAddressesArray = propertiesValue6.get("backendAddresses")) != null && !(backendAddressesArray instanceof NullNode)) {
                                        Iterator backendIPConfigurationsValue;
                                        backendIPConfigurationsValue = ((ArrayNode)backendAddressesArray).iterator();
                                        while (backendIPConfigurationsValue.hasNext()) {
                                            JsonNode ipAddressValue;
                                            JsonNode backendAddressesValue = (JsonNode)backendIPConfigurationsValue.next();
                                            ApplicationGatewayBackendAddress applicationGatewayBackendAddressInstance = new ApplicationGatewayBackendAddress();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendAddresses().add(applicationGatewayBackendAddressInstance);
                                            JsonNode fqdnValue = backendAddressesValue.get("fqdn");
                                            if (fqdnValue != null && !(fqdnValue instanceof NullNode)) {
                                                String fqdnInstance = fqdnValue.getTextValue();
                                                applicationGatewayBackendAddressInstance.setFqdn(fqdnInstance);
                                            }
                                            if ((ipAddressValue = backendAddressesValue.get("ipAddress")) == null || ipAddressValue instanceof NullNode) continue;
                                            String ipAddressInstance = ipAddressValue.getTextValue();
                                            applicationGatewayBackendAddressInstance.setIpAddress(ipAddressInstance);
                                        }
                                    }
                                    if ((provisioningStateValue5 = propertiesValue6.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                        String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        applicationGatewayBackendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                    }
                                }
                                if ((nameValue6 = backendAddressPoolsValue.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                                    String nameInstance6 = nameValue6.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setName(nameInstance6);
                                }
                                if ((etagValue5 = backendAddressPoolsValue.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                    String etagInstance5 = etagValue5.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setEtag(etagInstance5);
                                }
                                if ((idValue9 = backendAddressPoolsValue.get("id")) == null || idValue9 instanceof NullNode) continue;
                                String idInstance9 = idValue9.getTextValue();
                                applicationGatewayBackendAddressPoolJsonFormatInstance.setId(idInstance9);
                            }
                        }
                        if ((backendHttpSettingsCollectionArray = propertiesValue.get("backendHttpSettingsCollection")) != null && !(backendHttpSettingsCollectionArray instanceof NullNode)) {
                            for (Iterator backendHttpSettingsCollectionValue : (ArrayNode)backendHttpSettingsCollectionArray) {
                                JsonNode idValue10;
                                JsonNode etagValue6;
                                JsonNode nameValue7;
                                ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettingsJsonFormatInstance = new ApplicationGatewayBackendHttpSettings();
                                applicationGatewayInstance.getBackendHttpSettingsCollection().add(applicationGatewayBackendHttpSettingsJsonFormatInstance);
                                JsonNode propertiesValue7 = backendHttpSettingsCollectionValue.get("properties");
                                if (propertiesValue7 != null && !(propertiesValue7 instanceof NullNode)) {
                                    JsonNode provisioningStateValue6;
                                    JsonNode cookieBasedAffinityValue;
                                    JsonNode protocolValue;
                                    JsonNode portValue2 = propertiesValue7.get("port");
                                    if (portValue2 != null && !(portValue2 instanceof NullNode)) {
                                        int portInstance2 = portValue2.getIntValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setPort(portInstance2);
                                    }
                                    if ((protocolValue = propertiesValue7.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                        String protocolInstance = protocolValue.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    if ((cookieBasedAffinityValue = propertiesValue7.get("cookieBasedAffinity")) != null && !(cookieBasedAffinityValue instanceof NullNode)) {
                                        String cookieBasedAffinityInstance = cookieBasedAffinityValue.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setCookieBasedAffinity(cookieBasedAffinityInstance);
                                    }
                                    if ((provisioningStateValue6 = propertiesValue7.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                                        String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                    }
                                }
                                if ((nameValue7 = backendHttpSettingsCollectionValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                    String nameInstance7 = nameValue7.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setName(nameInstance7);
                                }
                                if ((etagValue6 = backendHttpSettingsCollectionValue.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                                    String etagInstance6 = etagValue6.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setEtag(etagInstance6);
                                }
                                if ((idValue10 = backendHttpSettingsCollectionValue.get("id")) == null || idValue10 instanceof NullNode) continue;
                                String idInstance10 = idValue10.getTextValue();
                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setId(idInstance10);
                            }
                        }
                        if ((httpListenersArray = propertiesValue.get("httpListeners")) != null && !(httpListenersArray instanceof NullNode)) {
                            for (Iterator httpListenersValue : (ArrayNode)httpListenersArray) {
                                JsonNode idValue14;
                                JsonNode etagValue7;
                                JsonNode nameValue8;
                                ApplicationGatewayHttpListener applicationGatewayHttpListenerJsonFormatInstance = new ApplicationGatewayHttpListener();
                                applicationGatewayInstance.getHttpListeners().add(applicationGatewayHttpListenerJsonFormatInstance);
                                JsonNode propertiesValue8 = httpListenersValue.get("properties");
                                if (propertiesValue8 != null && !(propertiesValue8 instanceof NullNode)) {
                                    JsonNode provisioningStateValue7;
                                    JsonNode sslCertificateValue;
                                    JsonNode protocolValue2;
                                    JsonNode frontendPortValue;
                                    JsonNode frontendIPConfigurationValue = propertiesValue8.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue != null && !(frontendIPConfigurationValue instanceof NullNode)) {
                                        ResourceId frontendIPConfigurationInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                        JsonNode idValue11 = frontendIPConfigurationValue.get("id");
                                        if (idValue11 != null && !(idValue11 instanceof NullNode)) {
                                            String idInstance11 = idValue11.getTextValue();
                                            frontendIPConfigurationInstance.setId(idInstance11);
                                        }
                                    }
                                    if ((frontendPortValue = propertiesValue8.get("frontendPort")) != null && !(frontendPortValue instanceof NullNode)) {
                                        ResourceId frontendPortInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                        JsonNode idValue12 = frontendPortValue.get("id");
                                        if (idValue12 != null && !(idValue12 instanceof NullNode)) {
                                            String idInstance12 = idValue12.getTextValue();
                                            frontendPortInstance.setId(idInstance12);
                                        }
                                    }
                                    if ((protocolValue2 = propertiesValue8.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                        String protocolInstance2 = protocolValue2.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setProtocol(protocolInstance2);
                                    }
                                    if ((sslCertificateValue = propertiesValue8.get("sslCertificate")) != null && !(sslCertificateValue instanceof NullNode)) {
                                        ResourceId sslCertificateInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setSslCertificate(sslCertificateInstance);
                                        JsonNode idValue13 = sslCertificateValue.get("id");
                                        if (idValue13 != null && !(idValue13 instanceof NullNode)) {
                                            String idInstance13 = idValue13.getTextValue();
                                            sslCertificateInstance.setId(idInstance13);
                                        }
                                    }
                                    if ((provisioningStateValue7 = propertiesValue8.get("provisioningState")) != null && !(provisioningStateValue7 instanceof NullNode)) {
                                        String provisioningStateInstance7 = provisioningStateValue7.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setProvisioningState(provisioningStateInstance7);
                                    }
                                }
                                if ((nameValue8 = httpListenersValue.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                                    String nameInstance8 = nameValue8.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setName(nameInstance8);
                                }
                                if ((etagValue7 = httpListenersValue.get("etag")) != null && !(etagValue7 instanceof NullNode)) {
                                    String etagInstance7 = etagValue7.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setEtag(etagInstance7);
                                }
                                if ((idValue14 = httpListenersValue.get("id")) == null || idValue14 instanceof NullNode) continue;
                                String idInstance14 = idValue14.getTextValue();
                                applicationGatewayHttpListenerJsonFormatInstance.setId(idInstance14);
                            }
                        }
                        if ((requestRoutingRulesArray = propertiesValue.get("requestRoutingRules")) != null && !(requestRoutingRulesArray instanceof NullNode)) {
                            for (JsonNode requestRoutingRulesValue : (ArrayNode)requestRoutingRulesArray) {
                                JsonNode idValue18;
                                JsonNode etagValue8;
                                JsonNode nameValue9;
                                ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRuleJsonFormatInstance = new ApplicationGatewayRequestRoutingRule();
                                applicationGatewayInstance.getRequestRoutingRules().add(applicationGatewayRequestRoutingRuleJsonFormatInstance);
                                JsonNode propertiesValue9 = requestRoutingRulesValue.get("properties");
                                if (propertiesValue9 != null && !(propertiesValue9 instanceof NullNode)) {
                                    JsonNode provisioningStateValue8;
                                    JsonNode httpListenerValue;
                                    JsonNode backendHttpSettingsValue;
                                    JsonNode backendAddressPoolValue;
                                    JsonNode ruleTypeValue = propertiesValue9.get("ruleType");
                                    if (ruleTypeValue != null && !(ruleTypeValue instanceof NullNode)) {
                                        String ruleTypeInstance = ruleTypeValue.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setRuleType(ruleTypeInstance);
                                    }
                                    if ((backendAddressPoolValue = propertiesValue9.get("backendAddressPool")) != null && !(backendAddressPoolValue instanceof NullNode)) {
                                        ResourceId backendAddressPoolInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                        JsonNode idValue15 = backendAddressPoolValue.get("id");
                                        if (idValue15 != null && !(idValue15 instanceof NullNode)) {
                                            String idInstance15 = idValue15.getTextValue();
                                            backendAddressPoolInstance.setId(idInstance15);
                                        }
                                    }
                                    if ((backendHttpSettingsValue = propertiesValue9.get("backendHttpSettings")) != null && !(backendHttpSettingsValue instanceof NullNode)) {
                                        ResourceId backendHttpSettingsInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendHttpSettings(backendHttpSettingsInstance);
                                        JsonNode idValue16 = backendHttpSettingsValue.get("id");
                                        if (idValue16 != null && !(idValue16 instanceof NullNode)) {
                                            String idInstance16 = idValue16.getTextValue();
                                            backendHttpSettingsInstance.setId(idInstance16);
                                        }
                                    }
                                    if ((httpListenerValue = propertiesValue9.get("httpListener")) != null && !(httpListenerValue instanceof NullNode)) {
                                        ResourceId httpListenerInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setHttpListener(httpListenerInstance);
                                        JsonNode idValue17 = httpListenerValue.get("id");
                                        if (idValue17 != null && !(idValue17 instanceof NullNode)) {
                                            String idInstance17 = idValue17.getTextValue();
                                            httpListenerInstance.setId(idInstance17);
                                        }
                                    }
                                    if ((provisioningStateValue8 = propertiesValue9.get("provisioningState")) != null && !(provisioningStateValue8 instanceof NullNode)) {
                                        String provisioningStateInstance8 = provisioningStateValue8.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance8);
                                    }
                                }
                                if ((nameValue9 = requestRoutingRulesValue.get("name")) != null && !(nameValue9 instanceof NullNode)) {
                                    String nameInstance9 = nameValue9.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setName(nameInstance9);
                                }
                                if ((etagValue8 = requestRoutingRulesValue.get("etag")) != null && !(etagValue8 instanceof NullNode)) {
                                    String etagInstance8 = etagValue8.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setEtag(etagInstance8);
                                }
                                if ((idValue18 = requestRoutingRulesValue.get("id")) == null || idValue18 instanceof NullNode) continue;
                                String idInstance18 = idValue18.getTextValue();
                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setId(idInstance18);
                            }
                        }
                        if ((provisioningStateValue9 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue9 instanceof NullNode)) {
                            String provisioningStateInstance9 = provisioningStateValue9.getTextValue();
                            applicationGatewayInstance.setProvisioningState(provisioningStateInstance9);
                        }
                    }
                    if ((etagValue9 = responseDoc.get("etag")) != null && !(etagValue9 instanceof NullNode)) {
                        String etagInstance9 = etagValue9.getTextValue();
                        applicationGatewayInstance.setEtag(etagInstance9);
                    }
                    if ((idValue19 = responseDoc.get("id")) != null && !(idValue19 instanceof NullNode)) {
                        String idInstance19 = idValue19.getTextValue();
                        applicationGatewayInstance.setId(idInstance19);
                    }
                    if ((nameValue10 = responseDoc.get("name")) != null && !(nameValue10 instanceof NullNode)) {
                        String nameInstance10 = nameValue10.getTextValue();
                        applicationGatewayInstance.setName(nameInstance10);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        applicationGatewayInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        applicationGatewayInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            applicationGatewayInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ApplicationGatewayGetResponse applicationGatewayGetResponse = result;
            return applicationGatewayGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ApplicationGatewayListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<ApplicationGatewayListResponse>(){

            @Override
            public ApplicationGatewayListResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationGatewayListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ApplicationGatewayListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ApplicationGatewayListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue10;
                            JsonNode idValue19;
                            JsonNode etagValue9;
                            ApplicationGateway applicationGatewayJsonFormatInstance = new ApplicationGateway();
                            result.getApplicationGateways().add(applicationGatewayJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue9;
                                JsonNode requestRoutingRulesArray;
                                JsonNode httpListenersArray;
                                JsonNode backendHttpSettingsCollectionArray;
                                JsonNode backendAddressPoolsArray;
                                Object idValue7;
                                JsonNode frontendPortsArray;
                                JsonNode frontendIPConfigurationsArray;
                                JsonNode sslCertificatesArray;
                                JsonNode gatewayIPConfigurationsArray;
                                JsonNode operationalStateValue;
                                Iterator tierValue;
                                JsonNode skuValue = propertiesValue.get("sku");
                                if (skuValue != null && !(skuValue instanceof NullNode)) {
                                    JsonNode capacityValue;
                                    ApplicationGatewaySku skuInstance = new ApplicationGatewaySku();
                                    applicationGatewayJsonFormatInstance.setSku(skuInstance);
                                    JsonNode nameValue = skuValue.get("name");
                                    if (nameValue != null && !(nameValue instanceof NullNode)) {
                                        String nameInstance = nameValue.getTextValue();
                                        skuInstance.setName(nameInstance);
                                    }
                                    if ((tierValue = skuValue.get("tier")) != null && !(tierValue instanceof NullNode)) {
                                        String tierInstance = tierValue.getTextValue();
                                        skuInstance.setTier(tierInstance);
                                    }
                                    if ((capacityValue = skuValue.get("capacity")) != null && !(capacityValue instanceof NullNode)) {
                                        int capacityInstance = capacityValue.getIntValue();
                                        skuInstance.setCapacity(capacityInstance);
                                    }
                                }
                                if ((operationalStateValue = propertiesValue.get("operationalState")) != null && !(operationalStateValue instanceof NullNode)) {
                                    String operationalStateInstance = operationalStateValue.getTextValue();
                                    applicationGatewayJsonFormatInstance.setOperationalState(operationalStateInstance);
                                }
                                if ((gatewayIPConfigurationsArray = propertiesValue.get("gatewayIPConfigurations")) != null && !(gatewayIPConfigurationsArray instanceof NullNode)) {
                                    tierValue = ((ArrayNode)gatewayIPConfigurationsArray).iterator();
                                    while (tierValue.hasNext()) {
                                        JsonNode idValue2;
                                        JsonNode etagValue;
                                        JsonNode nameValue2;
                                        Iterator gatewayIPConfigurationsValue = (JsonNode)tierValue.next();
                                        ApplicationGatewayIPConfiguration applicationGatewayIPConfigurationJsonFormatInstance = new ApplicationGatewayIPConfiguration();
                                        applicationGatewayJsonFormatInstance.getGatewayIPConfigurations().add(applicationGatewayIPConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue2 = gatewayIPConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && !(subnetValue instanceof NullNode)) {
                                                ResourceId subnetInstance = new ResourceId();
                                                applicationGatewayIPConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                applicationGatewayIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue2 = gatewayIPConfigurationsValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setName(nameInstance2);
                                        }
                                        if ((etagValue = gatewayIPConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue2 = gatewayIPConfigurationsValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                        String idInstance2 = idValue2.getTextValue();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setId(idInstance2);
                                    }
                                }
                                if ((sslCertificatesArray = propertiesValue.get("sslCertificates")) != null && !(sslCertificatesArray instanceof NullNode)) {
                                    for (JsonNode sslCertificatesValue : (ArrayNode)sslCertificatesArray) {
                                        JsonNode idValue3;
                                        JsonNode etagValue2;
                                        JsonNode nameValue3;
                                        ApplicationGatewaySslCertificate applicationGatewaySslCertificateJsonFormatInstance = new ApplicationGatewaySslCertificate();
                                        applicationGatewayJsonFormatInstance.getSslCertificates().add(applicationGatewaySslCertificateJsonFormatInstance);
                                        JsonNode propertiesValue3 = sslCertificatesValue.get("properties");
                                        if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                            JsonNode provisioningStateValue2;
                                            JsonNode publicCertDataValue;
                                            JsonNode passwordValue;
                                            JsonNode dataValue = propertiesValue3.get("data");
                                            if (dataValue != null && !(dataValue instanceof NullNode)) {
                                                String dataInstance = dataValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setData(dataInstance);
                                            }
                                            if ((passwordValue = propertiesValue3.get("password")) != null && !(passwordValue instanceof NullNode)) {
                                                String passwordInstance = passwordValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setPassword(passwordInstance);
                                            }
                                            if ((publicCertDataValue = propertiesValue3.get("publicCertData")) != null && !(publicCertDataValue instanceof NullNode)) {
                                                String publicCertDataInstance = publicCertDataValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setPublicCertData(publicCertDataInstance);
                                            }
                                            if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        if ((nameValue3 = sslCertificatesValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                            String nameInstance3 = nameValue3.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setName(nameInstance3);
                                        }
                                        if ((etagValue2 = sslCertificatesValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                            String etagInstance2 = etagValue2.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setEtag(etagInstance2);
                                        }
                                        if ((idValue3 = sslCertificatesValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                        String idInstance3 = idValue3.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setId(idInstance3);
                                    }
                                }
                                if ((frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations")) != null && !(frontendIPConfigurationsArray instanceof NullNode)) {
                                    for (Iterator frontendIPConfigurationsValue : (ArrayNode)frontendIPConfigurationsArray) {
                                        JsonNode idValue6;
                                        JsonNode etagValue3;
                                        JsonNode nameValue4;
                                        ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfigurationJsonFormatInstance = new ApplicationGatewayFrontendIPConfiguration();
                                        applicationGatewayJsonFormatInstance.getFrontendIPConfigurations().add(applicationGatewayFrontendIPConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue4 = frontendIPConfigurationsValue.get("properties");
                                        if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                            JsonNode provisioningStateValue3;
                                            JsonNode publicIPAddressValue;
                                            JsonNode subnetValue2;
                                            JsonNode privateIPAllocationMethodValue;
                                            JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                            if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                                String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAddress(privateIPAddressInstance);
                                            }
                                            if ((privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            if ((subnetValue2 = propertiesValue4.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                                ResourceId subnetInstance2 = new ResourceId();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setSubnet(subnetInstance2);
                                                JsonNode idValue4 = subnetValue2.get("id");
                                                if (idValue4 != null && !(idValue4 instanceof NullNode)) {
                                                    String idInstance4 = idValue4.getTextValue();
                                                    subnetInstance2.setId(idInstance4);
                                                }
                                            }
                                            if ((publicIPAddressValue = propertiesValue4.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPublicIPAddress(publicIPAddressInstance);
                                                JsonNode idValue5 = publicIPAddressValue.get("id");
                                                if (idValue5 != null && !(idValue5 instanceof NullNode)) {
                                                    String idInstance5 = idValue5.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance5);
                                                }
                                            }
                                            if ((provisioningStateValue3 = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                                String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                            }
                                        }
                                        if ((nameValue4 = frontendIPConfigurationsValue.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                            String nameInstance4 = nameValue4.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setName(nameInstance4);
                                        }
                                        if ((etagValue3 = frontendIPConfigurationsValue.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                            String etagInstance3 = etagValue3.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setEtag(etagInstance3);
                                        }
                                        if ((idValue6 = frontendIPConfigurationsValue.get("id")) == null || idValue6 instanceof NullNode) continue;
                                        String idInstance6 = idValue6.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setId(idInstance6);
                                    }
                                }
                                if ((frontendPortsArray = propertiesValue.get("frontendPorts")) != null && !(frontendPortsArray instanceof NullNode)) {
                                    Iterator frontendIPConfigurationsValue;
                                    frontendIPConfigurationsValue = ((ArrayNode)frontendPortsArray).iterator();
                                    while (frontendIPConfigurationsValue.hasNext()) {
                                        JsonNode etagValue4;
                                        JsonNode nameValue5;
                                        Iterator frontendPortsValue = (JsonNode)frontendIPConfigurationsValue.next();
                                        ApplicationGatewayFrontendPort applicationGatewayFrontendPortJsonFormatInstance = new ApplicationGatewayFrontendPort();
                                        applicationGatewayJsonFormatInstance.getFrontendPorts().add(applicationGatewayFrontendPortJsonFormatInstance);
                                        JsonNode propertiesValue5 = frontendPortsValue.get("properties");
                                        if (propertiesValue5 != null && !(propertiesValue5 instanceof NullNode)) {
                                            JsonNode provisioningStateValue4;
                                            JsonNode portValue = propertiesValue5.get("port");
                                            if (portValue != null && !(portValue instanceof NullNode)) {
                                                int portInstance = portValue.getIntValue();
                                                applicationGatewayFrontendPortJsonFormatInstance.setPort(portInstance);
                                            }
                                            if ((provisioningStateValue4 = propertiesValue5.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                                String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                                applicationGatewayFrontendPortJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                            }
                                        }
                                        if ((nameValue5 = frontendPortsValue.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                            String nameInstance5 = nameValue5.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setName(nameInstance5);
                                        }
                                        if ((etagValue4 = frontendPortsValue.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                            String etagInstance4 = etagValue4.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setEtag(etagInstance4);
                                        }
                                        if ((idValue7 = frontendPortsValue.get("id")) == null || idValue7 instanceof NullNode) continue;
                                        String idInstance7 = idValue7.getTextValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setId(idInstance7);
                                    }
                                }
                                if ((backendAddressPoolsArray = propertiesValue.get("backendAddressPools")) != null && !(backendAddressPoolsArray instanceof NullNode)) {
                                    for (Iterator backendAddressPoolsValue : (ArrayNode)backendAddressPoolsArray) {
                                        JsonNode idValue9;
                                        JsonNode etagValue5;
                                        JsonNode nameValue6;
                                        ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPoolJsonFormatInstance = new ApplicationGatewayBackendAddressPool();
                                        applicationGatewayJsonFormatInstance.getBackendAddressPools().add(applicationGatewayBackendAddressPoolJsonFormatInstance);
                                        JsonNode propertiesValue6 = backendAddressPoolsValue.get("properties");
                                        if (propertiesValue6 != null && !(propertiesValue6 instanceof NullNode)) {
                                            JsonNode provisioningStateValue5;
                                            JsonNode backendAddressesArray;
                                            JsonNode backendIPConfigurationsArray = propertiesValue6.get("backendIPConfigurations");
                                            if (backendIPConfigurationsArray != null && !(backendIPConfigurationsArray instanceof NullNode)) {
                                                idValue7 = ((ArrayNode)backendIPConfigurationsArray).iterator();
                                                while (idValue7.hasNext()) {
                                                    Iterator backendIPConfigurationsValue = (JsonNode)idValue7.next();
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendIPConfigurations().add(resourceIdInstance);
                                                    JsonNode idValue8 = backendIPConfigurationsValue.get("id");
                                                    if (idValue8 == null || idValue8 instanceof NullNode) continue;
                                                    String idInstance8 = idValue8.getTextValue();
                                                    resourceIdInstance.setId(idInstance8);
                                                }
                                            }
                                            if ((backendAddressesArray = propertiesValue6.get("backendAddresses")) != null && !(backendAddressesArray instanceof NullNode)) {
                                                for (JsonNode backendAddressesValue : (ArrayNode)backendAddressesArray) {
                                                    JsonNode ipAddressValue;
                                                    ApplicationGatewayBackendAddress applicationGatewayBackendAddressInstance = new ApplicationGatewayBackendAddress();
                                                    applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendAddresses().add(applicationGatewayBackendAddressInstance);
                                                    JsonNode fqdnValue = backendAddressesValue.get("fqdn");
                                                    if (fqdnValue != null && !(fqdnValue instanceof NullNode)) {
                                                        String fqdnInstance = fqdnValue.getTextValue();
                                                        applicationGatewayBackendAddressInstance.setFqdn(fqdnInstance);
                                                    }
                                                    if ((ipAddressValue = backendAddressesValue.get("ipAddress")) == null || ipAddressValue instanceof NullNode) continue;
                                                    String ipAddressInstance = ipAddressValue.getTextValue();
                                                    applicationGatewayBackendAddressInstance.setIpAddress(ipAddressInstance);
                                                }
                                            }
                                            if ((provisioningStateValue5 = propertiesValue6.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                                String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                                applicationGatewayBackendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                            }
                                        }
                                        if ((nameValue6 = backendAddressPoolsValue.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                                            String nameInstance6 = nameValue6.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setName(nameInstance6);
                                        }
                                        if ((etagValue5 = backendAddressPoolsValue.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                            String etagInstance5 = etagValue5.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setEtag(etagInstance5);
                                        }
                                        if ((idValue9 = backendAddressPoolsValue.get("id")) == null || idValue9 instanceof NullNode) continue;
                                        String idInstance9 = idValue9.getTextValue();
                                        applicationGatewayBackendAddressPoolJsonFormatInstance.setId(idInstance9);
                                    }
                                }
                                if ((backendHttpSettingsCollectionArray = propertiesValue.get("backendHttpSettingsCollection")) != null && !(backendHttpSettingsCollectionArray instanceof NullNode)) {
                                    Iterator backendAddressPoolsValue;
                                    backendAddressPoolsValue = ((ArrayNode)backendHttpSettingsCollectionArray).iterator();
                                    while (backendAddressPoolsValue.hasNext()) {
                                        JsonNode idValue10;
                                        JsonNode etagValue6;
                                        JsonNode nameValue7;
                                        Iterator backendHttpSettingsCollectionValue = (JsonNode)backendAddressPoolsValue.next();
                                        ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettingsJsonFormatInstance = new ApplicationGatewayBackendHttpSettings();
                                        applicationGatewayJsonFormatInstance.getBackendHttpSettingsCollection().add(applicationGatewayBackendHttpSettingsJsonFormatInstance);
                                        JsonNode propertiesValue7 = backendHttpSettingsCollectionValue.get("properties");
                                        if (propertiesValue7 != null && !(propertiesValue7 instanceof NullNode)) {
                                            JsonNode provisioningStateValue6;
                                            JsonNode cookieBasedAffinityValue;
                                            JsonNode protocolValue;
                                            JsonNode portValue2 = propertiesValue7.get("port");
                                            if (portValue2 != null && !(portValue2 instanceof NullNode)) {
                                                int portInstance2 = portValue2.getIntValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setPort(portInstance2);
                                            }
                                            if ((protocolValue = propertiesValue7.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            if ((cookieBasedAffinityValue = propertiesValue7.get("cookieBasedAffinity")) != null && !(cookieBasedAffinityValue instanceof NullNode)) {
                                                String cookieBasedAffinityInstance = cookieBasedAffinityValue.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setCookieBasedAffinity(cookieBasedAffinityInstance);
                                            }
                                            if ((provisioningStateValue6 = propertiesValue7.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                                                String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                            }
                                        }
                                        if ((nameValue7 = backendHttpSettingsCollectionValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                            String nameInstance7 = nameValue7.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setName(nameInstance7);
                                        }
                                        if ((etagValue6 = backendHttpSettingsCollectionValue.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                                            String etagInstance6 = etagValue6.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setEtag(etagInstance6);
                                        }
                                        if ((idValue10 = backendHttpSettingsCollectionValue.get("id")) == null || idValue10 instanceof NullNode) continue;
                                        String idInstance10 = idValue10.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setId(idInstance10);
                                    }
                                }
                                if ((httpListenersArray = propertiesValue.get("httpListeners")) != null && !(httpListenersArray instanceof NullNode)) {
                                    for (Iterator httpListenersValue : (ArrayNode)httpListenersArray) {
                                        JsonNode idValue14;
                                        JsonNode etagValue7;
                                        JsonNode nameValue8;
                                        ApplicationGatewayHttpListener applicationGatewayHttpListenerJsonFormatInstance = new ApplicationGatewayHttpListener();
                                        applicationGatewayJsonFormatInstance.getHttpListeners().add(applicationGatewayHttpListenerJsonFormatInstance);
                                        JsonNode propertiesValue8 = httpListenersValue.get("properties");
                                        if (propertiesValue8 != null && !(propertiesValue8 instanceof NullNode)) {
                                            JsonNode provisioningStateValue7;
                                            JsonNode sslCertificateValue;
                                            JsonNode protocolValue2;
                                            JsonNode frontendPortValue;
                                            JsonNode frontendIPConfigurationValue = propertiesValue8.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue != null && !(frontendIPConfigurationValue instanceof NullNode)) {
                                                ResourceId frontendIPConfigurationInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                                JsonNode idValue11 = frontendIPConfigurationValue.get("id");
                                                if (idValue11 != null && !(idValue11 instanceof NullNode)) {
                                                    String idInstance11 = idValue11.getTextValue();
                                                    frontendIPConfigurationInstance.setId(idInstance11);
                                                }
                                            }
                                            if ((frontendPortValue = propertiesValue8.get("frontendPort")) != null && !(frontendPortValue instanceof NullNode)) {
                                                ResourceId frontendPortInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                                JsonNode idValue12 = frontendPortValue.get("id");
                                                if (idValue12 != null && !(idValue12 instanceof NullNode)) {
                                                    String idInstance12 = idValue12.getTextValue();
                                                    frontendPortInstance.setId(idInstance12);
                                                }
                                            }
                                            if ((protocolValue2 = propertiesValue8.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                                String protocolInstance2 = protocolValue2.getTextValue();
                                                applicationGatewayHttpListenerJsonFormatInstance.setProtocol(protocolInstance2);
                                            }
                                            if ((sslCertificateValue = propertiesValue8.get("sslCertificate")) != null && !(sslCertificateValue instanceof NullNode)) {
                                                ResourceId sslCertificateInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setSslCertificate(sslCertificateInstance);
                                                JsonNode idValue13 = sslCertificateValue.get("id");
                                                if (idValue13 != null && !(idValue13 instanceof NullNode)) {
                                                    String idInstance13 = idValue13.getTextValue();
                                                    sslCertificateInstance.setId(idInstance13);
                                                }
                                            }
                                            if ((provisioningStateValue7 = propertiesValue8.get("provisioningState")) != null && !(provisioningStateValue7 instanceof NullNode)) {
                                                String provisioningStateInstance7 = provisioningStateValue7.getTextValue();
                                                applicationGatewayHttpListenerJsonFormatInstance.setProvisioningState(provisioningStateInstance7);
                                            }
                                        }
                                        if ((nameValue8 = httpListenersValue.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                                            String nameInstance8 = nameValue8.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setName(nameInstance8);
                                        }
                                        if ((etagValue7 = httpListenersValue.get("etag")) != null && !(etagValue7 instanceof NullNode)) {
                                            String etagInstance7 = etagValue7.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setEtag(etagInstance7);
                                        }
                                        if ((idValue14 = httpListenersValue.get("id")) == null || idValue14 instanceof NullNode) continue;
                                        String idInstance14 = idValue14.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setId(idInstance14);
                                    }
                                }
                                if ((requestRoutingRulesArray = propertiesValue.get("requestRoutingRules")) != null && !(requestRoutingRulesArray instanceof NullNode)) {
                                    Iterator httpListenersValue;
                                    httpListenersValue = ((ArrayNode)requestRoutingRulesArray).iterator();
                                    while (httpListenersValue.hasNext()) {
                                        JsonNode idValue18;
                                        JsonNode etagValue8;
                                        JsonNode nameValue9;
                                        JsonNode requestRoutingRulesValue = (JsonNode)httpListenersValue.next();
                                        ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRuleJsonFormatInstance = new ApplicationGatewayRequestRoutingRule();
                                        applicationGatewayJsonFormatInstance.getRequestRoutingRules().add(applicationGatewayRequestRoutingRuleJsonFormatInstance);
                                        JsonNode propertiesValue9 = requestRoutingRulesValue.get("properties");
                                        if (propertiesValue9 != null && !(propertiesValue9 instanceof NullNode)) {
                                            JsonNode provisioningStateValue8;
                                            JsonNode httpListenerValue;
                                            JsonNode backendHttpSettingsValue;
                                            JsonNode backendAddressPoolValue;
                                            JsonNode ruleTypeValue = propertiesValue9.get("ruleType");
                                            if (ruleTypeValue != null && !(ruleTypeValue instanceof NullNode)) {
                                                String ruleTypeInstance = ruleTypeValue.getTextValue();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setRuleType(ruleTypeInstance);
                                            }
                                            if ((backendAddressPoolValue = propertiesValue9.get("backendAddressPool")) != null && !(backendAddressPoolValue instanceof NullNode)) {
                                                ResourceId backendAddressPoolInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                                JsonNode idValue15 = backendAddressPoolValue.get("id");
                                                if (idValue15 != null && !(idValue15 instanceof NullNode)) {
                                                    String idInstance15 = idValue15.getTextValue();
                                                    backendAddressPoolInstance.setId(idInstance15);
                                                }
                                            }
                                            if ((backendHttpSettingsValue = propertiesValue9.get("backendHttpSettings")) != null && !(backendHttpSettingsValue instanceof NullNode)) {
                                                ResourceId backendHttpSettingsInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendHttpSettings(backendHttpSettingsInstance);
                                                JsonNode idValue16 = backendHttpSettingsValue.get("id");
                                                if (idValue16 != null && !(idValue16 instanceof NullNode)) {
                                                    String idInstance16 = idValue16.getTextValue();
                                                    backendHttpSettingsInstance.setId(idInstance16);
                                                }
                                            }
                                            if ((httpListenerValue = propertiesValue9.get("httpListener")) != null && !(httpListenerValue instanceof NullNode)) {
                                                ResourceId httpListenerInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setHttpListener(httpListenerInstance);
                                                JsonNode idValue17 = httpListenerValue.get("id");
                                                if (idValue17 != null && !(idValue17 instanceof NullNode)) {
                                                    String idInstance17 = idValue17.getTextValue();
                                                    httpListenerInstance.setId(idInstance17);
                                                }
                                            }
                                            if ((provisioningStateValue8 = propertiesValue9.get("provisioningState")) != null && !(provisioningStateValue8 instanceof NullNode)) {
                                                String provisioningStateInstance8 = provisioningStateValue8.getTextValue();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance8);
                                            }
                                        }
                                        if ((nameValue9 = requestRoutingRulesValue.get("name")) != null && !(nameValue9 instanceof NullNode)) {
                                            String nameInstance9 = nameValue9.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setName(nameInstance9);
                                        }
                                        if ((etagValue8 = requestRoutingRulesValue.get("etag")) != null && !(etagValue8 instanceof NullNode)) {
                                            String etagInstance8 = etagValue8.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setEtag(etagInstance8);
                                        }
                                        if ((idValue18 = requestRoutingRulesValue.get("id")) == null || idValue18 instanceof NullNode) continue;
                                        String idInstance18 = idValue18.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setId(idInstance18);
                                    }
                                }
                                if ((provisioningStateValue9 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue9 instanceof NullNode)) {
                                    String provisioningStateInstance9 = provisioningStateValue9.getTextValue();
                                    applicationGatewayJsonFormatInstance.setProvisioningState(provisioningStateInstance9);
                                }
                            }
                            if ((etagValue9 = valueValue.get("etag")) != null && !(etagValue9 instanceof NullNode)) {
                                String etagInstance9 = etagValue9.getTextValue();
                                applicationGatewayJsonFormatInstance.setEtag(etagInstance9);
                            }
                            if ((idValue19 = valueValue.get("id")) != null && !(idValue19 instanceof NullNode)) {
                                String idInstance19 = idValue19.getTextValue();
                                applicationGatewayJsonFormatInstance.setId(idInstance19);
                            }
                            if ((nameValue10 = valueValue.get("name")) != null && !(nameValue10 instanceof NullNode)) {
                                String nameInstance10 = nameValue10.getTextValue();
                                applicationGatewayJsonFormatInstance.setName(nameInstance10);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                applicationGatewayJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                applicationGatewayJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                applicationGatewayJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ApplicationGatewayListResponse applicationGatewayListResponse = result;
            return applicationGatewayListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ApplicationGatewayListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ApplicationGatewayListResponse>(){

            @Override
            public ApplicationGatewayListResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.listAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationGatewayListResponse listAll() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ApplicationGatewayListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ApplicationGatewayListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue10;
                            JsonNode idValue19;
                            JsonNode etagValue9;
                            ApplicationGateway applicationGatewayJsonFormatInstance = new ApplicationGateway();
                            result.getApplicationGateways().add(applicationGatewayJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue9;
                                JsonNode requestRoutingRulesArray;
                                JsonNode httpListenersArray;
                                JsonNode backendHttpSettingsCollectionArray;
                                JsonNode backendAddressPoolsArray;
                                Object idValue7;
                                JsonNode frontendPortsArray;
                                JsonNode frontendIPConfigurationsArray;
                                JsonNode sslCertificatesArray;
                                JsonNode gatewayIPConfigurationsArray;
                                JsonNode operationalStateValue;
                                Iterator tierValue;
                                JsonNode skuValue = propertiesValue.get("sku");
                                if (skuValue != null && !(skuValue instanceof NullNode)) {
                                    JsonNode capacityValue;
                                    ApplicationGatewaySku skuInstance = new ApplicationGatewaySku();
                                    applicationGatewayJsonFormatInstance.setSku(skuInstance);
                                    JsonNode nameValue = skuValue.get("name");
                                    if (nameValue != null && !(nameValue instanceof NullNode)) {
                                        String nameInstance = nameValue.getTextValue();
                                        skuInstance.setName(nameInstance);
                                    }
                                    if ((tierValue = skuValue.get("tier")) != null && !(tierValue instanceof NullNode)) {
                                        String tierInstance = tierValue.getTextValue();
                                        skuInstance.setTier(tierInstance);
                                    }
                                    if ((capacityValue = skuValue.get("capacity")) != null && !(capacityValue instanceof NullNode)) {
                                        int capacityInstance = capacityValue.getIntValue();
                                        skuInstance.setCapacity(capacityInstance);
                                    }
                                }
                                if ((operationalStateValue = propertiesValue.get("operationalState")) != null && !(operationalStateValue instanceof NullNode)) {
                                    String operationalStateInstance = operationalStateValue.getTextValue();
                                    applicationGatewayJsonFormatInstance.setOperationalState(operationalStateInstance);
                                }
                                if ((gatewayIPConfigurationsArray = propertiesValue.get("gatewayIPConfigurations")) != null && !(gatewayIPConfigurationsArray instanceof NullNode)) {
                                    tierValue = ((ArrayNode)gatewayIPConfigurationsArray).iterator();
                                    while (tierValue.hasNext()) {
                                        JsonNode idValue2;
                                        JsonNode etagValue;
                                        JsonNode nameValue2;
                                        Iterator gatewayIPConfigurationsValue = (JsonNode)tierValue.next();
                                        ApplicationGatewayIPConfiguration applicationGatewayIPConfigurationJsonFormatInstance = new ApplicationGatewayIPConfiguration();
                                        applicationGatewayJsonFormatInstance.getGatewayIPConfigurations().add(applicationGatewayIPConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue2 = gatewayIPConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && !(subnetValue instanceof NullNode)) {
                                                ResourceId subnetInstance = new ResourceId();
                                                applicationGatewayIPConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                applicationGatewayIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue2 = gatewayIPConfigurationsValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setName(nameInstance2);
                                        }
                                        if ((etagValue = gatewayIPConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue2 = gatewayIPConfigurationsValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                        String idInstance2 = idValue2.getTextValue();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setId(idInstance2);
                                    }
                                }
                                if ((sslCertificatesArray = propertiesValue.get("sslCertificates")) != null && !(sslCertificatesArray instanceof NullNode)) {
                                    for (JsonNode sslCertificatesValue : (ArrayNode)sslCertificatesArray) {
                                        JsonNode idValue3;
                                        JsonNode etagValue2;
                                        JsonNode nameValue3;
                                        ApplicationGatewaySslCertificate applicationGatewaySslCertificateJsonFormatInstance = new ApplicationGatewaySslCertificate();
                                        applicationGatewayJsonFormatInstance.getSslCertificates().add(applicationGatewaySslCertificateJsonFormatInstance);
                                        JsonNode propertiesValue3 = sslCertificatesValue.get("properties");
                                        if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                            JsonNode provisioningStateValue2;
                                            JsonNode publicCertDataValue;
                                            JsonNode passwordValue;
                                            JsonNode dataValue = propertiesValue3.get("data");
                                            if (dataValue != null && !(dataValue instanceof NullNode)) {
                                                String dataInstance = dataValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setData(dataInstance);
                                            }
                                            if ((passwordValue = propertiesValue3.get("password")) != null && !(passwordValue instanceof NullNode)) {
                                                String passwordInstance = passwordValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setPassword(passwordInstance);
                                            }
                                            if ((publicCertDataValue = propertiesValue3.get("publicCertData")) != null && !(publicCertDataValue instanceof NullNode)) {
                                                String publicCertDataInstance = publicCertDataValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setPublicCertData(publicCertDataInstance);
                                            }
                                            if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        if ((nameValue3 = sslCertificatesValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                            String nameInstance3 = nameValue3.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setName(nameInstance3);
                                        }
                                        if ((etagValue2 = sslCertificatesValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                            String etagInstance2 = etagValue2.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setEtag(etagInstance2);
                                        }
                                        if ((idValue3 = sslCertificatesValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                        String idInstance3 = idValue3.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setId(idInstance3);
                                    }
                                }
                                if ((frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations")) != null && !(frontendIPConfigurationsArray instanceof NullNode)) {
                                    for (Iterator frontendIPConfigurationsValue : (ArrayNode)frontendIPConfigurationsArray) {
                                        JsonNode idValue6;
                                        JsonNode etagValue3;
                                        JsonNode nameValue4;
                                        ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfigurationJsonFormatInstance = new ApplicationGatewayFrontendIPConfiguration();
                                        applicationGatewayJsonFormatInstance.getFrontendIPConfigurations().add(applicationGatewayFrontendIPConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue4 = frontendIPConfigurationsValue.get("properties");
                                        if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                            JsonNode provisioningStateValue3;
                                            JsonNode publicIPAddressValue;
                                            JsonNode subnetValue2;
                                            JsonNode privateIPAllocationMethodValue;
                                            JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                            if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                                String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAddress(privateIPAddressInstance);
                                            }
                                            if ((privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            if ((subnetValue2 = propertiesValue4.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                                ResourceId subnetInstance2 = new ResourceId();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setSubnet(subnetInstance2);
                                                JsonNode idValue4 = subnetValue2.get("id");
                                                if (idValue4 != null && !(idValue4 instanceof NullNode)) {
                                                    String idInstance4 = idValue4.getTextValue();
                                                    subnetInstance2.setId(idInstance4);
                                                }
                                            }
                                            if ((publicIPAddressValue = propertiesValue4.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPublicIPAddress(publicIPAddressInstance);
                                                JsonNode idValue5 = publicIPAddressValue.get("id");
                                                if (idValue5 != null && !(idValue5 instanceof NullNode)) {
                                                    String idInstance5 = idValue5.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance5);
                                                }
                                            }
                                            if ((provisioningStateValue3 = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                                String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                            }
                                        }
                                        if ((nameValue4 = frontendIPConfigurationsValue.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                            String nameInstance4 = nameValue4.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setName(nameInstance4);
                                        }
                                        if ((etagValue3 = frontendIPConfigurationsValue.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                            String etagInstance3 = etagValue3.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setEtag(etagInstance3);
                                        }
                                        if ((idValue6 = frontendIPConfigurationsValue.get("id")) == null || idValue6 instanceof NullNode) continue;
                                        String idInstance6 = idValue6.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setId(idInstance6);
                                    }
                                }
                                if ((frontendPortsArray = propertiesValue.get("frontendPorts")) != null && !(frontendPortsArray instanceof NullNode)) {
                                    Iterator frontendIPConfigurationsValue;
                                    frontendIPConfigurationsValue = ((ArrayNode)frontendPortsArray).iterator();
                                    while (frontendIPConfigurationsValue.hasNext()) {
                                        JsonNode etagValue4;
                                        JsonNode nameValue5;
                                        Iterator frontendPortsValue = (JsonNode)frontendIPConfigurationsValue.next();
                                        ApplicationGatewayFrontendPort applicationGatewayFrontendPortJsonFormatInstance = new ApplicationGatewayFrontendPort();
                                        applicationGatewayJsonFormatInstance.getFrontendPorts().add(applicationGatewayFrontendPortJsonFormatInstance);
                                        JsonNode propertiesValue5 = frontendPortsValue.get("properties");
                                        if (propertiesValue5 != null && !(propertiesValue5 instanceof NullNode)) {
                                            JsonNode provisioningStateValue4;
                                            JsonNode portValue = propertiesValue5.get("port");
                                            if (portValue != null && !(portValue instanceof NullNode)) {
                                                int portInstance = portValue.getIntValue();
                                                applicationGatewayFrontendPortJsonFormatInstance.setPort(portInstance);
                                            }
                                            if ((provisioningStateValue4 = propertiesValue5.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                                String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                                applicationGatewayFrontendPortJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                            }
                                        }
                                        if ((nameValue5 = frontendPortsValue.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                            String nameInstance5 = nameValue5.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setName(nameInstance5);
                                        }
                                        if ((etagValue4 = frontendPortsValue.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                            String etagInstance4 = etagValue4.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setEtag(etagInstance4);
                                        }
                                        if ((idValue7 = frontendPortsValue.get("id")) == null || idValue7 instanceof NullNode) continue;
                                        String idInstance7 = idValue7.getTextValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setId(idInstance7);
                                    }
                                }
                                if ((backendAddressPoolsArray = propertiesValue.get("backendAddressPools")) != null && !(backendAddressPoolsArray instanceof NullNode)) {
                                    for (Iterator backendAddressPoolsValue : (ArrayNode)backendAddressPoolsArray) {
                                        JsonNode idValue9;
                                        JsonNode etagValue5;
                                        JsonNode nameValue6;
                                        ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPoolJsonFormatInstance = new ApplicationGatewayBackendAddressPool();
                                        applicationGatewayJsonFormatInstance.getBackendAddressPools().add(applicationGatewayBackendAddressPoolJsonFormatInstance);
                                        JsonNode propertiesValue6 = backendAddressPoolsValue.get("properties");
                                        if (propertiesValue6 != null && !(propertiesValue6 instanceof NullNode)) {
                                            JsonNode provisioningStateValue5;
                                            JsonNode backendAddressesArray;
                                            JsonNode backendIPConfigurationsArray = propertiesValue6.get("backendIPConfigurations");
                                            if (backendIPConfigurationsArray != null && !(backendIPConfigurationsArray instanceof NullNode)) {
                                                idValue7 = ((ArrayNode)backendIPConfigurationsArray).iterator();
                                                while (idValue7.hasNext()) {
                                                    Iterator backendIPConfigurationsValue = (JsonNode)idValue7.next();
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendIPConfigurations().add(resourceIdInstance);
                                                    JsonNode idValue8 = backendIPConfigurationsValue.get("id");
                                                    if (idValue8 == null || idValue8 instanceof NullNode) continue;
                                                    String idInstance8 = idValue8.getTextValue();
                                                    resourceIdInstance.setId(idInstance8);
                                                }
                                            }
                                            if ((backendAddressesArray = propertiesValue6.get("backendAddresses")) != null && !(backendAddressesArray instanceof NullNode)) {
                                                for (JsonNode backendAddressesValue : (ArrayNode)backendAddressesArray) {
                                                    JsonNode ipAddressValue;
                                                    ApplicationGatewayBackendAddress applicationGatewayBackendAddressInstance = new ApplicationGatewayBackendAddress();
                                                    applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendAddresses().add(applicationGatewayBackendAddressInstance);
                                                    JsonNode fqdnValue = backendAddressesValue.get("fqdn");
                                                    if (fqdnValue != null && !(fqdnValue instanceof NullNode)) {
                                                        String fqdnInstance = fqdnValue.getTextValue();
                                                        applicationGatewayBackendAddressInstance.setFqdn(fqdnInstance);
                                                    }
                                                    if ((ipAddressValue = backendAddressesValue.get("ipAddress")) == null || ipAddressValue instanceof NullNode) continue;
                                                    String ipAddressInstance = ipAddressValue.getTextValue();
                                                    applicationGatewayBackendAddressInstance.setIpAddress(ipAddressInstance);
                                                }
                                            }
                                            if ((provisioningStateValue5 = propertiesValue6.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                                String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                                applicationGatewayBackendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                            }
                                        }
                                        if ((nameValue6 = backendAddressPoolsValue.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                                            String nameInstance6 = nameValue6.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setName(nameInstance6);
                                        }
                                        if ((etagValue5 = backendAddressPoolsValue.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                            String etagInstance5 = etagValue5.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setEtag(etagInstance5);
                                        }
                                        if ((idValue9 = backendAddressPoolsValue.get("id")) == null || idValue9 instanceof NullNode) continue;
                                        String idInstance9 = idValue9.getTextValue();
                                        applicationGatewayBackendAddressPoolJsonFormatInstance.setId(idInstance9);
                                    }
                                }
                                if ((backendHttpSettingsCollectionArray = propertiesValue.get("backendHttpSettingsCollection")) != null && !(backendHttpSettingsCollectionArray instanceof NullNode)) {
                                    Iterator backendAddressPoolsValue;
                                    backendAddressPoolsValue = ((ArrayNode)backendHttpSettingsCollectionArray).iterator();
                                    while (backendAddressPoolsValue.hasNext()) {
                                        JsonNode idValue10;
                                        JsonNode etagValue6;
                                        JsonNode nameValue7;
                                        Iterator backendHttpSettingsCollectionValue = (JsonNode)backendAddressPoolsValue.next();
                                        ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettingsJsonFormatInstance = new ApplicationGatewayBackendHttpSettings();
                                        applicationGatewayJsonFormatInstance.getBackendHttpSettingsCollection().add(applicationGatewayBackendHttpSettingsJsonFormatInstance);
                                        JsonNode propertiesValue7 = backendHttpSettingsCollectionValue.get("properties");
                                        if (propertiesValue7 != null && !(propertiesValue7 instanceof NullNode)) {
                                            JsonNode provisioningStateValue6;
                                            JsonNode cookieBasedAffinityValue;
                                            JsonNode protocolValue;
                                            JsonNode portValue2 = propertiesValue7.get("port");
                                            if (portValue2 != null && !(portValue2 instanceof NullNode)) {
                                                int portInstance2 = portValue2.getIntValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setPort(portInstance2);
                                            }
                                            if ((protocolValue = propertiesValue7.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            if ((cookieBasedAffinityValue = propertiesValue7.get("cookieBasedAffinity")) != null && !(cookieBasedAffinityValue instanceof NullNode)) {
                                                String cookieBasedAffinityInstance = cookieBasedAffinityValue.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setCookieBasedAffinity(cookieBasedAffinityInstance);
                                            }
                                            if ((provisioningStateValue6 = propertiesValue7.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                                                String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                            }
                                        }
                                        if ((nameValue7 = backendHttpSettingsCollectionValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                            String nameInstance7 = nameValue7.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setName(nameInstance7);
                                        }
                                        if ((etagValue6 = backendHttpSettingsCollectionValue.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                                            String etagInstance6 = etagValue6.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setEtag(etagInstance6);
                                        }
                                        if ((idValue10 = backendHttpSettingsCollectionValue.get("id")) == null || idValue10 instanceof NullNode) continue;
                                        String idInstance10 = idValue10.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setId(idInstance10);
                                    }
                                }
                                if ((httpListenersArray = propertiesValue.get("httpListeners")) != null && !(httpListenersArray instanceof NullNode)) {
                                    for (Iterator httpListenersValue : (ArrayNode)httpListenersArray) {
                                        JsonNode idValue14;
                                        JsonNode etagValue7;
                                        JsonNode nameValue8;
                                        ApplicationGatewayHttpListener applicationGatewayHttpListenerJsonFormatInstance = new ApplicationGatewayHttpListener();
                                        applicationGatewayJsonFormatInstance.getHttpListeners().add(applicationGatewayHttpListenerJsonFormatInstance);
                                        JsonNode propertiesValue8 = httpListenersValue.get("properties");
                                        if (propertiesValue8 != null && !(propertiesValue8 instanceof NullNode)) {
                                            JsonNode provisioningStateValue7;
                                            JsonNode sslCertificateValue;
                                            JsonNode protocolValue2;
                                            JsonNode frontendPortValue;
                                            JsonNode frontendIPConfigurationValue = propertiesValue8.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue != null && !(frontendIPConfigurationValue instanceof NullNode)) {
                                                ResourceId frontendIPConfigurationInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                                JsonNode idValue11 = frontendIPConfigurationValue.get("id");
                                                if (idValue11 != null && !(idValue11 instanceof NullNode)) {
                                                    String idInstance11 = idValue11.getTextValue();
                                                    frontendIPConfigurationInstance.setId(idInstance11);
                                                }
                                            }
                                            if ((frontendPortValue = propertiesValue8.get("frontendPort")) != null && !(frontendPortValue instanceof NullNode)) {
                                                ResourceId frontendPortInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                                JsonNode idValue12 = frontendPortValue.get("id");
                                                if (idValue12 != null && !(idValue12 instanceof NullNode)) {
                                                    String idInstance12 = idValue12.getTextValue();
                                                    frontendPortInstance.setId(idInstance12);
                                                }
                                            }
                                            if ((protocolValue2 = propertiesValue8.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                                String protocolInstance2 = protocolValue2.getTextValue();
                                                applicationGatewayHttpListenerJsonFormatInstance.setProtocol(protocolInstance2);
                                            }
                                            if ((sslCertificateValue = propertiesValue8.get("sslCertificate")) != null && !(sslCertificateValue instanceof NullNode)) {
                                                ResourceId sslCertificateInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setSslCertificate(sslCertificateInstance);
                                                JsonNode idValue13 = sslCertificateValue.get("id");
                                                if (idValue13 != null && !(idValue13 instanceof NullNode)) {
                                                    String idInstance13 = idValue13.getTextValue();
                                                    sslCertificateInstance.setId(idInstance13);
                                                }
                                            }
                                            if ((provisioningStateValue7 = propertiesValue8.get("provisioningState")) != null && !(provisioningStateValue7 instanceof NullNode)) {
                                                String provisioningStateInstance7 = provisioningStateValue7.getTextValue();
                                                applicationGatewayHttpListenerJsonFormatInstance.setProvisioningState(provisioningStateInstance7);
                                            }
                                        }
                                        if ((nameValue8 = httpListenersValue.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                                            String nameInstance8 = nameValue8.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setName(nameInstance8);
                                        }
                                        if ((etagValue7 = httpListenersValue.get("etag")) != null && !(etagValue7 instanceof NullNode)) {
                                            String etagInstance7 = etagValue7.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setEtag(etagInstance7);
                                        }
                                        if ((idValue14 = httpListenersValue.get("id")) == null || idValue14 instanceof NullNode) continue;
                                        String idInstance14 = idValue14.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setId(idInstance14);
                                    }
                                }
                                if ((requestRoutingRulesArray = propertiesValue.get("requestRoutingRules")) != null && !(requestRoutingRulesArray instanceof NullNode)) {
                                    Iterator httpListenersValue;
                                    httpListenersValue = ((ArrayNode)requestRoutingRulesArray).iterator();
                                    while (httpListenersValue.hasNext()) {
                                        JsonNode idValue18;
                                        JsonNode etagValue8;
                                        JsonNode nameValue9;
                                        JsonNode requestRoutingRulesValue = (JsonNode)httpListenersValue.next();
                                        ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRuleJsonFormatInstance = new ApplicationGatewayRequestRoutingRule();
                                        applicationGatewayJsonFormatInstance.getRequestRoutingRules().add(applicationGatewayRequestRoutingRuleJsonFormatInstance);
                                        JsonNode propertiesValue9 = requestRoutingRulesValue.get("properties");
                                        if (propertiesValue9 != null && !(propertiesValue9 instanceof NullNode)) {
                                            JsonNode provisioningStateValue8;
                                            JsonNode httpListenerValue;
                                            JsonNode backendHttpSettingsValue;
                                            JsonNode backendAddressPoolValue;
                                            JsonNode ruleTypeValue = propertiesValue9.get("ruleType");
                                            if (ruleTypeValue != null && !(ruleTypeValue instanceof NullNode)) {
                                                String ruleTypeInstance = ruleTypeValue.getTextValue();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setRuleType(ruleTypeInstance);
                                            }
                                            if ((backendAddressPoolValue = propertiesValue9.get("backendAddressPool")) != null && !(backendAddressPoolValue instanceof NullNode)) {
                                                ResourceId backendAddressPoolInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                                JsonNode idValue15 = backendAddressPoolValue.get("id");
                                                if (idValue15 != null && !(idValue15 instanceof NullNode)) {
                                                    String idInstance15 = idValue15.getTextValue();
                                                    backendAddressPoolInstance.setId(idInstance15);
                                                }
                                            }
                                            if ((backendHttpSettingsValue = propertiesValue9.get("backendHttpSettings")) != null && !(backendHttpSettingsValue instanceof NullNode)) {
                                                ResourceId backendHttpSettingsInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendHttpSettings(backendHttpSettingsInstance);
                                                JsonNode idValue16 = backendHttpSettingsValue.get("id");
                                                if (idValue16 != null && !(idValue16 instanceof NullNode)) {
                                                    String idInstance16 = idValue16.getTextValue();
                                                    backendHttpSettingsInstance.setId(idInstance16);
                                                }
                                            }
                                            if ((httpListenerValue = propertiesValue9.get("httpListener")) != null && !(httpListenerValue instanceof NullNode)) {
                                                ResourceId httpListenerInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setHttpListener(httpListenerInstance);
                                                JsonNode idValue17 = httpListenerValue.get("id");
                                                if (idValue17 != null && !(idValue17 instanceof NullNode)) {
                                                    String idInstance17 = idValue17.getTextValue();
                                                    httpListenerInstance.setId(idInstance17);
                                                }
                                            }
                                            if ((provisioningStateValue8 = propertiesValue9.get("provisioningState")) != null && !(provisioningStateValue8 instanceof NullNode)) {
                                                String provisioningStateInstance8 = provisioningStateValue8.getTextValue();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance8);
                                            }
                                        }
                                        if ((nameValue9 = requestRoutingRulesValue.get("name")) != null && !(nameValue9 instanceof NullNode)) {
                                            String nameInstance9 = nameValue9.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setName(nameInstance9);
                                        }
                                        if ((etagValue8 = requestRoutingRulesValue.get("etag")) != null && !(etagValue8 instanceof NullNode)) {
                                            String etagInstance8 = etagValue8.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setEtag(etagInstance8);
                                        }
                                        if ((idValue18 = requestRoutingRulesValue.get("id")) == null || idValue18 instanceof NullNode) continue;
                                        String idInstance18 = idValue18.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setId(idInstance18);
                                    }
                                }
                                if ((provisioningStateValue9 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue9 instanceof NullNode)) {
                                    String provisioningStateInstance9 = provisioningStateValue9.getTextValue();
                                    applicationGatewayJsonFormatInstance.setProvisioningState(provisioningStateInstance9);
                                }
                            }
                            if ((etagValue9 = valueValue.get("etag")) != null && !(etagValue9 instanceof NullNode)) {
                                String etagInstance9 = etagValue9.getTextValue();
                                applicationGatewayJsonFormatInstance.setEtag(etagInstance9);
                            }
                            if ((idValue19 = valueValue.get("id")) != null && !(idValue19 instanceof NullNode)) {
                                String idInstance19 = idValue19.getTextValue();
                                applicationGatewayJsonFormatInstance.setId(idInstance19);
                            }
                            if ((nameValue10 = valueValue.get("name")) != null && !(nameValue10 instanceof NullNode)) {
                                String nameInstance10 = nameValue10.getTextValue();
                                applicationGatewayJsonFormatInstance.setName(nameInstance10);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                applicationGatewayJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                applicationGatewayJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                applicationGatewayJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ApplicationGatewayListResponse applicationGatewayListResponse = result;
            return applicationGatewayListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> startAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.start(resourceGroupName, applicationGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse start(String resourceGroupName, String applicationGatewayName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"startAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            VirtualNetworkGatewayPutResponse response = client2.getApplicationGatewaysOperations().beginStartAsync(resourceGroupName, applicationGatewayName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> stopAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return ApplicationGatewayOperationsImpl.this.stop(resourceGroupName, applicationGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse stop(String resourceGroupName, String applicationGatewayName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"stopAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            VirtualNetworkGatewayPutResponse response = client2.getApplicationGatewaysOperations().beginStopAsync(resourceGroupName, applicationGatewayName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

