/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkInterfaceOperations;
import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.NetworkInterface;
import com.microsoft.azure.management.network.models.NetworkInterfaceDnsSettings;
import com.microsoft.azure.management.network.models.NetworkInterfaceGetResponse;
import com.microsoft.azure.management.network.models.NetworkInterfaceIpConfiguration;
import com.microsoft.azure.management.network.models.NetworkInterfaceListResponse;
import com.microsoft.azure.management.network.models.NetworkInterfacePutResponse;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class NetworkInterfaceOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
NetworkInterfaceOperations {
    private NetworkResourceProviderClientImpl client;

    NetworkInterfaceOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<NetworkInterfacePutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String networkInterfaceName, final NetworkInterface parameters) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkInterfacePutResponse>(){

            @Override
            public NetworkInterfacePutResponse call() throws Exception {
                return NetworkInterfaceOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, networkInterfaceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkInterfacePutResponse beginCreateOrUpdating(String resourceGroupName, String networkInterfaceName, NetworkInterface parameters) throws IOException, ServiceException {
        NetworkInterfacePutResponse networkInterfacePutResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode networkInterfaceJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkInterfaceName == null) {
            throw new NullPointerException("networkInterfaceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces/";
        url = url + URLEncoder.encode(networkInterfaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = networkInterfaceJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        networkInterfaceJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getVirtualMachine() != null) {
            ObjectNode virtualMachineValue = objectMapper.createObjectNode();
            propertiesValue.put("virtualMachine", (JsonNode)virtualMachineValue);
            if (parameters.getVirtualMachine().getId() != null) {
                virtualMachineValue.put("id", parameters.getVirtualMachine().getId());
            }
        }
        if (parameters.getNetworkSecurityGroup() != null) {
            ObjectNode networkSecurityGroupValue = objectMapper.createObjectNode();
            propertiesValue.put("networkSecurityGroup", (JsonNode)networkSecurityGroupValue);
            if (parameters.getNetworkSecurityGroup().getId() != null) {
                networkSecurityGroupValue.put("id", parameters.getNetworkSecurityGroup().getId());
            }
        }
        if (parameters.getIpConfigurations() != null && (!(parameters.getIpConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getIpConfigurations()).isInitialized())) {
            ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
            for (NetworkInterfaceIpConfiguration networkInterfaceIpConfiguration : parameters.getIpConfigurations()) {
                ObjectNode networkInterfaceIpConfigurationJsonFormatValue = objectMapper.createObjectNode();
                ipConfigurationsArray.add((JsonNode)networkInterfaceIpConfigurationJsonFormatValue);
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                networkInterfaceIpConfigurationJsonFormatValue.put("properties", (JsonNode)propertiesValue2);
                if (networkInterfaceIpConfiguration.getPrivateIpAddress() != null) {
                    propertiesValue2.put("privateIPAddress", networkInterfaceIpConfiguration.getPrivateIpAddress());
                }
                if (networkInterfaceIpConfiguration.getPrivateIpAllocationMethod() != null) {
                    propertiesValue2.put("privateIPAllocationMethod", networkInterfaceIpConfiguration.getPrivateIpAllocationMethod());
                }
                if (networkInterfaceIpConfiguration.getSubnet() != null) {
                    ObjectNode subnetValue = objectMapper.createObjectNode();
                    propertiesValue2.put("subnet", (JsonNode)subnetValue);
                    if (networkInterfaceIpConfiguration.getSubnet().getId() != null) {
                        subnetValue.put("id", networkInterfaceIpConfiguration.getSubnet().getId());
                    }
                }
                if (networkInterfaceIpConfiguration.getPublicIpAddress() != null) {
                    ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                    propertiesValue2.put("publicIPAddress", (JsonNode)publicIPAddressValue);
                    if (networkInterfaceIpConfiguration.getPublicIpAddress().getId() != null) {
                        publicIPAddressValue.put("id", networkInterfaceIpConfiguration.getPublicIpAddress().getId());
                    }
                }
                if (networkInterfaceIpConfiguration.getLoadBalancerBackendAddressPools() != null && (!(networkInterfaceIpConfiguration.getLoadBalancerBackendAddressPools() instanceof LazyCollection) || ((LazyCollection)networkInterfaceIpConfiguration.getLoadBalancerBackendAddressPools()).isInitialized())) {
                    ArrayNode loadBalancerBackendAddressPoolsArray = objectMapper.createArrayNode();
                    for (ResourceId loadBalancerBackendAddressPoolsItem : networkInterfaceIpConfiguration.getLoadBalancerBackendAddressPools()) {
                        ObjectNode resourceIdValue = objectMapper.createObjectNode();
                        loadBalancerBackendAddressPoolsArray.add((JsonNode)resourceIdValue);
                        if (loadBalancerBackendAddressPoolsItem.getId() == null) continue;
                        resourceIdValue.put("id", loadBalancerBackendAddressPoolsItem.getId());
                    }
                    propertiesValue2.put("loadBalancerBackendAddressPools", (JsonNode)loadBalancerBackendAddressPoolsArray);
                }
                if (networkInterfaceIpConfiguration.getLoadBalancerInboundNatRules() != null && (!(networkInterfaceIpConfiguration.getLoadBalancerInboundNatRules() instanceof LazyCollection) || ((LazyCollection)networkInterfaceIpConfiguration.getLoadBalancerInboundNatRules()).isInitialized())) {
                    ArrayNode loadBalancerInboundNatRulesArray = objectMapper.createArrayNode();
                    for (ResourceId loadBalancerInboundNatRulesItem : networkInterfaceIpConfiguration.getLoadBalancerInboundNatRules()) {
                        ObjectNode resourceIdValue2 = objectMapper.createObjectNode();
                        loadBalancerInboundNatRulesArray.add((JsonNode)resourceIdValue2);
                        if (loadBalancerInboundNatRulesItem.getId() == null) continue;
                        resourceIdValue2.put("id", loadBalancerInboundNatRulesItem.getId());
                    }
                    propertiesValue2.put("loadBalancerInboundNatRules", (JsonNode)loadBalancerInboundNatRulesArray);
                }
                if (networkInterfaceIpConfiguration.getProvisioningState() != null) {
                    propertiesValue2.put("provisioningState", networkInterfaceIpConfiguration.getProvisioningState());
                }
                if (networkInterfaceIpConfiguration.getName() != null) {
                    networkInterfaceIpConfigurationJsonFormatValue.put("name", networkInterfaceIpConfiguration.getName());
                }
                if (networkInterfaceIpConfiguration.getEtag() != null) {
                    networkInterfaceIpConfigurationJsonFormatValue.put("etag", networkInterfaceIpConfiguration.getEtag());
                }
                if (networkInterfaceIpConfiguration.getId() == null) continue;
                networkInterfaceIpConfigurationJsonFormatValue.put("id", networkInterfaceIpConfiguration.getId());
            }
            propertiesValue.put("ipConfigurations", (JsonNode)ipConfigurationsArray);
        }
        if (parameters.getDnsSettings() != null) {
            ObjectNode dnsSettingsValue = objectMapper.createObjectNode();
            propertiesValue.put("dnsSettings", (JsonNode)dnsSettingsValue);
            if (parameters.getDnsSettings().getDnsServers() != null && (!(parameters.getDnsSettings().getDnsServers() instanceof LazyCollection) || ((LazyCollection)parameters.getDnsSettings().getDnsServers()).isInitialized())) {
                ArrayNode dnsServersArray = objectMapper.createArrayNode();
                for (String dnsServersItem : parameters.getDnsSettings().getDnsServers()) {
                    dnsServersArray.add(dnsServersItem);
                }
                dnsSettingsValue.put("dnsServers", (JsonNode)dnsServersArray);
            }
            if (parameters.getDnsSettings().getAppliedDnsServers() != null && (!(parameters.getDnsSettings().getAppliedDnsServers() instanceof LazyCollection) || ((LazyCollection)parameters.getDnsSettings().getAppliedDnsServers()).isInitialized())) {
                ArrayNode appliedDnsServersArray = objectMapper.createArrayNode();
                for (String appliedDnsServersItem : parameters.getDnsSettings().getAppliedDnsServers()) {
                    appliedDnsServersArray.add(appliedDnsServersItem);
                }
                dnsSettingsValue.put("appliedDnsServers", (JsonNode)appliedDnsServersArray);
            }
            if (parameters.getDnsSettings().getInternalDnsNameLabel() != null) {
                dnsSettingsValue.put("internalDnsNameLabel", parameters.getDnsSettings().getInternalDnsNameLabel());
            }
            if (parameters.getDnsSettings().getInternalFqdn() != null) {
                dnsSettingsValue.put("internalFqdn", parameters.getDnsSettings().getInternalFqdn());
            }
        }
        if (parameters.getMacAddress() != null) {
            propertiesValue.put("macAddress", parameters.getMacAddress());
        }
        if (parameters.isPrimary() != null) {
            propertiesValue.put("primary", parameters.isPrimary());
        }
        propertiesValue.put("enableIPForwarding", parameters.isEnableIPForwarding());
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            networkInterfaceJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            networkInterfaceJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            networkInterfaceJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            networkInterfaceJsonFormatValue.put("type", parameters.getType());
        }
        networkInterfaceJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            networkInterfaceJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var17_24 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkInterfacePutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new NetworkInterfacePutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue8;
                    JsonNode etagValue2;
                    NetworkInterface networkInterfaceInstance = new NetworkInterface();
                    result.setNetworkInterface(networkInterfaceInstance);
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode enableIPForwardingValue;
                        JsonNode primaryValue;
                        JsonNode macAddressValue;
                        JsonNode dnsSettingsValue2;
                        JsonNode ipConfigurationsArray2;
                        JsonNode networkSecurityGroupValue2;
                        JsonNode virtualMachineValue2 = propertiesValue3.get("virtualMachine");
                        if (virtualMachineValue2 != null && !(virtualMachineValue2 instanceof NullNode)) {
                            ResourceId virtualMachineInstance = new ResourceId();
                            networkInterfaceInstance.setVirtualMachine(virtualMachineInstance);
                            JsonNode idValue = virtualMachineValue2.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                virtualMachineInstance.setId(idInstance);
                            }
                        }
                        if ((networkSecurityGroupValue2 = propertiesValue3.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue2 instanceof NullNode)) {
                            ResourceId networkSecurityGroupInstance = new ResourceId();
                            networkInterfaceInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                            Iterator idValue2 = networkSecurityGroupValue2.get("id");
                            if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                networkSecurityGroupInstance.setId(idInstance2);
                            }
                        }
                        if ((ipConfigurationsArray2 = propertiesValue3.get("ipConfigurations")) != null && !(ipConfigurationsArray2 instanceof NullNode)) {
                            for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray2) {
                                JsonNode idValue7;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                NetworkInterfaceIpConfiguration networkInterfaceIpConfigurationJsonFormatInstance = new NetworkInterfaceIpConfiguration();
                                networkInterfaceInstance.getIpConfigurations().add(networkInterfaceIpConfigurationJsonFormatInstance);
                                JsonNode propertiesValue4 = ipConfigurationsValue.get("properties");
                                if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    Iterator loadBalancerInboundNatRulesArray2;
                                    JsonNode loadBalancerBackendAddressPoolsArray2;
                                    JsonNode publicIPAddressValue2;
                                    JsonNode subnetValue2;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue2 = propertiesValue4.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue3 = subnetValue2.get("id");
                                        if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                            String idInstance3 = idValue3.getTextValue();
                                            subnetInstance.setId(idInstance3);
                                        }
                                    }
                                    if ((publicIPAddressValue2 = propertiesValue4.get("publicIPAddress")) != null && !(publicIPAddressValue2 instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        Iterator idValue4 = publicIPAddressValue2.get("id");
                                        if (idValue4 != null && !(idValue4 instanceof NullNode)) {
                                            String idInstance4 = idValue4.getTextValue();
                                            publicIPAddressInstance.setId(idInstance4);
                                        }
                                    }
                                    if ((loadBalancerBackendAddressPoolsArray2 = propertiesValue4.get("loadBalancerBackendAddressPools")) != null && !(loadBalancerBackendAddressPoolsArray2 instanceof NullNode)) {
                                        for (Iterator loadBalancerBackendAddressPoolsValue : (ArrayNode)loadBalancerBackendAddressPoolsArray2) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerBackendAddressPools().add(resourceIdInstance);
                                            JsonNode idValue5 = loadBalancerBackendAddressPoolsValue.get("id");
                                            if (idValue5 == null || idValue5 instanceof NullNode) continue;
                                            String idInstance5 = idValue5.getTextValue();
                                            resourceIdInstance.setId(idInstance5);
                                        }
                                    }
                                    if ((loadBalancerInboundNatRulesArray2 = propertiesValue4.get("loadBalancerInboundNatRules")) != null && !(loadBalancerInboundNatRulesArray2 instanceof NullNode)) {
                                        Iterator loadBalancerBackendAddressPoolsValue;
                                        loadBalancerBackendAddressPoolsValue = ((ArrayNode)loadBalancerInboundNatRulesArray2).iterator();
                                        while (loadBalancerBackendAddressPoolsValue.hasNext()) {
                                            JsonNode loadBalancerInboundNatRulesValue = (JsonNode)loadBalancerBackendAddressPoolsValue.next();
                                            ResourceId resourceIdInstance2 = new ResourceId();
                                            networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerInboundNatRules().add(resourceIdInstance2);
                                            JsonNode idValue6 = loadBalancerInboundNatRulesValue.get("id");
                                            if (idValue6 == null || idValue6 instanceof NullNode) continue;
                                            String idInstance6 = idValue6.getTextValue();
                                            resourceIdInstance2.setId(idInstance6);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue7 = ipConfigurationsValue.get("id")) == null || idValue7 instanceof NullNode) continue;
                                String idInstance7 = idValue7.getTextValue();
                                networkInterfaceIpConfigurationJsonFormatInstance.setId(idInstance7);
                            }
                        }
                        if ((dnsSettingsValue2 = propertiesValue3.get("dnsSettings")) != null && !(dnsSettingsValue2 instanceof NullNode)) {
                            JsonNode internalFqdnValue;
                            JsonNode internalDnsNameLabelValue;
                            JsonNode appliedDnsServersArray2;
                            NetworkInterfaceDnsSettings dnsSettingsInstance = new NetworkInterfaceDnsSettings();
                            networkInterfaceInstance.setDnsSettings(dnsSettingsInstance);
                            JsonNode dnsServersArray2 = dnsSettingsValue2.get("dnsServers");
                            if (dnsServersArray2 != null && !(dnsServersArray2 instanceof NullNode)) {
                                for (Iterator dnsServersValue : (ArrayNode)dnsServersArray2) {
                                    dnsSettingsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                }
                            }
                            if ((appliedDnsServersArray2 = dnsSettingsValue2.get("appliedDnsServers")) != null && !(appliedDnsServersArray2 instanceof NullNode)) {
                                for (JsonNode appliedDnsServersValue : (ArrayNode)appliedDnsServersArray2) {
                                    dnsSettingsInstance.getAppliedDnsServers().add(appliedDnsServersValue.getTextValue());
                                }
                            }
                            if ((internalDnsNameLabelValue = dnsSettingsValue2.get("internalDnsNameLabel")) != null && !(internalDnsNameLabelValue instanceof NullNode)) {
                                String internalDnsNameLabelInstance = internalDnsNameLabelValue.getTextValue();
                                dnsSettingsInstance.setInternalDnsNameLabel(internalDnsNameLabelInstance);
                            }
                            if ((internalFqdnValue = dnsSettingsValue2.get("internalFqdn")) != null && !(internalFqdnValue instanceof NullNode)) {
                                String internalFqdnInstance = internalFqdnValue.getTextValue();
                                dnsSettingsInstance.setInternalFqdn(internalFqdnInstance);
                            }
                        }
                        if ((macAddressValue = propertiesValue3.get("macAddress")) != null && !(macAddressValue instanceof NullNode)) {
                            String macAddressInstance = macAddressValue.getTextValue();
                            networkInterfaceInstance.setMacAddress(macAddressInstance);
                        }
                        if ((primaryValue = propertiesValue3.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                            boolean primaryInstance = primaryValue.getBooleanValue();
                            networkInterfaceInstance.setPrimary(primaryInstance);
                        }
                        if ((enableIPForwardingValue = propertiesValue3.get("enableIPForwarding")) != null && !(enableIPForwardingValue instanceof NullNode)) {
                            boolean enableIPForwardingInstance = enableIPForwardingValue.getBooleanValue();
                            networkInterfaceInstance.setEnableIPForwarding(enableIPForwardingInstance);
                        }
                        if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            networkInterfaceInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        networkInterfaceInstance.setEtag(etagInstance2);
                    }
                    if ((idValue8 = responseDoc.get("id")) != null && !(idValue8 instanceof NullNode)) {
                        String idInstance8 = idValue8.getTextValue();
                        networkInterfaceInstance.setId(idInstance8);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        networkInterfaceInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        networkInterfaceInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        networkInterfaceInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            networkInterfaceInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)closeableHttpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            networkInterfacePutResponse = result;
        }
        catch (Throwable throwable) {
            if (var17_24 != null && var17_24.getEntity() != null) {
                var17_24.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return networkInterfacePutResponse;
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String networkInterfaceName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return NetworkInterfaceOperationsImpl.this.beginDeleting(resourceGroupName, networkInterfaceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String networkInterfaceName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkInterfaceName == null) {
            throw new NullPointerException("networkInterfaceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces/";
        url = url + URLEncoder.encode(networkInterfaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String networkInterfaceName, final NetworkInterface parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return NetworkInterfaceOperationsImpl.this.createOrUpdate(resourceGroupName, networkInterfaceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String networkInterfaceName, NetworkInterface parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            NetworkInterfacePutResponse response = client2.getNetworkInterfacesOperations().beginCreateOrUpdatingAsync(resourceGroupName, networkInterfaceName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String networkInterfaceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return NetworkInterfaceOperationsImpl.this.delete(resourceGroupName, networkInterfaceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String networkInterfaceName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getNetworkInterfacesOperations().beginDeletingAsync(resourceGroupName, networkInterfaceName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<NetworkInterfaceGetResponse> getAsync(final String resourceGroupName, final String networkInterfaceName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkInterfaceGetResponse>(){

            @Override
            public NetworkInterfaceGetResponse call() throws Exception {
                return NetworkInterfaceOperationsImpl.this.get(resourceGroupName, networkInterfaceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkInterfaceGetResponse get(String resourceGroupName, String networkInterfaceName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkInterfaceName == null) {
            throw new NullPointerException("networkInterfaceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces/";
        url = url + URLEncoder.encode(networkInterfaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkInterfaceGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkInterfaceGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue8;
                    JsonNode etagValue2;
                    NetworkInterface networkInterfaceInstance = new NetworkInterface();
                    result.setNetworkInterface(networkInterfaceInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode enableIPForwardingValue;
                        JsonNode primaryValue;
                        JsonNode macAddressValue;
                        JsonNode dnsSettingsValue;
                        JsonNode ipConfigurationsArray;
                        JsonNode networkSecurityGroupValue;
                        JsonNode virtualMachineValue = propertiesValue.get("virtualMachine");
                        if (virtualMachineValue != null && !(virtualMachineValue instanceof NullNode)) {
                            ResourceId virtualMachineInstance = new ResourceId();
                            networkInterfaceInstance.setVirtualMachine(virtualMachineInstance);
                            JsonNode idValue = virtualMachineValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                virtualMachineInstance.setId(idInstance);
                            }
                        }
                        if ((networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue instanceof NullNode)) {
                            ResourceId networkSecurityGroupInstance = new ResourceId();
                            networkInterfaceInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                            Iterator idValue2 = networkSecurityGroupValue.get("id");
                            if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                networkSecurityGroupInstance.setId(idInstance2);
                            }
                        }
                        if ((ipConfigurationsArray = propertiesValue.get("ipConfigurations")) != null && !(ipConfigurationsArray instanceof NullNode)) {
                            for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                JsonNode idValue7;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                NetworkInterfaceIpConfiguration networkInterfaceIpConfigurationJsonFormatInstance = new NetworkInterfaceIpConfiguration();
                                networkInterfaceInstance.getIpConfigurations().add(networkInterfaceIpConfigurationJsonFormatInstance);
                                JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode loadBalancerInboundNatRulesArray;
                                    JsonNode loadBalancerBackendAddressPoolsArray;
                                    JsonNode publicIPAddressValue;
                                    JsonNode subnetValue;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue = propertiesValue2.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue3 = subnetValue.get("id");
                                        if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                            String idInstance3 = idValue3.getTextValue();
                                            subnetInstance.setId(idInstance3);
                                        }
                                    }
                                    if ((publicIPAddressValue = propertiesValue2.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        Iterator idValue4 = publicIPAddressValue.get("id");
                                        if (idValue4 != null && !(idValue4 instanceof NullNode)) {
                                            String idInstance4 = idValue4.getTextValue();
                                            publicIPAddressInstance.setId(idInstance4);
                                        }
                                    }
                                    if ((loadBalancerBackendAddressPoolsArray = propertiesValue2.get("loadBalancerBackendAddressPools")) != null && !(loadBalancerBackendAddressPoolsArray instanceof NullNode)) {
                                        for (Iterator loadBalancerBackendAddressPoolsValue : (ArrayNode)loadBalancerBackendAddressPoolsArray) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerBackendAddressPools().add(resourceIdInstance);
                                            JsonNode idValue5 = loadBalancerBackendAddressPoolsValue.get("id");
                                            if (idValue5 == null || idValue5 instanceof NullNode) continue;
                                            String idInstance5 = idValue5.getTextValue();
                                            resourceIdInstance.setId(idInstance5);
                                        }
                                    }
                                    if ((loadBalancerInboundNatRulesArray = propertiesValue2.get("loadBalancerInboundNatRules")) != null && !(loadBalancerInboundNatRulesArray instanceof NullNode)) {
                                        Iterator loadBalancerBackendAddressPoolsValue;
                                        loadBalancerBackendAddressPoolsValue = ((ArrayNode)loadBalancerInboundNatRulesArray).iterator();
                                        while (loadBalancerBackendAddressPoolsValue.hasNext()) {
                                            JsonNode loadBalancerInboundNatRulesValue = (JsonNode)loadBalancerBackendAddressPoolsValue.next();
                                            ResourceId resourceIdInstance2 = new ResourceId();
                                            networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerInboundNatRules().add(resourceIdInstance2);
                                            JsonNode idValue6 = loadBalancerInboundNatRulesValue.get("id");
                                            if (idValue6 == null || idValue6 instanceof NullNode) continue;
                                            String idInstance6 = idValue6.getTextValue();
                                            resourceIdInstance2.setId(idInstance6);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue7 = ipConfigurationsValue.get("id")) == null || idValue7 instanceof NullNode) continue;
                                String idInstance7 = idValue7.getTextValue();
                                networkInterfaceIpConfigurationJsonFormatInstance.setId(idInstance7);
                            }
                        }
                        if ((dnsSettingsValue = propertiesValue.get("dnsSettings")) != null && !(dnsSettingsValue instanceof NullNode)) {
                            JsonNode internalFqdnValue;
                            JsonNode internalDnsNameLabelValue;
                            JsonNode appliedDnsServersArray;
                            NetworkInterfaceDnsSettings dnsSettingsInstance = new NetworkInterfaceDnsSettings();
                            networkInterfaceInstance.setDnsSettings(dnsSettingsInstance);
                            JsonNode dnsServersArray = dnsSettingsValue.get("dnsServers");
                            if (dnsServersArray != null && !(dnsServersArray instanceof NullNode)) {
                                for (Iterator dnsServersValue : (ArrayNode)dnsServersArray) {
                                    dnsSettingsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                }
                            }
                            if ((appliedDnsServersArray = dnsSettingsValue.get("appliedDnsServers")) != null && !(appliedDnsServersArray instanceof NullNode)) {
                                for (JsonNode appliedDnsServersValue : (ArrayNode)appliedDnsServersArray) {
                                    dnsSettingsInstance.getAppliedDnsServers().add(appliedDnsServersValue.getTextValue());
                                }
                            }
                            if ((internalDnsNameLabelValue = dnsSettingsValue.get("internalDnsNameLabel")) != null && !(internalDnsNameLabelValue instanceof NullNode)) {
                                String internalDnsNameLabelInstance = internalDnsNameLabelValue.getTextValue();
                                dnsSettingsInstance.setInternalDnsNameLabel(internalDnsNameLabelInstance);
                            }
                            if ((internalFqdnValue = dnsSettingsValue.get("internalFqdn")) != null && !(internalFqdnValue instanceof NullNode)) {
                                String internalFqdnInstance = internalFqdnValue.getTextValue();
                                dnsSettingsInstance.setInternalFqdn(internalFqdnInstance);
                            }
                        }
                        if ((macAddressValue = propertiesValue.get("macAddress")) != null && !(macAddressValue instanceof NullNode)) {
                            String macAddressInstance = macAddressValue.getTextValue();
                            networkInterfaceInstance.setMacAddress(macAddressInstance);
                        }
                        if ((primaryValue = propertiesValue.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                            boolean primaryInstance = primaryValue.getBooleanValue();
                            networkInterfaceInstance.setPrimary(primaryInstance);
                        }
                        if ((enableIPForwardingValue = propertiesValue.get("enableIPForwarding")) != null && !(enableIPForwardingValue instanceof NullNode)) {
                            boolean enableIPForwardingInstance = enableIPForwardingValue.getBooleanValue();
                            networkInterfaceInstance.setEnableIPForwarding(enableIPForwardingInstance);
                        }
                        if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            networkInterfaceInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        networkInterfaceInstance.setEtag(etagInstance2);
                    }
                    if ((idValue8 = responseDoc.get("id")) != null && !(idValue8 instanceof NullNode)) {
                        String idInstance8 = idValue8.getTextValue();
                        networkInterfaceInstance.setId(idInstance8);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        networkInterfaceInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        networkInterfaceInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        networkInterfaceInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            networkInterfaceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkInterfaceGetResponse networkInterfaceGetResponse = result;
            return networkInterfaceGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<NetworkInterfaceListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkInterfaceListResponse>(){

            @Override
            public NetworkInterfaceListResponse call() throws Exception {
                return NetworkInterfaceOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkInterfaceListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkInterfaceListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkInterfaceListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue8;
                            JsonNode etagValue2;
                            NetworkInterface networkInterfaceJsonFormatInstance = new NetworkInterface();
                            result.getNetworkInterfaces().add(networkInterfaceJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue2;
                                JsonNode enableIPForwardingValue;
                                JsonNode primaryValue;
                                JsonNode macAddressValue;
                                JsonNode dnsSettingsValue;
                                JsonNode ipConfigurationsArray;
                                JsonNode networkSecurityGroupValue;
                                JsonNode virtualMachineValue = propertiesValue.get("virtualMachine");
                                if (virtualMachineValue != null && !(virtualMachineValue instanceof NullNode)) {
                                    ResourceId virtualMachineInstance = new ResourceId();
                                    networkInterfaceJsonFormatInstance.setVirtualMachine(virtualMachineInstance);
                                    JsonNode idValue = virtualMachineValue.get("id");
                                    if (idValue != null && !(idValue instanceof NullNode)) {
                                        String idInstance = idValue.getTextValue();
                                        virtualMachineInstance.setId(idInstance);
                                    }
                                }
                                if ((networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue instanceof NullNode)) {
                                    ResourceId networkSecurityGroupInstance = new ResourceId();
                                    networkInterfaceJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                    Iterator idValue2 = networkSecurityGroupValue.get("id");
                                    if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                        String idInstance2 = idValue2.getTextValue();
                                        networkSecurityGroupInstance.setId(idInstance2);
                                    }
                                }
                                if ((ipConfigurationsArray = propertiesValue.get("ipConfigurations")) != null && !(ipConfigurationsArray instanceof NullNode)) {
                                    for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                        JsonNode idValue7;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        NetworkInterfaceIpConfiguration networkInterfaceIpConfigurationJsonFormatInstance = new NetworkInterfaceIpConfiguration();
                                        networkInterfaceJsonFormatInstance.getIpConfigurations().add(networkInterfaceIpConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode loadBalancerInboundNatRulesArray;
                                            JsonNode loadBalancerBackendAddressPoolsArray;
                                            JsonNode publicIPAddressValue;
                                            JsonNode subnetValue;
                                            JsonNode privateIPAllocationMethodValue;
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                                String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            if ((privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            if ((subnetValue = propertiesValue2.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                                ResourceId subnetInstance = new ResourceId();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                JsonNode idValue3 = subnetValue.get("id");
                                                if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                                    String idInstance3 = idValue3.getTextValue();
                                                    subnetInstance.setId(idInstance3);
                                                }
                                            }
                                            if ((publicIPAddressValue = propertiesValue2.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                Iterator idValue4 = publicIPAddressValue.get("id");
                                                if (idValue4 != null && !(idValue4 instanceof NullNode)) {
                                                    String idInstance4 = idValue4.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance4);
                                                }
                                            }
                                            if ((loadBalancerBackendAddressPoolsArray = propertiesValue2.get("loadBalancerBackendAddressPools")) != null && !(loadBalancerBackendAddressPoolsArray instanceof NullNode)) {
                                                for (Iterator loadBalancerBackendAddressPoolsValue : (ArrayNode)loadBalancerBackendAddressPoolsArray) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerBackendAddressPools().add(resourceIdInstance);
                                                    JsonNode idValue5 = loadBalancerBackendAddressPoolsValue.get("id");
                                                    if (idValue5 == null || idValue5 instanceof NullNode) continue;
                                                    String idInstance5 = idValue5.getTextValue();
                                                    resourceIdInstance.setId(idInstance5);
                                                }
                                            }
                                            if ((loadBalancerInboundNatRulesArray = propertiesValue2.get("loadBalancerInboundNatRules")) != null && !(loadBalancerInboundNatRulesArray instanceof NullNode)) {
                                                Iterator loadBalancerBackendAddressPoolsValue;
                                                loadBalancerBackendAddressPoolsValue = ((ArrayNode)loadBalancerInboundNatRulesArray).iterator();
                                                while (loadBalancerBackendAddressPoolsValue.hasNext()) {
                                                    JsonNode loadBalancerInboundNatRulesValue = (JsonNode)loadBalancerBackendAddressPoolsValue.next();
                                                    ResourceId resourceIdInstance2 = new ResourceId();
                                                    networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerInboundNatRules().add(resourceIdInstance2);
                                                    JsonNode idValue6 = loadBalancerInboundNatRulesValue.get("id");
                                                    if (idValue6 == null || idValue6 instanceof NullNode) continue;
                                                    String idInstance6 = idValue6.getTextValue();
                                                    resourceIdInstance2.setId(idInstance6);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue7 = ipConfigurationsValue.get("id")) == null || idValue7 instanceof NullNode) continue;
                                        String idInstance7 = idValue7.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setId(idInstance7);
                                    }
                                }
                                if ((dnsSettingsValue = propertiesValue.get("dnsSettings")) != null && !(dnsSettingsValue instanceof NullNode)) {
                                    JsonNode internalFqdnValue;
                                    JsonNode internalDnsNameLabelValue;
                                    JsonNode appliedDnsServersArray;
                                    NetworkInterfaceDnsSettings dnsSettingsInstance = new NetworkInterfaceDnsSettings();
                                    networkInterfaceJsonFormatInstance.setDnsSettings(dnsSettingsInstance);
                                    JsonNode dnsServersArray = dnsSettingsValue.get("dnsServers");
                                    if (dnsServersArray != null && !(dnsServersArray instanceof NullNode)) {
                                        for (Iterator dnsServersValue : (ArrayNode)dnsServersArray) {
                                            dnsSettingsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                        }
                                    }
                                    if ((appliedDnsServersArray = dnsSettingsValue.get("appliedDnsServers")) != null && !(appliedDnsServersArray instanceof NullNode)) {
                                        Iterator dnsServersValue;
                                        dnsServersValue = ((ArrayNode)appliedDnsServersArray).iterator();
                                        while (dnsServersValue.hasNext()) {
                                            JsonNode appliedDnsServersValue = (JsonNode)dnsServersValue.next();
                                            dnsSettingsInstance.getAppliedDnsServers().add(appliedDnsServersValue.getTextValue());
                                        }
                                    }
                                    if ((internalDnsNameLabelValue = dnsSettingsValue.get("internalDnsNameLabel")) != null && !(internalDnsNameLabelValue instanceof NullNode)) {
                                        String internalDnsNameLabelInstance = internalDnsNameLabelValue.getTextValue();
                                        dnsSettingsInstance.setInternalDnsNameLabel(internalDnsNameLabelInstance);
                                    }
                                    if ((internalFqdnValue = dnsSettingsValue.get("internalFqdn")) != null && !(internalFqdnValue instanceof NullNode)) {
                                        String internalFqdnInstance = internalFqdnValue.getTextValue();
                                        dnsSettingsInstance.setInternalFqdn(internalFqdnInstance);
                                    }
                                }
                                if ((macAddressValue = propertiesValue.get("macAddress")) != null && !(macAddressValue instanceof NullNode)) {
                                    String macAddressInstance = macAddressValue.getTextValue();
                                    networkInterfaceJsonFormatInstance.setMacAddress(macAddressInstance);
                                }
                                if ((primaryValue = propertiesValue.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                                    boolean primaryInstance = primaryValue.getBooleanValue();
                                    networkInterfaceJsonFormatInstance.setPrimary(primaryInstance);
                                }
                                if ((enableIPForwardingValue = propertiesValue.get("enableIPForwarding")) != null && !(enableIPForwardingValue instanceof NullNode)) {
                                    boolean enableIPForwardingInstance = enableIPForwardingValue.getBooleanValue();
                                    networkInterfaceJsonFormatInstance.setEnableIPForwarding(enableIPForwardingInstance);
                                }
                                if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    networkInterfaceJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            if ((etagValue2 = valueValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                networkInterfaceJsonFormatInstance.setEtag(etagInstance2);
                            }
                            if ((idValue8 = valueValue.get("id")) != null && !(idValue8 instanceof NullNode)) {
                                String idInstance8 = idValue8.getTextValue();
                                networkInterfaceJsonFormatInstance.setId(idInstance8);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                networkInterfaceJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                networkInterfaceJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                networkInterfaceJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                networkInterfaceJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkInterfaceListResponse networkInterfaceListResponse = result;
            return networkInterfaceListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<NetworkInterfaceListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<NetworkInterfaceListResponse>(){

            @Override
            public NetworkInterfaceListResponse call() throws Exception {
                return NetworkInterfaceOperationsImpl.this.listAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkInterfaceListResponse listAll() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkInterfaceListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkInterfaceListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue8;
                            JsonNode etagValue2;
                            NetworkInterface networkInterfaceJsonFormatInstance = new NetworkInterface();
                            result.getNetworkInterfaces().add(networkInterfaceJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue2;
                                JsonNode enableIPForwardingValue;
                                JsonNode primaryValue;
                                JsonNode macAddressValue;
                                JsonNode dnsSettingsValue;
                                JsonNode ipConfigurationsArray;
                                JsonNode networkSecurityGroupValue;
                                JsonNode virtualMachineValue = propertiesValue.get("virtualMachine");
                                if (virtualMachineValue != null && !(virtualMachineValue instanceof NullNode)) {
                                    ResourceId virtualMachineInstance = new ResourceId();
                                    networkInterfaceJsonFormatInstance.setVirtualMachine(virtualMachineInstance);
                                    JsonNode idValue = virtualMachineValue.get("id");
                                    if (idValue != null && !(idValue instanceof NullNode)) {
                                        String idInstance = idValue.getTextValue();
                                        virtualMachineInstance.setId(idInstance);
                                    }
                                }
                                if ((networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue instanceof NullNode)) {
                                    ResourceId networkSecurityGroupInstance = new ResourceId();
                                    networkInterfaceJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                    Iterator idValue2 = networkSecurityGroupValue.get("id");
                                    if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                        String idInstance2 = idValue2.getTextValue();
                                        networkSecurityGroupInstance.setId(idInstance2);
                                    }
                                }
                                if ((ipConfigurationsArray = propertiesValue.get("ipConfigurations")) != null && !(ipConfigurationsArray instanceof NullNode)) {
                                    for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                        JsonNode idValue7;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        NetworkInterfaceIpConfiguration networkInterfaceIpConfigurationJsonFormatInstance = new NetworkInterfaceIpConfiguration();
                                        networkInterfaceJsonFormatInstance.getIpConfigurations().add(networkInterfaceIpConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode loadBalancerInboundNatRulesArray;
                                            JsonNode loadBalancerBackendAddressPoolsArray;
                                            JsonNode publicIPAddressValue;
                                            JsonNode subnetValue;
                                            JsonNode privateIPAllocationMethodValue;
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                                String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            if ((privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            if ((subnetValue = propertiesValue2.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                                ResourceId subnetInstance = new ResourceId();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                JsonNode idValue3 = subnetValue.get("id");
                                                if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                                    String idInstance3 = idValue3.getTextValue();
                                                    subnetInstance.setId(idInstance3);
                                                }
                                            }
                                            if ((publicIPAddressValue = propertiesValue2.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                Iterator idValue4 = publicIPAddressValue.get("id");
                                                if (idValue4 != null && !(idValue4 instanceof NullNode)) {
                                                    String idInstance4 = idValue4.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance4);
                                                }
                                            }
                                            if ((loadBalancerBackendAddressPoolsArray = propertiesValue2.get("loadBalancerBackendAddressPools")) != null && !(loadBalancerBackendAddressPoolsArray instanceof NullNode)) {
                                                for (Iterator loadBalancerBackendAddressPoolsValue : (ArrayNode)loadBalancerBackendAddressPoolsArray) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerBackendAddressPools().add(resourceIdInstance);
                                                    JsonNode idValue5 = loadBalancerBackendAddressPoolsValue.get("id");
                                                    if (idValue5 == null || idValue5 instanceof NullNode) continue;
                                                    String idInstance5 = idValue5.getTextValue();
                                                    resourceIdInstance.setId(idInstance5);
                                                }
                                            }
                                            if ((loadBalancerInboundNatRulesArray = propertiesValue2.get("loadBalancerInboundNatRules")) != null && !(loadBalancerInboundNatRulesArray instanceof NullNode)) {
                                                Iterator loadBalancerBackendAddressPoolsValue;
                                                loadBalancerBackendAddressPoolsValue = ((ArrayNode)loadBalancerInboundNatRulesArray).iterator();
                                                while (loadBalancerBackendAddressPoolsValue.hasNext()) {
                                                    JsonNode loadBalancerInboundNatRulesValue = (JsonNode)loadBalancerBackendAddressPoolsValue.next();
                                                    ResourceId resourceIdInstance2 = new ResourceId();
                                                    networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerInboundNatRules().add(resourceIdInstance2);
                                                    JsonNode idValue6 = loadBalancerInboundNatRulesValue.get("id");
                                                    if (idValue6 == null || idValue6 instanceof NullNode) continue;
                                                    String idInstance6 = idValue6.getTextValue();
                                                    resourceIdInstance2.setId(idInstance6);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue7 = ipConfigurationsValue.get("id")) == null || idValue7 instanceof NullNode) continue;
                                        String idInstance7 = idValue7.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setId(idInstance7);
                                    }
                                }
                                if ((dnsSettingsValue = propertiesValue.get("dnsSettings")) != null && !(dnsSettingsValue instanceof NullNode)) {
                                    JsonNode internalFqdnValue;
                                    JsonNode internalDnsNameLabelValue;
                                    JsonNode appliedDnsServersArray;
                                    NetworkInterfaceDnsSettings dnsSettingsInstance = new NetworkInterfaceDnsSettings();
                                    networkInterfaceJsonFormatInstance.setDnsSettings(dnsSettingsInstance);
                                    JsonNode dnsServersArray = dnsSettingsValue.get("dnsServers");
                                    if (dnsServersArray != null && !(dnsServersArray instanceof NullNode)) {
                                        for (Iterator dnsServersValue : (ArrayNode)dnsServersArray) {
                                            dnsSettingsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                        }
                                    }
                                    if ((appliedDnsServersArray = dnsSettingsValue.get("appliedDnsServers")) != null && !(appliedDnsServersArray instanceof NullNode)) {
                                        Iterator dnsServersValue;
                                        dnsServersValue = ((ArrayNode)appliedDnsServersArray).iterator();
                                        while (dnsServersValue.hasNext()) {
                                            JsonNode appliedDnsServersValue = (JsonNode)dnsServersValue.next();
                                            dnsSettingsInstance.getAppliedDnsServers().add(appliedDnsServersValue.getTextValue());
                                        }
                                    }
                                    if ((internalDnsNameLabelValue = dnsSettingsValue.get("internalDnsNameLabel")) != null && !(internalDnsNameLabelValue instanceof NullNode)) {
                                        String internalDnsNameLabelInstance = internalDnsNameLabelValue.getTextValue();
                                        dnsSettingsInstance.setInternalDnsNameLabel(internalDnsNameLabelInstance);
                                    }
                                    if ((internalFqdnValue = dnsSettingsValue.get("internalFqdn")) != null && !(internalFqdnValue instanceof NullNode)) {
                                        String internalFqdnInstance = internalFqdnValue.getTextValue();
                                        dnsSettingsInstance.setInternalFqdn(internalFqdnInstance);
                                    }
                                }
                                if ((macAddressValue = propertiesValue.get("macAddress")) != null && !(macAddressValue instanceof NullNode)) {
                                    String macAddressInstance = macAddressValue.getTextValue();
                                    networkInterfaceJsonFormatInstance.setMacAddress(macAddressInstance);
                                }
                                if ((primaryValue = propertiesValue.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                                    boolean primaryInstance = primaryValue.getBooleanValue();
                                    networkInterfaceJsonFormatInstance.setPrimary(primaryInstance);
                                }
                                if ((enableIPForwardingValue = propertiesValue.get("enableIPForwarding")) != null && !(enableIPForwardingValue instanceof NullNode)) {
                                    boolean enableIPForwardingInstance = enableIPForwardingValue.getBooleanValue();
                                    networkInterfaceJsonFormatInstance.setEnableIPForwarding(enableIPForwardingInstance);
                                }
                                if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    networkInterfaceJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            if ((etagValue2 = valueValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                networkInterfaceJsonFormatInstance.setEtag(etagInstance2);
                            }
                            if ((idValue8 = valueValue.get("id")) != null && !(idValue8 instanceof NullNode)) {
                                String idInstance8 = idValue8.getTextValue();
                                networkInterfaceJsonFormatInstance.setId(idInstance8);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                networkInterfaceJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                networkInterfaceJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                networkInterfaceJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                networkInterfaceJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkInterfaceListResponse networkInterfaceListResponse = result;
            return networkInterfaceListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

