/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.ApplicationGatewayOperations;
import com.microsoft.azure.management.network.ApplicationGatewayOperationsImpl;
import com.microsoft.azure.management.network.LoadBalancerOperations;
import com.microsoft.azure.management.network.LoadBalancerOperationsImpl;
import com.microsoft.azure.management.network.LocalNetworkGatewayOperations;
import com.microsoft.azure.management.network.LocalNetworkGatewayOperationsImpl;
import com.microsoft.azure.management.network.NetworkInterfaceOperations;
import com.microsoft.azure.management.network.NetworkInterfaceOperationsImpl;
import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkSecurityGroupOperations;
import com.microsoft.azure.management.network.NetworkSecurityGroupOperationsImpl;
import com.microsoft.azure.management.network.PublicIpAddressOperations;
import com.microsoft.azure.management.network.PublicIpAddressOperationsImpl;
import com.microsoft.azure.management.network.RouteOperations;
import com.microsoft.azure.management.network.RouteOperationsImpl;
import com.microsoft.azure.management.network.RouteTableOperations;
import com.microsoft.azure.management.network.RouteTableOperationsImpl;
import com.microsoft.azure.management.network.SecurityRuleOperations;
import com.microsoft.azure.management.network.SecurityRuleOperationsImpl;
import com.microsoft.azure.management.network.SubnetOperations;
import com.microsoft.azure.management.network.SubnetOperationsImpl;
import com.microsoft.azure.management.network.UsageOperations;
import com.microsoft.azure.management.network.UsageOperationsImpl;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnectionOperations;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnectionOperationsImpl;
import com.microsoft.azure.management.network.VirtualNetworkGatewayOperations;
import com.microsoft.azure.management.network.VirtualNetworkGatewayOperationsImpl;
import com.microsoft.azure.management.network.VirtualNetworkOperations;
import com.microsoft.azure.management.network.VirtualNetworkOperationsImpl;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.DnsNameAvailabilityResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class NetworkResourceProviderClientImpl
extends ServiceClient<NetworkResourceProviderClient>
implements NetworkResourceProviderClient {
    private String apiVersion = "2015-05-01-preview";
    private URI baseUri;
    private SubscriptionCloudCredentials credentials;
    private int longRunningOperationInitialTimeout = -1;
    private int longRunningOperationRetryTimeout = -1;
    private ApplicationGatewayOperations applicationGateways = new ApplicationGatewayOperationsImpl(this);
    private LoadBalancerOperations loadBalancers = new LoadBalancerOperationsImpl(this);
    private LocalNetworkGatewayOperations localNetworkGateways = new LocalNetworkGatewayOperationsImpl(this);
    private NetworkInterfaceOperations networkInterfaces = new NetworkInterfaceOperationsImpl(this);
    private NetworkSecurityGroupOperations networkSecurityGroups = new NetworkSecurityGroupOperationsImpl(this);
    private PublicIpAddressOperations publicIpAddresses = new PublicIpAddressOperationsImpl(this);
    private RouteOperations routes = new RouteOperationsImpl(this);
    private RouteTableOperations routeTables = new RouteTableOperationsImpl(this);
    private SecurityRuleOperations securityRules = new SecurityRuleOperationsImpl(this);
    private SubnetOperations subnets = new SubnetOperationsImpl(this);
    private UsageOperations usages = new UsageOperationsImpl(this);
    private VirtualNetworkGatewayConnectionOperations virtualNetworkGatewayConnections = new VirtualNetworkGatewayConnectionOperationsImpl(this);
    private VirtualNetworkGatewayOperations virtualNetworkGateways = new VirtualNetworkGatewayOperationsImpl(this);
    private VirtualNetworkOperations virtualNetworks = new VirtualNetworkOperationsImpl(this);

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }

    @Override
    public ApplicationGatewayOperations getApplicationGatewaysOperations() {
        return this.applicationGateways;
    }

    @Override
    public LoadBalancerOperations getLoadBalancersOperations() {
        return this.loadBalancers;
    }

    @Override
    public LocalNetworkGatewayOperations getLocalNetworkGatewaysOperations() {
        return this.localNetworkGateways;
    }

    @Override
    public NetworkInterfaceOperations getNetworkInterfacesOperations() {
        return this.networkInterfaces;
    }

    @Override
    public NetworkSecurityGroupOperations getNetworkSecurityGroupsOperations() {
        return this.networkSecurityGroups;
    }

    @Override
    public PublicIpAddressOperations getPublicIpAddressesOperations() {
        return this.publicIpAddresses;
    }

    @Override
    public RouteOperations getRoutesOperations() {
        return this.routes;
    }

    @Override
    public RouteTableOperations getRouteTablesOperations() {
        return this.routeTables;
    }

    @Override
    public SecurityRuleOperations getSecurityRulesOperations() {
        return this.securityRules;
    }

    @Override
    public SubnetOperations getSubnetsOperations() {
        return this.subnets;
    }

    @Override
    public UsageOperations getUsagesOperations() {
        return this.usages;
    }

    @Override
    public VirtualNetworkGatewayConnectionOperations getVirtualNetworkGatewayConnectionsOperations() {
        return this.virtualNetworkGatewayConnections;
    }

    @Override
    public VirtualNetworkGatewayOperations getVirtualNetworkGatewaysOperations() {
        return this.virtualNetworkGateways;
    }

    @Override
    public VirtualNetworkOperations getVirtualNetworksOperations() {
        return this.virtualNetworks;
    }

    public NetworkResourceProviderClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
    }

    @Inject
    public NetworkResourceProviderClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") SubscriptionCloudCredentials credentials, @Named(value="management.uri") URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.azure.com/");
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.baseUri = baseUri;
        }
    }

    public NetworkResourceProviderClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.azure.com/");
    }

    public NetworkResourceProviderClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    protected NetworkResourceProviderClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new NetworkResourceProviderClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }

    @Override
    public Future<DnsNameAvailabilityResponse> checkDnsNameAvailabilityAsync(final String location, final String domainNameLabel) {
        return this.getExecutorService().submit(new Callable<DnsNameAvailabilityResponse>(){

            @Override
            public DnsNameAvailabilityResponse call() throws Exception {
                return NetworkResourceProviderClientImpl.this.checkDnsNameAvailability(location, domainNameLabel);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DnsNameAvailabilityResponse checkDnsNameAvailability(String location, String domainNameLabel) throws IOException, ServiceException {
        String baseUrl;
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (domainNameLabel == null) {
            throw new NullPointerException("domainNameLabel");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("location", location);
            tracingParameters.put("domainNameLabel", domainNameLabel);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"checkDnsNameAvailabilityAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/locations/";
        url = url + URLEncoder.encode(location, "UTF-8");
        url = url + "/CheckDnsNameAvailability";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("domainNameLabel=" + URLEncoder.encode(domainNameLabel, "UTF-8"));
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DnsNameAvailabilityResponse result = null;
            if (statusCode == 200) {
                JsonNode availableValue;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DnsNameAvailabilityResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (availableValue = responseDoc.get("available")) != null && !(availableValue instanceof NullNode)) {
                    boolean availableInstance = availableValue.getBooleanValue();
                    result.setDnsNameAvailability(availableInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DnsNameAvailabilityResponse dnsNameAvailabilityResponse = result;
            return dnsNameAvailabilityResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> getLongRunningOperationStatusAsync(final String azureAsyncOperation) {
        return this.getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return NetworkResourceProviderClientImpl.this.getLongRunningOperationStatus(azureAsyncOperation);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse getLongRunningOperationStatus(String azureAsyncOperation) throws IOException, ServiceException {
        if (azureAsyncOperation == null) {
            throw new NullPointerException("azureAsyncOperation");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("azureAsyncOperation", azureAsyncOperation);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getLongRunningOperationStatusAsync", tracingParameters);
        }
        String url = "";
        url = url + azureAsyncOperation;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-05-01-preview");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            AzureAsyncOperationResponse result = null;
            if (statusCode == 200 || statusCode == 202) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new AzureAsyncOperationResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && !(statusValue instanceof NullNode)) {
                        String statusInstance = statusValue.getTextValue();
                        result.setStatus(statusInstance);
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

