/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.NetworkSecurityGroupOperations;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.NetworkSecurityGroup;
import com.microsoft.azure.management.network.models.NetworkSecurityGroupGetResponse;
import com.microsoft.azure.management.network.models.NetworkSecurityGroupListResponse;
import com.microsoft.azure.management.network.models.NetworkSecurityGroupPutResponse;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.SecurityRule;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class NetworkSecurityGroupOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
NetworkSecurityGroupOperations {
    private NetworkResourceProviderClientImpl client;

    NetworkSecurityGroupOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<NetworkSecurityGroupPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String networkSecurityGroupName, final NetworkSecurityGroup parameters) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkSecurityGroupPutResponse>(){

            @Override
            public NetworkSecurityGroupPutResponse call() throws Exception {
                return NetworkSecurityGroupOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, networkSecurityGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkSecurityGroupPutResponse beginCreateOrUpdating(String resourceGroupName, String networkSecurityGroupName, NetworkSecurityGroup parameters) throws IOException, ServiceException {
        NetworkSecurityGroupPutResponse networkSecurityGroupPutResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode networkSecurityGroupJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDefaultSecurityRules() != null) {
            for (SecurityRule defaultSecurityRulesParameterItem : parameters.getDefaultSecurityRules()) {
                if (defaultSecurityRulesParameterItem.getAccess() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.Access");
                }
                if (defaultSecurityRulesParameterItem.getDestinationAddressPrefix() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.DestinationAddressPrefix");
                }
                if (defaultSecurityRulesParameterItem.getDirection() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.Direction");
                }
                if (defaultSecurityRulesParameterItem.getProtocol() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.Protocol");
                }
                if (defaultSecurityRulesParameterItem.getSourceAddressPrefix() != null) continue;
                throw new NullPointerException("parameters.DefaultSecurityRules.SourceAddressPrefix");
            }
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getSecurityRules() != null) {
            for (SecurityRule securityRulesParameterItem : parameters.getSecurityRules()) {
                if (securityRulesParameterItem.getAccess() == null) {
                    throw new NullPointerException("parameters.SecurityRules.Access");
                }
                if (securityRulesParameterItem.getDestinationAddressPrefix() == null) {
                    throw new NullPointerException("parameters.SecurityRules.DestinationAddressPrefix");
                }
                if (securityRulesParameterItem.getDirection() == null) {
                    throw new NullPointerException("parameters.SecurityRules.Direction");
                }
                if (securityRulesParameterItem.getProtocol() == null) {
                    throw new NullPointerException("parameters.SecurityRules.Protocol");
                }
                if (securityRulesParameterItem.getSourceAddressPrefix() != null) continue;
                throw new NullPointerException("parameters.SecurityRules.SourceAddressPrefix");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = networkSecurityGroupJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        networkSecurityGroupJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getSecurityRules() != null && (!(parameters.getSecurityRules() instanceof LazyCollection) || ((LazyCollection)parameters.getSecurityRules()).isInitialized())) {
            ArrayNode securityRulesArray = objectMapper.createArrayNode();
            for (SecurityRule securityRule : parameters.getSecurityRules()) {
                ObjectNode securityRuleJsonFormatValue = objectMapper.createObjectNode();
                securityRulesArray.add((JsonNode)securityRuleJsonFormatValue);
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                securityRuleJsonFormatValue.put("properties", (JsonNode)propertiesValue2);
                if (securityRule.getDescription() != null) {
                    propertiesValue2.put("description", securityRule.getDescription());
                }
                propertiesValue2.put("protocol", securityRule.getProtocol());
                if (securityRule.getSourcePortRange() != null) {
                    propertiesValue2.put("sourcePortRange", securityRule.getSourcePortRange());
                }
                if (securityRule.getDestinationPortRange() != null) {
                    propertiesValue2.put("destinationPortRange", securityRule.getDestinationPortRange());
                }
                propertiesValue2.put("sourceAddressPrefix", securityRule.getSourceAddressPrefix());
                propertiesValue2.put("destinationAddressPrefix", securityRule.getDestinationAddressPrefix());
                propertiesValue2.put("access", securityRule.getAccess());
                propertiesValue2.put("priority", securityRule.getPriority());
                propertiesValue2.put("direction", securityRule.getDirection());
                if (securityRule.getProvisioningState() != null) {
                    propertiesValue2.put("provisioningState", securityRule.getProvisioningState());
                }
                if (securityRule.getName() != null) {
                    securityRuleJsonFormatValue.put("name", securityRule.getName());
                }
                if (securityRule.getEtag() != null) {
                    securityRuleJsonFormatValue.put("etag", securityRule.getEtag());
                }
                if (securityRule.getId() == null) continue;
                securityRuleJsonFormatValue.put("id", securityRule.getId());
            }
            propertiesValue.put("securityRules", (JsonNode)securityRulesArray);
        }
        if (parameters.getDefaultSecurityRules() != null && (!(parameters.getDefaultSecurityRules() instanceof LazyCollection) || ((LazyCollection)parameters.getDefaultSecurityRules()).isInitialized())) {
            ArrayNode defaultSecurityRulesArray = objectMapper.createArrayNode();
            for (SecurityRule securityRule : parameters.getDefaultSecurityRules()) {
                ObjectNode securityRuleJsonFormatValue2 = objectMapper.createObjectNode();
                defaultSecurityRulesArray.add((JsonNode)securityRuleJsonFormatValue2);
                ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                securityRuleJsonFormatValue2.put("properties", (JsonNode)propertiesValue3);
                if (securityRule.getDescription() != null) {
                    propertiesValue3.put("description", securityRule.getDescription());
                }
                propertiesValue3.put("protocol", securityRule.getProtocol());
                if (securityRule.getSourcePortRange() != null) {
                    propertiesValue3.put("sourcePortRange", securityRule.getSourcePortRange());
                }
                if (securityRule.getDestinationPortRange() != null) {
                    propertiesValue3.put("destinationPortRange", securityRule.getDestinationPortRange());
                }
                propertiesValue3.put("sourceAddressPrefix", securityRule.getSourceAddressPrefix());
                propertiesValue3.put("destinationAddressPrefix", securityRule.getDestinationAddressPrefix());
                propertiesValue3.put("access", securityRule.getAccess());
                propertiesValue3.put("priority", securityRule.getPriority());
                propertiesValue3.put("direction", securityRule.getDirection());
                if (securityRule.getProvisioningState() != null) {
                    propertiesValue3.put("provisioningState", securityRule.getProvisioningState());
                }
                if (securityRule.getName() != null) {
                    securityRuleJsonFormatValue2.put("name", securityRule.getName());
                }
                if (securityRule.getEtag() != null) {
                    securityRuleJsonFormatValue2.put("etag", securityRule.getEtag());
                }
                if (securityRule.getId() == null) continue;
                securityRuleJsonFormatValue2.put("id", securityRule.getId());
            }
            propertiesValue.put("defaultSecurityRules", (JsonNode)defaultSecurityRulesArray);
        }
        if (parameters.getNetworkInterfaces() != null && (!(parameters.getNetworkInterfaces() instanceof LazyCollection) || ((LazyCollection)parameters.getNetworkInterfaces()).isInitialized())) {
            ArrayNode networkInterfacesArray = objectMapper.createArrayNode();
            for (ResourceId resourceId : parameters.getNetworkInterfaces()) {
                ObjectNode resourceIdValue = objectMapper.createObjectNode();
                networkInterfacesArray.add((JsonNode)resourceIdValue);
                if (resourceId.getId() == null) continue;
                resourceIdValue.put("id", resourceId.getId());
            }
            propertiesValue.put("networkInterfaces", (JsonNode)networkInterfacesArray);
        }
        if (parameters.getSubnets() != null && (!(parameters.getSubnets() instanceof LazyCollection) || ((LazyCollection)parameters.getSubnets()).isInitialized())) {
            ArrayNode subnetsArray = objectMapper.createArrayNode();
            for (ResourceId resourceId : parameters.getSubnets()) {
                ObjectNode resourceIdValue2 = objectMapper.createObjectNode();
                subnetsArray.add((JsonNode)resourceIdValue2);
                if (resourceId.getId() == null) continue;
                resourceIdValue2.put("id", resourceId.getId());
            }
            propertiesValue.put("subnets", (JsonNode)subnetsArray);
        }
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            networkSecurityGroupJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            networkSecurityGroupJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            networkSecurityGroupJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            networkSecurityGroupJsonFormatValue.put("type", parameters.getType());
        }
        networkSecurityGroupJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            networkSecurityGroupJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var17_27 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkSecurityGroupPutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new NetworkSecurityGroupPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue3;
                    JsonNode idValue5;
                    JsonNode etagValue3;
                    NetworkSecurityGroup networkSecurityGroupInstance = new NetworkSecurityGroup();
                    result.setNetworkSecurityGroup(networkSecurityGroupInstance);
                    JsonNode propertiesValue4 = responseDoc.get("properties");
                    if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                        JsonNode provisioningStateValue3;
                        JsonNode subnetsArray2;
                        JsonNode networkInterfacesArray2;
                        JsonNode defaultSecurityRulesArray2;
                        JsonNode securityRulesArray2 = propertiesValue4.get("securityRules");
                        if (securityRulesArray2 != null && !(securityRulesArray2 instanceof NullNode)) {
                            for (Iterator securityRulesValue : (ArrayNode)securityRulesArray2) {
                                JsonNode idValue;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                                networkSecurityGroupInstance.getSecurityRules().add(securityRuleJsonFormatInstance);
                                JsonNode propertiesValue5 = securityRulesValue.get("properties");
                                if (propertiesValue5 != null && !(propertiesValue5 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode directionValue;
                                    JsonNode priorityValue;
                                    JsonNode accessValue;
                                    JsonNode destinationAddressPrefixValue;
                                    JsonNode sourceAddressPrefixValue;
                                    JsonNode destinationPortRangeValue;
                                    JsonNode sourcePortRangeValue;
                                    JsonNode protocolValue;
                                    JsonNode descriptionValue = propertiesValue5.get("description");
                                    if (descriptionValue != null && !(descriptionValue instanceof NullNode)) {
                                        String descriptionInstance = descriptionValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                    }
                                    if ((protocolValue = propertiesValue5.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                        String protocolInstance = protocolValue.getTextValue();
                                        securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    if ((sourcePortRangeValue = propertiesValue5.get("sourcePortRange")) != null && !(sourcePortRangeValue instanceof NullNode)) {
                                        String sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                        securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                    }
                                    if ((destinationPortRangeValue = propertiesValue5.get("destinationPortRange")) != null && !(destinationPortRangeValue instanceof NullNode)) {
                                        String destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                    }
                                    if ((sourceAddressPrefixValue = propertiesValue5.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue instanceof NullNode)) {
                                        String sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                        securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                    }
                                    if ((destinationAddressPrefixValue = propertiesValue5.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue instanceof NullNode)) {
                                        String destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                    }
                                    if ((accessValue = propertiesValue5.get("access")) != null && !(accessValue instanceof NullNode)) {
                                        String accessInstance = accessValue.getTextValue();
                                        securityRuleJsonFormatInstance.setAccess(accessInstance);
                                    }
                                    if ((priorityValue = propertiesValue5.get("priority")) != null && !(priorityValue instanceof NullNode)) {
                                        int priorityInstance = priorityValue.getIntValue();
                                        securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                    }
                                    if ((directionValue = propertiesValue5.get("direction")) != null && !(directionValue instanceof NullNode)) {
                                        String directionInstance = directionValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDirection(directionInstance);
                                    }
                                    if ((provisioningStateValue = propertiesValue5.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = securityRulesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    securityRuleJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = securityRulesValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    securityRuleJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue = securityRulesValue.get("id")) == null || idValue instanceof NullNode) continue;
                                String idInstance = idValue.getTextValue();
                                securityRuleJsonFormatInstance.setId(idInstance);
                            }
                        }
                        if ((defaultSecurityRulesArray2 = propertiesValue4.get("defaultSecurityRules")) != null && !(defaultSecurityRulesArray2 instanceof NullNode)) {
                            for (Iterator defaultSecurityRulesValue : (ArrayNode)defaultSecurityRulesArray2) {
                                JsonNode idValue2;
                                JsonNode etagValue2;
                                JsonNode nameValue2;
                                SecurityRule securityRuleJsonFormatInstance2 = new SecurityRule();
                                networkSecurityGroupInstance.getDefaultSecurityRules().add(securityRuleJsonFormatInstance2);
                                JsonNode propertiesValue6 = defaultSecurityRulesValue.get("properties");
                                if (propertiesValue6 != null && !(propertiesValue6 instanceof NullNode)) {
                                    JsonNode provisioningStateValue2;
                                    JsonNode directionValue2;
                                    JsonNode priorityValue2;
                                    Iterator accessValue2;
                                    JsonNode destinationAddressPrefixValue2;
                                    JsonNode sourceAddressPrefixValue2;
                                    JsonNode destinationPortRangeValue2;
                                    JsonNode sourcePortRangeValue2;
                                    JsonNode protocolValue2;
                                    JsonNode descriptionValue2 = propertiesValue6.get("description");
                                    if (descriptionValue2 != null && !(descriptionValue2 instanceof NullNode)) {
                                        String descriptionInstance2 = descriptionValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDescription(descriptionInstance2);
                                    }
                                    if ((protocolValue2 = propertiesValue6.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                        String protocolInstance2 = protocolValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setProtocol(protocolInstance2);
                                    }
                                    if ((sourcePortRangeValue2 = propertiesValue6.get("sourcePortRange")) != null && !(sourcePortRangeValue2 instanceof NullNode)) {
                                        String sourcePortRangeInstance2 = sourcePortRangeValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setSourcePortRange(sourcePortRangeInstance2);
                                    }
                                    if ((destinationPortRangeValue2 = propertiesValue6.get("destinationPortRange")) != null && !(destinationPortRangeValue2 instanceof NullNode)) {
                                        String destinationPortRangeInstance2 = destinationPortRangeValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDestinationPortRange(destinationPortRangeInstance2);
                                    }
                                    if ((sourceAddressPrefixValue2 = propertiesValue6.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue2 instanceof NullNode)) {
                                        String sourceAddressPrefixInstance2 = sourceAddressPrefixValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setSourceAddressPrefix(sourceAddressPrefixInstance2);
                                    }
                                    if ((destinationAddressPrefixValue2 = propertiesValue6.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue2 instanceof NullNode)) {
                                        String destinationAddressPrefixInstance2 = destinationAddressPrefixValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDestinationAddressPrefix(destinationAddressPrefixInstance2);
                                    }
                                    if ((accessValue2 = propertiesValue6.get("access")) != null && !(accessValue2 instanceof NullNode)) {
                                        String accessInstance2 = accessValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setAccess(accessInstance2);
                                    }
                                    if ((priorityValue2 = propertiesValue6.get("priority")) != null && !(priorityValue2 instanceof NullNode)) {
                                        int priorityInstance2 = priorityValue2.getIntValue();
                                        securityRuleJsonFormatInstance2.setPriority(priorityInstance2);
                                    }
                                    if ((directionValue2 = propertiesValue6.get("direction")) != null && !(directionValue2 instanceof NullNode)) {
                                        String directionInstance2 = directionValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDirection(directionInstance2);
                                    }
                                    if ((provisioningStateValue2 = propertiesValue6.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                if ((nameValue2 = defaultSecurityRulesValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setName(nameInstance2);
                                }
                                if ((etagValue2 = defaultSecurityRulesValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                    String etagInstance2 = etagValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setEtag(etagInstance2);
                                }
                                if ((idValue2 = defaultSecurityRulesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                String idInstance2 = idValue2.getTextValue();
                                securityRuleJsonFormatInstance2.setId(idInstance2);
                            }
                        }
                        if ((networkInterfacesArray2 = propertiesValue4.get("networkInterfaces")) != null && !(networkInterfacesArray2 instanceof NullNode)) {
                            for (Iterator networkInterfacesValue : (ArrayNode)networkInterfacesArray2) {
                                ResourceId resourceIdInstance = new ResourceId();
                                networkSecurityGroupInstance.getNetworkInterfaces().add(resourceIdInstance);
                                JsonNode idValue3 = networkInterfacesValue.get("id");
                                if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                resourceIdInstance.setId(idInstance3);
                            }
                        }
                        if ((subnetsArray2 = propertiesValue4.get("subnets")) != null && !(subnetsArray2 instanceof NullNode)) {
                            for (JsonNode subnetsValue : (ArrayNode)subnetsArray2) {
                                ResourceId resourceIdInstance2 = new ResourceId();
                                networkSecurityGroupInstance.getSubnets().add(resourceIdInstance2);
                                JsonNode idValue4 = subnetsValue.get("id");
                                if (idValue4 == null || idValue4 instanceof NullNode) continue;
                                String idInstance4 = idValue4.getTextValue();
                                resourceIdInstance2.setId(idInstance4);
                            }
                        }
                        if ((provisioningStateValue3 = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                            String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                            networkSecurityGroupInstance.setProvisioningState(provisioningStateInstance3);
                        }
                    }
                    if ((etagValue3 = responseDoc.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                        String etagInstance3 = etagValue3.getTextValue();
                        networkSecurityGroupInstance.setEtag(etagInstance3);
                    }
                    if ((idValue5 = responseDoc.get("id")) != null && !(idValue5 instanceof NullNode)) {
                        String idInstance5 = idValue5.getTextValue();
                        networkSecurityGroupInstance.setId(idInstance5);
                    }
                    if ((nameValue3 = responseDoc.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                        String nameInstance3 = nameValue3.getTextValue();
                        networkSecurityGroupInstance.setName(nameInstance3);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        networkSecurityGroupInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        networkSecurityGroupInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            networkSecurityGroupInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)closeableHttpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (closeableHttpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(closeableHttpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            networkSecurityGroupPutResponse = result;
        }
        catch (Throwable throwable) {
            if (var17_27 != null && var17_27.getEntity() != null) {
                var17_27.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return networkSecurityGroupPutResponse;
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String networkSecurityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return NetworkSecurityGroupOperationsImpl.this.beginDeleting(resourceGroupName, networkSecurityGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String networkSecurityGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String networkSecurityGroupName, final NetworkSecurityGroup parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return NetworkSecurityGroupOperationsImpl.this.createOrUpdate(resourceGroupName, networkSecurityGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String networkSecurityGroupName, NetworkSecurityGroup parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            NetworkSecurityGroupPutResponse response = client2.getNetworkSecurityGroupsOperations().beginCreateOrUpdatingAsync(resourceGroupName, networkSecurityGroupName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String networkSecurityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return NetworkSecurityGroupOperationsImpl.this.delete(resourceGroupName, networkSecurityGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String networkSecurityGroupName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getNetworkSecurityGroupsOperations().beginDeletingAsync(resourceGroupName, networkSecurityGroupName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<NetworkSecurityGroupGetResponse> getAsync(final String resourceGroupName, final String networkSecurityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkSecurityGroupGetResponse>(){

            @Override
            public NetworkSecurityGroupGetResponse call() throws Exception {
                return NetworkSecurityGroupOperationsImpl.this.get(resourceGroupName, networkSecurityGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkSecurityGroupGetResponse get(String resourceGroupName, String networkSecurityGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkSecurityGroupGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkSecurityGroupGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue3;
                    JsonNode idValue5;
                    JsonNode etagValue3;
                    NetworkSecurityGroup networkSecurityGroupInstance = new NetworkSecurityGroup();
                    result.setNetworkSecurityGroup(networkSecurityGroupInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue3;
                        JsonNode subnetsArray;
                        JsonNode networkInterfacesArray;
                        JsonNode defaultSecurityRulesArray;
                        JsonNode securityRulesArray = propertiesValue.get("securityRules");
                        if (securityRulesArray != null && !(securityRulesArray instanceof NullNode)) {
                            for (Iterator securityRulesValue : (ArrayNode)securityRulesArray) {
                                JsonNode idValue;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                                networkSecurityGroupInstance.getSecurityRules().add(securityRuleJsonFormatInstance);
                                JsonNode propertiesValue2 = securityRulesValue.get("properties");
                                if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode directionValue;
                                    JsonNode priorityValue;
                                    JsonNode accessValue;
                                    JsonNode destinationAddressPrefixValue;
                                    JsonNode sourceAddressPrefixValue;
                                    JsonNode destinationPortRangeValue;
                                    JsonNode sourcePortRangeValue;
                                    JsonNode protocolValue;
                                    JsonNode descriptionValue = propertiesValue2.get("description");
                                    if (descriptionValue != null && !(descriptionValue instanceof NullNode)) {
                                        String descriptionInstance = descriptionValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                    }
                                    if ((protocolValue = propertiesValue2.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                        String protocolInstance = protocolValue.getTextValue();
                                        securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    if ((sourcePortRangeValue = propertiesValue2.get("sourcePortRange")) != null && !(sourcePortRangeValue instanceof NullNode)) {
                                        String sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                        securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                    }
                                    if ((destinationPortRangeValue = propertiesValue2.get("destinationPortRange")) != null && !(destinationPortRangeValue instanceof NullNode)) {
                                        String destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                    }
                                    if ((sourceAddressPrefixValue = propertiesValue2.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue instanceof NullNode)) {
                                        String sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                        securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                    }
                                    if ((destinationAddressPrefixValue = propertiesValue2.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue instanceof NullNode)) {
                                        String destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                    }
                                    if ((accessValue = propertiesValue2.get("access")) != null && !(accessValue instanceof NullNode)) {
                                        String accessInstance = accessValue.getTextValue();
                                        securityRuleJsonFormatInstance.setAccess(accessInstance);
                                    }
                                    if ((priorityValue = propertiesValue2.get("priority")) != null && !(priorityValue instanceof NullNode)) {
                                        int priorityInstance = priorityValue.getIntValue();
                                        securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                    }
                                    if ((directionValue = propertiesValue2.get("direction")) != null && !(directionValue instanceof NullNode)) {
                                        String directionInstance = directionValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDirection(directionInstance);
                                    }
                                    if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = securityRulesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    securityRuleJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = securityRulesValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    securityRuleJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue = securityRulesValue.get("id")) == null || idValue instanceof NullNode) continue;
                                String idInstance = idValue.getTextValue();
                                securityRuleJsonFormatInstance.setId(idInstance);
                            }
                        }
                        if ((defaultSecurityRulesArray = propertiesValue.get("defaultSecurityRules")) != null && !(defaultSecurityRulesArray instanceof NullNode)) {
                            for (Iterator defaultSecurityRulesValue : (ArrayNode)defaultSecurityRulesArray) {
                                JsonNode idValue2;
                                JsonNode etagValue2;
                                JsonNode nameValue2;
                                SecurityRule securityRuleJsonFormatInstance2 = new SecurityRule();
                                networkSecurityGroupInstance.getDefaultSecurityRules().add(securityRuleJsonFormatInstance2);
                                JsonNode propertiesValue3 = defaultSecurityRulesValue.get("properties");
                                if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                    JsonNode provisioningStateValue2;
                                    JsonNode directionValue2;
                                    JsonNode priorityValue2;
                                    JsonNode accessValue2;
                                    JsonNode destinationAddressPrefixValue2;
                                    JsonNode sourceAddressPrefixValue2;
                                    JsonNode destinationPortRangeValue2;
                                    JsonNode sourcePortRangeValue2;
                                    JsonNode protocolValue2;
                                    JsonNode descriptionValue2 = propertiesValue3.get("description");
                                    if (descriptionValue2 != null && !(descriptionValue2 instanceof NullNode)) {
                                        String descriptionInstance2 = descriptionValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDescription(descriptionInstance2);
                                    }
                                    if ((protocolValue2 = propertiesValue3.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                        String protocolInstance2 = protocolValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setProtocol(protocolInstance2);
                                    }
                                    if ((sourcePortRangeValue2 = propertiesValue3.get("sourcePortRange")) != null && !(sourcePortRangeValue2 instanceof NullNode)) {
                                        String sourcePortRangeInstance2 = sourcePortRangeValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setSourcePortRange(sourcePortRangeInstance2);
                                    }
                                    if ((destinationPortRangeValue2 = propertiesValue3.get("destinationPortRange")) != null && !(destinationPortRangeValue2 instanceof NullNode)) {
                                        String destinationPortRangeInstance2 = destinationPortRangeValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDestinationPortRange(destinationPortRangeInstance2);
                                    }
                                    if ((sourceAddressPrefixValue2 = propertiesValue3.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue2 instanceof NullNode)) {
                                        String sourceAddressPrefixInstance2 = sourceAddressPrefixValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setSourceAddressPrefix(sourceAddressPrefixInstance2);
                                    }
                                    if ((destinationAddressPrefixValue2 = propertiesValue3.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue2 instanceof NullNode)) {
                                        String destinationAddressPrefixInstance2 = destinationAddressPrefixValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDestinationAddressPrefix(destinationAddressPrefixInstance2);
                                    }
                                    if ((accessValue2 = propertiesValue3.get("access")) != null && !(accessValue2 instanceof NullNode)) {
                                        String accessInstance2 = accessValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setAccess(accessInstance2);
                                    }
                                    if ((priorityValue2 = propertiesValue3.get("priority")) != null && !(priorityValue2 instanceof NullNode)) {
                                        int priorityInstance2 = priorityValue2.getIntValue();
                                        securityRuleJsonFormatInstance2.setPriority(priorityInstance2);
                                    }
                                    if ((directionValue2 = propertiesValue3.get("direction")) != null && !(directionValue2 instanceof NullNode)) {
                                        String directionInstance2 = directionValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDirection(directionInstance2);
                                    }
                                    if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                if ((nameValue2 = defaultSecurityRulesValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setName(nameInstance2);
                                }
                                if ((etagValue2 = defaultSecurityRulesValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                    String etagInstance2 = etagValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setEtag(etagInstance2);
                                }
                                if ((idValue2 = defaultSecurityRulesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                String idInstance2 = idValue2.getTextValue();
                                securityRuleJsonFormatInstance2.setId(idInstance2);
                            }
                        }
                        if ((networkInterfacesArray = propertiesValue.get("networkInterfaces")) != null && !(networkInterfacesArray instanceof NullNode)) {
                            for (Iterator networkInterfacesValue : (ArrayNode)networkInterfacesArray) {
                                ResourceId resourceIdInstance = new ResourceId();
                                networkSecurityGroupInstance.getNetworkInterfaces().add(resourceIdInstance);
                                JsonNode idValue3 = networkInterfacesValue.get("id");
                                if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                resourceIdInstance.setId(idInstance3);
                            }
                        }
                        if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                            for (JsonNode subnetsValue : (ArrayNode)subnetsArray) {
                                ResourceId resourceIdInstance2 = new ResourceId();
                                networkSecurityGroupInstance.getSubnets().add(resourceIdInstance2);
                                JsonNode idValue4 = subnetsValue.get("id");
                                if (idValue4 == null || idValue4 instanceof NullNode) continue;
                                String idInstance4 = idValue4.getTextValue();
                                resourceIdInstance2.setId(idInstance4);
                            }
                        }
                        if ((provisioningStateValue3 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                            String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                            networkSecurityGroupInstance.setProvisioningState(provisioningStateInstance3);
                        }
                    }
                    if ((etagValue3 = responseDoc.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                        String etagInstance3 = etagValue3.getTextValue();
                        networkSecurityGroupInstance.setEtag(etagInstance3);
                    }
                    if ((idValue5 = responseDoc.get("id")) != null && !(idValue5 instanceof NullNode)) {
                        String idInstance5 = idValue5.getTextValue();
                        networkSecurityGroupInstance.setId(idInstance5);
                    }
                    if ((nameValue3 = responseDoc.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                        String nameInstance3 = nameValue3.getTextValue();
                        networkSecurityGroupInstance.setName(nameInstance3);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        networkSecurityGroupInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        networkSecurityGroupInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            networkSecurityGroupInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkSecurityGroupGetResponse networkSecurityGroupGetResponse = result;
            return networkSecurityGroupGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<NetworkSecurityGroupListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkSecurityGroupListResponse>(){

            @Override
            public NetworkSecurityGroupListResponse call() throws Exception {
                return NetworkSecurityGroupOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkSecurityGroupListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkSecurityGroupListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkSecurityGroupListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue3;
                            JsonNode idValue5;
                            JsonNode etagValue3;
                            NetworkSecurityGroup networkSecurityGroupJsonFormatInstance = new NetworkSecurityGroup();
                            result.getNetworkSecurityGroups().add(networkSecurityGroupJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue3;
                                JsonNode subnetsArray;
                                JsonNode networkInterfacesArray;
                                JsonNode defaultSecurityRulesArray;
                                JsonNode securityRulesArray = propertiesValue.get("securityRules");
                                if (securityRulesArray != null && !(securityRulesArray instanceof NullNode)) {
                                    for (Iterator securityRulesValue : (ArrayNode)securityRulesArray) {
                                        JsonNode idValue;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                                        networkSecurityGroupJsonFormatInstance.getSecurityRules().add(securityRuleJsonFormatInstance);
                                        JsonNode propertiesValue2 = securityRulesValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode directionValue;
                                            JsonNode priorityValue;
                                            JsonNode accessValue;
                                            JsonNode destinationAddressPrefixValue;
                                            JsonNode sourceAddressPrefixValue;
                                            JsonNode destinationPortRangeValue;
                                            JsonNode sourcePortRangeValue;
                                            JsonNode protocolValue;
                                            JsonNode descriptionValue = propertiesValue2.get("description");
                                            if (descriptionValue != null && !(descriptionValue instanceof NullNode)) {
                                                String descriptionInstance = descriptionValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                            }
                                            if ((protocolValue = propertiesValue2.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            if ((sourcePortRangeValue = propertiesValue2.get("sourcePortRange")) != null && !(sourcePortRangeValue instanceof NullNode)) {
                                                String sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                                securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                            }
                                            if ((destinationPortRangeValue = propertiesValue2.get("destinationPortRange")) != null && !(destinationPortRangeValue instanceof NullNode)) {
                                                String destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                            }
                                            if ((sourceAddressPrefixValue = propertiesValue2.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue instanceof NullNode)) {
                                                String sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                                securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                            }
                                            if ((destinationAddressPrefixValue = propertiesValue2.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue instanceof NullNode)) {
                                                String destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                            }
                                            if ((accessValue = propertiesValue2.get("access")) != null && !(accessValue instanceof NullNode)) {
                                                String accessInstance = accessValue.getTextValue();
                                                securityRuleJsonFormatInstance.setAccess(accessInstance);
                                            }
                                            if ((priorityValue = propertiesValue2.get("priority")) != null && !(priorityValue instanceof NullNode)) {
                                                int priorityInstance = priorityValue.getIntValue();
                                                securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                            }
                                            if ((directionValue = propertiesValue2.get("direction")) != null && !(directionValue instanceof NullNode)) {
                                                String directionInstance = directionValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDirection(directionInstance);
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = securityRulesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            securityRuleJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = securityRulesValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            securityRuleJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue = securityRulesValue.get("id")) == null || idValue instanceof NullNode) continue;
                                        String idInstance = idValue.getTextValue();
                                        securityRuleJsonFormatInstance.setId(idInstance);
                                    }
                                }
                                if ((defaultSecurityRulesArray = propertiesValue.get("defaultSecurityRules")) != null && !(defaultSecurityRulesArray instanceof NullNode)) {
                                    Iterator securityRulesValue;
                                    securityRulesValue = ((ArrayNode)defaultSecurityRulesArray).iterator();
                                    while (securityRulesValue.hasNext()) {
                                        JsonNode idValue2;
                                        JsonNode etagValue2;
                                        JsonNode nameValue2;
                                        Iterator defaultSecurityRulesValue = (JsonNode)securityRulesValue.next();
                                        SecurityRule securityRuleJsonFormatInstance2 = new SecurityRule();
                                        networkSecurityGroupJsonFormatInstance.getDefaultSecurityRules().add(securityRuleJsonFormatInstance2);
                                        JsonNode propertiesValue3 = defaultSecurityRulesValue.get("properties");
                                        if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                            JsonNode provisioningStateValue2;
                                            JsonNode directionValue2;
                                            JsonNode priorityValue2;
                                            JsonNode accessValue2;
                                            JsonNode destinationAddressPrefixValue2;
                                            JsonNode sourceAddressPrefixValue2;
                                            JsonNode destinationPortRangeValue2;
                                            JsonNode sourcePortRangeValue2;
                                            JsonNode protocolValue2;
                                            JsonNode descriptionValue2 = propertiesValue3.get("description");
                                            if (descriptionValue2 != null && !(descriptionValue2 instanceof NullNode)) {
                                                String descriptionInstance2 = descriptionValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDescription(descriptionInstance2);
                                            }
                                            if ((protocolValue2 = propertiesValue3.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                                String protocolInstance2 = protocolValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setProtocol(protocolInstance2);
                                            }
                                            if ((sourcePortRangeValue2 = propertiesValue3.get("sourcePortRange")) != null && !(sourcePortRangeValue2 instanceof NullNode)) {
                                                String sourcePortRangeInstance2 = sourcePortRangeValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setSourcePortRange(sourcePortRangeInstance2);
                                            }
                                            if ((destinationPortRangeValue2 = propertiesValue3.get("destinationPortRange")) != null && !(destinationPortRangeValue2 instanceof NullNode)) {
                                                String destinationPortRangeInstance2 = destinationPortRangeValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDestinationPortRange(destinationPortRangeInstance2);
                                            }
                                            if ((sourceAddressPrefixValue2 = propertiesValue3.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue2 instanceof NullNode)) {
                                                String sourceAddressPrefixInstance2 = sourceAddressPrefixValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setSourceAddressPrefix(sourceAddressPrefixInstance2);
                                            }
                                            if ((destinationAddressPrefixValue2 = propertiesValue3.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue2 instanceof NullNode)) {
                                                String destinationAddressPrefixInstance2 = destinationAddressPrefixValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDestinationAddressPrefix(destinationAddressPrefixInstance2);
                                            }
                                            if ((accessValue2 = propertiesValue3.get("access")) != null && !(accessValue2 instanceof NullNode)) {
                                                String accessInstance2 = accessValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setAccess(accessInstance2);
                                            }
                                            if ((priorityValue2 = propertiesValue3.get("priority")) != null && !(priorityValue2 instanceof NullNode)) {
                                                int priorityInstance2 = priorityValue2.getIntValue();
                                                securityRuleJsonFormatInstance2.setPriority(priorityInstance2);
                                            }
                                            if ((directionValue2 = propertiesValue3.get("direction")) != null && !(directionValue2 instanceof NullNode)) {
                                                String directionInstance2 = directionValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDirection(directionInstance2);
                                            }
                                            if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        if ((nameValue2 = defaultSecurityRulesValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setName(nameInstance2);
                                        }
                                        if ((etagValue2 = defaultSecurityRulesValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                            String etagInstance2 = etagValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setEtag(etagInstance2);
                                        }
                                        if ((idValue2 = defaultSecurityRulesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                        String idInstance2 = idValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setId(idInstance2);
                                    }
                                }
                                if ((networkInterfacesArray = propertiesValue.get("networkInterfaces")) != null && !(networkInterfacesArray instanceof NullNode)) {
                                    for (Iterator networkInterfacesValue : (ArrayNode)networkInterfacesArray) {
                                        ResourceId resourceIdInstance = new ResourceId();
                                        networkSecurityGroupJsonFormatInstance.getNetworkInterfaces().add(resourceIdInstance);
                                        JsonNode idValue3 = networkInterfacesValue.get("id");
                                        if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                        String idInstance3 = idValue3.getTextValue();
                                        resourceIdInstance.setId(idInstance3);
                                    }
                                }
                                if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                                    Iterator networkInterfacesValue;
                                    networkInterfacesValue = ((ArrayNode)subnetsArray).iterator();
                                    while (networkInterfacesValue.hasNext()) {
                                        JsonNode subnetsValue = (JsonNode)networkInterfacesValue.next();
                                        ResourceId resourceIdInstance2 = new ResourceId();
                                        networkSecurityGroupJsonFormatInstance.getSubnets().add(resourceIdInstance2);
                                        JsonNode idValue4 = subnetsValue.get("id");
                                        if (idValue4 == null || idValue4 instanceof NullNode) continue;
                                        String idInstance4 = idValue4.getTextValue();
                                        resourceIdInstance2.setId(idInstance4);
                                    }
                                }
                                if ((provisioningStateValue3 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                    String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                    networkSecurityGroupJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                }
                            }
                            if ((etagValue3 = valueValue.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                String etagInstance3 = etagValue3.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setEtag(etagInstance3);
                            }
                            if ((idValue5 = valueValue.get("id")) != null && !(idValue5 instanceof NullNode)) {
                                String idInstance5 = idValue5.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setId(idInstance5);
                            }
                            if ((nameValue3 = valueValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                String nameInstance3 = nameValue3.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setName(nameInstance3);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                networkSecurityGroupJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkSecurityGroupListResponse networkSecurityGroupListResponse = result;
            return networkSecurityGroupListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<NetworkSecurityGroupListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<NetworkSecurityGroupListResponse>(){

            @Override
            public NetworkSecurityGroupListResponse call() throws Exception {
                return NetworkSecurityGroupOperationsImpl.this.listAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkSecurityGroupListResponse listAll() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkSecurityGroupListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkSecurityGroupListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue3;
                            JsonNode idValue5;
                            JsonNode etagValue3;
                            NetworkSecurityGroup networkSecurityGroupJsonFormatInstance = new NetworkSecurityGroup();
                            result.getNetworkSecurityGroups().add(networkSecurityGroupJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue3;
                                JsonNode subnetsArray;
                                JsonNode networkInterfacesArray;
                                JsonNode defaultSecurityRulesArray;
                                JsonNode securityRulesArray = propertiesValue.get("securityRules");
                                if (securityRulesArray != null && !(securityRulesArray instanceof NullNode)) {
                                    for (Iterator securityRulesValue : (ArrayNode)securityRulesArray) {
                                        JsonNode idValue;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                                        networkSecurityGroupJsonFormatInstance.getSecurityRules().add(securityRuleJsonFormatInstance);
                                        JsonNode propertiesValue2 = securityRulesValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode directionValue;
                                            JsonNode priorityValue;
                                            JsonNode accessValue;
                                            JsonNode destinationAddressPrefixValue;
                                            JsonNode sourceAddressPrefixValue;
                                            JsonNode destinationPortRangeValue;
                                            JsonNode sourcePortRangeValue;
                                            JsonNode protocolValue;
                                            JsonNode descriptionValue = propertiesValue2.get("description");
                                            if (descriptionValue != null && !(descriptionValue instanceof NullNode)) {
                                                String descriptionInstance = descriptionValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                            }
                                            if ((protocolValue = propertiesValue2.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            if ((sourcePortRangeValue = propertiesValue2.get("sourcePortRange")) != null && !(sourcePortRangeValue instanceof NullNode)) {
                                                String sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                                securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                            }
                                            if ((destinationPortRangeValue = propertiesValue2.get("destinationPortRange")) != null && !(destinationPortRangeValue instanceof NullNode)) {
                                                String destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                            }
                                            if ((sourceAddressPrefixValue = propertiesValue2.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue instanceof NullNode)) {
                                                String sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                                securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                            }
                                            if ((destinationAddressPrefixValue = propertiesValue2.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue instanceof NullNode)) {
                                                String destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                            }
                                            if ((accessValue = propertiesValue2.get("access")) != null && !(accessValue instanceof NullNode)) {
                                                String accessInstance = accessValue.getTextValue();
                                                securityRuleJsonFormatInstance.setAccess(accessInstance);
                                            }
                                            if ((priorityValue = propertiesValue2.get("priority")) != null && !(priorityValue instanceof NullNode)) {
                                                int priorityInstance = priorityValue.getIntValue();
                                                securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                            }
                                            if ((directionValue = propertiesValue2.get("direction")) != null && !(directionValue instanceof NullNode)) {
                                                String directionInstance = directionValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDirection(directionInstance);
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = securityRulesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            securityRuleJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = securityRulesValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            securityRuleJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue = securityRulesValue.get("id")) == null || idValue instanceof NullNode) continue;
                                        String idInstance = idValue.getTextValue();
                                        securityRuleJsonFormatInstance.setId(idInstance);
                                    }
                                }
                                if ((defaultSecurityRulesArray = propertiesValue.get("defaultSecurityRules")) != null && !(defaultSecurityRulesArray instanceof NullNode)) {
                                    Iterator securityRulesValue;
                                    securityRulesValue = ((ArrayNode)defaultSecurityRulesArray).iterator();
                                    while (securityRulesValue.hasNext()) {
                                        JsonNode idValue2;
                                        JsonNode etagValue2;
                                        JsonNode nameValue2;
                                        Iterator defaultSecurityRulesValue = (JsonNode)securityRulesValue.next();
                                        SecurityRule securityRuleJsonFormatInstance2 = new SecurityRule();
                                        networkSecurityGroupJsonFormatInstance.getDefaultSecurityRules().add(securityRuleJsonFormatInstance2);
                                        JsonNode propertiesValue3 = defaultSecurityRulesValue.get("properties");
                                        if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                            JsonNode provisioningStateValue2;
                                            JsonNode directionValue2;
                                            JsonNode priorityValue2;
                                            JsonNode accessValue2;
                                            JsonNode destinationAddressPrefixValue2;
                                            JsonNode sourceAddressPrefixValue2;
                                            JsonNode destinationPortRangeValue2;
                                            JsonNode sourcePortRangeValue2;
                                            JsonNode protocolValue2;
                                            JsonNode descriptionValue2 = propertiesValue3.get("description");
                                            if (descriptionValue2 != null && !(descriptionValue2 instanceof NullNode)) {
                                                String descriptionInstance2 = descriptionValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDescription(descriptionInstance2);
                                            }
                                            if ((protocolValue2 = propertiesValue3.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                                String protocolInstance2 = protocolValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setProtocol(protocolInstance2);
                                            }
                                            if ((sourcePortRangeValue2 = propertiesValue3.get("sourcePortRange")) != null && !(sourcePortRangeValue2 instanceof NullNode)) {
                                                String sourcePortRangeInstance2 = sourcePortRangeValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setSourcePortRange(sourcePortRangeInstance2);
                                            }
                                            if ((destinationPortRangeValue2 = propertiesValue3.get("destinationPortRange")) != null && !(destinationPortRangeValue2 instanceof NullNode)) {
                                                String destinationPortRangeInstance2 = destinationPortRangeValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDestinationPortRange(destinationPortRangeInstance2);
                                            }
                                            if ((sourceAddressPrefixValue2 = propertiesValue3.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue2 instanceof NullNode)) {
                                                String sourceAddressPrefixInstance2 = sourceAddressPrefixValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setSourceAddressPrefix(sourceAddressPrefixInstance2);
                                            }
                                            if ((destinationAddressPrefixValue2 = propertiesValue3.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue2 instanceof NullNode)) {
                                                String destinationAddressPrefixInstance2 = destinationAddressPrefixValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDestinationAddressPrefix(destinationAddressPrefixInstance2);
                                            }
                                            if ((accessValue2 = propertiesValue3.get("access")) != null && !(accessValue2 instanceof NullNode)) {
                                                String accessInstance2 = accessValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setAccess(accessInstance2);
                                            }
                                            if ((priorityValue2 = propertiesValue3.get("priority")) != null && !(priorityValue2 instanceof NullNode)) {
                                                int priorityInstance2 = priorityValue2.getIntValue();
                                                securityRuleJsonFormatInstance2.setPriority(priorityInstance2);
                                            }
                                            if ((directionValue2 = propertiesValue3.get("direction")) != null && !(directionValue2 instanceof NullNode)) {
                                                String directionInstance2 = directionValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDirection(directionInstance2);
                                            }
                                            if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        if ((nameValue2 = defaultSecurityRulesValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setName(nameInstance2);
                                        }
                                        if ((etagValue2 = defaultSecurityRulesValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                            String etagInstance2 = etagValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setEtag(etagInstance2);
                                        }
                                        if ((idValue2 = defaultSecurityRulesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                        String idInstance2 = idValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setId(idInstance2);
                                    }
                                }
                                if ((networkInterfacesArray = propertiesValue.get("networkInterfaces")) != null && !(networkInterfacesArray instanceof NullNode)) {
                                    for (Iterator networkInterfacesValue : (ArrayNode)networkInterfacesArray) {
                                        ResourceId resourceIdInstance = new ResourceId();
                                        networkSecurityGroupJsonFormatInstance.getNetworkInterfaces().add(resourceIdInstance);
                                        JsonNode idValue3 = networkInterfacesValue.get("id");
                                        if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                        String idInstance3 = idValue3.getTextValue();
                                        resourceIdInstance.setId(idInstance3);
                                    }
                                }
                                if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                                    Iterator networkInterfacesValue;
                                    networkInterfacesValue = ((ArrayNode)subnetsArray).iterator();
                                    while (networkInterfacesValue.hasNext()) {
                                        JsonNode subnetsValue = (JsonNode)networkInterfacesValue.next();
                                        ResourceId resourceIdInstance2 = new ResourceId();
                                        networkSecurityGroupJsonFormatInstance.getSubnets().add(resourceIdInstance2);
                                        JsonNode idValue4 = subnetsValue.get("id");
                                        if (idValue4 == null || idValue4 instanceof NullNode) continue;
                                        String idInstance4 = idValue4.getTextValue();
                                        resourceIdInstance2.setId(idInstance4);
                                    }
                                }
                                if ((provisioningStateValue3 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                    String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                    networkSecurityGroupJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                }
                            }
                            if ((etagValue3 = valueValue.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                String etagInstance3 = etagValue3.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setEtag(etagInstance3);
                            }
                            if ((idValue5 = valueValue.get("id")) != null && !(idValue5 instanceof NullNode)) {
                                String idInstance5 = idValue5.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setId(idInstance5);
                            }
                            if ((nameValue3 = valueValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                String nameInstance3 = nameValue3.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setName(nameInstance3);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                networkSecurityGroupJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkSecurityGroupListResponse networkSecurityGroupListResponse = result;
            return networkSecurityGroupListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

