/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.RouteOperations;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.Route;
import com.microsoft.azure.management.network.models.RouteGetResponse;
import com.microsoft.azure.management.network.models.RouteListResponse;
import com.microsoft.azure.management.network.models.RoutePutResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class RouteOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
RouteOperations {
    private NetworkResourceProviderClientImpl client;

    RouteOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<RoutePutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String routeTableName, final String routeName, final Route routeParameters) {
        return this.getClient().getExecutorService().submit(new Callable<RoutePutResponse>(){

            @Override
            public RoutePutResponse call() throws Exception {
                return RouteOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, routeTableName, routeName, routeParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoutePutResponse beginCreateOrUpdating(String resourceGroupName, String routeTableName, String routeName, Route routeParameters) throws IOException, ServiceException {
        ObjectNode routeJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (routeName == null) {
            throw new NullPointerException("routeName");
        }
        if (routeParameters == null) {
            throw new NullPointerException("routeParameters");
        }
        if (routeParameters.getNextHopType() == null) {
            throw new NullPointerException("routeParameters.NextHopType");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            tracingParameters.put("routeParameters", routeParameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        url = url + "/routes/";
        url = url + URLEncoder.encode(routeName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = routeJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        routeJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (routeParameters.getAddressPrefix() != null) {
            propertiesValue.put("addressPrefix", routeParameters.getAddressPrefix());
        }
        propertiesValue.put("nextHopType", routeParameters.getNextHopType());
        if (routeParameters.getNextHopIpAddress() != null) {
            propertiesValue.put("nextHopIpAddress", routeParameters.getNextHopIpAddress());
        }
        if (routeParameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", routeParameters.getProvisioningState());
        }
        if (routeParameters.getName() != null) {
            routeJsonFormatValue.put("name", routeParameters.getName());
        }
        if (routeParameters.getEtag() != null) {
            routeJsonFormatValue.put("etag", routeParameters.getEtag());
        }
        if (routeParameters.getId() != null) {
            routeJsonFormatValue.put("id", routeParameters.getId());
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RoutePutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RoutePutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode idValue;
                    JsonNode etagValue;
                    JsonNode nameValue;
                    Route routeInstance = new Route();
                    result.setRoute(routeInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode provisioningStateValue;
                        JsonNode nextHopIpAddressValue;
                        JsonNode nextHopTypeValue;
                        JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                        if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                            String addressPrefixInstance = addressPrefixValue.getTextValue();
                            routeInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        if ((nextHopTypeValue = propertiesValue2.get("nextHopType")) != null && !(nextHopTypeValue instanceof NullNode)) {
                            String nextHopTypeInstance = nextHopTypeValue.getTextValue();
                            routeInstance.setNextHopType(nextHopTypeInstance);
                        }
                        if ((nextHopIpAddressValue = propertiesValue2.get("nextHopIpAddress")) != null && !(nextHopIpAddressValue instanceof NullNode)) {
                            String nextHopIpAddressInstance = nextHopIpAddressValue.getTextValue();
                            routeInstance.setNextHopIpAddress(nextHopIpAddressInstance);
                        }
                        if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            routeInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        routeInstance.setName(nameInstance);
                    }
                    if ((etagValue = responseDoc.get("etag")) != null && !(etagValue instanceof NullNode)) {
                        String etagInstance = etagValue.getTextValue();
                        routeInstance.setEtag(etagInstance);
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        routeInstance.setId(idInstance);
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RoutePutResponse routePutResponse = result;
            return routePutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String routeTableName, final String routeName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return RouteOperationsImpl.this.beginDeleting(resourceGroupName, routeTableName, routeName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String routeTableName, String routeName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (routeName == null) {
            throw new NullPointerException("routeName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        url = url + "/routes/";
        url = url + URLEncoder.encode(routeName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String routeTableName, final String routeName, final Route routeParameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return RouteOperationsImpl.this.createOrUpdate(resourceGroupName, routeTableName, routeName, routeParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String routeTableName, String routeName, Route routeParameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            tracingParameters.put("routeParameters", routeParameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            RoutePutResponse response = client2.getRoutesOperations().beginCreateOrUpdatingAsync(resourceGroupName, routeTableName, routeName, routeParameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String routeTableName, final String routeName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RouteOperationsImpl.this.delete(resourceGroupName, routeTableName, routeName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String routeTableName, String routeName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getRoutesOperations().beginDeletingAsync(resourceGroupName, routeTableName, routeName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<RouteGetResponse> getAsync(final String resourceGroupName, final String routeTableName, final String routeName) {
        return this.getClient().getExecutorService().submit(new Callable<RouteGetResponse>(){

            @Override
            public RouteGetResponse call() throws Exception {
                return RouteOperationsImpl.this.get(resourceGroupName, routeTableName, routeName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteGetResponse get(String resourceGroupName, String routeTableName, String routeName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (routeName == null) {
            throw new NullPointerException("routeName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        url = url + "/routes/";
        url = url + URLEncoder.encode(routeName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RouteGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RouteGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode idValue;
                    JsonNode etagValue;
                    JsonNode nameValue;
                    Route routeInstance = new Route();
                    result.setRoute(routeInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue;
                        JsonNode nextHopIpAddressValue;
                        JsonNode nextHopTypeValue;
                        JsonNode addressPrefixValue = propertiesValue.get("addressPrefix");
                        if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                            String addressPrefixInstance = addressPrefixValue.getTextValue();
                            routeInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        if ((nextHopTypeValue = propertiesValue.get("nextHopType")) != null && !(nextHopTypeValue instanceof NullNode)) {
                            String nextHopTypeInstance = nextHopTypeValue.getTextValue();
                            routeInstance.setNextHopType(nextHopTypeInstance);
                        }
                        if ((nextHopIpAddressValue = propertiesValue.get("nextHopIpAddress")) != null && !(nextHopIpAddressValue instanceof NullNode)) {
                            String nextHopIpAddressInstance = nextHopIpAddressValue.getTextValue();
                            routeInstance.setNextHopIpAddress(nextHopIpAddressInstance);
                        }
                        if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            routeInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        routeInstance.setName(nameInstance);
                    }
                    if ((etagValue = responseDoc.get("etag")) != null && !(etagValue instanceof NullNode)) {
                        String etagInstance = etagValue.getTextValue();
                        routeInstance.setEtag(etagInstance);
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        routeInstance.setId(idInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RouteGetResponse routeGetResponse = result;
            return routeGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RouteListResponse> listAsync(final String resourceGroupName, final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<RouteListResponse>(){

            @Override
            public RouteListResponse call() throws Exception {
                return RouteOperationsImpl.this.list(resourceGroupName, routeTableName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteListResponse list(String resourceGroupName, String routeTableName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        url = url + "/routes";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RouteListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RouteListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode idValue;
                            JsonNode etagValue;
                            JsonNode nameValue;
                            Route routeJsonFormatInstance = new Route();
                            result.getRoutes().add(routeJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue;
                                JsonNode nextHopIpAddressValue;
                                JsonNode nextHopTypeValue;
                                JsonNode addressPrefixValue = propertiesValue.get("addressPrefix");
                                if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                    String addressPrefixInstance = addressPrefixValue.getTextValue();
                                    routeJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                }
                                if ((nextHopTypeValue = propertiesValue.get("nextHopType")) != null && !(nextHopTypeValue instanceof NullNode)) {
                                    String nextHopTypeInstance = nextHopTypeValue.getTextValue();
                                    routeJsonFormatInstance.setNextHopType(nextHopTypeInstance);
                                }
                                if ((nextHopIpAddressValue = propertiesValue.get("nextHopIpAddress")) != null && !(nextHopIpAddressValue instanceof NullNode)) {
                                    String nextHopIpAddressInstance = nextHopIpAddressValue.getTextValue();
                                    routeJsonFormatInstance.setNextHopIpAddress(nextHopIpAddressInstance);
                                }
                                if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                    String provisioningStateInstance = provisioningStateValue.getTextValue();
                                    routeJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                routeJsonFormatInstance.setName(nameInstance);
                            }
                            if ((etagValue = valueValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                String etagInstance = etagValue.getTextValue();
                                routeJsonFormatInstance.setEtag(etagInstance);
                            }
                            if ((idValue = valueValue.get("id")) == null || idValue instanceof NullNode) continue;
                            String idInstance = idValue.getTextValue();
                            routeJsonFormatInstance.setId(idInstance);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RouteListResponse routeListResponse = result;
            return routeListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

