/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.RouteTableOperations;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.Route;
import com.microsoft.azure.management.network.models.RouteTable;
import com.microsoft.azure.management.network.models.RouteTableGetResponse;
import com.microsoft.azure.management.network.models.RouteTableListResponse;
import com.microsoft.azure.management.network.models.RouteTablePutResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class RouteTableOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
RouteTableOperations {
    private NetworkResourceProviderClientImpl client;

    RouteTableOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<RouteTablePutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String routeTableName, final RouteTable parameters) {
        return this.getClient().getExecutorService().submit(new Callable<RouteTablePutResponse>(){

            @Override
            public RouteTablePutResponse call() throws Exception {
                return RouteTableOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, routeTableName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteTablePutResponse beginCreateOrUpdating(String resourceGroupName, String routeTableName, RouteTable parameters) throws IOException, ServiceException {
        RouteTablePutResponse routeTablePutResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode routeTableJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getRoutes() != null) {
            for (Route routesParameterItem : parameters.getRoutes()) {
                if (routesParameterItem.getNextHopType() != null) continue;
                throw new NullPointerException("parameters.Routes.NextHopType");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = routeTableJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        routeTableJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getRoutes() != null && (!(parameters.getRoutes() instanceof LazyCollection) || ((LazyCollection)parameters.getRoutes()).isInitialized())) {
            ArrayNode routesArray = objectMapper.createArrayNode();
            for (Route route : parameters.getRoutes()) {
                ObjectNode routeJsonFormatValue = objectMapper.createObjectNode();
                routesArray.add((JsonNode)routeJsonFormatValue);
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                routeJsonFormatValue.put("properties", (JsonNode)propertiesValue2);
                if (route.getAddressPrefix() != null) {
                    propertiesValue2.put("addressPrefix", route.getAddressPrefix());
                }
                propertiesValue2.put("nextHopType", route.getNextHopType());
                if (route.getNextHopIpAddress() != null) {
                    propertiesValue2.put("nextHopIpAddress", route.getNextHopIpAddress());
                }
                if (route.getProvisioningState() != null) {
                    propertiesValue2.put("provisioningState", route.getProvisioningState());
                }
                if (route.getName() != null) {
                    routeJsonFormatValue.put("name", route.getName());
                }
                if (route.getEtag() != null) {
                    routeJsonFormatValue.put("etag", route.getEtag());
                }
                if (route.getId() == null) continue;
                routeJsonFormatValue.put("id", route.getId());
            }
            propertiesValue.put("routes", (JsonNode)routesArray);
        }
        if (parameters.getSubnets() != null && (!(parameters.getSubnets() instanceof LazyCollection) || ((LazyCollection)parameters.getSubnets()).isInitialized())) {
            ArrayNode subnetsArray = objectMapper.createArrayNode();
            for (ResourceId resourceId : parameters.getSubnets()) {
                ObjectNode resourceIdValue = objectMapper.createObjectNode();
                subnetsArray.add((JsonNode)resourceIdValue);
                if (resourceId.getId() == null) continue;
                resourceIdValue.put("id", resourceId.getId());
            }
            propertiesValue.put("subnets", (JsonNode)subnetsArray);
        }
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            routeTableJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            routeTableJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            routeTableJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            routeTableJsonFormatValue.put("type", parameters.getType());
        }
        routeTableJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            routeTableJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var17_23 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RouteTablePutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new RouteTablePutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue3;
                    JsonNode etagValue2;
                    RouteTable routeTableInstance = new RouteTable();
                    result.setRouteTable(routeTableInstance);
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode subnetsArray2;
                        JsonNode routesArray2 = propertiesValue3.get("routes");
                        if (routesArray2 != null && !(routesArray2 instanceof NullNode)) {
                            for (Iterator routesValue : (ArrayNode)routesArray2) {
                                JsonNode idValue;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                Route routeJsonFormatInstance = new Route();
                                routeTableInstance.getRoutes().add(routeJsonFormatInstance);
                                JsonNode propertiesValue4 = routesValue.get("properties");
                                if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode nextHopIpAddressValue;
                                    JsonNode nextHopTypeValue;
                                    JsonNode addressPrefixValue = propertiesValue4.get("addressPrefix");
                                    if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                        String addressPrefixInstance = addressPrefixValue.getTextValue();
                                        routeJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                    }
                                    if ((nextHopTypeValue = propertiesValue4.get("nextHopType")) != null && !(nextHopTypeValue instanceof NullNode)) {
                                        String nextHopTypeInstance = nextHopTypeValue.getTextValue();
                                        routeJsonFormatInstance.setNextHopType(nextHopTypeInstance);
                                    }
                                    if ((nextHopIpAddressValue = propertiesValue4.get("nextHopIpAddress")) != null && !(nextHopIpAddressValue instanceof NullNode)) {
                                        String nextHopIpAddressInstance = nextHopIpAddressValue.getTextValue();
                                        routeJsonFormatInstance.setNextHopIpAddress(nextHopIpAddressInstance);
                                    }
                                    if ((provisioningStateValue = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        routeJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = routesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    routeJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = routesValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    routeJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue = routesValue.get("id")) == null || idValue instanceof NullNode) continue;
                                String idInstance = idValue.getTextValue();
                                routeJsonFormatInstance.setId(idInstance);
                            }
                        }
                        if ((subnetsArray2 = propertiesValue3.get("subnets")) != null && !(subnetsArray2 instanceof NullNode)) {
                            for (JsonNode subnetsValue : (ArrayNode)subnetsArray2) {
                                ResourceId resourceIdInstance = new ResourceId();
                                routeTableInstance.getSubnets().add(resourceIdInstance);
                                JsonNode idValue2 = subnetsValue.get("id");
                                if (idValue2 == null || idValue2 instanceof NullNode) continue;
                                String idInstance2 = idValue2.getTextValue();
                                resourceIdInstance.setId(idInstance2);
                            }
                        }
                        if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            routeTableInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        routeTableInstance.setEtag(etagInstance2);
                    }
                    if ((idValue3 = responseDoc.get("id")) != null && !(idValue3 instanceof NullNode)) {
                        String idInstance3 = idValue3.getTextValue();
                        routeTableInstance.setId(idInstance3);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        routeTableInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        routeTableInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        routeTableInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            routeTableInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)closeableHttpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (closeableHttpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(closeableHttpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            routeTablePutResponse = result;
        }
        catch (Throwable throwable) {
            if (var17_23 != null && var17_23.getEntity() != null) {
                var17_23.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return routeTablePutResponse;
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return RouteTableOperationsImpl.this.beginDeleting(resourceGroupName, routeTableName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String routeTableName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String routeTableName, final RouteTable parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return RouteTableOperationsImpl.this.createOrUpdate(resourceGroupName, routeTableName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String routeTableName, RouteTable parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            RouteTablePutResponse response = client2.getRouteTablesOperations().beginCreateOrUpdatingAsync(resourceGroupName, routeTableName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RouteTableOperationsImpl.this.delete(resourceGroupName, routeTableName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String routeTableName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getRouteTablesOperations().beginDeletingAsync(resourceGroupName, routeTableName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<RouteTableGetResponse> getAsync(final String resourceGroupName, final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<RouteTableGetResponse>(){

            @Override
            public RouteTableGetResponse call() throws Exception {
                return RouteTableOperationsImpl.this.get(resourceGroupName, routeTableName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteTableGetResponse get(String resourceGroupName, String routeTableName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RouteTableGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RouteTableGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue3;
                    JsonNode etagValue2;
                    RouteTable routeTableInstance = new RouteTable();
                    result.setRouteTable(routeTableInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode subnetsArray;
                        JsonNode routesArray = propertiesValue.get("routes");
                        if (routesArray != null && !(routesArray instanceof NullNode)) {
                            for (Iterator routesValue : (ArrayNode)routesArray) {
                                JsonNode idValue;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                Route routeJsonFormatInstance = new Route();
                                routeTableInstance.getRoutes().add(routeJsonFormatInstance);
                                JsonNode propertiesValue2 = routesValue.get("properties");
                                if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode nextHopIpAddressValue;
                                    JsonNode nextHopTypeValue;
                                    JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                    if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                        String addressPrefixInstance = addressPrefixValue.getTextValue();
                                        routeJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                    }
                                    if ((nextHopTypeValue = propertiesValue2.get("nextHopType")) != null && !(nextHopTypeValue instanceof NullNode)) {
                                        String nextHopTypeInstance = nextHopTypeValue.getTextValue();
                                        routeJsonFormatInstance.setNextHopType(nextHopTypeInstance);
                                    }
                                    if ((nextHopIpAddressValue = propertiesValue2.get("nextHopIpAddress")) != null && !(nextHopIpAddressValue instanceof NullNode)) {
                                        String nextHopIpAddressInstance = nextHopIpAddressValue.getTextValue();
                                        routeJsonFormatInstance.setNextHopIpAddress(nextHopIpAddressInstance);
                                    }
                                    if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        routeJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = routesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    routeJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = routesValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    routeJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue = routesValue.get("id")) == null || idValue instanceof NullNode) continue;
                                String idInstance = idValue.getTextValue();
                                routeJsonFormatInstance.setId(idInstance);
                            }
                        }
                        if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                            for (JsonNode subnetsValue : (ArrayNode)subnetsArray) {
                                ResourceId resourceIdInstance = new ResourceId();
                                routeTableInstance.getSubnets().add(resourceIdInstance);
                                JsonNode idValue2 = subnetsValue.get("id");
                                if (idValue2 == null || idValue2 instanceof NullNode) continue;
                                String idInstance2 = idValue2.getTextValue();
                                resourceIdInstance.setId(idInstance2);
                            }
                        }
                        if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            routeTableInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        routeTableInstance.setEtag(etagInstance2);
                    }
                    if ((idValue3 = responseDoc.get("id")) != null && !(idValue3 instanceof NullNode)) {
                        String idInstance3 = idValue3.getTextValue();
                        routeTableInstance.setId(idInstance3);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        routeTableInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        routeTableInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        routeTableInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            routeTableInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RouteTableGetResponse routeTableGetResponse = result;
            return routeTableGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RouteTableListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<RouteTableListResponse>(){

            @Override
            public RouteTableListResponse call() throws Exception {
                return RouteTableOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteTableListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RouteTableListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RouteTableListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue3;
                            JsonNode etagValue2;
                            RouteTable routeTableJsonFormatInstance = new RouteTable();
                            result.getRouteTables().add(routeTableJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue2;
                                JsonNode subnetsArray;
                                JsonNode routesArray = propertiesValue.get("routes");
                                if (routesArray != null && !(routesArray instanceof NullNode)) {
                                    for (Iterator routesValue : (ArrayNode)routesArray) {
                                        JsonNode idValue;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        Route routeJsonFormatInstance = new Route();
                                        routeTableJsonFormatInstance.getRoutes().add(routeJsonFormatInstance);
                                        JsonNode propertiesValue2 = routesValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode nextHopIpAddressValue;
                                            JsonNode nextHopTypeValue;
                                            JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                            if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                                String addressPrefixInstance = addressPrefixValue.getTextValue();
                                                routeJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                            }
                                            if ((nextHopTypeValue = propertiesValue2.get("nextHopType")) != null && !(nextHopTypeValue instanceof NullNode)) {
                                                String nextHopTypeInstance = nextHopTypeValue.getTextValue();
                                                routeJsonFormatInstance.setNextHopType(nextHopTypeInstance);
                                            }
                                            if ((nextHopIpAddressValue = propertiesValue2.get("nextHopIpAddress")) != null && !(nextHopIpAddressValue instanceof NullNode)) {
                                                String nextHopIpAddressInstance = nextHopIpAddressValue.getTextValue();
                                                routeJsonFormatInstance.setNextHopIpAddress(nextHopIpAddressInstance);
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                routeJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = routesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            routeJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = routesValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            routeJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue = routesValue.get("id")) == null || idValue instanceof NullNode) continue;
                                        String idInstance = idValue.getTextValue();
                                        routeJsonFormatInstance.setId(idInstance);
                                    }
                                }
                                if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                                    Iterator routesValue;
                                    routesValue = ((ArrayNode)subnetsArray).iterator();
                                    while (routesValue.hasNext()) {
                                        JsonNode subnetsValue = (JsonNode)routesValue.next();
                                        ResourceId resourceIdInstance = new ResourceId();
                                        routeTableJsonFormatInstance.getSubnets().add(resourceIdInstance);
                                        JsonNode idValue2 = subnetsValue.get("id");
                                        if (idValue2 == null || idValue2 instanceof NullNode) continue;
                                        String idInstance2 = idValue2.getTextValue();
                                        resourceIdInstance.setId(idInstance2);
                                    }
                                }
                                if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    routeTableJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            if ((etagValue2 = valueValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                routeTableJsonFormatInstance.setEtag(etagInstance2);
                            }
                            if ((idValue3 = valueValue.get("id")) != null && !(idValue3 instanceof NullNode)) {
                                String idInstance3 = idValue3.getTextValue();
                                routeTableJsonFormatInstance.setId(idInstance3);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                routeTableJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                routeTableJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                routeTableJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                routeTableJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RouteTableListResponse routeTableListResponse = result;
            return routeTableListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RouteTableListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<RouteTableListResponse>(){

            @Override
            public RouteTableListResponse call() throws Exception {
                return RouteTableOperationsImpl.this.listAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteTableListResponse listAll() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/routeTables";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RouteTableListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RouteTableListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue3;
                            JsonNode etagValue2;
                            RouteTable routeTableJsonFormatInstance = new RouteTable();
                            result.getRouteTables().add(routeTableJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue2;
                                JsonNode subnetsArray;
                                JsonNode routesArray = propertiesValue.get("routes");
                                if (routesArray != null && !(routesArray instanceof NullNode)) {
                                    for (Iterator routesValue : (ArrayNode)routesArray) {
                                        JsonNode idValue;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        Route routeJsonFormatInstance = new Route();
                                        routeTableJsonFormatInstance.getRoutes().add(routeJsonFormatInstance);
                                        JsonNode propertiesValue2 = routesValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode nextHopIpAddressValue;
                                            JsonNode nextHopTypeValue;
                                            JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                            if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                                String addressPrefixInstance = addressPrefixValue.getTextValue();
                                                routeJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                            }
                                            if ((nextHopTypeValue = propertiesValue2.get("nextHopType")) != null && !(nextHopTypeValue instanceof NullNode)) {
                                                String nextHopTypeInstance = nextHopTypeValue.getTextValue();
                                                routeJsonFormatInstance.setNextHopType(nextHopTypeInstance);
                                            }
                                            if ((nextHopIpAddressValue = propertiesValue2.get("nextHopIpAddress")) != null && !(nextHopIpAddressValue instanceof NullNode)) {
                                                String nextHopIpAddressInstance = nextHopIpAddressValue.getTextValue();
                                                routeJsonFormatInstance.setNextHopIpAddress(nextHopIpAddressInstance);
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                routeJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = routesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            routeJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = routesValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            routeJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue = routesValue.get("id")) == null || idValue instanceof NullNode) continue;
                                        String idInstance = idValue.getTextValue();
                                        routeJsonFormatInstance.setId(idInstance);
                                    }
                                }
                                if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                                    Iterator routesValue;
                                    routesValue = ((ArrayNode)subnetsArray).iterator();
                                    while (routesValue.hasNext()) {
                                        JsonNode subnetsValue = (JsonNode)routesValue.next();
                                        ResourceId resourceIdInstance = new ResourceId();
                                        routeTableJsonFormatInstance.getSubnets().add(resourceIdInstance);
                                        JsonNode idValue2 = subnetsValue.get("id");
                                        if (idValue2 == null || idValue2 instanceof NullNode) continue;
                                        String idInstance2 = idValue2.getTextValue();
                                        resourceIdInstance.setId(idInstance2);
                                    }
                                }
                                if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    routeTableJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            if ((etagValue2 = valueValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                routeTableJsonFormatInstance.setEtag(etagInstance2);
                            }
                            if ((idValue3 = valueValue.get("id")) != null && !(idValue3 instanceof NullNode)) {
                                String idInstance3 = idValue3.getTextValue();
                                routeTableJsonFormatInstance.setId(idInstance3);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                routeTableJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                routeTableJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                routeTableJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                routeTableJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RouteTableListResponse routeTableListResponse = result;
            return routeTableListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

