/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.SecurityRuleOperations;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.SecurityRule;
import com.microsoft.azure.management.network.models.SecurityRuleGetResponse;
import com.microsoft.azure.management.network.models.SecurityRuleListResponse;
import com.microsoft.azure.management.network.models.SecurityRulePutResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class SecurityRuleOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
SecurityRuleOperations {
    private NetworkResourceProviderClientImpl client;

    SecurityRuleOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<SecurityRulePutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName, final SecurityRule securityRuleParameters) {
        return this.getClient().getExecutorService().submit(new Callable<SecurityRulePutResponse>(){

            @Override
            public SecurityRulePutResponse call() throws Exception {
                return SecurityRuleOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, networkSecurityGroupName, securityRuleName, securityRuleParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityRulePutResponse beginCreateOrUpdating(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, SecurityRule securityRuleParameters) throws IOException, ServiceException {
        ObjectNode securityRuleJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        if (securityRuleName == null) {
            throw new NullPointerException("securityRuleName");
        }
        if (securityRuleParameters == null) {
            throw new NullPointerException("securityRuleParameters");
        }
        if (securityRuleParameters.getAccess() == null) {
            throw new NullPointerException("securityRuleParameters.Access");
        }
        if (securityRuleParameters.getDestinationAddressPrefix() == null) {
            throw new NullPointerException("securityRuleParameters.DestinationAddressPrefix");
        }
        if (securityRuleParameters.getDirection() == null) {
            throw new NullPointerException("securityRuleParameters.Direction");
        }
        if (securityRuleParameters.getProtocol() == null) {
            throw new NullPointerException("securityRuleParameters.Protocol");
        }
        if (securityRuleParameters.getSourceAddressPrefix() == null) {
            throw new NullPointerException("securityRuleParameters.SourceAddressPrefix");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            tracingParameters.put("securityRuleParameters", securityRuleParameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        url = url + "/securityRules/";
        url = url + URLEncoder.encode(securityRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = securityRuleJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        securityRuleJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (securityRuleParameters.getDescription() != null) {
            propertiesValue.put("description", securityRuleParameters.getDescription());
        }
        propertiesValue.put("protocol", securityRuleParameters.getProtocol());
        if (securityRuleParameters.getSourcePortRange() != null) {
            propertiesValue.put("sourcePortRange", securityRuleParameters.getSourcePortRange());
        }
        if (securityRuleParameters.getDestinationPortRange() != null) {
            propertiesValue.put("destinationPortRange", securityRuleParameters.getDestinationPortRange());
        }
        propertiesValue.put("sourceAddressPrefix", securityRuleParameters.getSourceAddressPrefix());
        propertiesValue.put("destinationAddressPrefix", securityRuleParameters.getDestinationAddressPrefix());
        propertiesValue.put("access", securityRuleParameters.getAccess());
        propertiesValue.put("priority", securityRuleParameters.getPriority());
        propertiesValue.put("direction", securityRuleParameters.getDirection());
        if (securityRuleParameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", securityRuleParameters.getProvisioningState());
        }
        if (securityRuleParameters.getName() != null) {
            securityRuleJsonFormatValue.put("name", securityRuleParameters.getName());
        }
        if (securityRuleParameters.getEtag() != null) {
            securityRuleJsonFormatValue.put("etag", securityRuleParameters.getEtag());
        }
        if (securityRuleParameters.getId() != null) {
            securityRuleJsonFormatValue.put("id", securityRuleParameters.getId());
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecurityRulePutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SecurityRulePutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode idValue;
                    JsonNode etagValue;
                    JsonNode nameValue;
                    SecurityRule securityRuleInstance = new SecurityRule();
                    result.setSecurityRule(securityRuleInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                        Object provisioningStateValue;
                        JsonNode directionValue;
                        JsonNode priorityValue;
                        JsonNode accessValue;
                        JsonNode destinationAddressPrefixValue;
                        JsonNode sourceAddressPrefixValue;
                        JsonNode destinationPortRangeValue;
                        JsonNode sourcePortRangeValue;
                        JsonNode protocolValue;
                        JsonNode descriptionValue = propertiesValue2.get("description");
                        if (descriptionValue != null && !(descriptionValue instanceof NullNode)) {
                            String descriptionInstance = descriptionValue.getTextValue();
                            securityRuleInstance.setDescription(descriptionInstance);
                        }
                        if ((protocolValue = propertiesValue2.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                            String protocolInstance = protocolValue.getTextValue();
                            securityRuleInstance.setProtocol(protocolInstance);
                        }
                        if ((sourcePortRangeValue = propertiesValue2.get("sourcePortRange")) != null && !(sourcePortRangeValue instanceof NullNode)) {
                            String sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                            securityRuleInstance.setSourcePortRange(sourcePortRangeInstance);
                        }
                        if ((destinationPortRangeValue = propertiesValue2.get("destinationPortRange")) != null && !(destinationPortRangeValue instanceof NullNode)) {
                            String destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                            securityRuleInstance.setDestinationPortRange(destinationPortRangeInstance);
                        }
                        if ((sourceAddressPrefixValue = propertiesValue2.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue instanceof NullNode)) {
                            String sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                            securityRuleInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                        }
                        if ((destinationAddressPrefixValue = propertiesValue2.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue instanceof NullNode)) {
                            String destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                            securityRuleInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                        }
                        if ((accessValue = propertiesValue2.get("access")) != null && !(accessValue instanceof NullNode)) {
                            String accessInstance = accessValue.getTextValue();
                            securityRuleInstance.setAccess(accessInstance);
                        }
                        if ((priorityValue = propertiesValue2.get("priority")) != null && !(priorityValue instanceof NullNode)) {
                            int priorityInstance = priorityValue.getIntValue();
                            securityRuleInstance.setPriority(priorityInstance);
                        }
                        if ((directionValue = propertiesValue2.get("direction")) != null && !(directionValue instanceof NullNode)) {
                            String directionInstance = directionValue.getTextValue();
                            securityRuleInstance.setDirection(directionInstance);
                        }
                        if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            securityRuleInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        securityRuleInstance.setName(nameInstance);
                    }
                    if ((etagValue = responseDoc.get("etag")) != null && !(etagValue instanceof NullNode)) {
                        String etagInstance = etagValue.getTextValue();
                        securityRuleInstance.setEtag(etagInstance);
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        securityRuleInstance.setId(idInstance);
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecurityRulePutResponse securityRulePutResponse = result;
            return securityRulePutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return SecurityRuleOperationsImpl.this.beginDeleting(resourceGroupName, networkSecurityGroupName, securityRuleName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        if (securityRuleName == null) {
            throw new NullPointerException("securityRuleName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        url = url + "/securityRules/";
        url = url + URLEncoder.encode(securityRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName, final SecurityRule securityRuleParameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return SecurityRuleOperationsImpl.this.createOrUpdate(resourceGroupName, networkSecurityGroupName, securityRuleName, securityRuleParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, SecurityRule securityRuleParameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            tracingParameters.put("securityRuleParameters", securityRuleParameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            SecurityRulePutResponse response = client2.getSecurityRulesOperations().beginCreateOrUpdatingAsync(resourceGroupName, networkSecurityGroupName, securityRuleName, securityRuleParameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return SecurityRuleOperationsImpl.this.delete(resourceGroupName, networkSecurityGroupName, securityRuleName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getSecurityRulesOperations().beginDeletingAsync(resourceGroupName, networkSecurityGroupName, securityRuleName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<SecurityRuleGetResponse> getAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<SecurityRuleGetResponse>(){

            @Override
            public SecurityRuleGetResponse call() throws Exception {
                return SecurityRuleOperationsImpl.this.get(resourceGroupName, networkSecurityGroupName, securityRuleName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityRuleGetResponse get(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        if (securityRuleName == null) {
            throw new NullPointerException("securityRuleName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        url = url + "/securityRules/";
        url = url + URLEncoder.encode(securityRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecurityRuleGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SecurityRuleGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode idValue;
                    JsonNode etagValue;
                    JsonNode nameValue;
                    SecurityRule securityRuleInstance = new SecurityRule();
                    result.setSecurityRule(securityRuleInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue;
                        JsonNode directionValue;
                        JsonNode priorityValue;
                        JsonNode accessValue;
                        JsonNode destinationAddressPrefixValue;
                        JsonNode sourceAddressPrefixValue;
                        JsonNode destinationPortRangeValue;
                        JsonNode sourcePortRangeValue;
                        JsonNode protocolValue;
                        JsonNode descriptionValue = propertiesValue.get("description");
                        if (descriptionValue != null && !(descriptionValue instanceof NullNode)) {
                            String descriptionInstance = descriptionValue.getTextValue();
                            securityRuleInstance.setDescription(descriptionInstance);
                        }
                        if ((protocolValue = propertiesValue.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                            String protocolInstance = protocolValue.getTextValue();
                            securityRuleInstance.setProtocol(protocolInstance);
                        }
                        if ((sourcePortRangeValue = propertiesValue.get("sourcePortRange")) != null && !(sourcePortRangeValue instanceof NullNode)) {
                            String sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                            securityRuleInstance.setSourcePortRange(sourcePortRangeInstance);
                        }
                        if ((destinationPortRangeValue = propertiesValue.get("destinationPortRange")) != null && !(destinationPortRangeValue instanceof NullNode)) {
                            String destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                            securityRuleInstance.setDestinationPortRange(destinationPortRangeInstance);
                        }
                        if ((sourceAddressPrefixValue = propertiesValue.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue instanceof NullNode)) {
                            String sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                            securityRuleInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                        }
                        if ((destinationAddressPrefixValue = propertiesValue.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue instanceof NullNode)) {
                            String destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                            securityRuleInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                        }
                        if ((accessValue = propertiesValue.get("access")) != null && !(accessValue instanceof NullNode)) {
                            String accessInstance = accessValue.getTextValue();
                            securityRuleInstance.setAccess(accessInstance);
                        }
                        if ((priorityValue = propertiesValue.get("priority")) != null && !(priorityValue instanceof NullNode)) {
                            int priorityInstance = priorityValue.getIntValue();
                            securityRuleInstance.setPriority(priorityInstance);
                        }
                        if ((directionValue = propertiesValue.get("direction")) != null && !(directionValue instanceof NullNode)) {
                            String directionInstance = directionValue.getTextValue();
                            securityRuleInstance.setDirection(directionInstance);
                        }
                        if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            securityRuleInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        securityRuleInstance.setName(nameInstance);
                    }
                    if ((etagValue = responseDoc.get("etag")) != null && !(etagValue instanceof NullNode)) {
                        String etagInstance = etagValue.getTextValue();
                        securityRuleInstance.setEtag(etagInstance);
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        securityRuleInstance.setId(idInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecurityRuleGetResponse securityRuleGetResponse = result;
            return securityRuleGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SecurityRuleListResponse> listAsync(final String resourceGroupName, final String networkSecurityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<SecurityRuleListResponse>(){

            @Override
            public SecurityRuleListResponse call() throws Exception {
                return SecurityRuleOperationsImpl.this.list(resourceGroupName, networkSecurityGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityRuleListResponse list(String resourceGroupName, String networkSecurityGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        url = url + "/securityRules";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecurityRuleListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SecurityRuleListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode idValue;
                            JsonNode etagValue;
                            JsonNode nameValue;
                            SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                            result.getSecurityRules().add(securityRuleJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue;
                                JsonNode directionValue;
                                JsonNode priorityValue;
                                JsonNode accessValue;
                                JsonNode destinationAddressPrefixValue;
                                JsonNode sourceAddressPrefixValue;
                                JsonNode destinationPortRangeValue;
                                JsonNode sourcePortRangeValue;
                                JsonNode protocolValue;
                                JsonNode descriptionValue = propertiesValue.get("description");
                                if (descriptionValue != null && !(descriptionValue instanceof NullNode)) {
                                    String descriptionInstance = descriptionValue.getTextValue();
                                    securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                }
                                if ((protocolValue = propertiesValue.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                    String protocolInstance = protocolValue.getTextValue();
                                    securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                }
                                if ((sourcePortRangeValue = propertiesValue.get("sourcePortRange")) != null && !(sourcePortRangeValue instanceof NullNode)) {
                                    String sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                    securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                }
                                if ((destinationPortRangeValue = propertiesValue.get("destinationPortRange")) != null && !(destinationPortRangeValue instanceof NullNode)) {
                                    String destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                    securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                }
                                if ((sourceAddressPrefixValue = propertiesValue.get("sourceAddressPrefix")) != null && !(sourceAddressPrefixValue instanceof NullNode)) {
                                    String sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                    securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                }
                                if ((destinationAddressPrefixValue = propertiesValue.get("destinationAddressPrefix")) != null && !(destinationAddressPrefixValue instanceof NullNode)) {
                                    String destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                    securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                }
                                if ((accessValue = propertiesValue.get("access")) != null && !(accessValue instanceof NullNode)) {
                                    String accessInstance = accessValue.getTextValue();
                                    securityRuleJsonFormatInstance.setAccess(accessInstance);
                                }
                                if ((priorityValue = propertiesValue.get("priority")) != null && !(priorityValue instanceof NullNode)) {
                                    int priorityInstance = priorityValue.getIntValue();
                                    securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                }
                                if ((directionValue = propertiesValue.get("direction")) != null && !(directionValue instanceof NullNode)) {
                                    String directionInstance = directionValue.getTextValue();
                                    securityRuleJsonFormatInstance.setDirection(directionInstance);
                                }
                                if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                    String provisioningStateInstance = provisioningStateValue.getTextValue();
                                    securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                securityRuleJsonFormatInstance.setName(nameInstance);
                            }
                            if ((etagValue = valueValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                String etagInstance = etagValue.getTextValue();
                                securityRuleJsonFormatInstance.setEtag(etagInstance);
                            }
                            if ((idValue = valueValue.get("id")) == null || idValue instanceof NullNode) continue;
                            String idInstance = idValue.getTextValue();
                            securityRuleJsonFormatInstance.setId(idInstance);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecurityRuleListResponse securityRuleListResponse = result;
            return securityRuleListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

