/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.SubnetOperations;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.Subnet;
import com.microsoft.azure.management.network.models.SubnetGetResponse;
import com.microsoft.azure.management.network.models.SubnetListResponse;
import com.microsoft.azure.management.network.models.SubnetPutResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class SubnetOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
SubnetOperations {
    private NetworkResourceProviderClientImpl client;

    SubnetOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<SubnetPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName, final Subnet subnetParameters) {
        return this.getClient().getExecutorService().submit(new Callable<SubnetPutResponse>(){

            @Override
            public SubnetPutResponse call() throws Exception {
                return SubnetOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, virtualNetworkName, subnetName, subnetParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubnetPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkName, String subnetName, Subnet subnetParameters) throws IOException, ServiceException {
        ObjectNode subnetJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        if (subnetParameters == null) {
            throw new NullPointerException("subnetParameters");
        }
        if (subnetParameters.getAddressPrefix() == null) {
            throw new NullPointerException("subnetParameters.AddressPrefix");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            tracingParameters.put("subnetParameters", subnetParameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = subnetJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        subnetJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        propertiesValue.put("addressPrefix", subnetParameters.getAddressPrefix());
        if (subnetParameters.getNetworkSecurityGroup() != null) {
            ObjectNode networkSecurityGroupValue = objectMapper.createObjectNode();
            propertiesValue.put("networkSecurityGroup", (JsonNode)networkSecurityGroupValue);
            if (subnetParameters.getNetworkSecurityGroup().getId() != null) {
                networkSecurityGroupValue.put("id", subnetParameters.getNetworkSecurityGroup().getId());
            }
        }
        if (subnetParameters.getRouteTable() != null) {
            ObjectNode routeTableValue = objectMapper.createObjectNode();
            propertiesValue.put("routeTable", (JsonNode)routeTableValue);
            if (subnetParameters.getRouteTable().getId() != null) {
                routeTableValue.put("id", subnetParameters.getRouteTable().getId());
            }
        }
        if (subnetParameters.getIpConfigurations() != null && (!(subnetParameters.getIpConfigurations() instanceof LazyCollection) || ((LazyCollection)subnetParameters.getIpConfigurations()).isInitialized())) {
            ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
            for (ResourceId ipConfigurationsItem : subnetParameters.getIpConfigurations()) {
                ObjectNode resourceIdValue = objectMapper.createObjectNode();
                ipConfigurationsArray.add((JsonNode)resourceIdValue);
                if (ipConfigurationsItem.getId() == null) continue;
                resourceIdValue.put("id", ipConfigurationsItem.getId());
            }
            propertiesValue.put("ipConfigurations", (JsonNode)ipConfigurationsArray);
        }
        if (subnetParameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", subnetParameters.getProvisioningState());
        }
        if (subnetParameters.getName() != null) {
            subnetJsonFormatValue.put("name", subnetParameters.getName());
        }
        if (subnetParameters.getEtag() != null) {
            subnetJsonFormatValue.put("etag", subnetParameters.getEtag());
        }
        if (subnetParameters.getId() != null) {
            subnetJsonFormatValue.put("id", subnetParameters.getId());
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SubnetPutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubnetPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode idValue4;
                    JsonNode etagValue;
                    JsonNode nameValue;
                    Subnet subnetInstance = new Subnet();
                    result.setSubnet(subnetInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode provisioningStateValue;
                        JsonNode ipConfigurationsArray2;
                        JsonNode routeTableValue2;
                        JsonNode networkSecurityGroupValue2;
                        JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                        if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                            String addressPrefixInstance = addressPrefixValue.getTextValue();
                            subnetInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        if ((networkSecurityGroupValue2 = propertiesValue2.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue2 instanceof NullNode)) {
                            ResourceId networkSecurityGroupInstance = new ResourceId();
                            subnetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                            JsonNode idValue = networkSecurityGroupValue2.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                networkSecurityGroupInstance.setId(idInstance);
                            }
                        }
                        if ((routeTableValue2 = propertiesValue2.get("routeTable")) != null && !(routeTableValue2 instanceof NullNode)) {
                            ResourceId routeTableInstance = new ResourceId();
                            subnetInstance.setRouteTable(routeTableInstance);
                            Iterator idValue2 = routeTableValue2.get("id");
                            if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                routeTableInstance.setId(idInstance2);
                            }
                        }
                        if ((ipConfigurationsArray2 = propertiesValue2.get("ipConfigurations")) != null && !(ipConfigurationsArray2 instanceof NullNode)) {
                            for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray2) {
                                ResourceId resourceIdInstance = new ResourceId();
                                subnetInstance.getIpConfigurations().add(resourceIdInstance);
                                JsonNode idValue3 = ipConfigurationsValue.get("id");
                                if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                resourceIdInstance.setId(idInstance3);
                            }
                        }
                        if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            subnetInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        subnetInstance.setName(nameInstance);
                    }
                    if ((etagValue = responseDoc.get("etag")) != null && !(etagValue instanceof NullNode)) {
                        String etagInstance = etagValue.getTextValue();
                        subnetInstance.setEtag(etagInstance);
                    }
                    if ((idValue4 = responseDoc.get("id")) != null && !(idValue4 instanceof NullNode)) {
                        String idInstance4 = idValue4.getTextValue();
                        subnetInstance.setId(idInstance4);
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SubnetPutResponse subnetPutResponse = result;
            return subnetPutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return SubnetOperationsImpl.this.beginDeleting(resourceGroupName, virtualNetworkName, subnetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkName, String subnetName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName, final Subnet subnetParameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return SubnetOperationsImpl.this.createOrUpdate(resourceGroupName, virtualNetworkName, subnetName, subnetParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkName, String subnetName, Subnet subnetParameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            tracingParameters.put("subnetParameters", subnetParameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            SubnetPutResponse response = client2.getSubnetsOperations().beginCreateOrUpdatingAsync(resourceGroupName, virtualNetworkName, subnetName, subnetParameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return SubnetOperationsImpl.this.delete(resourceGroupName, virtualNetworkName, subnetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String virtualNetworkName, String subnetName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getSubnetsOperations().beginDeletingAsync(resourceGroupName, virtualNetworkName, subnetName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<SubnetGetResponse> getAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<SubnetGetResponse>(){

            @Override
            public SubnetGetResponse call() throws Exception {
                return SubnetOperationsImpl.this.get(resourceGroupName, virtualNetworkName, subnetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubnetGetResponse get(String resourceGroupName, String virtualNetworkName, String subnetName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SubnetGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubnetGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode idValue4;
                    JsonNode etagValue;
                    JsonNode nameValue;
                    Subnet subnetInstance = new Subnet();
                    result.setSubnet(subnetInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue;
                        JsonNode ipConfigurationsArray;
                        JsonNode routeTableValue;
                        JsonNode networkSecurityGroupValue;
                        JsonNode addressPrefixValue = propertiesValue.get("addressPrefix");
                        if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                            String addressPrefixInstance = addressPrefixValue.getTextValue();
                            subnetInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        if ((networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue instanceof NullNode)) {
                            ResourceId networkSecurityGroupInstance = new ResourceId();
                            subnetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                            JsonNode idValue = networkSecurityGroupValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                networkSecurityGroupInstance.setId(idInstance);
                            }
                        }
                        if ((routeTableValue = propertiesValue.get("routeTable")) != null && !(routeTableValue instanceof NullNode)) {
                            ResourceId routeTableInstance = new ResourceId();
                            subnetInstance.setRouteTable(routeTableInstance);
                            Iterator idValue2 = routeTableValue.get("id");
                            if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                routeTableInstance.setId(idInstance2);
                            }
                        }
                        if ((ipConfigurationsArray = propertiesValue.get("ipConfigurations")) != null && !(ipConfigurationsArray instanceof NullNode)) {
                            for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                ResourceId resourceIdInstance = new ResourceId();
                                subnetInstance.getIpConfigurations().add(resourceIdInstance);
                                JsonNode idValue3 = ipConfigurationsValue.get("id");
                                if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                resourceIdInstance.setId(idInstance3);
                            }
                        }
                        if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            subnetInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        subnetInstance.setName(nameInstance);
                    }
                    if ((etagValue = responseDoc.get("etag")) != null && !(etagValue instanceof NullNode)) {
                        String etagInstance = etagValue.getTextValue();
                        subnetInstance.setEtag(etagInstance);
                    }
                    if ((idValue4 = responseDoc.get("id")) != null && !(idValue4 instanceof NullNode)) {
                        String idInstance4 = idValue4.getTextValue();
                        subnetInstance.setId(idInstance4);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SubnetGetResponse subnetGetResponse = result;
            return subnetGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SubnetListResponse> listAsync(final String resourceGroupName, final String virtualNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<SubnetListResponse>(){

            @Override
            public SubnetListResponse call() throws Exception {
                return SubnetOperationsImpl.this.list(resourceGroupName, virtualNetworkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubnetListResponse list(String resourceGroupName, String virtualNetworkName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        url = url + "/subnets";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SubnetListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubnetListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode idValue4;
                            JsonNode etagValue;
                            JsonNode nameValue;
                            Subnet subnetJsonFormatInstance = new Subnet();
                            result.getSubnets().add(subnetJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue;
                                JsonNode ipConfigurationsArray;
                                JsonNode routeTableValue;
                                JsonNode networkSecurityGroupValue;
                                JsonNode addressPrefixValue = propertiesValue.get("addressPrefix");
                                if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                    String addressPrefixInstance = addressPrefixValue.getTextValue();
                                    subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                }
                                if ((networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue instanceof NullNode)) {
                                    ResourceId networkSecurityGroupInstance = new ResourceId();
                                    subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                    JsonNode idValue = networkSecurityGroupValue.get("id");
                                    if (idValue != null && !(idValue instanceof NullNode)) {
                                        String idInstance = idValue.getTextValue();
                                        networkSecurityGroupInstance.setId(idInstance);
                                    }
                                }
                                if ((routeTableValue = propertiesValue.get("routeTable")) != null && !(routeTableValue instanceof NullNode)) {
                                    ResourceId routeTableInstance = new ResourceId();
                                    subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                    Iterator idValue2 = routeTableValue.get("id");
                                    if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                        String idInstance2 = idValue2.getTextValue();
                                        routeTableInstance.setId(idInstance2);
                                    }
                                }
                                if ((ipConfigurationsArray = propertiesValue.get("ipConfigurations")) != null && !(ipConfigurationsArray instanceof NullNode)) {
                                    for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                        ResourceId resourceIdInstance = new ResourceId();
                                        subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                        JsonNode idValue3 = ipConfigurationsValue.get("id");
                                        if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                        String idInstance3 = idValue3.getTextValue();
                                        resourceIdInstance.setId(idInstance3);
                                    }
                                }
                                if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                    String provisioningStateInstance = provisioningStateValue.getTextValue();
                                    subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                subnetJsonFormatInstance.setName(nameInstance);
                            }
                            if ((etagValue = valueValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                String etagInstance = etagValue.getTextValue();
                                subnetJsonFormatInstance.setEtag(etagInstance);
                            }
                            if ((idValue4 = valueValue.get("id")) == null || idValue4 instanceof NullNode) continue;
                            String idInstance4 = idValue4.getTextValue();
                            subnetJsonFormatInstance.setId(idInstance4);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SubnetListResponse subnetListResponse = result;
            return subnetListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

