/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.UsageOperations;
import com.microsoft.azure.management.network.models.Usage;
import com.microsoft.azure.management.network.models.UsageName;
import com.microsoft.azure.management.network.models.UsagesListResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class UsageOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
UsageOperations {
    private NetworkResourceProviderClientImpl client;

    UsageOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<UsagesListResponse> listAsync(final String location) {
        return this.getClient().getExecutorService().submit(new Callable<UsagesListResponse>(){

            @Override
            public UsagesListResponse call() throws Exception {
                return UsageOperationsImpl.this.list(location);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsagesListResponse list(String location) throws IOException, ServiceException {
        String baseUrl;
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (location != null && location.length() > 1000) {
            throw new IllegalArgumentException("location");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", location)) {
            throw new IllegalArgumentException("location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("location", location);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/locations/";
        url = url + URLEncoder.encode(location, "UTF-8");
        url = url + "/usages";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UsagesListResponse result = null;
            if (statusCode == 200) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new UsagesListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode localizedValueValue;
                        JsonNode nameValue;
                        JsonNode limitValue;
                        JsonNode currentValueValue;
                        Usage usageInstance = new Usage();
                        result.getUsages().add(usageInstance);
                        JsonNode unitValue = valueValue.get("unit");
                        if (unitValue != null && !(unitValue instanceof NullNode)) {
                            String unitInstance = unitValue.getTextValue();
                            usageInstance.setUnit(unitInstance);
                        }
                        if ((currentValueValue = valueValue.get("currentValue")) != null && !(currentValueValue instanceof NullNode)) {
                            int currentValueInstance = currentValueValue.getIntValue();
                            usageInstance.setCurrentValue(currentValueInstance);
                        }
                        if ((limitValue = valueValue.get("limit")) != null && !(limitValue instanceof NullNode)) {
                            long limitInstance = limitValue.getLongValue();
                            usageInstance.setLimit(limitInstance);
                        }
                        if ((nameValue = valueValue.get("name")) == null || nameValue instanceof NullNode) continue;
                        UsageName nameInstance = new UsageName();
                        usageInstance.setName(nameInstance);
                        JsonNode valueValue2 = nameValue.get("value");
                        if (valueValue2 != null && !(valueValue2 instanceof NullNode)) {
                            String valueInstance = valueValue2.getTextValue();
                            nameInstance.setValue(valueInstance);
                        }
                        if ((localizedValueValue = nameValue.get("localizedValue")) == null || localizedValueValue instanceof NullNode) continue;
                        String localizedValueInstance = localizedValueValue.getTextValue();
                        nameInstance.setLocalizedValue(localizedValueInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            UsagesListResponse usagesListResponse = result;
            return usagesListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

