/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnectionOperations;
import com.microsoft.azure.management.network.models.AddressSpace;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.ConnectionResetSharedKey;
import com.microsoft.azure.management.network.models.ConnectionResetSharedKeyPutResponse;
import com.microsoft.azure.management.network.models.ConnectionSharedKey;
import com.microsoft.azure.management.network.models.ConnectionSharedKeyPutResponse;
import com.microsoft.azure.management.network.models.ConnectionSharedKeyResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.LocalNetworkGateway;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGateway;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayConnection;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayConnectionGetResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayConnectionListResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayConnectionPutResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayIpConfiguration;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class VirtualNetworkGatewayConnectionOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
VirtualNetworkGatewayConnectionOperations {
    private NetworkResourceProviderClientImpl client;

    VirtualNetworkGatewayConnectionOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualNetworkGatewayConnectionPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final VirtualNetworkGatewayConnection parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayConnectionPutResponse>(){

            @Override
            public VirtualNetworkGatewayConnectionPutResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayConnectionPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkGatewayConnectionName, VirtualNetworkGatewayConnection parameters) throws IOException, ServiceException {
        ObjectNode virtualNetworkGatewayConnectionJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocalNetworkGateway2() != null && parameters.getLocalNetworkGateway2().getLocation() == null) {
            throw new NullPointerException("parameters.LocalNetworkGateway2.Location");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getVirtualNetworkGateway1() != null && parameters.getVirtualNetworkGateway1().getLocation() == null) {
            throw new NullPointerException("parameters.VirtualNetworkGateway1.Location");
        }
        if (parameters.getVirtualNetworkGateway2() != null && parameters.getVirtualNetworkGateway2().getLocation() == null) {
            throw new NullPointerException("parameters.VirtualNetworkGateway2.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = virtualNetworkGatewayConnectionJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        virtualNetworkGatewayConnectionJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getVirtualNetworkGateway1() != null) {
            ObjectNode virtualNetworkGateway1Value = objectMapper.createObjectNode();
            propertiesValue.put("virtualNetworkGateway1", (JsonNode)virtualNetworkGateway1Value);
            if (parameters.getVirtualNetworkGateway1().getIpConfigurations() != null && (!(parameters.getVirtualNetworkGateway1().getIpConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getVirtualNetworkGateway1().getIpConfigurations()).isInitialized())) {
                ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
                for (VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfiguration : parameters.getVirtualNetworkGateway1().getIpConfigurations()) {
                    ObjectNode virtualNetworkGatewayIpConfigurationValue = objectMapper.createObjectNode();
                    ipConfigurationsArray.add((JsonNode)virtualNetworkGatewayIpConfigurationValue);
                    if (virtualNetworkGatewayIpConfiguration.getPrivateIpAddress() != null) {
                        virtualNetworkGatewayIpConfigurationValue.put("privateIPAddress", virtualNetworkGatewayIpConfiguration.getPrivateIpAddress());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getPrivateIpAllocationMethod() != null) {
                        virtualNetworkGatewayIpConfigurationValue.put("privateIPAllocationMethod", virtualNetworkGatewayIpConfiguration.getPrivateIpAllocationMethod());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getSubnet() != null) {
                        ObjectNode subnetValue = objectMapper.createObjectNode();
                        virtualNetworkGatewayIpConfigurationValue.put("subnet", (JsonNode)subnetValue);
                        if (virtualNetworkGatewayIpConfiguration.getSubnet().getId() != null) {
                            subnetValue.put("id", virtualNetworkGatewayIpConfiguration.getSubnet().getId());
                        }
                    }
                    if (virtualNetworkGatewayIpConfiguration.getPublicIpAddress() != null) {
                        ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                        virtualNetworkGatewayIpConfigurationValue.put("publicIPAddress", (JsonNode)publicIPAddressValue);
                        if (virtualNetworkGatewayIpConfiguration.getPublicIpAddress().getId() != null) {
                            publicIPAddressValue.put("id", virtualNetworkGatewayIpConfiguration.getPublicIpAddress().getId());
                        }
                    }
                    if (virtualNetworkGatewayIpConfiguration.getProvisioningState() != null) {
                        virtualNetworkGatewayIpConfigurationValue.put("provisioningState", virtualNetworkGatewayIpConfiguration.getProvisioningState());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getName() != null) {
                        virtualNetworkGatewayIpConfigurationValue.put("name", virtualNetworkGatewayIpConfiguration.getName());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getEtag() != null) {
                        virtualNetworkGatewayIpConfigurationValue.put("etag", virtualNetworkGatewayIpConfiguration.getEtag());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getId() == null) continue;
                    virtualNetworkGatewayIpConfigurationValue.put("id", virtualNetworkGatewayIpConfiguration.getId());
                }
                virtualNetworkGateway1Value.put("ipConfigurations", (JsonNode)ipConfigurationsArray);
            }
            if (parameters.getVirtualNetworkGateway1().getGatewayType() != null) {
                virtualNetworkGateway1Value.put("gatewayType", parameters.getVirtualNetworkGateway1().getGatewayType());
            }
            if (parameters.getVirtualNetworkGateway1().getVpnType() != null) {
                virtualNetworkGateway1Value.put("vpnType", parameters.getVirtualNetworkGateway1().getVpnType());
            }
            virtualNetworkGateway1Value.put("enableBgp", parameters.getVirtualNetworkGateway1().isEnableBgp());
            if (parameters.getVirtualNetworkGateway1().getProvisioningState() != null) {
                virtualNetworkGateway1Value.put("provisioningState", parameters.getVirtualNetworkGateway1().getProvisioningState());
            }
            if (parameters.getVirtualNetworkGateway1().getEtag() != null) {
                virtualNetworkGateway1Value.put("etag", parameters.getVirtualNetworkGateway1().getEtag());
            }
            if (parameters.getVirtualNetworkGateway1().getId() != null) {
                virtualNetworkGateway1Value.put("id", parameters.getVirtualNetworkGateway1().getId());
            }
            if (parameters.getVirtualNetworkGateway1().getName() != null) {
                virtualNetworkGateway1Value.put("name", parameters.getVirtualNetworkGateway1().getName());
            }
            if (parameters.getVirtualNetworkGateway1().getType() != null) {
                virtualNetworkGateway1Value.put("type", parameters.getVirtualNetworkGateway1().getType());
            }
            virtualNetworkGateway1Value.put("location", parameters.getVirtualNetworkGateway1().getLocation());
            if (parameters.getVirtualNetworkGateway1().getTags() != null) {
                ObjectNode tagsDictionary = objectMapper.createObjectNode();
                for (Map.Entry entry : parameters.getVirtualNetworkGateway1().getTags().entrySet()) {
                    String tagsKey = (String)entry.getKey();
                    String tagsValue = (String)entry.getValue();
                    tagsDictionary.put(tagsKey, tagsValue);
                }
                virtualNetworkGateway1Value.put("tags", (JsonNode)tagsDictionary);
            }
        }
        if (parameters.getVirtualNetworkGateway2() != null) {
            ObjectNode virtualNetworkGateway2Value = objectMapper.createObjectNode();
            propertiesValue.put("virtualNetworkGateway2", (JsonNode)virtualNetworkGateway2Value);
            if (parameters.getVirtualNetworkGateway2().getIpConfigurations() != null && (!(parameters.getVirtualNetworkGateway2().getIpConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getVirtualNetworkGateway2().getIpConfigurations()).isInitialized())) {
                ArrayNode ipConfigurationsArray2 = objectMapper.createArrayNode();
                for (VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfiguration : parameters.getVirtualNetworkGateway2().getIpConfigurations()) {
                    ObjectNode virtualNetworkGatewayIpConfigurationValue2 = objectMapper.createObjectNode();
                    ipConfigurationsArray2.add((JsonNode)virtualNetworkGatewayIpConfigurationValue2);
                    if (virtualNetworkGatewayIpConfiguration.getPrivateIpAddress() != null) {
                        virtualNetworkGatewayIpConfigurationValue2.put("privateIPAddress", virtualNetworkGatewayIpConfiguration.getPrivateIpAddress());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getPrivateIpAllocationMethod() != null) {
                        virtualNetworkGatewayIpConfigurationValue2.put("privateIPAllocationMethod", virtualNetworkGatewayIpConfiguration.getPrivateIpAllocationMethod());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getSubnet() != null) {
                        ObjectNode subnetValue2 = objectMapper.createObjectNode();
                        virtualNetworkGatewayIpConfigurationValue2.put("subnet", (JsonNode)subnetValue2);
                        if (virtualNetworkGatewayIpConfiguration.getSubnet().getId() != null) {
                            subnetValue2.put("id", virtualNetworkGatewayIpConfiguration.getSubnet().getId());
                        }
                    }
                    if (virtualNetworkGatewayIpConfiguration.getPublicIpAddress() != null) {
                        ObjectNode publicIPAddressValue2 = objectMapper.createObjectNode();
                        virtualNetworkGatewayIpConfigurationValue2.put("publicIPAddress", (JsonNode)publicIPAddressValue2);
                        if (virtualNetworkGatewayIpConfiguration.getPublicIpAddress().getId() != null) {
                            publicIPAddressValue2.put("id", virtualNetworkGatewayIpConfiguration.getPublicIpAddress().getId());
                        }
                    }
                    if (virtualNetworkGatewayIpConfiguration.getProvisioningState() != null) {
                        virtualNetworkGatewayIpConfigurationValue2.put("provisioningState", virtualNetworkGatewayIpConfiguration.getProvisioningState());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getName() != null) {
                        virtualNetworkGatewayIpConfigurationValue2.put("name", virtualNetworkGatewayIpConfiguration.getName());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getEtag() != null) {
                        virtualNetworkGatewayIpConfigurationValue2.put("etag", virtualNetworkGatewayIpConfiguration.getEtag());
                    }
                    if (virtualNetworkGatewayIpConfiguration.getId() == null) continue;
                    virtualNetworkGatewayIpConfigurationValue2.put("id", virtualNetworkGatewayIpConfiguration.getId());
                }
                virtualNetworkGateway2Value.put("ipConfigurations", (JsonNode)ipConfigurationsArray2);
            }
            if (parameters.getVirtualNetworkGateway2().getGatewayType() != null) {
                virtualNetworkGateway2Value.put("gatewayType", parameters.getVirtualNetworkGateway2().getGatewayType());
            }
            if (parameters.getVirtualNetworkGateway2().getVpnType() != null) {
                virtualNetworkGateway2Value.put("vpnType", parameters.getVirtualNetworkGateway2().getVpnType());
            }
            virtualNetworkGateway2Value.put("enableBgp", parameters.getVirtualNetworkGateway2().isEnableBgp());
            if (parameters.getVirtualNetworkGateway2().getProvisioningState() != null) {
                virtualNetworkGateway2Value.put("provisioningState", parameters.getVirtualNetworkGateway2().getProvisioningState());
            }
            if (parameters.getVirtualNetworkGateway2().getEtag() != null) {
                virtualNetworkGateway2Value.put("etag", parameters.getVirtualNetworkGateway2().getEtag());
            }
            if (parameters.getVirtualNetworkGateway2().getId() != null) {
                virtualNetworkGateway2Value.put("id", parameters.getVirtualNetworkGateway2().getId());
            }
            if (parameters.getVirtualNetworkGateway2().getName() != null) {
                virtualNetworkGateway2Value.put("name", parameters.getVirtualNetworkGateway2().getName());
            }
            if (parameters.getVirtualNetworkGateway2().getType() != null) {
                virtualNetworkGateway2Value.put("type", parameters.getVirtualNetworkGateway2().getType());
            }
            virtualNetworkGateway2Value.put("location", parameters.getVirtualNetworkGateway2().getLocation());
            if (parameters.getVirtualNetworkGateway2().getTags() != null) {
                ObjectNode tagsDictionary2 = objectMapper.createObjectNode();
                for (Map.Entry entry : parameters.getVirtualNetworkGateway2().getTags().entrySet()) {
                    String tagsKey2 = (String)entry.getKey();
                    String tagsValue2 = (String)entry.getValue();
                    tagsDictionary2.put(tagsKey2, tagsValue2);
                }
                virtualNetworkGateway2Value.put("tags", (JsonNode)tagsDictionary2);
            }
        }
        if (parameters.getLocalNetworkGateway2() != null) {
            ObjectNode localNetworkGateway2Value = objectMapper.createObjectNode();
            propertiesValue.put("localNetworkGateway2", (JsonNode)localNetworkGateway2Value);
            if (parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace() != null) {
                ObjectNode localNetworkAddressSpaceValue = objectMapper.createObjectNode();
                localNetworkGateway2Value.put("localNetworkAddressSpace", (JsonNode)localNetworkAddressSpaceValue);
                if (parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace().getAddressPrefixes() != null && (!(parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace().getAddressPrefixes() instanceof LazyCollection) || ((LazyCollection)parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace().getAddressPrefixes()).isInitialized())) {
                    ArrayNode addressPrefixesArray = objectMapper.createArrayNode();
                    for (String addressPrefixesItem : parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace().getAddressPrefixes()) {
                        addressPrefixesArray.add(addressPrefixesItem);
                    }
                    localNetworkAddressSpaceValue.put("addressPrefixes", (JsonNode)addressPrefixesArray);
                }
            }
            if (parameters.getLocalNetworkGateway2().getGatewayIpAddress() != null) {
                localNetworkGateway2Value.put("gatewayIpAddress", parameters.getLocalNetworkGateway2().getGatewayIpAddress());
            }
            if (parameters.getLocalNetworkGateway2().getProvisioningState() != null) {
                localNetworkGateway2Value.put("provisioningState", parameters.getLocalNetworkGateway2().getProvisioningState());
            }
            if (parameters.getLocalNetworkGateway2().getEtag() != null) {
                localNetworkGateway2Value.put("etag", parameters.getLocalNetworkGateway2().getEtag());
            }
            if (parameters.getLocalNetworkGateway2().getId() != null) {
                localNetworkGateway2Value.put("id", parameters.getLocalNetworkGateway2().getId());
            }
            if (parameters.getLocalNetworkGateway2().getName() != null) {
                localNetworkGateway2Value.put("name", parameters.getLocalNetworkGateway2().getName());
            }
            if (parameters.getLocalNetworkGateway2().getType() != null) {
                localNetworkGateway2Value.put("type", parameters.getLocalNetworkGateway2().getType());
            }
            localNetworkGateway2Value.put("location", parameters.getLocalNetworkGateway2().getLocation());
            if (parameters.getLocalNetworkGateway2().getTags() != null) {
                ObjectNode tagsDictionary3 = objectMapper.createObjectNode();
                for (Map.Entry entry : parameters.getLocalNetworkGateway2().getTags().entrySet()) {
                    String tagsKey3 = (String)entry.getKey();
                    String tagsValue3 = (String)entry.getValue();
                    tagsDictionary3.put(tagsKey3, tagsValue3);
                }
                localNetworkGateway2Value.put("tags", (JsonNode)tagsDictionary3);
            }
        }
        if (parameters.getConnectionType() != null) {
            propertiesValue.put("connectionType", parameters.getConnectionType());
        }
        propertiesValue.put("routingWeight", parameters.getRoutingWeight());
        if (parameters.getSharedKey() != null) {
            propertiesValue.put("sharedKey", parameters.getSharedKey());
        }
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            virtualNetworkGatewayConnectionJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            virtualNetworkGatewayConnectionJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            virtualNetworkGatewayConnectionJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            virtualNetworkGatewayConnectionJsonFormatValue.put("type", parameters.getType());
        }
        virtualNetworkGatewayConnectionJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary4 = objectMapper.createObjectNode();
            for (Map.Entry entry4 : parameters.getTags().entrySet()) {
                String string = (String)entry4.getKey();
                String tagsValue4 = (String)entry4.getValue();
                tagsDictionary4.put(string, tagsValue4);
            }
            virtualNetworkGatewayConnectionJsonFormatValue.put("tags", (JsonNode)tagsDictionary4);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int n;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((n = httpResponse.getStatusLine().getStatusCode()) != 200 && n != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayConnectionPutResponse result = null;
            if (n == 200 || n == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayConnectionPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement4;
                    JsonNode locationValue4;
                    JsonNode typeValue4;
                    JsonNode nameValue6;
                    JsonNode idValue10;
                    JsonNode etagValue6;
                    VirtualNetworkGatewayConnection virtualNetworkGatewayConnectionInstance = new VirtualNetworkGatewayConnection();
                    result.setVirtualNetworkGatewayConnection(virtualNetworkGatewayConnectionInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode provisioningStateValue6;
                        JsonNode sharedKeyValue;
                        JsonNode routingWeightValue;
                        JsonNode connectionTypeValue;
                        JsonNode localNetworkGateway2Value2;
                        JsonNode virtualNetworkGateway2Value2;
                        JsonNode virtualNetworkGateway1Value2 = propertiesValue2.get("virtualNetworkGateway1");
                        if (virtualNetworkGateway1Value2 != null && !(virtualNetworkGateway1Value2 instanceof NullNode)) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue4;
                            JsonNode etagValue2;
                            JsonNode provisioningStateValue2;
                            JsonNode enableBgpValue;
                            Object vpnTypeValue;
                            JsonNode gatewayTypeValue;
                            VirtualNetworkGateway virtualNetworkGateway1Instance = new VirtualNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setVirtualNetworkGateway1(virtualNetworkGateway1Instance);
                            JsonNode ipConfigurationsArray3 = virtualNetworkGateway1Value2.get("ipConfigurations");
                            if (ipConfigurationsArray3 != null && !(ipConfigurationsArray3 instanceof NullNode)) {
                                for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray3) {
                                    JsonNode idValue3;
                                    JsonNode etagValue;
                                    JsonNode nameValue;
                                    JsonNode provisioningStateValue;
                                    JsonNode publicIPAddressValue3;
                                    JsonNode subnetValue3;
                                    JsonNode privateIPAllocationMethodValue;
                                    VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance = new VirtualNetworkGatewayIpConfiguration();
                                    virtualNetworkGateway1Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance);
                                    JsonNode privateIPAddressValue = ipConfigurationsValue.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = ipConfigurationsValue.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue3 = ipConfigurationsValue.get("subnet")) != null && !(subnetValue3 instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue3.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((publicIPAddressValue3 = ipConfigurationsValue.get("publicIPAddress")) != null && !(publicIPAddressValue3 instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance.setPublicIpAddress(publicIPAddressInstance);
                                        JsonNode idValue2 = publicIPAddressValue3.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((provisioningStateValue = ipConfigurationsValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                    if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                        String nameInstance = nameValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setName(nameInstance);
                                    }
                                    if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                        String etagInstance = etagValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setEtag(etagInstance);
                                    }
                                    if ((idValue3 = ipConfigurationsValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                    String idInstance3 = idValue3.getTextValue();
                                    virtualNetworkGatewayIpConfigurationInstance.setId(idInstance3);
                                }
                            }
                            if ((gatewayTypeValue = virtualNetworkGateway1Value2.get("gatewayType")) != null && !(gatewayTypeValue instanceof NullNode)) {
                                String gatewayTypeInstance = gatewayTypeValue.getTextValue();
                                virtualNetworkGateway1Instance.setGatewayType(gatewayTypeInstance);
                            }
                            if ((vpnTypeValue = virtualNetworkGateway1Value2.get("vpnType")) != null && !(vpnTypeValue instanceof NullNode)) {
                                String vpnTypeInstance = vpnTypeValue.getTextValue();
                                virtualNetworkGateway1Instance.setVpnType(vpnTypeInstance);
                            }
                            if ((enableBgpValue = virtualNetworkGateway1Value2.get("enableBgp")) != null && !(enableBgpValue instanceof NullNode)) {
                                boolean enableBgpInstance = enableBgpValue.getBooleanValue();
                                virtualNetworkGateway1Instance.setEnableBgp(enableBgpInstance);
                            }
                            if ((provisioningStateValue2 = virtualNetworkGateway1Value2.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                virtualNetworkGateway1Instance.setProvisioningState(provisioningStateInstance2);
                            }
                            if ((etagValue2 = virtualNetworkGateway1Value2.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkGateway1Instance.setEtag(etagInstance2);
                            }
                            if ((idValue4 = virtualNetworkGateway1Value2.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                String idInstance4 = idValue4.getTextValue();
                                virtualNetworkGateway1Instance.setId(idInstance4);
                            }
                            if ((nameValue2 = virtualNetworkGateway1Value2.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkGateway1Instance.setName(nameInstance2);
                            }
                            if ((typeValue = virtualNetworkGateway1Value2.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                virtualNetworkGateway1Instance.setType(typeInstance);
                            }
                            if ((locationValue = virtualNetworkGateway1Value2.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                virtualNetworkGateway1Instance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = virtualNetworkGateway1Value2.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                                Iterator itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry property = (Map.Entry)itr.next();
                                    String tagsKey5 = (String)property.getKey();
                                    String tagsValue5 = ((JsonNode)property.getValue()).getTextValue();
                                    virtualNetworkGateway1Instance.getTags().put(tagsKey5, tagsValue5);
                                }
                            }
                        }
                        if ((virtualNetworkGateway2Value2 = propertiesValue2.get("virtualNetworkGateway2")) != null && !(virtualNetworkGateway2Value2 instanceof NullNode)) {
                            JsonNode tagsSequenceElement2;
                            JsonNode locationValue2;
                            JsonNode typeValue2;
                            JsonNode nameValue4;
                            JsonNode idValue8;
                            JsonNode etagValue4;
                            Object provisioningStateValue4;
                            JsonNode enableBgpValue2;
                            JsonNode vpnTypeValue2;
                            JsonNode gatewayTypeValue2;
                            VirtualNetworkGateway virtualNetworkGateway2Instance = new VirtualNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setVirtualNetworkGateway2(virtualNetworkGateway2Instance);
                            JsonNode ipConfigurationsArray4 = virtualNetworkGateway2Value2.get("ipConfigurations");
                            if (ipConfigurationsArray4 != null && !(ipConfigurationsArray4 instanceof NullNode)) {
                                for (JsonNode ipConfigurationsValue2 : (ArrayNode)ipConfigurationsArray4) {
                                    JsonNode idValue7;
                                    JsonNode etagValue3;
                                    JsonNode nameValue3;
                                    JsonNode provisioningStateValue3;
                                    JsonNode publicIPAddressValue4;
                                    JsonNode subnetValue4;
                                    JsonNode privateIPAllocationMethodValue2;
                                    VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance2 = new VirtualNetworkGatewayIpConfiguration();
                                    virtualNetworkGateway2Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance2);
                                    JsonNode privateIPAddressValue2 = ipConfigurationsValue2.get("privateIPAddress");
                                    if (privateIPAddressValue2 != null && !(privateIPAddressValue2 instanceof NullNode)) {
                                        String privateIPAddressInstance2 = privateIPAddressValue2.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAddress(privateIPAddressInstance2);
                                    }
                                    if ((privateIPAllocationMethodValue2 = ipConfigurationsValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue2 instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance2 = privateIPAllocationMethodValue2.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance2);
                                    }
                                    if ((subnetValue4 = ipConfigurationsValue2.get("subnet")) != null && !(subnetValue4 instanceof NullNode)) {
                                        ResourceId subnetInstance2 = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance2.setSubnet(subnetInstance2);
                                        JsonNode idValue5 = subnetValue4.get("id");
                                        if (idValue5 != null && !(idValue5 instanceof NullNode)) {
                                            String idInstance5 = idValue5.getTextValue();
                                            subnetInstance2.setId(idInstance5);
                                        }
                                    }
                                    if ((publicIPAddressValue4 = ipConfigurationsValue2.get("publicIPAddress")) != null && !(publicIPAddressValue4 instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance2 = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPublicIpAddress(publicIPAddressInstance2);
                                        JsonNode idValue6 = publicIPAddressValue4.get("id");
                                        if (idValue6 != null && !(idValue6 instanceof NullNode)) {
                                            String idInstance6 = idValue6.getTextValue();
                                            publicIPAddressInstance2.setId(idInstance6);
                                        }
                                    }
                                    if ((provisioningStateValue3 = ipConfigurationsValue2.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                        String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setProvisioningState(provisioningStateInstance3);
                                    }
                                    if ((nameValue3 = ipConfigurationsValue2.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                        String nameInstance3 = nameValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setName(nameInstance3);
                                    }
                                    if ((etagValue3 = ipConfigurationsValue2.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                        String etagInstance3 = etagValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setEtag(etagInstance3);
                                    }
                                    if ((idValue7 = ipConfigurationsValue2.get("id")) == null || idValue7 instanceof NullNode) continue;
                                    String idInstance7 = idValue7.getTextValue();
                                    virtualNetworkGatewayIpConfigurationInstance2.setId(idInstance7);
                                }
                            }
                            if ((gatewayTypeValue2 = virtualNetworkGateway2Value2.get("gatewayType")) != null && !(gatewayTypeValue2 instanceof NullNode)) {
                                String gatewayTypeInstance2 = gatewayTypeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setGatewayType(gatewayTypeInstance2);
                            }
                            if ((vpnTypeValue2 = virtualNetworkGateway2Value2.get("vpnType")) != null && !(vpnTypeValue2 instanceof NullNode)) {
                                String vpnTypeInstance2 = vpnTypeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setVpnType(vpnTypeInstance2);
                            }
                            if ((enableBgpValue2 = virtualNetworkGateway2Value2.get("enableBgp")) != null && !(enableBgpValue2 instanceof NullNode)) {
                                boolean enableBgpInstance2 = enableBgpValue2.getBooleanValue();
                                virtualNetworkGateway2Instance.setEnableBgp(enableBgpInstance2);
                            }
                            if ((provisioningStateValue4 = virtualNetworkGateway2Value2.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                virtualNetworkGateway2Instance.setProvisioningState(provisioningStateInstance4);
                            }
                            if ((etagValue4 = virtualNetworkGateway2Value2.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                String etagInstance4 = etagValue4.getTextValue();
                                virtualNetworkGateway2Instance.setEtag(etagInstance4);
                            }
                            if ((idValue8 = virtualNetworkGateway2Value2.get("id")) != null && !(idValue8 instanceof NullNode)) {
                                String idInstance8 = idValue8.getTextValue();
                                virtualNetworkGateway2Instance.setId(idInstance8);
                            }
                            if ((nameValue4 = virtualNetworkGateway2Value2.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                String nameInstance4 = nameValue4.getTextValue();
                                virtualNetworkGateway2Instance.setName(nameInstance4);
                            }
                            if ((typeValue2 = virtualNetworkGateway2Value2.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                String typeInstance2 = typeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setType(typeInstance2);
                            }
                            if ((locationValue2 = virtualNetworkGateway2Value2.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                                String locationInstance2 = locationValue2.getTextValue();
                                virtualNetworkGateway2Instance.setLocation(locationInstance2);
                            }
                            if ((tagsSequenceElement2 = virtualNetworkGateway2Value2.get("tags")) != null && !(tagsSequenceElement2 instanceof NullNode)) {
                                Iterator itr2 = tagsSequenceElement2.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry property2 = (Map.Entry)itr2.next();
                                    String tagsKey6 = (String)property2.getKey();
                                    String tagsValue6 = ((JsonNode)property2.getValue()).getTextValue();
                                    virtualNetworkGateway2Instance.getTags().put(tagsKey6, tagsValue6);
                                }
                            }
                        }
                        if ((localNetworkGateway2Value2 = propertiesValue2.get("localNetworkGateway2")) != null && !(localNetworkGateway2Value2 instanceof NullNode)) {
                            Object tagsSequenceElement3;
                            JsonNode locationValue3;
                            JsonNode typeValue3;
                            JsonNode nameValue5;
                            JsonNode idValue9;
                            JsonNode etagValue5;
                            JsonNode provisioningStateValue5;
                            JsonNode gatewayIpAddressValue;
                            LocalNetworkGateway localNetworkGateway2Instance = new LocalNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setLocalNetworkGateway2(localNetworkGateway2Instance);
                            JsonNode localNetworkAddressSpaceValue2 = localNetworkGateway2Value2.get("localNetworkAddressSpace");
                            if (localNetworkAddressSpaceValue2 != null && !(localNetworkAddressSpaceValue2 instanceof NullNode)) {
                                AddressSpace localNetworkAddressSpaceInstance = new AddressSpace();
                                localNetworkGateway2Instance.setLocalNetworkAddressSpace(localNetworkAddressSpaceInstance);
                                JsonNode addressPrefixesArray2 = localNetworkAddressSpaceValue2.get("addressPrefixes");
                                if (addressPrefixesArray2 != null && !(addressPrefixesArray2 instanceof NullNode)) {
                                    for (JsonNode addressPrefixesValue : (ArrayNode)addressPrefixesArray2) {
                                        localNetworkAddressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                    }
                                }
                            }
                            if ((gatewayIpAddressValue = localNetworkGateway2Value2.get("gatewayIpAddress")) != null && !(gatewayIpAddressValue instanceof NullNode)) {
                                String gatewayIpAddressInstance = gatewayIpAddressValue.getTextValue();
                                localNetworkGateway2Instance.setGatewayIpAddress(gatewayIpAddressInstance);
                            }
                            if ((provisioningStateValue5 = localNetworkGateway2Value2.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                localNetworkGateway2Instance.setProvisioningState(provisioningStateInstance5);
                            }
                            if ((etagValue5 = localNetworkGateway2Value2.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                String etagInstance5 = etagValue5.getTextValue();
                                localNetworkGateway2Instance.setEtag(etagInstance5);
                            }
                            if ((idValue9 = localNetworkGateway2Value2.get("id")) != null && !(idValue9 instanceof NullNode)) {
                                String idInstance9 = idValue9.getTextValue();
                                localNetworkGateway2Instance.setId(idInstance9);
                            }
                            if ((nameValue5 = localNetworkGateway2Value2.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                String nameInstance5 = nameValue5.getTextValue();
                                localNetworkGateway2Instance.setName(nameInstance5);
                            }
                            if ((typeValue3 = localNetworkGateway2Value2.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                String typeInstance3 = typeValue3.getTextValue();
                                localNetworkGateway2Instance.setType(typeInstance3);
                            }
                            if ((locationValue3 = localNetworkGateway2Value2.get("location")) != null && !(locationValue3 instanceof NullNode)) {
                                String locationInstance3 = locationValue3.getTextValue();
                                localNetworkGateway2Instance.setLocation(locationInstance3);
                            }
                            if ((tagsSequenceElement3 = localNetworkGateway2Value2.get("tags")) != null && !(tagsSequenceElement3 instanceof NullNode)) {
                                Iterator itr3 = tagsSequenceElement3.getFields();
                                while (itr3.hasNext()) {
                                    Map.Entry property3 = (Map.Entry)itr3.next();
                                    String tagsKey7 = (String)property3.getKey();
                                    String tagsValue7 = ((JsonNode)property3.getValue()).getTextValue();
                                    localNetworkGateway2Instance.getTags().put(tagsKey7, tagsValue7);
                                }
                            }
                        }
                        if ((connectionTypeValue = propertiesValue2.get("connectionType")) != null && !(connectionTypeValue instanceof NullNode)) {
                            String connectionTypeInstance = connectionTypeValue.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setConnectionType(connectionTypeInstance);
                        }
                        if ((routingWeightValue = propertiesValue2.get("routingWeight")) != null && !(routingWeightValue instanceof NullNode)) {
                            int routingWeightInstance = routingWeightValue.getIntValue();
                            virtualNetworkGatewayConnectionInstance.setRoutingWeight(routingWeightInstance);
                        }
                        if ((sharedKeyValue = propertiesValue2.get("sharedKey")) != null && !(sharedKeyValue instanceof NullNode)) {
                            String sharedKeyInstance = sharedKeyValue.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setSharedKey(sharedKeyInstance);
                        }
                        if ((provisioningStateValue6 = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                            String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setProvisioningState(provisioningStateInstance6);
                        }
                    }
                    if ((etagValue6 = responseDoc.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                        String etagInstance6 = etagValue6.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setEtag(etagInstance6);
                    }
                    if ((idValue10 = responseDoc.get("id")) != null && !(idValue10 instanceof NullNode)) {
                        String idInstance10 = idValue10.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setId(idInstance10);
                    }
                    if ((nameValue6 = responseDoc.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                        String nameInstance6 = nameValue6.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setName(nameInstance6);
                    }
                    if ((typeValue4 = responseDoc.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                        String typeInstance4 = typeValue4.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setType(typeInstance4);
                    }
                    if ((locationValue4 = responseDoc.get("location")) != null && !(locationValue4 instanceof NullNode)) {
                        String locationInstance4 = locationValue4.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setLocation(locationInstance4);
                    }
                    if ((tagsSequenceElement4 = responseDoc.get("tags")) != null && !(tagsSequenceElement4 instanceof NullNode)) {
                        Iterator itr4 = tagsSequenceElement4.getFields();
                        while (itr4.hasNext()) {
                            Map.Entry property4 = (Map.Entry)itr4.next();
                            String tagsKey8 = (String)property4.getKey();
                            String tagsValue8 = ((JsonNode)property4.getValue()).getTextValue();
                            virtualNetworkGatewayConnectionInstance.getTags().put(tagsKey8, tagsValue8);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(n);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkGatewayConnectionPutResponse virtualNetworkGatewayConnectionPutResponse = result;
            return virtualNetworkGatewayConnectionPutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.beginDeleting(resourceGroupName, virtualNetworkGatewayConnectionName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkGatewayConnectionName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ConnectionResetSharedKeyPutResponse> beginResetSharedKeyAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final ConnectionResetSharedKey parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ConnectionResetSharedKeyPutResponse>(){

            @Override
            public ConnectionResetSharedKeyPutResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.beginResetSharedKey(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResetSharedKeyPutResponse beginResetSharedKey(String resourceGroupName, String virtualNetworkGatewayConnectionName, ConnectionResetSharedKey parameters) throws IOException, ServiceException {
        ObjectNode connectionResetSharedKeyJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginResetSharedKeyAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        url = url + "/sharedkey/reset";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = connectionResetSharedKeyJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        connectionResetSharedKeyJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        propertiesValue.put("keyLength", parameters.getKeyLength());
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ConnectionResetSharedKeyPutResponse result = null;
            if (statusCode == 200 || statusCode == 202) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ConnectionResetSharedKeyPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode keyLengthValue;
                    ConnectionResetSharedKey connectionResetSharedKeyInstance = new ConnectionResetSharedKey();
                    result.setConnectionResetSharedKey(connectionResetSharedKeyInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode) && (keyLengthValue = propertiesValue2.get("keyLength")) != null && !(keyLengthValue instanceof NullNode)) {
                        long keyLengthInstance = keyLengthValue.getLongValue();
                        connectionResetSharedKeyInstance.setKeyLength(keyLengthInstance);
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ConnectionResetSharedKeyPutResponse connectionResetSharedKeyPutResponse = result;
            return connectionResetSharedKeyPutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ConnectionSharedKeyPutResponse> beginSetSharedKeyAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final ConnectionSharedKey parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ConnectionSharedKeyPutResponse>(){

            @Override
            public ConnectionSharedKeyPutResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.beginSetSharedKey(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionSharedKeyPutResponse beginSetSharedKey(String resourceGroupName, String virtualNetworkGatewayConnectionName, ConnectionSharedKey parameters) throws IOException, ServiceException {
        ObjectNode connectionSharedKeyJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginSetSharedKeyAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        url = url + "/sharedkey";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = connectionSharedKeyJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        connectionSharedKeyJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getValue() != null) {
            propertiesValue.put("value", parameters.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ConnectionSharedKeyPutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ConnectionSharedKeyPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode valueValue;
                    ConnectionSharedKey connectionSharedKeyInstance = new ConnectionSharedKey();
                    result.setConnectionSharedKey(connectionSharedKeyInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode) && (valueValue = propertiesValue2.get("value")) != null && !(valueValue instanceof NullNode)) {
                        String valueInstance = valueValue.getTextValue();
                        connectionSharedKeyInstance.setValue(valueInstance);
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ConnectionSharedKeyPutResponse connectionSharedKeyPutResponse = result;
            return connectionSharedKeyPutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final VirtualNetworkGatewayConnection parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.createOrUpdate(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkGatewayConnectionName, VirtualNetworkGatewayConnection parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            VirtualNetworkGatewayConnectionPutResponse response = client2.getVirtualNetworkGatewayConnectionsOperations().beginCreateOrUpdatingAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.delete(resourceGroupName, virtualNetworkGatewayConnectionName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String virtualNetworkGatewayConnectionName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getVirtualNetworkGatewayConnectionsOperations().beginDeletingAsync(resourceGroupName, virtualNetworkGatewayConnectionName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkGatewayConnectionGetResponse> getAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayConnectionGetResponse>(){

            @Override
            public VirtualNetworkGatewayConnectionGetResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.get(resourceGroupName, virtualNetworkGatewayConnectionName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayConnectionGetResponse get(String resourceGroupName, String virtualNetworkGatewayConnectionName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayConnectionGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayConnectionGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement4;
                    JsonNode locationValue4;
                    JsonNode typeValue4;
                    JsonNode nameValue6;
                    JsonNode idValue10;
                    JsonNode etagValue6;
                    VirtualNetworkGatewayConnection virtualNetworkGatewayConnectionInstance = new VirtualNetworkGatewayConnection();
                    result.setVirtualNetworkGatewayConnection(virtualNetworkGatewayConnectionInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue6;
                        JsonNode sharedKeyValue;
                        JsonNode routingWeightValue;
                        JsonNode connectionTypeValue;
                        JsonNode localNetworkGateway2Value;
                        JsonNode virtualNetworkGateway2Value;
                        JsonNode virtualNetworkGateway1Value = propertiesValue.get("virtualNetworkGateway1");
                        if (virtualNetworkGateway1Value != null && !(virtualNetworkGateway1Value instanceof NullNode)) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue4;
                            JsonNode etagValue2;
                            JsonNode provisioningStateValue2;
                            JsonNode enableBgpValue;
                            Object vpnTypeValue;
                            JsonNode gatewayTypeValue;
                            VirtualNetworkGateway virtualNetworkGateway1Instance = new VirtualNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setVirtualNetworkGateway1(virtualNetworkGateway1Instance);
                            JsonNode ipConfigurationsArray = virtualNetworkGateway1Value.get("ipConfigurations");
                            if (ipConfigurationsArray != null && !(ipConfigurationsArray instanceof NullNode)) {
                                for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                    JsonNode idValue3;
                                    JsonNode etagValue;
                                    JsonNode nameValue;
                                    JsonNode provisioningStateValue;
                                    JsonNode publicIPAddressValue;
                                    JsonNode subnetValue;
                                    JsonNode privateIPAllocationMethodValue;
                                    VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance = new VirtualNetworkGatewayIpConfiguration();
                                    virtualNetworkGateway1Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance);
                                    JsonNode privateIPAddressValue = ipConfigurationsValue.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = ipConfigurationsValue.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue = ipConfigurationsValue.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((publicIPAddressValue = ipConfigurationsValue.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance.setPublicIpAddress(publicIPAddressInstance);
                                        JsonNode idValue2 = publicIPAddressValue.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((provisioningStateValue = ipConfigurationsValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                    if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                        String nameInstance = nameValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setName(nameInstance);
                                    }
                                    if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                        String etagInstance = etagValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setEtag(etagInstance);
                                    }
                                    if ((idValue3 = ipConfigurationsValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                    String idInstance3 = idValue3.getTextValue();
                                    virtualNetworkGatewayIpConfigurationInstance.setId(idInstance3);
                                }
                            }
                            if ((gatewayTypeValue = virtualNetworkGateway1Value.get("gatewayType")) != null && !(gatewayTypeValue instanceof NullNode)) {
                                String gatewayTypeInstance = gatewayTypeValue.getTextValue();
                                virtualNetworkGateway1Instance.setGatewayType(gatewayTypeInstance);
                            }
                            if ((vpnTypeValue = virtualNetworkGateway1Value.get("vpnType")) != null && !(vpnTypeValue instanceof NullNode)) {
                                String vpnTypeInstance = vpnTypeValue.getTextValue();
                                virtualNetworkGateway1Instance.setVpnType(vpnTypeInstance);
                            }
                            if ((enableBgpValue = virtualNetworkGateway1Value.get("enableBgp")) != null && !(enableBgpValue instanceof NullNode)) {
                                boolean enableBgpInstance = enableBgpValue.getBooleanValue();
                                virtualNetworkGateway1Instance.setEnableBgp(enableBgpInstance);
                            }
                            if ((provisioningStateValue2 = virtualNetworkGateway1Value.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                virtualNetworkGateway1Instance.setProvisioningState(provisioningStateInstance2);
                            }
                            if ((etagValue2 = virtualNetworkGateway1Value.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkGateway1Instance.setEtag(etagInstance2);
                            }
                            if ((idValue4 = virtualNetworkGateway1Value.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                String idInstance4 = idValue4.getTextValue();
                                virtualNetworkGateway1Instance.setId(idInstance4);
                            }
                            if ((nameValue2 = virtualNetworkGateway1Value.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkGateway1Instance.setName(nameInstance2);
                            }
                            if ((typeValue = virtualNetworkGateway1Value.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                virtualNetworkGateway1Instance.setType(typeInstance);
                            }
                            if ((locationValue = virtualNetworkGateway1Value.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                virtualNetworkGateway1Instance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = virtualNetworkGateway1Value.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                                Iterator itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry property = (Map.Entry)itr.next();
                                    String tagsKey = (String)property.getKey();
                                    String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                    virtualNetworkGateway1Instance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                        if ((virtualNetworkGateway2Value = propertiesValue.get("virtualNetworkGateway2")) != null && !(virtualNetworkGateway2Value instanceof NullNode)) {
                            JsonNode tagsSequenceElement2;
                            JsonNode locationValue2;
                            JsonNode typeValue2;
                            JsonNode nameValue4;
                            JsonNode idValue8;
                            JsonNode etagValue4;
                            Object provisioningStateValue4;
                            JsonNode enableBgpValue2;
                            JsonNode vpnTypeValue2;
                            JsonNode gatewayTypeValue2;
                            VirtualNetworkGateway virtualNetworkGateway2Instance = new VirtualNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setVirtualNetworkGateway2(virtualNetworkGateway2Instance);
                            JsonNode ipConfigurationsArray2 = virtualNetworkGateway2Value.get("ipConfigurations");
                            if (ipConfigurationsArray2 != null && !(ipConfigurationsArray2 instanceof NullNode)) {
                                for (JsonNode ipConfigurationsValue2 : (ArrayNode)ipConfigurationsArray2) {
                                    JsonNode idValue7;
                                    JsonNode etagValue3;
                                    JsonNode nameValue3;
                                    JsonNode provisioningStateValue3;
                                    JsonNode publicIPAddressValue2;
                                    JsonNode subnetValue2;
                                    JsonNode privateIPAllocationMethodValue2;
                                    VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance2 = new VirtualNetworkGatewayIpConfiguration();
                                    virtualNetworkGateway2Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance2);
                                    JsonNode privateIPAddressValue2 = ipConfigurationsValue2.get("privateIPAddress");
                                    if (privateIPAddressValue2 != null && !(privateIPAddressValue2 instanceof NullNode)) {
                                        String privateIPAddressInstance2 = privateIPAddressValue2.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAddress(privateIPAddressInstance2);
                                    }
                                    if ((privateIPAllocationMethodValue2 = ipConfigurationsValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue2 instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance2 = privateIPAllocationMethodValue2.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance2);
                                    }
                                    if ((subnetValue2 = ipConfigurationsValue2.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                        ResourceId subnetInstance2 = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance2.setSubnet(subnetInstance2);
                                        JsonNode idValue5 = subnetValue2.get("id");
                                        if (idValue5 != null && !(idValue5 instanceof NullNode)) {
                                            String idInstance5 = idValue5.getTextValue();
                                            subnetInstance2.setId(idInstance5);
                                        }
                                    }
                                    if ((publicIPAddressValue2 = ipConfigurationsValue2.get("publicIPAddress")) != null && !(publicIPAddressValue2 instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance2 = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPublicIpAddress(publicIPAddressInstance2);
                                        JsonNode idValue6 = publicIPAddressValue2.get("id");
                                        if (idValue6 != null && !(idValue6 instanceof NullNode)) {
                                            String idInstance6 = idValue6.getTextValue();
                                            publicIPAddressInstance2.setId(idInstance6);
                                        }
                                    }
                                    if ((provisioningStateValue3 = ipConfigurationsValue2.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                        String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setProvisioningState(provisioningStateInstance3);
                                    }
                                    if ((nameValue3 = ipConfigurationsValue2.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                        String nameInstance3 = nameValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setName(nameInstance3);
                                    }
                                    if ((etagValue3 = ipConfigurationsValue2.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                        String etagInstance3 = etagValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setEtag(etagInstance3);
                                    }
                                    if ((idValue7 = ipConfigurationsValue2.get("id")) == null || idValue7 instanceof NullNode) continue;
                                    String idInstance7 = idValue7.getTextValue();
                                    virtualNetworkGatewayIpConfigurationInstance2.setId(idInstance7);
                                }
                            }
                            if ((gatewayTypeValue2 = virtualNetworkGateway2Value.get("gatewayType")) != null && !(gatewayTypeValue2 instanceof NullNode)) {
                                String gatewayTypeInstance2 = gatewayTypeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setGatewayType(gatewayTypeInstance2);
                            }
                            if ((vpnTypeValue2 = virtualNetworkGateway2Value.get("vpnType")) != null && !(vpnTypeValue2 instanceof NullNode)) {
                                String vpnTypeInstance2 = vpnTypeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setVpnType(vpnTypeInstance2);
                            }
                            if ((enableBgpValue2 = virtualNetworkGateway2Value.get("enableBgp")) != null && !(enableBgpValue2 instanceof NullNode)) {
                                boolean enableBgpInstance2 = enableBgpValue2.getBooleanValue();
                                virtualNetworkGateway2Instance.setEnableBgp(enableBgpInstance2);
                            }
                            if ((provisioningStateValue4 = virtualNetworkGateway2Value.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                virtualNetworkGateway2Instance.setProvisioningState(provisioningStateInstance4);
                            }
                            if ((etagValue4 = virtualNetworkGateway2Value.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                String etagInstance4 = etagValue4.getTextValue();
                                virtualNetworkGateway2Instance.setEtag(etagInstance4);
                            }
                            if ((idValue8 = virtualNetworkGateway2Value.get("id")) != null && !(idValue8 instanceof NullNode)) {
                                String idInstance8 = idValue8.getTextValue();
                                virtualNetworkGateway2Instance.setId(idInstance8);
                            }
                            if ((nameValue4 = virtualNetworkGateway2Value.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                String nameInstance4 = nameValue4.getTextValue();
                                virtualNetworkGateway2Instance.setName(nameInstance4);
                            }
                            if ((typeValue2 = virtualNetworkGateway2Value.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                String typeInstance2 = typeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setType(typeInstance2);
                            }
                            if ((locationValue2 = virtualNetworkGateway2Value.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                                String locationInstance2 = locationValue2.getTextValue();
                                virtualNetworkGateway2Instance.setLocation(locationInstance2);
                            }
                            if ((tagsSequenceElement2 = virtualNetworkGateway2Value.get("tags")) != null && !(tagsSequenceElement2 instanceof NullNode)) {
                                Iterator itr2 = tagsSequenceElement2.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry property2 = (Map.Entry)itr2.next();
                                    String tagsKey2 = (String)property2.getKey();
                                    String tagsValue2 = ((JsonNode)property2.getValue()).getTextValue();
                                    virtualNetworkGateway2Instance.getTags().put(tagsKey2, tagsValue2);
                                }
                            }
                        }
                        if ((localNetworkGateway2Value = propertiesValue.get("localNetworkGateway2")) != null && !(localNetworkGateway2Value instanceof NullNode)) {
                            JsonNode tagsSequenceElement3;
                            JsonNode locationValue3;
                            JsonNode typeValue3;
                            JsonNode nameValue5;
                            JsonNode idValue9;
                            JsonNode etagValue5;
                            JsonNode provisioningStateValue5;
                            JsonNode gatewayIpAddressValue;
                            LocalNetworkGateway localNetworkGateway2Instance = new LocalNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setLocalNetworkGateway2(localNetworkGateway2Instance);
                            JsonNode localNetworkAddressSpaceValue = localNetworkGateway2Value.get("localNetworkAddressSpace");
                            if (localNetworkAddressSpaceValue != null && !(localNetworkAddressSpaceValue instanceof NullNode)) {
                                AddressSpace localNetworkAddressSpaceInstance = new AddressSpace();
                                localNetworkGateway2Instance.setLocalNetworkAddressSpace(localNetworkAddressSpaceInstance);
                                JsonNode addressPrefixesArray = localNetworkAddressSpaceValue.get("addressPrefixes");
                                if (addressPrefixesArray != null && !(addressPrefixesArray instanceof NullNode)) {
                                    for (JsonNode addressPrefixesValue : (ArrayNode)addressPrefixesArray) {
                                        localNetworkAddressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                    }
                                }
                            }
                            if ((gatewayIpAddressValue = localNetworkGateway2Value.get("gatewayIpAddress")) != null && !(gatewayIpAddressValue instanceof NullNode)) {
                                String gatewayIpAddressInstance = gatewayIpAddressValue.getTextValue();
                                localNetworkGateway2Instance.setGatewayIpAddress(gatewayIpAddressInstance);
                            }
                            if ((provisioningStateValue5 = localNetworkGateway2Value.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                localNetworkGateway2Instance.setProvisioningState(provisioningStateInstance5);
                            }
                            if ((etagValue5 = localNetworkGateway2Value.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                String etagInstance5 = etagValue5.getTextValue();
                                localNetworkGateway2Instance.setEtag(etagInstance5);
                            }
                            if ((idValue9 = localNetworkGateway2Value.get("id")) != null && !(idValue9 instanceof NullNode)) {
                                String idInstance9 = idValue9.getTextValue();
                                localNetworkGateway2Instance.setId(idInstance9);
                            }
                            if ((nameValue5 = localNetworkGateway2Value.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                String nameInstance5 = nameValue5.getTextValue();
                                localNetworkGateway2Instance.setName(nameInstance5);
                            }
                            if ((typeValue3 = localNetworkGateway2Value.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                String typeInstance3 = typeValue3.getTextValue();
                                localNetworkGateway2Instance.setType(typeInstance3);
                            }
                            if ((locationValue3 = localNetworkGateway2Value.get("location")) != null && !(locationValue3 instanceof NullNode)) {
                                String locationInstance3 = locationValue3.getTextValue();
                                localNetworkGateway2Instance.setLocation(locationInstance3);
                            }
                            if ((tagsSequenceElement3 = localNetworkGateway2Value.get("tags")) != null && !(tagsSequenceElement3 instanceof NullNode)) {
                                Iterator itr3 = tagsSequenceElement3.getFields();
                                while (itr3.hasNext()) {
                                    Map.Entry property3 = (Map.Entry)itr3.next();
                                    String tagsKey3 = (String)property3.getKey();
                                    String tagsValue3 = ((JsonNode)property3.getValue()).getTextValue();
                                    localNetworkGateway2Instance.getTags().put(tagsKey3, tagsValue3);
                                }
                            }
                        }
                        if ((connectionTypeValue = propertiesValue.get("connectionType")) != null && !(connectionTypeValue instanceof NullNode)) {
                            String connectionTypeInstance = connectionTypeValue.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setConnectionType(connectionTypeInstance);
                        }
                        if ((routingWeightValue = propertiesValue.get("routingWeight")) != null && !(routingWeightValue instanceof NullNode)) {
                            int routingWeightInstance = routingWeightValue.getIntValue();
                            virtualNetworkGatewayConnectionInstance.setRoutingWeight(routingWeightInstance);
                        }
                        if ((sharedKeyValue = propertiesValue.get("sharedKey")) != null && !(sharedKeyValue instanceof NullNode)) {
                            String sharedKeyInstance = sharedKeyValue.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setSharedKey(sharedKeyInstance);
                        }
                        if ((provisioningStateValue6 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                            String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setProvisioningState(provisioningStateInstance6);
                        }
                    }
                    if ((etagValue6 = responseDoc.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                        String etagInstance6 = etagValue6.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setEtag(etagInstance6);
                    }
                    if ((idValue10 = responseDoc.get("id")) != null && !(idValue10 instanceof NullNode)) {
                        String idInstance10 = idValue10.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setId(idInstance10);
                    }
                    if ((nameValue6 = responseDoc.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                        String nameInstance6 = nameValue6.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setName(nameInstance6);
                    }
                    if ((typeValue4 = responseDoc.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                        String typeInstance4 = typeValue4.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setType(typeInstance4);
                    }
                    if ((locationValue4 = responseDoc.get("location")) != null && !(locationValue4 instanceof NullNode)) {
                        String locationInstance4 = locationValue4.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setLocation(locationInstance4);
                    }
                    if ((tagsSequenceElement4 = responseDoc.get("tags")) != null && !(tagsSequenceElement4 instanceof NullNode)) {
                        Iterator itr4 = tagsSequenceElement4.getFields();
                        while (itr4.hasNext()) {
                            Map.Entry property4 = (Map.Entry)itr4.next();
                            String tagsKey4 = (String)property4.getKey();
                            String tagsValue4 = ((JsonNode)property4.getValue()).getTextValue();
                            virtualNetworkGatewayConnectionInstance.getTags().put(tagsKey4, tagsValue4);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkGatewayConnectionGetResponse virtualNetworkGatewayConnectionGetResponse = result;
            return virtualNetworkGatewayConnectionGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ConnectionSharedKeyResponse> getSharedKeyAsync(final String resourceGroupName, final String connectionSharedKeyName) {
        return this.getClient().getExecutorService().submit(new Callable<ConnectionSharedKeyResponse>(){

            @Override
            public ConnectionSharedKeyResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.getSharedKey(resourceGroupName, connectionSharedKeyName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionSharedKeyResponse getSharedKey(String resourceGroupName, String connectionSharedKeyName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (connectionSharedKeyName == null) {
            throw new NullPointerException("connectionSharedKeyName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("connectionSharedKeyName", connectionSharedKeyName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getSharedKeyAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(connectionSharedKeyName, "UTF-8");
        url = url + "/sharedkey";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ConnectionSharedKeyResponse result = null;
            if (statusCode == 200) {
                JsonNode valueValue;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ConnectionSharedKeyResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueValue = responseDoc.get("value")) != null && !(valueValue instanceof NullNode)) {
                    String valueInstance = valueValue.getTextValue();
                    result.setValue(valueInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ConnectionSharedKeyResponse connectionSharedKeyResponse = result;
            return connectionSharedKeyResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkGatewayConnectionListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayConnectionListResponse>(){

            @Override
            public VirtualNetworkGatewayConnectionListResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayConnectionListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayConnectionListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayConnectionListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement4;
                            JsonNode locationValue4;
                            JsonNode typeValue4;
                            JsonNode nameValue6;
                            JsonNode idValue10;
                            JsonNode etagValue6;
                            VirtualNetworkGatewayConnection virtualNetworkGatewayConnectionJsonFormatInstance = new VirtualNetworkGatewayConnection();
                            result.getVirtualNetworkGatewayConnections().add(virtualNetworkGatewayConnectionJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue6;
                                JsonNode sharedKeyValue;
                                JsonNode routingWeightValue;
                                JsonNode connectionTypeValue;
                                JsonNode localNetworkGateway2Value;
                                Object provisioningStateValue4;
                                JsonNode virtualNetworkGateway2Value;
                                Object vpnTypeValue;
                                JsonNode virtualNetworkGateway1Value = propertiesValue.get("virtualNetworkGateway1");
                                if (virtualNetworkGateway1Value != null && !(virtualNetworkGateway1Value instanceof NullNode)) {
                                    JsonNode tagsSequenceElement;
                                    JsonNode locationValue;
                                    JsonNode typeValue;
                                    JsonNode nameValue2;
                                    JsonNode idValue4;
                                    JsonNode etagValue2;
                                    JsonNode provisioningStateValue2;
                                    JsonNode enableBgpValue;
                                    JsonNode gatewayTypeValue;
                                    VirtualNetworkGateway virtualNetworkGateway1Instance = new VirtualNetworkGateway();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setVirtualNetworkGateway1(virtualNetworkGateway1Instance);
                                    JsonNode ipConfigurationsArray = virtualNetworkGateway1Value.get("ipConfigurations");
                                    if (ipConfigurationsArray != null && !(ipConfigurationsArray instanceof NullNode)) {
                                        for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                            JsonNode idValue3;
                                            JsonNode etagValue;
                                            JsonNode nameValue;
                                            JsonNode provisioningStateValue;
                                            JsonNode publicIPAddressValue;
                                            JsonNode subnetValue;
                                            JsonNode privateIPAllocationMethodValue;
                                            VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance = new VirtualNetworkGatewayIpConfiguration();
                                            virtualNetworkGateway1Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance);
                                            JsonNode privateIPAddressValue = ipConfigurationsValue.get("privateIPAddress");
                                            if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                                String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            if ((privateIPAllocationMethodValue = ipConfigurationsValue.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            if ((subnetValue = ipConfigurationsValue.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                                ResourceId subnetInstance = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationInstance.setSubnet(subnetInstance);
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            if ((publicIPAddressValue = ipConfigurationsValue.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationInstance.setPublicIpAddress(publicIPAddressInstance);
                                                JsonNode idValue2 = publicIPAddressValue.get("id");
                                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                                    String idInstance2 = idValue2.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance2);
                                                }
                                            }
                                            if ((provisioningStateValue = ipConfigurationsValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                            if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                                String nameInstance = nameValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setName(nameInstance);
                                            }
                                            if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                                String etagInstance = etagValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setEtag(etagInstance);
                                            }
                                            if ((idValue3 = ipConfigurationsValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                            String idInstance3 = idValue3.getTextValue();
                                            virtualNetworkGatewayIpConfigurationInstance.setId(idInstance3);
                                        }
                                    }
                                    if ((gatewayTypeValue = virtualNetworkGateway1Value.get("gatewayType")) != null && !(gatewayTypeValue instanceof NullNode)) {
                                        String gatewayTypeInstance = gatewayTypeValue.getTextValue();
                                        virtualNetworkGateway1Instance.setGatewayType(gatewayTypeInstance);
                                    }
                                    if ((vpnTypeValue = virtualNetworkGateway1Value.get("vpnType")) != null && !(vpnTypeValue instanceof NullNode)) {
                                        String vpnTypeInstance = vpnTypeValue.getTextValue();
                                        virtualNetworkGateway1Instance.setVpnType(vpnTypeInstance);
                                    }
                                    if ((enableBgpValue = virtualNetworkGateway1Value.get("enableBgp")) != null && !(enableBgpValue instanceof NullNode)) {
                                        boolean enableBgpInstance = enableBgpValue.getBooleanValue();
                                        virtualNetworkGateway1Instance.setEnableBgp(enableBgpInstance);
                                    }
                                    if ((provisioningStateValue2 = virtualNetworkGateway1Value.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        virtualNetworkGateway1Instance.setProvisioningState(provisioningStateInstance2);
                                    }
                                    if ((etagValue2 = virtualNetworkGateway1Value.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                        String etagInstance2 = etagValue2.getTextValue();
                                        virtualNetworkGateway1Instance.setEtag(etagInstance2);
                                    }
                                    if ((idValue4 = virtualNetworkGateway1Value.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                        String idInstance4 = idValue4.getTextValue();
                                        virtualNetworkGateway1Instance.setId(idInstance4);
                                    }
                                    if ((nameValue2 = virtualNetworkGateway1Value.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                        String nameInstance2 = nameValue2.getTextValue();
                                        virtualNetworkGateway1Instance.setName(nameInstance2);
                                    }
                                    if ((typeValue = virtualNetworkGateway1Value.get("type")) != null && !(typeValue instanceof NullNode)) {
                                        String typeInstance = typeValue.getTextValue();
                                        virtualNetworkGateway1Instance.setType(typeInstance);
                                    }
                                    if ((locationValue = virtualNetworkGateway1Value.get("location")) != null && !(locationValue instanceof NullNode)) {
                                        String locationInstance = locationValue.getTextValue();
                                        virtualNetworkGateway1Instance.setLocation(locationInstance);
                                    }
                                    if ((tagsSequenceElement = virtualNetworkGateway1Value.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                                        Iterator itr = tagsSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry property = (Map.Entry)itr.next();
                                            String tagsKey = (String)property.getKey();
                                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                            virtualNetworkGateway1Instance.getTags().put(tagsKey, tagsValue);
                                        }
                                    }
                                }
                                if ((virtualNetworkGateway2Value = propertiesValue.get("virtualNetworkGateway2")) != null && !(virtualNetworkGateway2Value instanceof NullNode)) {
                                    JsonNode tagsSequenceElement2;
                                    JsonNode locationValue2;
                                    JsonNode typeValue2;
                                    JsonNode nameValue4;
                                    JsonNode idValue8;
                                    JsonNode etagValue4;
                                    JsonNode enableBgpValue2;
                                    JsonNode vpnTypeValue2;
                                    JsonNode gatewayTypeValue2;
                                    VirtualNetworkGateway virtualNetworkGateway2Instance = new VirtualNetworkGateway();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setVirtualNetworkGateway2(virtualNetworkGateway2Instance);
                                    JsonNode ipConfigurationsArray2 = virtualNetworkGateway2Value.get("ipConfigurations");
                                    if (ipConfigurationsArray2 != null && !(ipConfigurationsArray2 instanceof NullNode)) {
                                        vpnTypeValue = ((ArrayNode)ipConfigurationsArray2).iterator();
                                        while (vpnTypeValue.hasNext()) {
                                            JsonNode idValue7;
                                            JsonNode etagValue3;
                                            JsonNode nameValue3;
                                            JsonNode provisioningStateValue3;
                                            JsonNode publicIPAddressValue2;
                                            JsonNode subnetValue2;
                                            JsonNode privateIPAllocationMethodValue2;
                                            JsonNode ipConfigurationsValue2 = (JsonNode)vpnTypeValue.next();
                                            VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance2 = new VirtualNetworkGatewayIpConfiguration();
                                            virtualNetworkGateway2Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance2);
                                            JsonNode privateIPAddressValue2 = ipConfigurationsValue2.get("privateIPAddress");
                                            if (privateIPAddressValue2 != null && !(privateIPAddressValue2 instanceof NullNode)) {
                                                String privateIPAddressInstance2 = privateIPAddressValue2.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAddress(privateIPAddressInstance2);
                                            }
                                            if ((privateIPAllocationMethodValue2 = ipConfigurationsValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue2 instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance2 = privateIPAllocationMethodValue2.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance2);
                                            }
                                            if ((subnetValue2 = ipConfigurationsValue2.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                                ResourceId subnetInstance2 = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationInstance2.setSubnet(subnetInstance2);
                                                JsonNode idValue5 = subnetValue2.get("id");
                                                if (idValue5 != null && !(idValue5 instanceof NullNode)) {
                                                    String idInstance5 = idValue5.getTextValue();
                                                    subnetInstance2.setId(idInstance5);
                                                }
                                            }
                                            if ((publicIPAddressValue2 = ipConfigurationsValue2.get("publicIPAddress")) != null && !(publicIPAddressValue2 instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance2 = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationInstance2.setPublicIpAddress(publicIPAddressInstance2);
                                                JsonNode idValue6 = publicIPAddressValue2.get("id");
                                                if (idValue6 != null && !(idValue6 instanceof NullNode)) {
                                                    String idInstance6 = idValue6.getTextValue();
                                                    publicIPAddressInstance2.setId(idInstance6);
                                                }
                                            }
                                            if ((provisioningStateValue3 = ipConfigurationsValue2.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                                String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setProvisioningState(provisioningStateInstance3);
                                            }
                                            if ((nameValue3 = ipConfigurationsValue2.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                                String nameInstance3 = nameValue3.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setName(nameInstance3);
                                            }
                                            if ((etagValue3 = ipConfigurationsValue2.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                                String etagInstance3 = etagValue3.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setEtag(etagInstance3);
                                            }
                                            if ((idValue7 = ipConfigurationsValue2.get("id")) == null || idValue7 instanceof NullNode) continue;
                                            String idInstance7 = idValue7.getTextValue();
                                            virtualNetworkGatewayIpConfigurationInstance2.setId(idInstance7);
                                        }
                                    }
                                    if ((gatewayTypeValue2 = virtualNetworkGateway2Value.get("gatewayType")) != null && !(gatewayTypeValue2 instanceof NullNode)) {
                                        String gatewayTypeInstance2 = gatewayTypeValue2.getTextValue();
                                        virtualNetworkGateway2Instance.setGatewayType(gatewayTypeInstance2);
                                    }
                                    if ((vpnTypeValue2 = virtualNetworkGateway2Value.get("vpnType")) != null && !(vpnTypeValue2 instanceof NullNode)) {
                                        String vpnTypeInstance2 = vpnTypeValue2.getTextValue();
                                        virtualNetworkGateway2Instance.setVpnType(vpnTypeInstance2);
                                    }
                                    if ((enableBgpValue2 = virtualNetworkGateway2Value.get("enableBgp")) != null && !(enableBgpValue2 instanceof NullNode)) {
                                        boolean enableBgpInstance2 = enableBgpValue2.getBooleanValue();
                                        virtualNetworkGateway2Instance.setEnableBgp(enableBgpInstance2);
                                    }
                                    if ((provisioningStateValue4 = virtualNetworkGateway2Value.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                        String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        virtualNetworkGateway2Instance.setProvisioningState(provisioningStateInstance4);
                                    }
                                    if ((etagValue4 = virtualNetworkGateway2Value.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                        String etagInstance4 = etagValue4.getTextValue();
                                        virtualNetworkGateway2Instance.setEtag(etagInstance4);
                                    }
                                    if ((idValue8 = virtualNetworkGateway2Value.get("id")) != null && !(idValue8 instanceof NullNode)) {
                                        String idInstance8 = idValue8.getTextValue();
                                        virtualNetworkGateway2Instance.setId(idInstance8);
                                    }
                                    if ((nameValue4 = virtualNetworkGateway2Value.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                        String nameInstance4 = nameValue4.getTextValue();
                                        virtualNetworkGateway2Instance.setName(nameInstance4);
                                    }
                                    if ((typeValue2 = virtualNetworkGateway2Value.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                        String typeInstance2 = typeValue2.getTextValue();
                                        virtualNetworkGateway2Instance.setType(typeInstance2);
                                    }
                                    if ((locationValue2 = virtualNetworkGateway2Value.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                                        String locationInstance2 = locationValue2.getTextValue();
                                        virtualNetworkGateway2Instance.setLocation(locationInstance2);
                                    }
                                    if ((tagsSequenceElement2 = virtualNetworkGateway2Value.get("tags")) != null && !(tagsSequenceElement2 instanceof NullNode)) {
                                        Iterator itr2 = tagsSequenceElement2.getFields();
                                        while (itr2.hasNext()) {
                                            Map.Entry property2 = (Map.Entry)itr2.next();
                                            String tagsKey2 = (String)property2.getKey();
                                            String tagsValue2 = ((JsonNode)property2.getValue()).getTextValue();
                                            virtualNetworkGateway2Instance.getTags().put(tagsKey2, tagsValue2);
                                        }
                                    }
                                }
                                if ((localNetworkGateway2Value = propertiesValue.get("localNetworkGateway2")) != null && !(localNetworkGateway2Value instanceof NullNode)) {
                                    JsonNode tagsSequenceElement3;
                                    JsonNode locationValue3;
                                    JsonNode typeValue3;
                                    JsonNode nameValue5;
                                    JsonNode idValue9;
                                    JsonNode etagValue5;
                                    JsonNode provisioningStateValue5;
                                    JsonNode gatewayIpAddressValue;
                                    LocalNetworkGateway localNetworkGateway2Instance = new LocalNetworkGateway();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setLocalNetworkGateway2(localNetworkGateway2Instance);
                                    JsonNode localNetworkAddressSpaceValue = localNetworkGateway2Value.get("localNetworkAddressSpace");
                                    if (localNetworkAddressSpaceValue != null && !(localNetworkAddressSpaceValue instanceof NullNode)) {
                                        AddressSpace localNetworkAddressSpaceInstance = new AddressSpace();
                                        localNetworkGateway2Instance.setLocalNetworkAddressSpace(localNetworkAddressSpaceInstance);
                                        JsonNode addressPrefixesArray = localNetworkAddressSpaceValue.get("addressPrefixes");
                                        if (addressPrefixesArray != null && !(addressPrefixesArray instanceof NullNode)) {
                                            provisioningStateValue4 = ((ArrayNode)addressPrefixesArray).iterator();
                                            while (provisioningStateValue4.hasNext()) {
                                                JsonNode addressPrefixesValue = (JsonNode)provisioningStateValue4.next();
                                                localNetworkAddressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                            }
                                        }
                                    }
                                    if ((gatewayIpAddressValue = localNetworkGateway2Value.get("gatewayIpAddress")) != null && !(gatewayIpAddressValue instanceof NullNode)) {
                                        String gatewayIpAddressInstance = gatewayIpAddressValue.getTextValue();
                                        localNetworkGateway2Instance.setGatewayIpAddress(gatewayIpAddressInstance);
                                    }
                                    if ((provisioningStateValue5 = localNetworkGateway2Value.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                        String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        localNetworkGateway2Instance.setProvisioningState(provisioningStateInstance5);
                                    }
                                    if ((etagValue5 = localNetworkGateway2Value.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                        String etagInstance5 = etagValue5.getTextValue();
                                        localNetworkGateway2Instance.setEtag(etagInstance5);
                                    }
                                    if ((idValue9 = localNetworkGateway2Value.get("id")) != null && !(idValue9 instanceof NullNode)) {
                                        String idInstance9 = idValue9.getTextValue();
                                        localNetworkGateway2Instance.setId(idInstance9);
                                    }
                                    if ((nameValue5 = localNetworkGateway2Value.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                        String nameInstance5 = nameValue5.getTextValue();
                                        localNetworkGateway2Instance.setName(nameInstance5);
                                    }
                                    if ((typeValue3 = localNetworkGateway2Value.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                        String typeInstance3 = typeValue3.getTextValue();
                                        localNetworkGateway2Instance.setType(typeInstance3);
                                    }
                                    if ((locationValue3 = localNetworkGateway2Value.get("location")) != null && !(locationValue3 instanceof NullNode)) {
                                        String locationInstance3 = locationValue3.getTextValue();
                                        localNetworkGateway2Instance.setLocation(locationInstance3);
                                    }
                                    if ((tagsSequenceElement3 = localNetworkGateway2Value.get("tags")) != null && !(tagsSequenceElement3 instanceof NullNode)) {
                                        Iterator itr3 = tagsSequenceElement3.getFields();
                                        while (itr3.hasNext()) {
                                            Map.Entry property3 = (Map.Entry)itr3.next();
                                            String tagsKey3 = (String)property3.getKey();
                                            String tagsValue3 = ((JsonNode)property3.getValue()).getTextValue();
                                            localNetworkGateway2Instance.getTags().put(tagsKey3, tagsValue3);
                                        }
                                    }
                                }
                                if ((connectionTypeValue = propertiesValue.get("connectionType")) != null && !(connectionTypeValue instanceof NullNode)) {
                                    String connectionTypeInstance = connectionTypeValue.getTextValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setConnectionType(connectionTypeInstance);
                                }
                                if ((routingWeightValue = propertiesValue.get("routingWeight")) != null && !(routingWeightValue instanceof NullNode)) {
                                    int routingWeightInstance = routingWeightValue.getIntValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setRoutingWeight(routingWeightInstance);
                                }
                                if ((sharedKeyValue = propertiesValue.get("sharedKey")) != null && !(sharedKeyValue instanceof NullNode)) {
                                    String sharedKeyInstance = sharedKeyValue.getTextValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setSharedKey(sharedKeyInstance);
                                }
                                if ((provisioningStateValue6 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                                    String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                }
                            }
                            if ((etagValue6 = valueValue.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                                String etagInstance6 = etagValue6.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setEtag(etagInstance6);
                            }
                            if ((idValue10 = valueValue.get("id")) != null && !(idValue10 instanceof NullNode)) {
                                String idInstance10 = idValue10.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setId(idInstance10);
                            }
                            if ((nameValue6 = valueValue.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                                String nameInstance6 = nameValue6.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setName(nameInstance6);
                            }
                            if ((typeValue4 = valueValue.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                                String typeInstance4 = typeValue4.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setType(typeInstance4);
                            }
                            if ((locationValue4 = valueValue.get("location")) != null && !(locationValue4 instanceof NullNode)) {
                                String locationInstance4 = locationValue4.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setLocation(locationInstance4);
                            }
                            if ((tagsSequenceElement4 = valueValue.get("tags")) == null || tagsSequenceElement4 instanceof NullNode) continue;
                            Iterator itr4 = tagsSequenceElement4.getFields();
                            while (itr4.hasNext()) {
                                Map.Entry property4 = (Map.Entry)itr4.next();
                                String tagsKey4 = (String)property4.getKey();
                                String tagsValue4 = ((JsonNode)property4.getValue()).getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.getTags().put(tagsKey4, tagsValue4);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkGatewayConnectionListResponse virtualNetworkGatewayConnectionListResponse = result;
            return virtualNetworkGatewayConnectionListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> resetSharedKeyAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final ConnectionResetSharedKey parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.resetSharedKey(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse resetSharedKey(String resourceGroupName, String virtualNetworkGatewayConnectionName, ConnectionResetSharedKey parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"resetSharedKeyAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            ConnectionResetSharedKeyPutResponse response = client2.getVirtualNetworkGatewayConnectionsOperations().beginResetSharedKeyAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> setSharedKeyAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final ConnectionSharedKey parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return VirtualNetworkGatewayConnectionOperationsImpl.this.setSharedKey(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse setSharedKey(String resourceGroupName, String virtualNetworkGatewayConnectionName, ConnectionSharedKey parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"setSharedKeyAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            ConnectionSharedKeyPutResponse response = client2.getVirtualNetworkGatewayConnectionsOperations().beginSetSharedKeyAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

