/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.VirtualNetworkGatewayOperations;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGateway;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayGetResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayIpConfiguration;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayListResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayPutResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class VirtualNetworkGatewayOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
VirtualNetworkGatewayOperations {
    private NetworkResourceProviderClientImpl client;

    VirtualNetworkGatewayOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualNetworkGatewayPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String virtualNetworkGatewayName, final VirtualNetworkGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayPutResponse>(){

            @Override
            public VirtualNetworkGatewayPutResponse call() throws Exception {
                return VirtualNetworkGatewayOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, virtualNetworkGatewayName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws IOException, ServiceException {
        VirtualNetworkGatewayPutResponse virtualNetworkGatewayPutResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode virtualNetworkGatewayJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayName == null) {
            throw new NullPointerException("virtualNetworkGatewayName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworkgateways/";
        url = url + URLEncoder.encode(virtualNetworkGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = virtualNetworkGatewayJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        virtualNetworkGatewayJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getIpConfigurations() != null && (!(parameters.getIpConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getIpConfigurations()).isInitialized())) {
            ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
            for (VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfiguration : parameters.getIpConfigurations()) {
                ObjectNode virtualNetworkGatewayIpConfigurationJsonFormatValue = objectMapper.createObjectNode();
                ipConfigurationsArray.add((JsonNode)virtualNetworkGatewayIpConfigurationJsonFormatValue);
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                virtualNetworkGatewayIpConfigurationJsonFormatValue.put("properties", (JsonNode)propertiesValue2);
                if (virtualNetworkGatewayIpConfiguration.getPrivateIpAddress() != null) {
                    propertiesValue2.put("privateIPAddress", virtualNetworkGatewayIpConfiguration.getPrivateIpAddress());
                }
                if (virtualNetworkGatewayIpConfiguration.getPrivateIpAllocationMethod() != null) {
                    propertiesValue2.put("privateIPAllocationMethod", virtualNetworkGatewayIpConfiguration.getPrivateIpAllocationMethod());
                }
                if (virtualNetworkGatewayIpConfiguration.getSubnet() != null) {
                    ObjectNode subnetValue = objectMapper.createObjectNode();
                    propertiesValue2.put("subnet", (JsonNode)subnetValue);
                    if (virtualNetworkGatewayIpConfiguration.getSubnet().getId() != null) {
                        subnetValue.put("id", virtualNetworkGatewayIpConfiguration.getSubnet().getId());
                    }
                }
                if (virtualNetworkGatewayIpConfiguration.getPublicIpAddress() != null) {
                    ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                    propertiesValue2.put("publicIPAddress", (JsonNode)publicIPAddressValue);
                    if (virtualNetworkGatewayIpConfiguration.getPublicIpAddress().getId() != null) {
                        publicIPAddressValue.put("id", virtualNetworkGatewayIpConfiguration.getPublicIpAddress().getId());
                    }
                }
                if (virtualNetworkGatewayIpConfiguration.getProvisioningState() != null) {
                    propertiesValue2.put("provisioningState", virtualNetworkGatewayIpConfiguration.getProvisioningState());
                }
                if (virtualNetworkGatewayIpConfiguration.getName() != null) {
                    virtualNetworkGatewayIpConfigurationJsonFormatValue.put("name", virtualNetworkGatewayIpConfiguration.getName());
                }
                if (virtualNetworkGatewayIpConfiguration.getEtag() != null) {
                    virtualNetworkGatewayIpConfigurationJsonFormatValue.put("etag", virtualNetworkGatewayIpConfiguration.getEtag());
                }
                if (virtualNetworkGatewayIpConfiguration.getId() == null) continue;
                virtualNetworkGatewayIpConfigurationJsonFormatValue.put("id", virtualNetworkGatewayIpConfiguration.getId());
            }
            propertiesValue.put("ipConfigurations", (JsonNode)ipConfigurationsArray);
        }
        if (parameters.getGatewayType() != null) {
            propertiesValue.put("gatewayType", parameters.getGatewayType());
        }
        if (parameters.getVpnType() != null) {
            propertiesValue.put("vpnType", parameters.getVpnType());
        }
        propertiesValue.put("enableBgp", parameters.isEnableBgp());
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            virtualNetworkGatewayJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            virtualNetworkGatewayJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            virtualNetworkGatewayJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            virtualNetworkGatewayJsonFormatValue.put("type", parameters.getType());
        }
        virtualNetworkGatewayJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            virtualNetworkGatewayJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var17_20 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayPutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue4;
                    JsonNode etagValue2;
                    VirtualNetworkGateway virtualNetworkGatewayInstance = new VirtualNetworkGateway();
                    result.setVirtualNetworkGateway(virtualNetworkGatewayInstance);
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode enableBgpValue;
                        JsonNode vpnTypeValue;
                        JsonNode gatewayTypeValue;
                        JsonNode ipConfigurationsArray2 = propertiesValue3.get("ipConfigurations");
                        if (ipConfigurationsArray2 != null && !(ipConfigurationsArray2 instanceof NullNode)) {
                            for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray2) {
                                JsonNode idValue3;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationJsonFormatInstance = new VirtualNetworkGatewayIpConfiguration();
                                virtualNetworkGatewayInstance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationJsonFormatInstance);
                                JsonNode propertiesValue4 = ipConfigurationsValue.get("properties");
                                if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode publicIPAddressValue2;
                                    JsonNode subnetValue2;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue2 = propertiesValue4.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue2.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((publicIPAddressValue2 = propertiesValue4.get("publicIPAddress")) != null && !(publicIPAddressValue2 instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        JsonNode idValue2 = publicIPAddressValue2.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue3 = ipConfigurationsValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setId(idInstance3);
                            }
                        }
                        if ((gatewayTypeValue = propertiesValue3.get("gatewayType")) != null && !(gatewayTypeValue instanceof NullNode)) {
                            String gatewayTypeInstance = gatewayTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setGatewayType(gatewayTypeInstance);
                        }
                        if ((vpnTypeValue = propertiesValue3.get("vpnType")) != null && !(vpnTypeValue instanceof NullNode)) {
                            String vpnTypeInstance = vpnTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setVpnType(vpnTypeInstance);
                        }
                        if ((enableBgpValue = propertiesValue3.get("enableBgp")) != null && !(enableBgpValue instanceof NullNode)) {
                            boolean enableBgpInstance = enableBgpValue.getBooleanValue();
                            virtualNetworkGatewayInstance.setEnableBgp(enableBgpInstance);
                        }
                        if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkGatewayInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkGatewayInstance.setEtag(etagInstance2);
                    }
                    if ((idValue4 = responseDoc.get("id")) != null && !(idValue4 instanceof NullNode)) {
                        String idInstance4 = idValue4.getTextValue();
                        virtualNetworkGatewayInstance.setId(idInstance4);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkGatewayInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        virtualNetworkGatewayInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualNetworkGatewayInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            virtualNetworkGatewayInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)closeableHttpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (closeableHttpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(closeableHttpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            virtualNetworkGatewayPutResponse = result;
        }
        catch (Throwable throwable) {
            if (var17_20 != null && var17_20.getEntity() != null) {
                var17_20.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return virtualNetworkGatewayPutResponse;
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String virtualNetworkGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return VirtualNetworkGatewayOperationsImpl.this.beginDeleting(resourceGroupName, virtualNetworkGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkGatewayName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayName == null) {
            throw new NullPointerException("virtualNetworkGatewayName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualNetworkGateways/";
        url = url + URLEncoder.encode(virtualNetworkGatewayName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkGatewayPutResponse> beginResetAsync(final String resourceGroupName, final String virtualNetworkGatewayName, final VirtualNetworkGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayPutResponse>(){

            @Override
            public VirtualNetworkGatewayPutResponse call() throws Exception {
                return VirtualNetworkGatewayOperationsImpl.this.beginReset(resourceGroupName, virtualNetworkGatewayName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayPutResponse beginReset(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws IOException, ServiceException {
        VirtualNetworkGatewayPutResponse virtualNetworkGatewayPutResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode virtualNetworkGatewayJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayName == null) {
            throw new NullPointerException("virtualNetworkGatewayName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginResetAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworkgateways/";
        url = url + URLEncoder.encode(virtualNetworkGatewayName, "UTF-8");
        url = url + "/reset";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = virtualNetworkGatewayJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        virtualNetworkGatewayJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getIpConfigurations() != null && (!(parameters.getIpConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getIpConfigurations()).isInitialized())) {
            ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
            for (VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfiguration : parameters.getIpConfigurations()) {
                ObjectNode virtualNetworkGatewayIpConfigurationJsonFormatValue = objectMapper.createObjectNode();
                ipConfigurationsArray.add((JsonNode)virtualNetworkGatewayIpConfigurationJsonFormatValue);
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                virtualNetworkGatewayIpConfigurationJsonFormatValue.put("properties", (JsonNode)propertiesValue2);
                if (virtualNetworkGatewayIpConfiguration.getPrivateIpAddress() != null) {
                    propertiesValue2.put("privateIPAddress", virtualNetworkGatewayIpConfiguration.getPrivateIpAddress());
                }
                if (virtualNetworkGatewayIpConfiguration.getPrivateIpAllocationMethod() != null) {
                    propertiesValue2.put("privateIPAllocationMethod", virtualNetworkGatewayIpConfiguration.getPrivateIpAllocationMethod());
                }
                if (virtualNetworkGatewayIpConfiguration.getSubnet() != null) {
                    ObjectNode subnetValue = objectMapper.createObjectNode();
                    propertiesValue2.put("subnet", (JsonNode)subnetValue);
                    if (virtualNetworkGatewayIpConfiguration.getSubnet().getId() != null) {
                        subnetValue.put("id", virtualNetworkGatewayIpConfiguration.getSubnet().getId());
                    }
                }
                if (virtualNetworkGatewayIpConfiguration.getPublicIpAddress() != null) {
                    ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                    propertiesValue2.put("publicIPAddress", (JsonNode)publicIPAddressValue);
                    if (virtualNetworkGatewayIpConfiguration.getPublicIpAddress().getId() != null) {
                        publicIPAddressValue.put("id", virtualNetworkGatewayIpConfiguration.getPublicIpAddress().getId());
                    }
                }
                if (virtualNetworkGatewayIpConfiguration.getProvisioningState() != null) {
                    propertiesValue2.put("provisioningState", virtualNetworkGatewayIpConfiguration.getProvisioningState());
                }
                if (virtualNetworkGatewayIpConfiguration.getName() != null) {
                    virtualNetworkGatewayIpConfigurationJsonFormatValue.put("name", virtualNetworkGatewayIpConfiguration.getName());
                }
                if (virtualNetworkGatewayIpConfiguration.getEtag() != null) {
                    virtualNetworkGatewayIpConfigurationJsonFormatValue.put("etag", virtualNetworkGatewayIpConfiguration.getEtag());
                }
                if (virtualNetworkGatewayIpConfiguration.getId() == null) continue;
                virtualNetworkGatewayIpConfigurationJsonFormatValue.put("id", virtualNetworkGatewayIpConfiguration.getId());
            }
            propertiesValue.put("ipConfigurations", (JsonNode)ipConfigurationsArray);
        }
        if (parameters.getGatewayType() != null) {
            propertiesValue.put("gatewayType", parameters.getGatewayType());
        }
        if (parameters.getVpnType() != null) {
            propertiesValue.put("vpnType", parameters.getVpnType());
        }
        propertiesValue.put("enableBgp", parameters.isEnableBgp());
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            virtualNetworkGatewayJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            virtualNetworkGatewayJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            virtualNetworkGatewayJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            virtualNetworkGatewayJsonFormatValue.put("type", parameters.getType());
        }
        virtualNetworkGatewayJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            virtualNetworkGatewayJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var17_20 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayPutResponse result = null;
            if (statusCode == 200 || statusCode == 202) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue4;
                    JsonNode etagValue2;
                    VirtualNetworkGateway virtualNetworkGatewayInstance = new VirtualNetworkGateway();
                    result.setVirtualNetworkGateway(virtualNetworkGatewayInstance);
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode enableBgpValue;
                        JsonNode vpnTypeValue;
                        JsonNode gatewayTypeValue;
                        JsonNode ipConfigurationsArray2 = propertiesValue3.get("ipConfigurations");
                        if (ipConfigurationsArray2 != null && !(ipConfigurationsArray2 instanceof NullNode)) {
                            for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray2) {
                                JsonNode idValue3;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationJsonFormatInstance = new VirtualNetworkGatewayIpConfiguration();
                                virtualNetworkGatewayInstance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationJsonFormatInstance);
                                JsonNode propertiesValue4 = ipConfigurationsValue.get("properties");
                                if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode publicIPAddressValue2;
                                    JsonNode subnetValue2;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue2 = propertiesValue4.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue2.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((publicIPAddressValue2 = propertiesValue4.get("publicIPAddress")) != null && !(publicIPAddressValue2 instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        JsonNode idValue2 = publicIPAddressValue2.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue3 = ipConfigurationsValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setId(idInstance3);
                            }
                        }
                        if ((gatewayTypeValue = propertiesValue3.get("gatewayType")) != null && !(gatewayTypeValue instanceof NullNode)) {
                            String gatewayTypeInstance = gatewayTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setGatewayType(gatewayTypeInstance);
                        }
                        if ((vpnTypeValue = propertiesValue3.get("vpnType")) != null && !(vpnTypeValue instanceof NullNode)) {
                            String vpnTypeInstance = vpnTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setVpnType(vpnTypeInstance);
                        }
                        if ((enableBgpValue = propertiesValue3.get("enableBgp")) != null && !(enableBgpValue instanceof NullNode)) {
                            boolean enableBgpInstance = enableBgpValue.getBooleanValue();
                            virtualNetworkGatewayInstance.setEnableBgp(enableBgpInstance);
                        }
                        if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkGatewayInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkGatewayInstance.setEtag(etagInstance2);
                    }
                    if ((idValue4 = responseDoc.get("id")) != null && !(idValue4 instanceof NullNode)) {
                        String idInstance4 = idValue4.getTextValue();
                        virtualNetworkGatewayInstance.setId(idInstance4);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkGatewayInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        virtualNetworkGatewayInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualNetworkGatewayInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            virtualNetworkGatewayInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)closeableHttpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (closeableHttpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(closeableHttpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            virtualNetworkGatewayPutResponse = result;
        }
        catch (Throwable throwable) {
            if (var17_20 != null && var17_20.getEntity() != null) {
                var17_20.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return virtualNetworkGatewayPutResponse;
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String virtualNetworkGatewayName, final VirtualNetworkGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return VirtualNetworkGatewayOperationsImpl.this.createOrUpdate(resourceGroupName, virtualNetworkGatewayName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            VirtualNetworkGatewayPutResponse response = client2.getVirtualNetworkGatewaysOperations().beginCreateOrUpdatingAsync(resourceGroupName, virtualNetworkGatewayName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String virtualNetworkGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualNetworkGatewayOperationsImpl.this.delete(resourceGroupName, virtualNetworkGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String virtualNetworkGatewayName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getVirtualNetworkGatewaysOperations().beginDeletingAsync(resourceGroupName, virtualNetworkGatewayName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkGatewayGetResponse> getAsync(final String resourceGroupName, final String virtualNetworkGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayGetResponse>(){

            @Override
            public VirtualNetworkGatewayGetResponse call() throws Exception {
                return VirtualNetworkGatewayOperationsImpl.this.get(resourceGroupName, virtualNetworkGatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayGetResponse get(String resourceGroupName, String virtualNetworkGatewayName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayName == null) {
            throw new NullPointerException("virtualNetworkGatewayName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualNetworkGateways/";
        url = url + URLEncoder.encode(virtualNetworkGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue4;
                    JsonNode etagValue2;
                    VirtualNetworkGateway virtualNetworkGatewayInstance = new VirtualNetworkGateway();
                    result.setVirtualNetworkGateway(virtualNetworkGatewayInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode enableBgpValue;
                        JsonNode vpnTypeValue;
                        JsonNode gatewayTypeValue;
                        JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                        if (ipConfigurationsArray != null && !(ipConfigurationsArray instanceof NullNode)) {
                            for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                JsonNode idValue3;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationJsonFormatInstance = new VirtualNetworkGatewayIpConfiguration();
                                virtualNetworkGatewayInstance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationJsonFormatInstance);
                                JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode publicIPAddressValue;
                                    JsonNode subnetValue;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue = propertiesValue2.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((publicIPAddressValue = propertiesValue2.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        JsonNode idValue2 = publicIPAddressValue.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue3 = ipConfigurationsValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                String idInstance3 = idValue3.getTextValue();
                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setId(idInstance3);
                            }
                        }
                        if ((gatewayTypeValue = propertiesValue.get("gatewayType")) != null && !(gatewayTypeValue instanceof NullNode)) {
                            String gatewayTypeInstance = gatewayTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setGatewayType(gatewayTypeInstance);
                        }
                        if ((vpnTypeValue = propertiesValue.get("vpnType")) != null && !(vpnTypeValue instanceof NullNode)) {
                            String vpnTypeInstance = vpnTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setVpnType(vpnTypeInstance);
                        }
                        if ((enableBgpValue = propertiesValue.get("enableBgp")) != null && !(enableBgpValue instanceof NullNode)) {
                            boolean enableBgpInstance = enableBgpValue.getBooleanValue();
                            virtualNetworkGatewayInstance.setEnableBgp(enableBgpInstance);
                        }
                        if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkGatewayInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkGatewayInstance.setEtag(etagInstance2);
                    }
                    if ((idValue4 = responseDoc.get("id")) != null && !(idValue4 instanceof NullNode)) {
                        String idInstance4 = idValue4.getTextValue();
                        virtualNetworkGatewayInstance.setId(idInstance4);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkGatewayInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        virtualNetworkGatewayInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualNetworkGatewayInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            virtualNetworkGatewayInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkGatewayGetResponse virtualNetworkGatewayGetResponse = result;
            return virtualNetworkGatewayGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkGatewayListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayListResponse>(){

            @Override
            public VirtualNetworkGatewayListResponse call() throws Exception {
                return VirtualNetworkGatewayOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGatewayListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualNetworkGateways";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGatewayListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue4;
                            JsonNode etagValue2;
                            VirtualNetworkGateway virtualNetworkGatewayJsonFormatInstance = new VirtualNetworkGateway();
                            result.getVirtualNetworkGateways().add(virtualNetworkGatewayJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue2;
                                JsonNode enableBgpValue;
                                JsonNode vpnTypeValue;
                                JsonNode gatewayTypeValue;
                                JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                                if (ipConfigurationsArray != null && !(ipConfigurationsArray instanceof NullNode)) {
                                    for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                        JsonNode idValue3;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationJsonFormatInstance = new VirtualNetworkGatewayIpConfiguration();
                                        virtualNetworkGatewayJsonFormatInstance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode publicIPAddressValue;
                                            JsonNode subnetValue;
                                            JsonNode privateIPAllocationMethodValue;
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                                String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            if ((privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            if ((subnetValue = propertiesValue2.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                                ResourceId subnetInstance = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            if ((publicIPAddressValue = propertiesValue2.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                JsonNode idValue2 = publicIPAddressValue.get("id");
                                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                                    String idInstance2 = idValue2.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance2);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = ipConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            virtualNetworkGatewayIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = ipConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            virtualNetworkGatewayIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue3 = ipConfigurationsValue.get("id")) == null || idValue3 instanceof NullNode) continue;
                                        String idInstance3 = idValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setId(idInstance3);
                                    }
                                }
                                if ((gatewayTypeValue = propertiesValue.get("gatewayType")) != null && !(gatewayTypeValue instanceof NullNode)) {
                                    String gatewayTypeInstance = gatewayTypeValue.getTextValue();
                                    virtualNetworkGatewayJsonFormatInstance.setGatewayType(gatewayTypeInstance);
                                }
                                if ((vpnTypeValue = propertiesValue.get("vpnType")) != null && !(vpnTypeValue instanceof NullNode)) {
                                    String vpnTypeInstance = vpnTypeValue.getTextValue();
                                    virtualNetworkGatewayJsonFormatInstance.setVpnType(vpnTypeInstance);
                                }
                                if ((enableBgpValue = propertiesValue.get("enableBgp")) != null && !(enableBgpValue instanceof NullNode)) {
                                    boolean enableBgpInstance = enableBgpValue.getBooleanValue();
                                    virtualNetworkGatewayJsonFormatInstance.setEnableBgp(enableBgpInstance);
                                }
                                if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualNetworkGatewayJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            if ((etagValue2 = valueValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setEtag(etagInstance2);
                            }
                            if ((idValue4 = valueValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                String idInstance4 = idValue4.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setId(idInstance4);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkGatewayListResponse virtualNetworkGatewayListResponse = result;
            return virtualNetworkGatewayListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> resetAsync(final String resourceGroupName, final String virtualNetworkGatewayName, final VirtualNetworkGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return VirtualNetworkGatewayOperationsImpl.this.reset(resourceGroupName, virtualNetworkGatewayName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse reset(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"resetAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            VirtualNetworkGatewayPutResponse response = client2.getVirtualNetworkGatewaysOperations().beginResetAsync(resourceGroupName, virtualNetworkGatewayName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

