/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.AvailableProvidersListParameters;
import com.microsoft.azure.management.network.AzureReachabilityReportParameters;
import com.microsoft.azure.management.network.ConnectivityParameters;
import com.microsoft.azure.management.network.FlowLogStatusParameters;
import com.microsoft.azure.management.network.NextHopParameters;
import com.microsoft.azure.management.network.QueryTroubleshootingParameters;
import com.microsoft.azure.management.network.SecurityGroupViewParameters;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.TopologyParameters;
import com.microsoft.azure.management.network.TroubleshootingParameters;
import com.microsoft.azure.management.network.VerificationIPFlowParameters;
import com.microsoft.azure.management.network.implementation.AvailableProvidersListInner;
import com.microsoft.azure.management.network.implementation.AzureReachabilityReportInner;
import com.microsoft.azure.management.network.implementation.ConnectivityInformationInner;
import com.microsoft.azure.management.network.implementation.FlowLogInformationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkWatcherInner;
import com.microsoft.azure.management.network.implementation.NextHopResultInner;
import com.microsoft.azure.management.network.implementation.PageImpl1;
import com.microsoft.azure.management.network.implementation.SecurityGroupViewResultInner;
import com.microsoft.azure.management.network.implementation.TopologyInner;
import com.microsoft.azure.management.network.implementation.TroubleshootingResultInner;
import com.microsoft.azure.management.network.implementation.VerificationIPFlowResultInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class NetworkWatchersInner
implements InnerSupportsGet<NetworkWatcherInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<NetworkWatcherInner> {
    private NetworkWatchersService service;
    private NetworkManagementClientImpl client;

    public NetworkWatchersInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (NetworkWatchersService)retrofit.create(NetworkWatchersService.class);
        this.client = client;
    }

    public NetworkWatcherInner createOrUpdate(String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters) {
        return (NetworkWatcherInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkWatcherInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters, ServiceCallback<NetworkWatcherInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<NetworkWatcherInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<NetworkWatcherInner>, NetworkWatcherInner>(){

            public NetworkWatcherInner call(ServiceResponse<NetworkWatcherInner> response) {
                return (NetworkWatcherInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkWatcherInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-04-01";
        return this.service.createOrUpdate(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkWatcherInner>>>(){

            public Observable<ServiceResponse<NetworkWatcherInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkWatcherInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkWatcherInner>(){}.getType()).register(201, new TypeToken<NetworkWatcherInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NetworkWatcherInner getByResourceGroup(String resourceGroupName, String networkWatcherName) {
        return (NetworkWatcherInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkWatcherName).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkWatcherInner> getByResourceGroupAsync(String resourceGroupName, String networkWatcherName, ServiceCallback<NetworkWatcherInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkWatcherName), serviceCallback);
    }

    public Observable<NetworkWatcherInner> getByResourceGroupAsync(String resourceGroupName, String networkWatcherName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkWatcherName).map((Func1)new Func1<ServiceResponse<NetworkWatcherInner>, NetworkWatcherInner>(){

            public NetworkWatcherInner call(ServiceResponse<NetworkWatcherInner> response) {
                return (NetworkWatcherInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkWatcherInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        return this.service.getByResourceGroup(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkWatcherInner>>>(){

            public Observable<ServiceResponse<NetworkWatcherInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkWatcherInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkWatcherInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String networkWatcherName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String networkWatcherName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String networkWatcherName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String networkWatcherName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        return this.service.beginDelete(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NetworkWatcherInner updateTags(String resourceGroupName, String networkWatcherName) {
        return (NetworkWatcherInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, networkWatcherName).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkWatcherInner> updateTagsAsync(String resourceGroupName, String networkWatcherName, ServiceCallback<NetworkWatcherInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, networkWatcherName), serviceCallback);
    }

    public Observable<NetworkWatcherInner> updateTagsAsync(String resourceGroupName, String networkWatcherName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, networkWatcherName).map((Func1)new Func1<ServiceResponse<NetworkWatcherInner>, NetworkWatcherInner>(){

            public NetworkWatcherInner call(ServiceResponse<NetworkWatcherInner> response) {
                return (NetworkWatcherInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkWatcherInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.updateTags(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkWatcherInner>>>(){

            public Observable<ServiceResponse<NetworkWatcherInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public NetworkWatcherInner updateTags(String resourceGroupName, String networkWatcherName, Map<String, String> tags) {
        return (NetworkWatcherInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, networkWatcherName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkWatcherInner> updateTagsAsync(String resourceGroupName, String networkWatcherName, Map<String, String> tags, ServiceCallback<NetworkWatcherInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, networkWatcherName, tags), serviceCallback);
    }

    public Observable<NetworkWatcherInner> updateTagsAsync(String resourceGroupName, String networkWatcherName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, networkWatcherName, tags).map((Func1)new Func1<ServiceResponse<NetworkWatcherInner>, NetworkWatcherInner>(){

            public NetworkWatcherInner call(ServiceResponse<NetworkWatcherInner> response) {
                return (NetworkWatcherInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkWatcherInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-04-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.updateTags(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkWatcherInner>>>(){

            public Observable<ServiceResponse<NetworkWatcherInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkWatcherInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkWatcherInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NetworkWatcherInner> listByResourceGroup(String resourceGroupName) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<NetworkWatcherInner>(page){

            public Page<NetworkWatcherInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<NetworkWatcherInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<NetworkWatcherInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<NetworkWatcherInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<NetworkWatcherInner>>, Page<NetworkWatcherInner>>(){

            public Page<NetworkWatcherInner> call(ServiceResponse<List<NetworkWatcherInner>> response) {
                PageImpl1<NetworkWatcherInner> page = new PageImpl1<NetworkWatcherInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<NetworkWatcherInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<NetworkWatcherInner>>>>(){

            public Observable<ServiceResponse<List<NetworkWatcherInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkWatchersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<NetworkWatcherInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<NetworkWatcherInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NetworkWatcherInner> list() {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<NetworkWatcherInner>(page){

            public Page<NetworkWatcherInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<NetworkWatcherInner>> listAsync(ServiceCallback<List<NetworkWatcherInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<NetworkWatcherInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<NetworkWatcherInner>>, Page<NetworkWatcherInner>>(){

            public Page<NetworkWatcherInner> call(ServiceResponse<List<NetworkWatcherInner>> response) {
                PageImpl1<NetworkWatcherInner> page = new PageImpl1<NetworkWatcherInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<NetworkWatcherInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        return this.service.list(this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<NetworkWatcherInner>>>>(){

            public Observable<ServiceResponse<List<NetworkWatcherInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkWatchersInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<NetworkWatcherInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<NetworkWatcherInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TopologyInner getTopology(String resourceGroupName, String networkWatcherName, TopologyParameters parameters) {
        return (TopologyInner)((ServiceResponse)this.getTopologyWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<TopologyInner> getTopologyAsync(String resourceGroupName, String networkWatcherName, TopologyParameters parameters, ServiceCallback<TopologyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTopologyWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<TopologyInner> getTopologyAsync(String resourceGroupName, String networkWatcherName, TopologyParameters parameters) {
        return this.getTopologyWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<TopologyInner>, TopologyInner>(){

            public TopologyInner call(ServiceResponse<TopologyInner> response) {
                return (TopologyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TopologyInner>> getTopologyWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, TopologyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        return this.service.getTopology(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TopologyInner>>>(){

            public Observable<ServiceResponse<TopologyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.getTopologyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TopologyInner> getTopologyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TopologyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VerificationIPFlowResultInner verifyIPFlow(String resourceGroupName, String networkWatcherName, VerificationIPFlowParameters parameters) {
        return (VerificationIPFlowResultInner)((ServiceResponse)this.verifyIPFlowWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<VerificationIPFlowResultInner> verifyIPFlowAsync(String resourceGroupName, String networkWatcherName, VerificationIPFlowParameters parameters, ServiceCallback<VerificationIPFlowResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.verifyIPFlowWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<VerificationIPFlowResultInner> verifyIPFlowAsync(String resourceGroupName, String networkWatcherName, VerificationIPFlowParameters parameters) {
        return this.verifyIPFlowWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<VerificationIPFlowResultInner>, VerificationIPFlowResultInner>(){

            public VerificationIPFlowResultInner call(ServiceResponse<VerificationIPFlowResultInner> response) {
                return (VerificationIPFlowResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VerificationIPFlowResultInner>> verifyIPFlowWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, VerificationIPFlowParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.verifyIPFlow(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<VerificationIPFlowResultInner>(){}.getType());
    }

    public VerificationIPFlowResultInner beginVerifyIPFlow(String resourceGroupName, String networkWatcherName, VerificationIPFlowParameters parameters) {
        return (VerificationIPFlowResultInner)((ServiceResponse)this.beginVerifyIPFlowWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<VerificationIPFlowResultInner> beginVerifyIPFlowAsync(String resourceGroupName, String networkWatcherName, VerificationIPFlowParameters parameters, ServiceCallback<VerificationIPFlowResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginVerifyIPFlowWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<VerificationIPFlowResultInner> beginVerifyIPFlowAsync(String resourceGroupName, String networkWatcherName, VerificationIPFlowParameters parameters) {
        return this.beginVerifyIPFlowWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<VerificationIPFlowResultInner>, VerificationIPFlowResultInner>(){

            public VerificationIPFlowResultInner call(ServiceResponse<VerificationIPFlowResultInner> response) {
                return (VerificationIPFlowResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VerificationIPFlowResultInner>> beginVerifyIPFlowWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, VerificationIPFlowParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        return this.service.beginVerifyIPFlow(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VerificationIPFlowResultInner>>>(){

            public Observable<ServiceResponse<VerificationIPFlowResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginVerifyIPFlowDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VerificationIPFlowResultInner> beginVerifyIPFlowDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VerificationIPFlowResultInner>(){}.getType()).register(202, new TypeToken<VerificationIPFlowResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NextHopResultInner getNextHop(String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        return (NextHopResultInner)((ServiceResponse)this.getNextHopWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<NextHopResultInner> getNextHopAsync(String resourceGroupName, String networkWatcherName, NextHopParameters parameters, ServiceCallback<NextHopResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getNextHopWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<NextHopResultInner> getNextHopAsync(String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        return this.getNextHopWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<NextHopResultInner>, NextHopResultInner>(){

            public NextHopResultInner call(ServiceResponse<NextHopResultInner> response) {
                return (NextHopResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<NextHopResultInner>> getNextHopWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.getNextHop(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<NextHopResultInner>(){}.getType());
    }

    public NextHopResultInner beginGetNextHop(String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        return (NextHopResultInner)((ServiceResponse)this.beginGetNextHopWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<NextHopResultInner> beginGetNextHopAsync(String resourceGroupName, String networkWatcherName, NextHopParameters parameters, ServiceCallback<NextHopResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetNextHopWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<NextHopResultInner> beginGetNextHopAsync(String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        return this.beginGetNextHopWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<NextHopResultInner>, NextHopResultInner>(){

            public NextHopResultInner call(ServiceResponse<NextHopResultInner> response) {
                return (NextHopResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<NextHopResultInner>> beginGetNextHopWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        return this.service.beginGetNextHop(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NextHopResultInner>>>(){

            public Observable<ServiceResponse<NextHopResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginGetNextHopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NextHopResultInner> beginGetNextHopDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NextHopResultInner>(){}.getType()).register(202, new TypeToken<NextHopResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SecurityGroupViewResultInner getVMSecurityRules(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return (SecurityGroupViewResultInner)((ServiceResponse)this.getVMSecurityRulesWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).toBlocking().last()).body();
    }

    public ServiceFuture<SecurityGroupViewResultInner> getVMSecurityRulesAsync(String resourceGroupName, String networkWatcherName, String targetResourceId, ServiceCallback<SecurityGroupViewResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getVMSecurityRulesWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId), serviceCallback);
    }

    public Observable<SecurityGroupViewResultInner> getVMSecurityRulesAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return this.getVMSecurityRulesWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).map((Func1)new Func1<ServiceResponse<SecurityGroupViewResultInner>, SecurityGroupViewResultInner>(){

            public SecurityGroupViewResultInner call(ServiceResponse<SecurityGroupViewResultInner> response) {
                return (SecurityGroupViewResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SecurityGroupViewResultInner>> getVMSecurityRulesWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (targetResourceId == null) {
            throw new IllegalArgumentException("Parameter targetResourceId is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        SecurityGroupViewParameters parameters = new SecurityGroupViewParameters();
        parameters.withTargetResourceId(targetResourceId);
        Observable<Response<ResponseBody>> observable = this.service.getVMSecurityRules(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<SecurityGroupViewResultInner>(){}.getType());
    }

    public SecurityGroupViewResultInner beginGetVMSecurityRules(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return (SecurityGroupViewResultInner)((ServiceResponse)this.beginGetVMSecurityRulesWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).toBlocking().single()).body();
    }

    public ServiceFuture<SecurityGroupViewResultInner> beginGetVMSecurityRulesAsync(String resourceGroupName, String networkWatcherName, String targetResourceId, ServiceCallback<SecurityGroupViewResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetVMSecurityRulesWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId), serviceCallback);
    }

    public Observable<SecurityGroupViewResultInner> beginGetVMSecurityRulesAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return this.beginGetVMSecurityRulesWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).map((Func1)new Func1<ServiceResponse<SecurityGroupViewResultInner>, SecurityGroupViewResultInner>(){

            public SecurityGroupViewResultInner call(ServiceResponse<SecurityGroupViewResultInner> response) {
                return (SecurityGroupViewResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SecurityGroupViewResultInner>> beginGetVMSecurityRulesWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (targetResourceId == null) {
            throw new IllegalArgumentException("Parameter targetResourceId is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        SecurityGroupViewParameters parameters = new SecurityGroupViewParameters();
        parameters.withTargetResourceId(targetResourceId);
        return this.service.beginGetVMSecurityRules(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityGroupViewResultInner>>>(){

            public Observable<ServiceResponse<SecurityGroupViewResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginGetVMSecurityRulesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecurityGroupViewResultInner> beginGetVMSecurityRulesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SecurityGroupViewResultInner>(){}.getType()).register(202, new TypeToken<SecurityGroupViewResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TroubleshootingResultInner getTroubleshooting(String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        return (TroubleshootingResultInner)((ServiceResponse)this.getTroubleshootingWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<TroubleshootingResultInner> getTroubleshootingAsync(String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, ServiceCallback<TroubleshootingResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTroubleshootingWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<TroubleshootingResultInner> getTroubleshootingAsync(String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        return this.getTroubleshootingWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<TroubleshootingResultInner>, TroubleshootingResultInner>(){

            public TroubleshootingResultInner call(ServiceResponse<TroubleshootingResultInner> response) {
                return (TroubleshootingResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TroubleshootingResultInner>> getTroubleshootingWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.getTroubleshooting(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<TroubleshootingResultInner>(){}.getType());
    }

    public TroubleshootingResultInner beginGetTroubleshooting(String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        return (TroubleshootingResultInner)((ServiceResponse)this.beginGetTroubleshootingWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<TroubleshootingResultInner> beginGetTroubleshootingAsync(String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, ServiceCallback<TroubleshootingResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetTroubleshootingWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<TroubleshootingResultInner> beginGetTroubleshootingAsync(String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        return this.beginGetTroubleshootingWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<TroubleshootingResultInner>, TroubleshootingResultInner>(){

            public TroubleshootingResultInner call(ServiceResponse<TroubleshootingResultInner> response) {
                return (TroubleshootingResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TroubleshootingResultInner>> beginGetTroubleshootingWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        return this.service.beginGetTroubleshooting(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TroubleshootingResultInner>>>(){

            public Observable<ServiceResponse<TroubleshootingResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginGetTroubleshootingDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TroubleshootingResultInner> beginGetTroubleshootingDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TroubleshootingResultInner>(){}.getType()).register(202, new TypeToken<TroubleshootingResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TroubleshootingResultInner getTroubleshootingResult(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return (TroubleshootingResultInner)((ServiceResponse)this.getTroubleshootingResultWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).toBlocking().last()).body();
    }

    public ServiceFuture<TroubleshootingResultInner> getTroubleshootingResultAsync(String resourceGroupName, String networkWatcherName, String targetResourceId, ServiceCallback<TroubleshootingResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTroubleshootingResultWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId), serviceCallback);
    }

    public Observable<TroubleshootingResultInner> getTroubleshootingResultAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return this.getTroubleshootingResultWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).map((Func1)new Func1<ServiceResponse<TroubleshootingResultInner>, TroubleshootingResultInner>(){

            public TroubleshootingResultInner call(ServiceResponse<TroubleshootingResultInner> response) {
                return (TroubleshootingResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TroubleshootingResultInner>> getTroubleshootingResultWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (targetResourceId == null) {
            throw new IllegalArgumentException("Parameter targetResourceId is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        QueryTroubleshootingParameters parameters = new QueryTroubleshootingParameters();
        parameters.withTargetResourceId(targetResourceId);
        Observable<Response<ResponseBody>> observable = this.service.getTroubleshootingResult(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<TroubleshootingResultInner>(){}.getType());
    }

    public TroubleshootingResultInner beginGetTroubleshootingResult(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return (TroubleshootingResultInner)((ServiceResponse)this.beginGetTroubleshootingResultWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).toBlocking().single()).body();
    }

    public ServiceFuture<TroubleshootingResultInner> beginGetTroubleshootingResultAsync(String resourceGroupName, String networkWatcherName, String targetResourceId, ServiceCallback<TroubleshootingResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetTroubleshootingResultWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId), serviceCallback);
    }

    public Observable<TroubleshootingResultInner> beginGetTroubleshootingResultAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return this.beginGetTroubleshootingResultWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).map((Func1)new Func1<ServiceResponse<TroubleshootingResultInner>, TroubleshootingResultInner>(){

            public TroubleshootingResultInner call(ServiceResponse<TroubleshootingResultInner> response) {
                return (TroubleshootingResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TroubleshootingResultInner>> beginGetTroubleshootingResultWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (targetResourceId == null) {
            throw new IllegalArgumentException("Parameter targetResourceId is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        QueryTroubleshootingParameters parameters = new QueryTroubleshootingParameters();
        parameters.withTargetResourceId(targetResourceId);
        return this.service.beginGetTroubleshootingResult(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TroubleshootingResultInner>>>(){

            public Observable<ServiceResponse<TroubleshootingResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginGetTroubleshootingResultDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TroubleshootingResultInner> beginGetTroubleshootingResultDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TroubleshootingResultInner>(){}.getType()).register(202, new TypeToken<TroubleshootingResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FlowLogInformationInner setFlowLogConfiguration(String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        return (FlowLogInformationInner)((ServiceResponse)this.setFlowLogConfigurationWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<FlowLogInformationInner> setFlowLogConfigurationAsync(String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, ServiceCallback<FlowLogInformationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setFlowLogConfigurationWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<FlowLogInformationInner> setFlowLogConfigurationAsync(String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        return this.setFlowLogConfigurationWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<FlowLogInformationInner>, FlowLogInformationInner>(){

            public FlowLogInformationInner call(ServiceResponse<FlowLogInformationInner> response) {
                return (FlowLogInformationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<FlowLogInformationInner>> setFlowLogConfigurationWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.setFlowLogConfiguration(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<FlowLogInformationInner>(){}.getType());
    }

    public FlowLogInformationInner beginSetFlowLogConfiguration(String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        return (FlowLogInformationInner)((ServiceResponse)this.beginSetFlowLogConfigurationWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<FlowLogInformationInner> beginSetFlowLogConfigurationAsync(String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, ServiceCallback<FlowLogInformationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginSetFlowLogConfigurationWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<FlowLogInformationInner> beginSetFlowLogConfigurationAsync(String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        return this.beginSetFlowLogConfigurationWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<FlowLogInformationInner>, FlowLogInformationInner>(){

            public FlowLogInformationInner call(ServiceResponse<FlowLogInformationInner> response) {
                return (FlowLogInformationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<FlowLogInformationInner>> beginSetFlowLogConfigurationWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        return this.service.beginSetFlowLogConfiguration(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FlowLogInformationInner>>>(){

            public Observable<ServiceResponse<FlowLogInformationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginSetFlowLogConfigurationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FlowLogInformationInner> beginSetFlowLogConfigurationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FlowLogInformationInner>(){}.getType()).register(202, new TypeToken<FlowLogInformationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FlowLogInformationInner getFlowLogStatus(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return (FlowLogInformationInner)((ServiceResponse)this.getFlowLogStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).toBlocking().last()).body();
    }

    public ServiceFuture<FlowLogInformationInner> getFlowLogStatusAsync(String resourceGroupName, String networkWatcherName, String targetResourceId, ServiceCallback<FlowLogInformationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getFlowLogStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId), serviceCallback);
    }

    public Observable<FlowLogInformationInner> getFlowLogStatusAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return this.getFlowLogStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).map((Func1)new Func1<ServiceResponse<FlowLogInformationInner>, FlowLogInformationInner>(){

            public FlowLogInformationInner call(ServiceResponse<FlowLogInformationInner> response) {
                return (FlowLogInformationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<FlowLogInformationInner>> getFlowLogStatusWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (targetResourceId == null) {
            throw new IllegalArgumentException("Parameter targetResourceId is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        FlowLogStatusParameters parameters = new FlowLogStatusParameters();
        parameters.withTargetResourceId(targetResourceId);
        Observable<Response<ResponseBody>> observable = this.service.getFlowLogStatus(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<FlowLogInformationInner>(){}.getType());
    }

    public FlowLogInformationInner beginGetFlowLogStatus(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return (FlowLogInformationInner)((ServiceResponse)this.beginGetFlowLogStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).toBlocking().single()).body();
    }

    public ServiceFuture<FlowLogInformationInner> beginGetFlowLogStatusAsync(String resourceGroupName, String networkWatcherName, String targetResourceId, ServiceCallback<FlowLogInformationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetFlowLogStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId), serviceCallback);
    }

    public Observable<FlowLogInformationInner> beginGetFlowLogStatusAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        return this.beginGetFlowLogStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, targetResourceId).map((Func1)new Func1<ServiceResponse<FlowLogInformationInner>, FlowLogInformationInner>(){

            public FlowLogInformationInner call(ServiceResponse<FlowLogInformationInner> response) {
                return (FlowLogInformationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<FlowLogInformationInner>> beginGetFlowLogStatusWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String targetResourceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (targetResourceId == null) {
            throw new IllegalArgumentException("Parameter targetResourceId is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        FlowLogStatusParameters parameters = new FlowLogStatusParameters();
        parameters.withTargetResourceId(targetResourceId);
        return this.service.beginGetFlowLogStatus(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FlowLogInformationInner>>>(){

            public Observable<ServiceResponse<FlowLogInformationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginGetFlowLogStatusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FlowLogInformationInner> beginGetFlowLogStatusDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FlowLogInformationInner>(){}.getType()).register(202, new TypeToken<FlowLogInformationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ConnectivityInformationInner checkConnectivity(String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        return (ConnectivityInformationInner)((ServiceResponse)this.checkConnectivityWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<ConnectivityInformationInner> checkConnectivityAsync(String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, ServiceCallback<ConnectivityInformationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkConnectivityWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<ConnectivityInformationInner> checkConnectivityAsync(String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        return this.checkConnectivityWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<ConnectivityInformationInner>, ConnectivityInformationInner>(){

            public ConnectivityInformationInner call(ServiceResponse<ConnectivityInformationInner> response) {
                return (ConnectivityInformationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ConnectivityInformationInner>> checkConnectivityWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.checkConnectivity(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ConnectivityInformationInner>(){}.getType());
    }

    public ConnectivityInformationInner beginCheckConnectivity(String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        return (ConnectivityInformationInner)((ServiceResponse)this.beginCheckConnectivityWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ConnectivityInformationInner> beginCheckConnectivityAsync(String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, ServiceCallback<ConnectivityInformationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCheckConnectivityWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<ConnectivityInformationInner> beginCheckConnectivityAsync(String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        return this.beginCheckConnectivityWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<ConnectivityInformationInner>, ConnectivityInformationInner>(){

            public ConnectivityInformationInner call(ServiceResponse<ConnectivityInformationInner> response) {
                return (ConnectivityInformationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ConnectivityInformationInner>> beginCheckConnectivityWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        return this.service.beginCheckConnectivity(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConnectivityInformationInner>>>(){

            public Observable<ServiceResponse<ConnectivityInformationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginCheckConnectivityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ConnectivityInformationInner> beginCheckConnectivityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConnectivityInformationInner>(){}.getType()).register(202, new TypeToken<ConnectivityInformationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AzureReachabilityReportInner getAzureReachabilityReport(String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        return (AzureReachabilityReportInner)((ServiceResponse)this.getAzureReachabilityReportWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<AzureReachabilityReportInner> getAzureReachabilityReportAsync(String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters, ServiceCallback<AzureReachabilityReportInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAzureReachabilityReportWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<AzureReachabilityReportInner> getAzureReachabilityReportAsync(String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        return this.getAzureReachabilityReportWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<AzureReachabilityReportInner>, AzureReachabilityReportInner>(){

            public AzureReachabilityReportInner call(ServiceResponse<AzureReachabilityReportInner> response) {
                return (AzureReachabilityReportInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AzureReachabilityReportInner>> getAzureReachabilityReportWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.getAzureReachabilityReport(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<AzureReachabilityReportInner>(){}.getType());
    }

    public AzureReachabilityReportInner beginGetAzureReachabilityReport(String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        return (AzureReachabilityReportInner)((ServiceResponse)this.beginGetAzureReachabilityReportWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<AzureReachabilityReportInner> beginGetAzureReachabilityReportAsync(String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters, ServiceCallback<AzureReachabilityReportInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetAzureReachabilityReportWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<AzureReachabilityReportInner> beginGetAzureReachabilityReportAsync(String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        return this.beginGetAzureReachabilityReportWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<AzureReachabilityReportInner>, AzureReachabilityReportInner>(){

            public AzureReachabilityReportInner call(ServiceResponse<AzureReachabilityReportInner> response) {
                return (AzureReachabilityReportInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AzureReachabilityReportInner>> beginGetAzureReachabilityReportWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        return this.service.beginGetAzureReachabilityReport(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AzureReachabilityReportInner>>>(){

            public Observable<ServiceResponse<AzureReachabilityReportInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginGetAzureReachabilityReportDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AzureReachabilityReportInner> beginGetAzureReachabilityReportDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AzureReachabilityReportInner>(){}.getType()).register(202, new TypeToken<AzureReachabilityReportInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AvailableProvidersListInner listAvailableProviders(String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        return (AvailableProvidersListInner)((ServiceResponse)this.listAvailableProvidersWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<AvailableProvidersListInner> listAvailableProvidersAsync(String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters, ServiceCallback<AvailableProvidersListInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAvailableProvidersWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<AvailableProvidersListInner> listAvailableProvidersAsync(String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        return this.listAvailableProvidersWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<AvailableProvidersListInner>, AvailableProvidersListInner>(){

            public AvailableProvidersListInner call(ServiceResponse<AvailableProvidersListInner> response) {
                return (AvailableProvidersListInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AvailableProvidersListInner>> listAvailableProvidersWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.listAvailableProviders(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<AvailableProvidersListInner>(){}.getType());
    }

    public AvailableProvidersListInner beginListAvailableProviders(String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        return (AvailableProvidersListInner)((ServiceResponse)this.beginListAvailableProvidersWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<AvailableProvidersListInner> beginListAvailableProvidersAsync(String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters, ServiceCallback<AvailableProvidersListInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginListAvailableProvidersWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters), serviceCallback);
    }

    public Observable<AvailableProvidersListInner> beginListAvailableProvidersAsync(String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        return this.beginListAvailableProvidersWithServiceResponseAsync(resourceGroupName, networkWatcherName, parameters).map((Func1)new Func1<ServiceResponse<AvailableProvidersListInner>, AvailableProvidersListInner>(){

            public AvailableProvidersListInner call(ServiceResponse<AvailableProvidersListInner> response) {
                return (AvailableProvidersListInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AvailableProvidersListInner>> beginListAvailableProvidersWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-01";
        return this.service.beginListAvailableProviders(resourceGroupName, networkWatcherName, this.client.subscriptionId(), parameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AvailableProvidersListInner>>>(){

            public Observable<ServiceResponse<AvailableProvidersListInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkWatchersInner.this.beginListAvailableProvidersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AvailableProvidersListInner> beginListAvailableProvidersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AvailableProvidersListInner>(){}.getType()).register(202, new TypeToken<AvailableProvidersListInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface NetworkWatchersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body NetworkWatcherInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/networkWatchers")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers getTopology"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/topology")
        public Observable<Response<ResponseBody>> getTopology(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body TopologyParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers verifyIPFlow"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/ipFlowVerify")
        public Observable<Response<ResponseBody>> verifyIPFlow(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body VerificationIPFlowParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginVerifyIPFlow"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/ipFlowVerify")
        public Observable<Response<ResponseBody>> beginVerifyIPFlow(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body VerificationIPFlowParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers getNextHop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/nextHop")
        public Observable<Response<ResponseBody>> getNextHop(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body NextHopParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginGetNextHop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/nextHop")
        public Observable<Response<ResponseBody>> beginGetNextHop(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body NextHopParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers getVMSecurityRules"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/securityGroupView")
        public Observable<Response<ResponseBody>> getVMSecurityRules(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body SecurityGroupViewParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginGetVMSecurityRules"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/securityGroupView")
        public Observable<Response<ResponseBody>> beginGetVMSecurityRules(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body SecurityGroupViewParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers getTroubleshooting"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/troubleshoot")
        public Observable<Response<ResponseBody>> getTroubleshooting(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body TroubleshootingParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginGetTroubleshooting"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/troubleshoot")
        public Observable<Response<ResponseBody>> beginGetTroubleshooting(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body TroubleshootingParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers getTroubleshootingResult"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryTroubleshootResult")
        public Observable<Response<ResponseBody>> getTroubleshootingResult(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body QueryTroubleshootingParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginGetTroubleshootingResult"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryTroubleshootResult")
        public Observable<Response<ResponseBody>> beginGetTroubleshootingResult(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body QueryTroubleshootingParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers setFlowLogConfiguration"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/configureFlowLog")
        public Observable<Response<ResponseBody>> setFlowLogConfiguration(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body FlowLogInformationInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginSetFlowLogConfiguration"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/configureFlowLog")
        public Observable<Response<ResponseBody>> beginSetFlowLogConfiguration(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body FlowLogInformationInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers getFlowLogStatus"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryFlowLogStatus")
        public Observable<Response<ResponseBody>> getFlowLogStatus(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FlowLogStatusParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginGetFlowLogStatus"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryFlowLogStatus")
        public Observable<Response<ResponseBody>> beginGetFlowLogStatus(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FlowLogStatusParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers checkConnectivity"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectivityCheck")
        public Observable<Response<ResponseBody>> checkConnectivity(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body ConnectivityParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginCheckConnectivity"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectivityCheck")
        public Observable<Response<ResponseBody>> beginCheckConnectivity(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body ConnectivityParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers getAzureReachabilityReport"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/azureReachabilityReport")
        public Observable<Response<ResponseBody>> getAzureReachabilityReport(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body AzureReachabilityReportParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginGetAzureReachabilityReport"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/azureReachabilityReport")
        public Observable<Response<ResponseBody>> beginGetAzureReachabilityReport(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body AzureReachabilityReportParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers listAvailableProviders"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/availableProvidersList")
        public Observable<Response<ResponseBody>> listAvailableProviders(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body AvailableProvidersListParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkWatchers beginListAvailableProviders"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/availableProvidersList")
        public Observable<Response<ResponseBody>> beginListAvailableProviders(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Body AvailableProvidersListParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

