/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.microsoft.azure.SubResource;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Effective network security group.
 */
public class EffectiveNetworkSecurityGroup {
    /**
     * The ID of network security group that is applied.
     */
    @JsonProperty(value = "networkSecurityGroup")
    private SubResource networkSecurityGroup;

    /**
     * The association property.
     */
    @JsonProperty(value = "association")
    private EffectiveNetworkSecurityGroupAssociation association;

    /**
     * A collection of effective security rules.
     */
    @JsonProperty(value = "effectiveSecurityRules")
    private List<EffectiveNetworkSecurityRule> effectiveSecurityRules;

    /**
     * Get the networkSecurityGroup value.
     *
     * @return the networkSecurityGroup value
     */
    public SubResource networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    /**
     * Set the networkSecurityGroup value.
     *
     * @param networkSecurityGroup the networkSecurityGroup value to set
     * @return the EffectiveNetworkSecurityGroup object itself.
     */
    public EffectiveNetworkSecurityGroup withNetworkSecurityGroup(SubResource networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    /**
     * Get the association value.
     *
     * @return the association value
     */
    public EffectiveNetworkSecurityGroupAssociation association() {
        return this.association;
    }

    /**
     * Set the association value.
     *
     * @param association the association value to set
     * @return the EffectiveNetworkSecurityGroup object itself.
     */
    public EffectiveNetworkSecurityGroup withAssociation(EffectiveNetworkSecurityGroupAssociation association) {
        this.association = association;
        return this;
    }

    /**
     * Get the effectiveSecurityRules value.
     *
     * @return the effectiveSecurityRules value
     */
    public List<EffectiveNetworkSecurityRule> effectiveSecurityRules() {
        return this.effectiveSecurityRules;
    }

    /**
     * Set the effectiveSecurityRules value.
     *
     * @param effectiveSecurityRules the effectiveSecurityRules value to set
     * @return the EffectiveNetworkSecurityGroup object itself.
     */
    public EffectiveNetworkSecurityGroup withEffectiveSecurityRules(List<EffectiveNetworkSecurityRule> effectiveSecurityRules) {
        this.effectiveSecurityRules = effectiveSecurityRules;
        return this;
    }

}
