/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaysInner;
import com.microsoft.azure.management.network.implementation.BgpServiceCommunitiesInner;
import com.microsoft.azure.management.network.implementation.DnsNameAvailabilityResultInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitAuthorizationsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteServiceProvidersInner;
import com.microsoft.azure.management.network.implementation.LoadBalancersInner;
import com.microsoft.azure.management.network.implementation.LocalNetworkGatewaysInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfacesInner;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupsInner;
import com.microsoft.azure.management.network.implementation.NetworkWatchersInner;
import com.microsoft.azure.management.network.implementation.PacketCapturesInner;
import com.microsoft.azure.management.network.implementation.PublicIPAddressesInner;
import com.microsoft.azure.management.network.implementation.RouteFilterRulesInner;
import com.microsoft.azure.management.network.implementation.RouteFiltersInner;
import com.microsoft.azure.management.network.implementation.RouteTablesInner;
import com.microsoft.azure.management.network.implementation.RoutesInner;
import com.microsoft.azure.management.network.implementation.SecurityRulesInner;
import com.microsoft.azure.management.network.implementation.SubnetsInner;
import com.microsoft.azure.management.network.implementation.UsagesInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayConnectionsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewaysInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkPeeringsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworksInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class NetworkManagementClientImpl
extends AzureServiceClient {
    private NetworkManagementClientService service;
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ApplicationGatewaysInner applicationGateways;
    private ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations;
    private ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings;
    private ExpressRouteCircuitsInner expressRouteCircuits;
    private ExpressRouteServiceProvidersInner expressRouteServiceProviders;
    private LoadBalancersInner loadBalancers;
    private NetworkInterfacesInner networkInterfaces;
    private NetworkSecurityGroupsInner networkSecurityGroups;
    private SecurityRulesInner securityRules;
    private NetworkWatchersInner networkWatchers;
    private PacketCapturesInner packetCaptures;
    private PublicIPAddressesInner publicIPAddresses;
    private RouteFiltersInner routeFilters;
    private RouteFilterRulesInner routeFilterRules;
    private RouteTablesInner routeTables;
    private RoutesInner routes;
    private BgpServiceCommunitiesInner bgpServiceCommunities;
    private UsagesInner usages;
    private VirtualNetworksInner virtualNetworks;
    private SubnetsInner subnets;
    private VirtualNetworkPeeringsInner virtualNetworkPeerings;
    private VirtualNetworkGatewaysInner virtualNetworkGateways;
    private VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections;
    private LocalNetworkGatewaysInner localNetworkGateways;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public NetworkManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public NetworkManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public NetworkManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public NetworkManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ApplicationGatewaysInner applicationGateways() {
        return this.applicationGateways;
    }

    public ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations() {
        return this.expressRouteCircuitAuthorizations;
    }

    public ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings() {
        return this.expressRouteCircuitPeerings;
    }

    public ExpressRouteCircuitsInner expressRouteCircuits() {
        return this.expressRouteCircuits;
    }

    public ExpressRouteServiceProvidersInner expressRouteServiceProviders() {
        return this.expressRouteServiceProviders;
    }

    public LoadBalancersInner loadBalancers() {
        return this.loadBalancers;
    }

    public NetworkInterfacesInner networkInterfaces() {
        return this.networkInterfaces;
    }

    public NetworkSecurityGroupsInner networkSecurityGroups() {
        return this.networkSecurityGroups;
    }

    public SecurityRulesInner securityRules() {
        return this.securityRules;
    }

    public NetworkWatchersInner networkWatchers() {
        return this.networkWatchers;
    }

    public PacketCapturesInner packetCaptures() {
        return this.packetCaptures;
    }

    public PublicIPAddressesInner publicIPAddresses() {
        return this.publicIPAddresses;
    }

    public RouteFiltersInner routeFilters() {
        return this.routeFilters;
    }

    public RouteFilterRulesInner routeFilterRules() {
        return this.routeFilterRules;
    }

    public RouteTablesInner routeTables() {
        return this.routeTables;
    }

    public RoutesInner routes() {
        return this.routes;
    }

    public BgpServiceCommunitiesInner bgpServiceCommunities() {
        return this.bgpServiceCommunities;
    }

    public UsagesInner usages() {
        return this.usages;
    }

    public VirtualNetworksInner virtualNetworks() {
        return this.virtualNetworks;
    }

    public SubnetsInner subnets() {
        return this.subnets;
    }

    public VirtualNetworkPeeringsInner virtualNetworkPeerings() {
        return this.virtualNetworkPeerings;
    }

    public VirtualNetworkGatewaysInner virtualNetworkGateways() {
        return this.virtualNetworkGateways;
    }

    public VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections() {
        return this.virtualNetworkGatewayConnections;
    }

    public LocalNetworkGatewaysInner localNetworkGateways() {
        return this.localNetworkGateways;
    }

    public NetworkManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public NetworkManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public NetworkManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.applicationGateways = new ApplicationGatewaysInner(this.restClient().retrofit(), this);
        this.expressRouteCircuitAuthorizations = new ExpressRouteCircuitAuthorizationsInner(this.restClient().retrofit(), this);
        this.expressRouteCircuitPeerings = new ExpressRouteCircuitPeeringsInner(this.restClient().retrofit(), this);
        this.expressRouteCircuits = new ExpressRouteCircuitsInner(this.restClient().retrofit(), this);
        this.expressRouteServiceProviders = new ExpressRouteServiceProvidersInner(this.restClient().retrofit(), this);
        this.loadBalancers = new LoadBalancersInner(this.restClient().retrofit(), this);
        this.networkInterfaces = new NetworkInterfacesInner(this.restClient().retrofit(), this);
        this.networkSecurityGroups = new NetworkSecurityGroupsInner(this.restClient().retrofit(), this);
        this.securityRules = new SecurityRulesInner(this.restClient().retrofit(), this);
        this.networkWatchers = new NetworkWatchersInner(this.restClient().retrofit(), this);
        this.packetCaptures = new PacketCapturesInner(this.restClient().retrofit(), this);
        this.publicIPAddresses = new PublicIPAddressesInner(this.restClient().retrofit(), this);
        this.routeFilters = new RouteFiltersInner(this.restClient().retrofit(), this);
        this.routeFilterRules = new RouteFilterRulesInner(this.restClient().retrofit(), this);
        this.routeTables = new RouteTablesInner(this.restClient().retrofit(), this);
        this.routes = new RoutesInner(this.restClient().retrofit(), this);
        this.bgpServiceCommunities = new BgpServiceCommunitiesInner(this.restClient().retrofit(), this);
        this.usages = new UsagesInner(this.restClient().retrofit(), this);
        this.virtualNetworks = new VirtualNetworksInner(this.restClient().retrofit(), this);
        this.subnets = new SubnetsInner(this.restClient().retrofit(), this);
        this.virtualNetworkPeerings = new VirtualNetworkPeeringsInner(this.restClient().retrofit(), this);
        this.virtualNetworkGateways = new VirtualNetworkGatewaysInner(this.restClient().retrofit(), this);
        this.virtualNetworkGatewayConnections = new VirtualNetworkGatewayConnectionsInner(this.restClient().retrofit(), this);
        this.localNetworkGateways = new LocalNetworkGatewaysInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "NetworkManagementClient");
    }

    private void initializeService() {
        this.service = (NetworkManagementClientService)this.restClient().retrofit().create(NetworkManagementClientService.class);
    }

    public DnsNameAvailabilityResultInner checkDnsNameAvailability(String location) {
        return (DnsNameAvailabilityResultInner)((ServiceResponse)this.checkDnsNameAvailabilityWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    public ServiceFuture<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, ServiceCallback<DnsNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkDnsNameAvailabilityWithServiceResponseAsync(location), serviceCallback);
    }

    public Observable<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location) {
        return this.checkDnsNameAvailabilityWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<DnsNameAvailabilityResultInner>, DnsNameAvailabilityResultInner>(){

            public DnsNameAvailabilityResultInner call(ServiceResponse<DnsNameAvailabilityResultInner> response) {
                return (DnsNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> checkDnsNameAvailabilityWithServiceResponseAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01";
        String domainNameLabel = null;
        return this.service.checkDnsNameAvailability(location, this.subscriptionId(), domainNameLabel, "2017-03-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DnsNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.checkDnsNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DnsNameAvailabilityResultInner checkDnsNameAvailability(String location, String domainNameLabel) {
        return (DnsNameAvailabilityResultInner)((ServiceResponse)this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).toBlocking().single()).body();
    }

    public ServiceFuture<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel, ServiceCallback<DnsNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel), serviceCallback);
    }

    public Observable<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel) {
        return this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).map((Func1)new Func1<ServiceResponse<DnsNameAvailabilityResultInner>, DnsNameAvailabilityResultInner>(){

            public DnsNameAvailabilityResultInner call(ServiceResponse<DnsNameAvailabilityResultInner> response) {
                return (DnsNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> checkDnsNameAvailabilityWithServiceResponseAsync(String location, String domainNameLabel) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01";
        return this.service.checkDnsNameAvailability(location, this.subscriptionId(), domainNameLabel, "2017-03-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DnsNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.checkDnsNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DnsNameAvailabilityResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface NetworkManagementClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient checkDnsNameAvailability"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/CheckDnsNameAvailability")
        public Observable<Response<ResponseBody>> checkDnsNameAvailability(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="domainNameLabel") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

