/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.PublicIPAddressSku;
import com.microsoft.azure.management.network.PublicIPAddressSkuName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@LangDefinition
@Beta(value=Beta.SinceVersion.V1_3_0)
public final class PublicIPSkuType {
    private static final Map<String, PublicIPSkuType> VALUES_BY_NAME = new HashMap<String, PublicIPSkuType>();
    public static final PublicIPSkuType BASIC = new PublicIPSkuType(PublicIPAddressSkuName.BASIC);
    public static final PublicIPSkuType STANDARD = new PublicIPSkuType(PublicIPAddressSkuName.STANDARD);
    private PublicIPAddressSkuName skuName;

    public static PublicIPSkuType[] values() {
        Collection<PublicIPSkuType> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new PublicIPSkuType[valuesCollection.size()]);
    }

    private PublicIPSkuType(PublicIPAddressSkuName skuName) {
        this.skuName = skuName;
        if (skuName != null) {
            VALUES_BY_NAME.put(skuName.toString().toLowerCase(), this);
        }
    }

    public static PublicIPSkuType fromSku(PublicIPAddressSku pipSku) {
        if (pipSku == null) {
            return null;
        }
        if (pipSku.name() == null) {
            return null;
        }
        PublicIPSkuType result = VALUES_BY_NAME.get(pipSku.name().toString().toLowerCase());
        if (result != null) {
            return result;
        }
        return new PublicIPSkuType(pipSku.name());
    }

    public PublicIPAddressSku sku() {
        return new PublicIPAddressSku().withName(this.skuName);
    }

    public int hashCode() {
        return this.skuName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PublicIPSkuType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.skuName == null) {
            return ((PublicIPSkuType)obj).skuName == null;
        }
        return this.skuName.equals((Object)((PublicIPSkuType)obj).skuName);
    }
}

