/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PublicIPAddressInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PublicIPAddressesInner
implements InnerSupportsGet<PublicIPAddressInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<PublicIPAddressInner> {
    private PublicIPAddressesService service;
    private NetworkManagementClientImpl client;

    public PublicIPAddressesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (PublicIPAddressesService)retrofit.create(PublicIPAddressesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String publicIpAddressName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String publicIpAddressName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String publicIpAddressName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String publicIpAddressName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String publicIpAddressName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String publicIpAddressName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpAddressName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PublicIPAddressInner getByResourceGroup(String resourceGroupName, String publicIpAddressName) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpAddressName).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPAddressInner> getByResourceGroupAsync(String resourceGroupName, String publicIpAddressName, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpAddressName), serviceCallback);
    }

    public Observable<PublicIPAddressInner> getByResourceGroupAsync(String resourceGroupName, String publicIpAddressName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpAddressName).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PublicIPAddressInner getByResourceGroup(String resourceGroupName, String publicIpAddressName, String expand) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpAddressName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPAddressInner> getByResourceGroupAsync(String resourceGroupName, String publicIpAddressName, String expand, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpAddressName, expand), serviceCallback);
    }

    public Observable<PublicIPAddressInner> getByResourceGroupAsync(String resourceGroupName, String publicIpAddressName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpAddressName, expand).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPAddressInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PublicIPAddressInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PublicIPAddressInner createOrUpdate(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<PublicIPAddressInner> createOrUpdateAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters), serviceCallback);
    }

    public Observable<PublicIPAddressInner> createOrUpdateAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PublicIPAddressInner>(){}.getType());
    }

    public PublicIPAddressInner beginCreateOrUpdate(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPAddressInner> beginCreateOrUpdateAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters), serviceCallback);
    }

    public Observable<PublicIPAddressInner> beginCreateOrUpdateAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpAddressName, parameters).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName, PublicIPAddressInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPAddressInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PublicIPAddressInner>(){}.getType()).register(201, new TypeToken<PublicIPAddressInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PublicIPAddressInner updateTags(String resourceGroupName, String publicIpAddressName) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpAddressName).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPAddressInner> updateTagsAsync(String resourceGroupName, String publicIpAddressName, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpAddressName), serviceCallback);
    }

    public Observable<PublicIPAddressInner> updateTagsAsync(String resourceGroupName, String publicIpAddressName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpAddressName).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.updateTags(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PublicIPAddressInner updateTags(String resourceGroupName, String publicIpAddressName, Map<String, String> tags) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpAddressName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPAddressInner> updateTagsAsync(String resourceGroupName, String publicIpAddressName, Map<String, String> tags, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpAddressName, tags), serviceCallback);
    }

    public Observable<PublicIPAddressInner> updateTagsAsync(String resourceGroupName, String publicIpAddressName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpAddressName, tags).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String publicIpAddressName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.updateTags(resourceGroupName, publicIpAddressName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPAddressInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PublicIPAddressInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.body()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPAddressInner>> listAsync(ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.body()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPAddressInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listVirtualMachineScaleSetPublicIPAddresses(String resourceGroupName, String virtualMachineScaleSetName) {
        ServiceResponse response = (ServiceResponse)this.listVirtualMachineScaleSetPublicIPAddressesSinglePageAsync(resourceGroupName, virtualMachineScaleSetName).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.body()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listVirtualMachineScaleSetPublicIPAddressesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPAddressInner>> listVirtualMachineScaleSetPublicIPAddressesAsync(String resourceGroupName, String virtualMachineScaleSetName, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listVirtualMachineScaleSetPublicIPAddressesSinglePageAsync(resourceGroupName, virtualMachineScaleSetName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listVirtualMachineScaleSetPublicIPAddressesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listVirtualMachineScaleSetPublicIPAddressesAsync(String resourceGroupName, String virtualMachineScaleSetName) {
        return this.listVirtualMachineScaleSetPublicIPAddressesWithServiceResponseAsync(resourceGroupName, virtualMachineScaleSetName).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listVirtualMachineScaleSetPublicIPAddressesWithServiceResponseAsync(String resourceGroupName, String virtualMachineScaleSetName) {
        return this.listVirtualMachineScaleSetPublicIPAddressesSinglePageAsync(resourceGroupName, virtualMachineScaleSetName).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listVirtualMachineScaleSetPublicIPAddressesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listVirtualMachineScaleSetPublicIPAddressesSinglePageAsync(String resourceGroupName, String virtualMachineScaleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualMachineScaleSetName == null) {
            throw new IllegalArgumentException("Parameter virtualMachineScaleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-10-01";
        return this.service.listVirtualMachineScaleSetPublicIPAddresses(resourceGroupName, virtualMachineScaleSetName, this.client.subscriptionId(), "2018-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listVirtualMachineScaleSetPublicIPAddressesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listVirtualMachineScaleSetPublicIPAddressesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listVirtualMachineScaleSetVMPublicIPAddresses(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName) {
        ServiceResponse response = (ServiceResponse)this.listVirtualMachineScaleSetVMPublicIPAddressesSinglePageAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.body()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listVirtualMachineScaleSetVMPublicIPAddressesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPAddressInner>> listVirtualMachineScaleSetVMPublicIPAddressesAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listVirtualMachineScaleSetVMPublicIPAddressesSinglePageAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listVirtualMachineScaleSetVMPublicIPAddressesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listVirtualMachineScaleSetVMPublicIPAddressesAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName) {
        return this.listVirtualMachineScaleSetVMPublicIPAddressesWithServiceResponseAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listVirtualMachineScaleSetVMPublicIPAddressesWithServiceResponseAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName) {
        return this.listVirtualMachineScaleSetVMPublicIPAddressesSinglePageAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listVirtualMachineScaleSetVMPublicIPAddressesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listVirtualMachineScaleSetVMPublicIPAddressesSinglePageAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualMachineScaleSetName == null) {
            throw new IllegalArgumentException("Parameter virtualMachineScaleSetName is required and cannot be null.");
        }
        if (virtualmachineIndex == null) {
            throw new IllegalArgumentException("Parameter virtualmachineIndex is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (ipConfigurationName == null) {
            throw new IllegalArgumentException("Parameter ipConfigurationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-10-01";
        return this.service.listVirtualMachineScaleSetVMPublicIPAddresses(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, this.client.subscriptionId(), "2018-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listVirtualMachineScaleSetVMPublicIPAddressesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listVirtualMachineScaleSetVMPublicIPAddressesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PublicIPAddressInner getVirtualMachineScaleSetPublicIPAddress(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, String publicIpAddressName) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.getVirtualMachineScaleSetPublicIPAddressWithServiceResponseAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, publicIpAddressName).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPAddressInner> getVirtualMachineScaleSetPublicIPAddressAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, String publicIpAddressName, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getVirtualMachineScaleSetPublicIPAddressWithServiceResponseAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, publicIpAddressName), serviceCallback);
    }

    public Observable<PublicIPAddressInner> getVirtualMachineScaleSetPublicIPAddressAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, String publicIpAddressName) {
        return this.getVirtualMachineScaleSetPublicIPAddressWithServiceResponseAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, publicIpAddressName).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> getVirtualMachineScaleSetPublicIPAddressWithServiceResponseAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, String publicIpAddressName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualMachineScaleSetName == null) {
            throw new IllegalArgumentException("Parameter virtualMachineScaleSetName is required and cannot be null.");
        }
        if (virtualmachineIndex == null) {
            throw new IllegalArgumentException("Parameter virtualmachineIndex is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (ipConfigurationName == null) {
            throw new IllegalArgumentException("Parameter ipConfigurationName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-10-01";
        String expand = null;
        return this.service.getVirtualMachineScaleSetPublicIPAddress(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, publicIpAddressName, this.client.subscriptionId(), "2018-10-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.getVirtualMachineScaleSetPublicIPAddressDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PublicIPAddressInner getVirtualMachineScaleSetPublicIPAddress(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, String publicIpAddressName, String expand) {
        return (PublicIPAddressInner)((Object)((ServiceResponse)this.getVirtualMachineScaleSetPublicIPAddressWithServiceResponseAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, publicIpAddressName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPAddressInner> getVirtualMachineScaleSetPublicIPAddressAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, String publicIpAddressName, String expand, ServiceCallback<PublicIPAddressInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getVirtualMachineScaleSetPublicIPAddressWithServiceResponseAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, publicIpAddressName, expand), serviceCallback);
    }

    public Observable<PublicIPAddressInner> getVirtualMachineScaleSetPublicIPAddressAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, String publicIpAddressName, String expand) {
        return this.getVirtualMachineScaleSetPublicIPAddressWithServiceResponseAsync(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, publicIpAddressName, expand).map((Func1)new Func1<ServiceResponse<PublicIPAddressInner>, PublicIPAddressInner>(){

            public PublicIPAddressInner call(ServiceResponse<PublicIPAddressInner> response) {
                return (PublicIPAddressInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPAddressInner>> getVirtualMachineScaleSetPublicIPAddressWithServiceResponseAsync(String resourceGroupName, String virtualMachineScaleSetName, String virtualmachineIndex, String networkInterfaceName, String ipConfigurationName, String publicIpAddressName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualMachineScaleSetName == null) {
            throw new IllegalArgumentException("Parameter virtualMachineScaleSetName is required and cannot be null.");
        }
        if (virtualmachineIndex == null) {
            throw new IllegalArgumentException("Parameter virtualmachineIndex is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (ipConfigurationName == null) {
            throw new IllegalArgumentException("Parameter ipConfigurationName is required and cannot be null.");
        }
        if (publicIpAddressName == null) {
            throw new IllegalArgumentException("Parameter publicIpAddressName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-10-01";
        return this.service.getVirtualMachineScaleSetPublicIPAddress(resourceGroupName, virtualMachineScaleSetName, virtualmachineIndex, networkInterfaceName, ipConfigurationName, publicIpAddressName, this.client.subscriptionId(), "2018-10-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPAddressInner>>>(){

            public Observable<ServiceResponse<PublicIPAddressInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPAddressesInner.this.getVirtualMachineScaleSetPublicIPAddressDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPAddressInner> getVirtualMachineScaleSetPublicIPAddressDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PublicIPAddressInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.body()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPAddressInner>> listNextAsync(String nextPageLink, ServiceFuture<List<PublicIPAddressInner>> serviceFuture, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.body()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPAddressInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<PublicIPAddressInner>> serviceFuture, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listVirtualMachineScaleSetPublicIPAddressesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listVirtualMachineScaleSetPublicIPAddressesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.body()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listVirtualMachineScaleSetPublicIPAddressesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPAddressInner>> listVirtualMachineScaleSetPublicIPAddressesNextAsync(String nextPageLink, ServiceFuture<List<PublicIPAddressInner>> serviceFuture, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listVirtualMachineScaleSetPublicIPAddressesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listVirtualMachineScaleSetPublicIPAddressesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listVirtualMachineScaleSetPublicIPAddressesNextAsync(String nextPageLink) {
        return this.listVirtualMachineScaleSetPublicIPAddressesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listVirtualMachineScaleSetPublicIPAddressesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listVirtualMachineScaleSetPublicIPAddressesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listVirtualMachineScaleSetPublicIPAddressesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listVirtualMachineScaleSetPublicIPAddressesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listVirtualMachineScaleSetPublicIPAddressesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listVirtualMachineScaleSetPublicIPAddressesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listVirtualMachineScaleSetPublicIPAddressesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPAddressInner> listVirtualMachineScaleSetVMPublicIPAddressesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listVirtualMachineScaleSetVMPublicIPAddressesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPAddressInner>((Page)response.body()){

            public Page<PublicIPAddressInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPAddressesInner.this.listVirtualMachineScaleSetVMPublicIPAddressesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPAddressInner>> listVirtualMachineScaleSetVMPublicIPAddressesNextAsync(String nextPageLink, ServiceFuture<List<PublicIPAddressInner>> serviceFuture, ListOperationCallback<PublicIPAddressInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listVirtualMachineScaleSetVMPublicIPAddressesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(String nextPageLink) {
                return PublicIPAddressesInner.this.listVirtualMachineScaleSetVMPublicIPAddressesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPAddressInner>> listVirtualMachineScaleSetVMPublicIPAddressesNextAsync(String nextPageLink) {
        return this.listVirtualMachineScaleSetVMPublicIPAddressesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Page<PublicIPAddressInner>>(){

            public Page<PublicIPAddressInner> call(ServiceResponse<Page<PublicIPAddressInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listVirtualMachineScaleSetVMPublicIPAddressesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listVirtualMachineScaleSetVMPublicIPAddressesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPAddressInner>>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(ServiceResponse<Page<PublicIPAddressInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPAddressesInner.this.listVirtualMachineScaleSetVMPublicIPAddressesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPAddressInner>>> listVirtualMachineScaleSetVMPublicIPAddressesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listVirtualMachineScaleSetVMPublicIPAddressesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPAddressInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPAddressInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPAddressesInner.this.listVirtualMachineScaleSetVMPublicIPAddressesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPAddressInner>> listVirtualMachineScaleSetVMPublicIPAddressesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPAddressInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PublicIPAddressesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Body PublicIPAddressInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Body PublicIPAddressInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="publicIpAddressName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/publicIPAddresses")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses listVirtualMachineScaleSetPublicIPAddresses"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/publicipaddresses")
        public Observable<Response<ResponseBody>> listVirtualMachineScaleSetPublicIPAddresses(@Path(value="resourceGroupName") String var1, @Path(value="virtualMachineScaleSetName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses listVirtualMachineScaleSetVMPublicIPAddresses"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces/{networkInterfaceName}/ipconfigurations/{ipConfigurationName}/publicipaddresses")
        public Observable<Response<ResponseBody>> listVirtualMachineScaleSetVMPublicIPAddresses(@Path(value="resourceGroupName") String var1, @Path(value="virtualMachineScaleSetName") String var2, @Path(value="virtualmachineIndex") String var3, @Path(value="networkInterfaceName") String var4, @Path(value="ipConfigurationName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses getVirtualMachineScaleSetPublicIPAddress"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces/{networkInterfaceName}/ipconfigurations/{ipConfigurationName}/publicipaddresses/{publicIpAddressName}")
        public Observable<Response<ResponseBody>> getVirtualMachineScaleSetPublicIPAddress(@Path(value="resourceGroupName") String var1, @Path(value="virtualMachineScaleSetName") String var2, @Path(value="virtualmachineIndex") String var3, @Path(value="networkInterfaceName") String var4, @Path(value="ipConfigurationName") String var5, @Path(value="publicIpAddressName") String var6, @Path(value="subscriptionId") String var7, @Query(value="api-version") String var8, @Query(value="$expand") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses listVirtualMachineScaleSetPublicIPAddressesNext"})
        @GET
        public Observable<Response<ResponseBody>> listVirtualMachineScaleSetPublicIPAddressesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPAddresses listVirtualMachineScaleSetVMPublicIPAddressesNext"})
        @GET
        public Observable<Response<ResponseBody>> listVirtualMachineScaleSetVMPublicIPAddressesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

