/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.ServiceTagsListResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServiceTagsInner {
    private ServiceTagsService service;
    private NetworkManagementClientImpl client;

    public ServiceTagsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ServiceTagsService)retrofit.create(ServiceTagsService.class);
        this.client = client;
    }

    public ServiceTagsListResultInner list(String location) {
        return (ServiceTagsListResultInner)((ServiceResponse)this.listWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    public ServiceFuture<ServiceTagsListResultInner> listAsync(String location, ServiceCallback<ServiceTagsListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(location), serviceCallback);
    }

    public Observable<ServiceTagsListResultInner> listAsync(String location) {
        return this.listWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<ServiceTagsListResultInner>, ServiceTagsListResultInner>(){

            public ServiceTagsListResultInner call(ServiceResponse<ServiceTagsListResultInner> response) {
                return (ServiceTagsListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServiceTagsListResultInner>> listWithServiceResponseAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(location, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceTagsListResultInner>>>(){

            public Observable<ServiceResponse<ServiceTagsListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceTagsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceTagsListResultInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceTagsListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServiceTagsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceTags list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/serviceTags")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

