/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPConfiguration;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NicIPConfiguration;
import com.microsoft.azure.management.network.RouteTable;
import com.microsoft.azure.management.network.ServiceEndpointPropertiesFormat;
import com.microsoft.azure.management.network.ServiceEndpointType;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.IPAddressAvailabilityResultInner;
import com.microsoft.azure.management.network.implementation.NetworkImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupInner;
import com.microsoft.azure.management.network.implementation.RouteTableInner;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworksInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@LangDefinition
class SubnetImpl
extends ChildResourceImpl<SubnetInner, NetworkImpl, Network>
implements Subnet,
Subnet.Definition<Network.DefinitionStages.WithCreateAndSubnet>,
Subnet.UpdateDefinition<Network.Update>,
Subnet.Update {
    SubnetImpl(SubnetInner inner, NetworkImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public int networkInterfaceIPConfigurationCount() {
        List<IPConfiguration> ipConfigRefs = ((SubnetInner)((Object)this.inner())).ipConfigurations();
        if (ipConfigRefs != null) {
            return ipConfigRefs.size();
        }
        return 0;
    }

    @Override
    public String addressPrefix() {
        return ((SubnetInner)((Object)this.inner())).addressPrefix();
    }

    public String name() {
        return ((SubnetInner)((Object)this.inner())).name();
    }

    @Override
    public String networkSecurityGroupId() {
        return ((SubnetInner)((Object)this.inner())).networkSecurityGroup() != null ? ((SubnetInner)((Object)this.inner())).networkSecurityGroup().id() : null;
    }

    @Override
    public String routeTableId() {
        return ((SubnetInner)((Object)this.inner())).routeTable() != null ? ((SubnetInner)((Object)this.inner())).routeTable().id() : null;
    }

    @Override
    public Map<ServiceEndpointType, List<Region>> servicesWithAccess() {
        HashMap<ServiceEndpointType, List<Region>> services = new HashMap<ServiceEndpointType, List<Region>>();
        if (((SubnetInner)((Object)this.inner())).serviceEndpoints() != null) {
            for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)((Object)this.inner())).serviceEndpoints()) {
                ServiceEndpointType serviceEndpointType = ServiceEndpointType.fromString(endpoint.service());
                if (!services.containsKey((Object)serviceEndpointType)) {
                    services.put(serviceEndpointType, new ArrayList());
                }
                if (endpoint.locations() == null) continue;
                ArrayList<Region> regions = new ArrayList<Region>();
                for (String location : endpoint.locations()) {
                    regions.add(Region.fromName((String)location));
                }
                ((List)services.get((Object)serviceEndpointType)).addAll(regions);
            }
        }
        return services;
    }

    @Override
    public SubnetImpl withoutNetworkSecurityGroup() {
        ((SubnetInner)((Object)this.inner())).withNetworkSecurityGroup(null);
        return this;
    }

    @Override
    public SubnetImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup nsg) {
        return this.withExistingNetworkSecurityGroup(nsg.id());
    }

    @Override
    public SubnetImpl withExistingNetworkSecurityGroup(String resourceId) {
        NetworkSecurityGroupInner reference = new NetworkSecurityGroupInner().withId(resourceId);
        ((SubnetInner)((Object)this.inner())).withNetworkSecurityGroup(reference);
        return this;
    }

    @Override
    public SubnetImpl withExistingRouteTable(String resourceId) {
        RouteTableInner reference = new RouteTableInner().withId(resourceId);
        ((SubnetInner)((Object)this.inner())).withRouteTable(reference);
        return this;
    }

    @Override
    public SubnetImpl withExistingRouteTable(RouteTable routeTable) {
        return this.withExistingRouteTable(routeTable.id());
    }

    @Override
    public Subnet.Update withoutRouteTable() {
        ((SubnetInner)((Object)this.inner())).withRouteTable(null);
        return this;
    }

    @Override
    public SubnetImpl withAddressPrefix(String cidr) {
        ((SubnetInner)((Object)this.inner())).withAddressPrefix(cidr);
        return this;
    }

    @Override
    public SubnetImpl withAccessFromService(ServiceEndpointType service) {
        if (((SubnetInner)((Object)this.inner())).serviceEndpoints() == null) {
            ((SubnetInner)((Object)this.inner())).withServiceEndpoints(new ArrayList<ServiceEndpointPropertiesFormat>());
        }
        boolean found = false;
        for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)((Object)this.inner())).serviceEndpoints()) {
            if (!endpoint.service().equalsIgnoreCase(service.toString())) continue;
            found = true;
            break;
        }
        if (!found) {
            ((SubnetInner)((Object)this.inner())).serviceEndpoints().add(new ServiceEndpointPropertiesFormat().withService(service.toString()).withLocations(new ArrayList<String>()));
        }
        return this;
    }

    @Override
    public Subnet.Update withoutAccessFromService(ServiceEndpointType service) {
        if (((SubnetInner)((Object)this.inner())).serviceEndpoints() != null) {
            int foundIndex = -1;
            int i = 0;
            for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)((Object)this.inner())).serviceEndpoints()) {
                if (endpoint.service().equalsIgnoreCase(service.toString())) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex != -1) {
                ((SubnetInner)((Object)this.inner())).serviceEndpoints().remove(foundIndex);
            }
        }
        return this;
    }

    public NetworkImpl attach() {
        return ((NetworkImpl)this.parent()).withSubnet(this);
    }

    @Override
    public RouteTable getRouteTable() {
        return this.routeTableId() != null ? (RouteTable)((NetworkManager)((NetworkImpl)this.parent()).manager()).routeTables().getById(this.routeTableId()) : null;
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        String nsgId = this.networkSecurityGroupId();
        return nsgId != null ? (NetworkSecurityGroup)((NetworkManager)((NetworkImpl)this.parent()).manager()).networkSecurityGroups().getById(nsgId) : null;
    }

    @Override
    public Set<NicIPConfiguration> getNetworkInterfaceIPConfigurations() {
        return Collections.unmodifiableSet(new TreeSet<NicIPConfiguration>(this.listNetworkInterfaceIPConfigurations()));
    }

    @Override
    public Collection<NicIPConfiguration> listNetworkInterfaceIPConfigurations() {
        ArrayList<NicIPConfiguration> ipConfigs = new ArrayList<NicIPConfiguration>();
        TreeMap<String, NetworkInterface> nics = new TreeMap<String, NetworkInterface>();
        List<IPConfiguration> ipConfigRefs = ((SubnetInner)((Object)this.inner())).ipConfigurations();
        if (ipConfigRefs == null) {
            return ipConfigs;
        }
        for (IPConfiguration ipConfigRef : ipConfigRefs) {
            String nicID = ResourceUtils.parentResourceIdFromResourceId((String)ipConfigRef.id());
            String ipConfigName = ResourceUtils.nameFromResourceId((String)ipConfigRef.id());
            NetworkInterface nic = (NetworkInterface)nics.get(nicID.toLowerCase());
            if (nic == null) {
                nic = (NetworkInterface)((NetworkManager)((NetworkImpl)this.parent()).manager()).networkInterfaces().getById(nicID);
            }
            if (nic == null) continue;
            nics.put(nic.id().toLowerCase(), nic);
            NicIPConfiguration ipConfig = nic.ipConfigurations().get(ipConfigName);
            if (ipConfig == null) continue;
            ipConfigs.add(ipConfig);
        }
        return Collections.unmodifiableCollection(ipConfigs);
    }

    @Override
    public Set<String> listAvailablePrivateIPAddresses() {
        TreeSet<String> ipAddresses = new TreeSet<String>();
        String cidr = this.addressPrefix();
        if (cidr == null) {
            return ipAddresses;
        }
        String takenIPAddress = cidr.split("/")[0];
        IPAddressAvailabilityResultInner result = ((VirtualNetworksInner)((NetworkManager)((NetworkImpl)this.parent()).manager()).networks().inner()).checkIPAddressAvailability(((NetworkImpl)this.parent()).resourceGroupName(), ((NetworkImpl)this.parent()).name(), takenIPAddress);
        if (result == null) {
            return ipAddresses;
        }
        ipAddresses.addAll(result.availableIPAddresses());
        return ipAddresses;
    }
}

