/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VirtualRouterInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualRoutersInner
implements InnerSupportsGet<VirtualRouterInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<VirtualRouterInner> {
    private VirtualRoutersService service;
    private NetworkManagementClientImpl client;

    public VirtualRoutersInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VirtualRoutersService)retrofit.create(VirtualRoutersService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String virtualRouterName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualRouterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualRouterName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualRouterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, virtualRouterName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualRouterName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualRouterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualRouterName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualRouterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, virtualRouterName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualRoutersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VirtualRouterInner getByResourceGroup(String resourceGroupName, String virtualRouterName) {
        return (VirtualRouterInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualRouterInner> getByResourceGroupAsync(String resourceGroupName, String virtualRouterName, ServiceCallback<VirtualRouterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName), serviceCallback);
    }

    public Observable<VirtualRouterInner> getByResourceGroupAsync(String resourceGroupName, String virtualRouterName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName).map((Func1)new Func1<ServiceResponse<VirtualRouterInner>, VirtualRouterInner>(){

            public VirtualRouterInner call(ServiceResponse<VirtualRouterInner> response) {
                return (VirtualRouterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualRouterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualRouterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, virtualRouterName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterInner>>>(){

            public Observable<ServiceResponse<VirtualRouterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualRoutersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualRouterInner getByResourceGroup(String resourceGroupName, String virtualRouterName, String expand) {
        return (VirtualRouterInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualRouterInner> getByResourceGroupAsync(String resourceGroupName, String virtualRouterName, String expand, ServiceCallback<VirtualRouterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName, expand), serviceCallback);
    }

    public Observable<VirtualRouterInner> getByResourceGroupAsync(String resourceGroupName, String virtualRouterName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName, expand).map((Func1)new Func1<ServiceResponse<VirtualRouterInner>, VirtualRouterInner>(){

            public VirtualRouterInner call(ServiceResponse<VirtualRouterInner> response) {
                return (VirtualRouterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualRouterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, virtualRouterName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterInner>>>(){

            public Observable<ServiceResponse<VirtualRouterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualRoutersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualRouterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualRouterInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VirtualRouterInner createOrUpdate(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        return (VirtualRouterInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualRouterInner> createOrUpdateAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters, ServiceCallback<VirtualRouterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters), serviceCallback);
    }

    public Observable<VirtualRouterInner> createOrUpdateAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters).map((Func1)new Func1<ServiceResponse<VirtualRouterInner>, VirtualRouterInner>(){

            public VirtualRouterInner call(ServiceResponse<VirtualRouterInner> response) {
                return (VirtualRouterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualRouterInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, virtualRouterName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualRouterInner>(){}.getType());
    }

    public VirtualRouterInner beginCreateOrUpdate(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        return (VirtualRouterInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualRouterInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters, ServiceCallback<VirtualRouterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters), serviceCallback);
    }

    public Observable<VirtualRouterInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters).map((Func1)new Func1<ServiceResponse<VirtualRouterInner>, VirtualRouterInner>(){

            public VirtualRouterInner call(ServiceResponse<VirtualRouterInner> response) {
                return (VirtualRouterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualRouterInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, virtualRouterName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterInner>>>(){

            public Observable<ServiceResponse<VirtualRouterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualRoutersInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualRouterInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualRouterInner>(){}.getType()).register(201, new TypeToken<VirtualRouterInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualRouterInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualRouterInner>((Page)response.body()){

            public Page<VirtualRouterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualRoutersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualRouterInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VirtualRouterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(String nextPageLink) {
                return VirtualRoutersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualRouterInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VirtualRouterInner>>, Page<VirtualRouterInner>>(){

            public Page<VirtualRouterInner> call(ServiceResponse<Page<VirtualRouterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualRouterInner>>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(ServiceResponse<Page<VirtualRouterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualRoutersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualRoutersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualRouterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualRouterInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualRouterInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualRouterInner>((Page)response.body()){

            public Page<VirtualRouterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualRoutersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualRouterInner>> listAsync(ListOperationCallback<VirtualRouterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(String nextPageLink) {
                return VirtualRoutersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualRouterInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VirtualRouterInner>>, Page<VirtualRouterInner>>(){

            public Page<VirtualRouterInner> call(ServiceResponse<Page<VirtualRouterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VirtualRouterInner>>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(ServiceResponse<Page<VirtualRouterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualRoutersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualRoutersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualRouterInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualRouterInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualRouterInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualRouterInner>((Page)response.body()){

            public Page<VirtualRouterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualRoutersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualRouterInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VirtualRouterInner>> serviceFuture, ListOperationCallback<VirtualRouterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(String nextPageLink) {
                return VirtualRoutersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualRouterInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualRouterInner>>, Page<VirtualRouterInner>>(){

            public Page<VirtualRouterInner> call(ServiceResponse<Page<VirtualRouterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualRouterInner>>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(ServiceResponse<Page<VirtualRouterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualRoutersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualRoutersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualRouterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualRouterInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualRouterInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualRouterInner>((Page)response.body()){

            public Page<VirtualRouterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualRoutersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualRouterInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualRouterInner>> serviceFuture, ListOperationCallback<VirtualRouterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(String nextPageLink) {
                return VirtualRoutersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualRouterInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualRouterInner>>, Page<VirtualRouterInner>>(){

            public Page<VirtualRouterInner> call(ServiceResponse<Page<VirtualRouterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualRouterInner>>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(ServiceResponse<Page<VirtualRouterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualRoutersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualRoutersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualRouterInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualRouterInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface VirtualRoutersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualRouterInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualRouterInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualRouters")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

