/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.IpGroupInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class IpGroupsInner
implements InnerSupportsGet<IpGroupInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<IpGroupInner> {
    private IpGroupsService service;
    private NetworkManagementClientImpl client;

    public IpGroupsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (IpGroupsService)retrofit.create(IpGroupsService.class);
        this.client = client;
    }

    public IpGroupInner getByResourceGroup(String resourceGroupName, String ipGroupsName) {
        return (IpGroupInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName).toBlocking().single()).body());
    }

    public ServiceFuture<IpGroupInner> getByResourceGroupAsync(String resourceGroupName, String ipGroupsName, ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName), serviceCallback);
    }

    public Observable<IpGroupInner> getByResourceGroupAsync(String resourceGroupName, String ipGroupsName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName).map((Func1)new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>(){

            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return (IpGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<IpGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ipGroupsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, ipGroupsName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>(){

            public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = IpGroupsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public IpGroupInner getByResourceGroup(String resourceGroupName, String ipGroupsName, String expand) {
        return (IpGroupInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<IpGroupInner> getByResourceGroupAsync(String resourceGroupName, String ipGroupsName, String expand, ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName, expand), serviceCallback);
    }

    public Observable<IpGroupInner> getByResourceGroupAsync(String resourceGroupName, String ipGroupsName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName, expand).map((Func1)new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>(){

            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return (IpGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<IpGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ipGroupsName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, ipGroupsName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>(){

            public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = IpGroupsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IpGroupInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<IpGroupInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public IpGroupInner createOrUpdate(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        return (IpGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<IpGroupInner> createOrUpdateAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters, ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters), serviceCallback);
    }

    public Observable<IpGroupInner> createOrUpdateAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters).map((Func1)new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>(){

            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return (IpGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<IpGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, ipGroupsName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<IpGroupInner>(){}.getType());
    }

    public IpGroupInner beginCreateOrUpdate(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        return (IpGroupInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<IpGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters, ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters), serviceCallback);
    }

    public Observable<IpGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters).map((Func1)new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>(){

            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return (IpGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<IpGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, ipGroupsName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>(){

            public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = IpGroupsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IpGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<IpGroupInner>(){}.getType()).register(201, new TypeToken<IpGroupInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public IpGroupInner updateGroups(String resourceGroupName, String ipGroupsName) {
        return (IpGroupInner)((Object)((ServiceResponse)this.updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName).toBlocking().single()).body());
    }

    public ServiceFuture<IpGroupInner> updateGroupsAsync(String resourceGroupName, String ipGroupsName, ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName), serviceCallback);
    }

    public Observable<IpGroupInner> updateGroupsAsync(String resourceGroupName, String ipGroupsName) {
        return this.updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName).map((Func1)new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>(){

            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return (IpGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<IpGroupInner>> updateGroupsWithServiceResponseAsync(String resourceGroupName, String ipGroupsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.updateGroups(resourceGroupName, ipGroupsName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>(){

            public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = IpGroupsInner.this.updateGroupsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public IpGroupInner updateGroups(String resourceGroupName, String ipGroupsName, Map<String, String> tags) {
        return (IpGroupInner)((Object)((ServiceResponse)this.updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<IpGroupInner> updateGroupsAsync(String resourceGroupName, String ipGroupsName, Map<String, String> tags, ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName, tags), serviceCallback);
    }

    public Observable<IpGroupInner> updateGroupsAsync(String resourceGroupName, String ipGroupsName, Map<String, String> tags) {
        return this.updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName, tags).map((Func1)new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>(){

            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return (IpGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<IpGroupInner>> updateGroupsWithServiceResponseAsync(String resourceGroupName, String ipGroupsName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.updateGroups(resourceGroupName, ipGroupsName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>(){

            public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = IpGroupsInner.this.updateGroupsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IpGroupInner> updateGroupsDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<IpGroupInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public void delete(String resourceGroupName, String ipGroupsName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, ipGroupsName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String ipGroupsName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, ipGroupsName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String ipGroupsName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, ipGroupsName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String ipGroupsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, ipGroupsName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String ipGroupsName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, ipGroupsName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String ipGroupsName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, ipGroupsName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String ipGroupsName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, ipGroupsName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String ipGroupsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, ipGroupsName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = IpGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<IpGroupInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<IpGroupInner>((Page)response.body()){

            public Page<IpGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)IpGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<IpGroupInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<IpGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(String nextPageLink) {
                return IpGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<IpGroupInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<IpGroupInner>>, Page<IpGroupInner>>(){

            public Page<IpGroupInner> call(ServiceResponse<Page<IpGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<IpGroupInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<IpGroupInner>>, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(ServiceResponse<Page<IpGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(IpGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<IpGroupInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = IpGroupsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<IpGroupInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<IpGroupInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<IpGroupInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<IpGroupInner>((Page)response.body()){

            public Page<IpGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)IpGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<IpGroupInner>> listAsync(ListOperationCallback<IpGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(String nextPageLink) {
                return IpGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<IpGroupInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<IpGroupInner>>, Page<IpGroupInner>>(){

            public Page<IpGroupInner> call(ServiceResponse<Page<IpGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<IpGroupInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<IpGroupInner>>, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(ServiceResponse<Page<IpGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(IpGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<IpGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = IpGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<IpGroupInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<IpGroupInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<IpGroupInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<IpGroupInner>((Page)response.body()){

            public Page<IpGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)IpGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<IpGroupInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<IpGroupInner>> serviceFuture, ListOperationCallback<IpGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(String nextPageLink) {
                return IpGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<IpGroupInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<IpGroupInner>>, Page<IpGroupInner>>(){

            public Page<IpGroupInner> call(ServiceResponse<Page<IpGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<IpGroupInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<IpGroupInner>>, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(ServiceResponse<Page<IpGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(IpGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<IpGroupInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = IpGroupsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<IpGroupInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<IpGroupInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<IpGroupInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<IpGroupInner>((Page)response.body()){

            public Page<IpGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)IpGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<IpGroupInner>> listNextAsync(String nextPageLink, ServiceFuture<List<IpGroupInner>> serviceFuture, ListOperationCallback<IpGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(String nextPageLink) {
                return IpGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<IpGroupInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<IpGroupInner>>, Page<IpGroupInner>>(){

            public Page<IpGroupInner> call(ServiceResponse<Page<IpGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<IpGroupInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<IpGroupInner>>, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(ServiceResponse<Page<IpGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(IpGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<IpGroupInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IpGroupInner>>>>(){

            public Observable<ServiceResponse<Page<IpGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = IpGroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<IpGroupInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<IpGroupInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface IpGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="ipGroupsName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="ipGroupsName") String var2, @Path(value="subscriptionId") String var3, @Body IpGroupInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="ipGroupsName") String var2, @Path(value="subscriptionId") String var3, @Body IpGroupInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups updateGroups"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}")
        public Observable<Response<ResponseBody>> updateGroups(@Path(value="resourceGroupName") String var1, @Path(value="ipGroupsName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="ipGroupsName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="ipGroupsName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/ipGroups")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

