/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PeerExpressRouteCircuitConnectionInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PeerExpressRouteCircuitConnectionsInner {
    private PeerExpressRouteCircuitConnectionsService service;
    private NetworkManagementClientImpl client;

    public PeerExpressRouteCircuitConnectionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (PeerExpressRouteCircuitConnectionsService)retrofit.create(PeerExpressRouteCircuitConnectionsService.class);
        this.client = client;
    }

    public PeerExpressRouteCircuitConnectionInner get(String resourceGroupName, String circuitName, String peeringName, String connectionName) {
        return (PeerExpressRouteCircuitConnectionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, circuitName, peeringName, connectionName).toBlocking().single()).body());
    }

    public ServiceFuture<PeerExpressRouteCircuitConnectionInner> getAsync(String resourceGroupName, String circuitName, String peeringName, String connectionName, ServiceCallback<PeerExpressRouteCircuitConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, circuitName, peeringName, connectionName), serviceCallback);
    }

    public Observable<PeerExpressRouteCircuitConnectionInner> getAsync(String resourceGroupName, String circuitName, String peeringName, String connectionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, circuitName, peeringName, connectionName).map((Func1)new Func1<ServiceResponse<PeerExpressRouteCircuitConnectionInner>, PeerExpressRouteCircuitConnectionInner>(){

            public PeerExpressRouteCircuitConnectionInner call(ServiceResponse<PeerExpressRouteCircuitConnectionInner> response) {
                return (PeerExpressRouteCircuitConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PeerExpressRouteCircuitConnectionInner>> getWithServiceResponseAsync(String resourceGroupName, String circuitName, String peeringName, String connectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (circuitName == null) {
            throw new IllegalArgumentException("Parameter circuitName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, circuitName, peeringName, connectionName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PeerExpressRouteCircuitConnectionInner>>>(){

            public Observable<ServiceResponse<PeerExpressRouteCircuitConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PeerExpressRouteCircuitConnectionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PeerExpressRouteCircuitConnectionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PeerExpressRouteCircuitConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PeerExpressRouteCircuitConnectionInner> list(String resourceGroupName, String circuitName, String peeringName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, circuitName, peeringName).toBlocking().single();
        return new PagedList<PeerExpressRouteCircuitConnectionInner>((Page)response.body()){

            public Page<PeerExpressRouteCircuitConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PeerExpressRouteCircuitConnectionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PeerExpressRouteCircuitConnectionInner>> listAsync(String resourceGroupName, String circuitName, String peeringName, ListOperationCallback<PeerExpressRouteCircuitConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, circuitName, peeringName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> call(String nextPageLink) {
                return PeerExpressRouteCircuitConnectionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PeerExpressRouteCircuitConnectionInner>> listAsync(String resourceGroupName, String circuitName, String peeringName) {
        return this.listWithServiceResponseAsync(resourceGroupName, circuitName, peeringName).map((Func1)new Func1<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>, Page<PeerExpressRouteCircuitConnectionInner>>(){

            public Page<PeerExpressRouteCircuitConnectionInner> call(ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> listWithServiceResponseAsync(String resourceGroupName, String circuitName, String peeringName) {
        return this.listSinglePageAsync(resourceGroupName, circuitName, peeringName).concatMap((Func1)new Func1<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>, Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> call(ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PeerExpressRouteCircuitConnectionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> listSinglePageAsync(String resourceGroupName, String circuitName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (circuitName == null) {
            throw new IllegalArgumentException("Parameter circuitName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, circuitName, peeringName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PeerExpressRouteCircuitConnectionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PeerExpressRouteCircuitConnectionInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PeerExpressRouteCircuitConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PeerExpressRouteCircuitConnectionInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PeerExpressRouteCircuitConnectionInner>((Page)response.body()){

            public Page<PeerExpressRouteCircuitConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PeerExpressRouteCircuitConnectionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PeerExpressRouteCircuitConnectionInner>> listNextAsync(String nextPageLink, ServiceFuture<List<PeerExpressRouteCircuitConnectionInner>> serviceFuture, ListOperationCallback<PeerExpressRouteCircuitConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> call(String nextPageLink) {
                return PeerExpressRouteCircuitConnectionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PeerExpressRouteCircuitConnectionInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>, Page<PeerExpressRouteCircuitConnectionInner>>(){

            public Page<PeerExpressRouteCircuitConnectionInner> call(ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>, Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> call(ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PeerExpressRouteCircuitConnectionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PeerExpressRouteCircuitConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PeerExpressRouteCircuitConnectionsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PeerExpressRouteCircuitConnectionInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PeerExpressRouteCircuitConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PeerExpressRouteCircuitConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PeerExpressRouteCircuitConnections get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/peerConnections/{connectionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="circuitName") String var2, @Path(value="peeringName") String var3, @Path(value="connectionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PeerExpressRouteCircuitConnections list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/peerConnections")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="circuitName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PeerExpressRouteCircuitConnections listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

