/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.models.ListBlobsIncludeItem;
import java.util.ArrayList;

public final class BlobListingDetails {
    public static final BlobListingDetails NONE = new BlobListingDetails();
    private boolean copy;
    private boolean metadata;
    private boolean snapshots;
    private boolean uncommittedBlobs;
    private boolean deletedBlobs;

    public boolean copy() {
        return this.copy;
    }

    public BlobListingDetails withCopy(boolean copy) {
        this.copy = copy;
        return this;
    }

    public boolean metadata() {
        return this.metadata;
    }

    public BlobListingDetails withMetadata(boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean snapshots() {
        return this.snapshots;
    }

    public BlobListingDetails withSnapshots(boolean snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    public boolean uncommittedBlobs() {
        return this.uncommittedBlobs;
    }

    public BlobListingDetails withUncommittedBlobs(boolean uncommittedBlobs) {
        this.uncommittedBlobs = uncommittedBlobs;
        return this;
    }

    public boolean deletedBlobs() {
        return this.deletedBlobs;
    }

    public BlobListingDetails withDeletedBlobs(boolean deletedBlobs) {
        this.deletedBlobs = deletedBlobs;
        return this;
    }

    ArrayList<ListBlobsIncludeItem> toList() {
        ArrayList<ListBlobsIncludeItem> details = new ArrayList<ListBlobsIncludeItem>();
        if (this.copy) {
            details.add(ListBlobsIncludeItem.COPY);
        }
        if (this.deletedBlobs) {
            details.add(ListBlobsIncludeItem.DELETED);
        }
        if (this.metadata) {
            details.add(ListBlobsIncludeItem.METADATA);
        }
        if (this.snapshots) {
            details.add(ListBlobsIncludeItem.SNAPSHOTS);
        }
        if (this.uncommittedBlobs) {
            details.add(ListBlobsIncludeItem.UNCOMMITTEDBLOBS);
        }
        return details;
    }
}

