/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.util.Locale;

public final class BlobRange {
    public static final BlobRange DEFAULT = new BlobRange();
    private long offset;
    private Long count;

    public long offset() {
        return this.offset;
    }

    public BlobRange withOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("BlobRange offset must be greater than or equal to 0.");
        }
        this.offset = offset;
        return this;
    }

    public Long count() {
        return this.count;
    }

    public BlobRange withCount(Long count) {
        if (count != null && count < 0L) {
            throw new IllegalArgumentException("BlobRange count must be greater than or equal to 0 if specified.");
        }
        this.count = count;
        return this;
    }

    public String toString() {
        if (this.count != null) {
            long rangeEnd = this.offset + this.count - 1L;
            return String.format(Locale.ROOT, "bytes=%d-%d", this.offset, rangeEnd);
        }
        return String.format(Locale.ROOT, "bytes=%d-", this.offset);
    }
}

