/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.models.BlockBlobCommitBlockListResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobGetBlockListResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobStageBlockFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobStageBlockResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobUploadResponse;
import com.microsoft.azure.storage.blob.models.BlockListType;
import com.microsoft.azure.storage.blob.models.BlockLookupList;
import com.microsoft.azure.storage.blob.models.LeaseAccessConditions;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;

public final class BlockBlobURL
extends BlobURL {
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final int MAX_BLOCKS = 50000;

    public BlockBlobURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    @Override
    public BlockBlobURL withPipeline(HttpPipeline pipeline) {
        try {
            return new BlockBlobURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public BlockBlobURL withSnapshot(String snapshot) throws MalformedURLException, UnknownHostException {
        BlobURLParts blobURLParts = URLParser.parse(new URL(this.storageClient.url()));
        blobURLParts.withSnapshot(snapshot);
        return new BlockBlobURL(blobURLParts.toURL(), this.storageClient.httpPipeline());
    }

    public Single<BlockBlobUploadResponse> upload(Flowable<ByteBuffer> data, long length, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Context context) {
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().uploadWithRestResponseAsync(context, data, length, null, metadata, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<BlockBlobStageBlockResponse> stageBlock(String base64BlockID, Flowable<ByteBuffer> data, long length, LeaseAccessConditions leaseAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().stageBlockWithRestResponseAsync(context, base64BlockID, length, data, null, null, null, leaseAccessConditions));
    }

    public Single<BlockBlobStageBlockFromURLResponse> stageBlockFromURL(String base64BlockID, URL sourceURL, BlobRange sourceRange, byte[] sourceContentMD5, LeaseAccessConditions leaseAccessConditions, Context context) {
        sourceRange = sourceRange == null ? BlobRange.DEFAULT : sourceRange;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().stageBlockFromURLWithRestResponseAsync(context, base64BlockID, 0L, sourceURL, sourceRange.toString(), sourceContentMD5, null, null, leaseAccessConditions));
    }

    public Single<BlockBlobGetBlockListResponse> getBlockList(BlockListType listType, LeaseAccessConditions leaseAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().getBlockListWithRestResponseAsync(context, listType, null, null, null, leaseAccessConditions));
    }

    public Single<BlockBlobCommitBlockListResponse> commitBlockList(List<String> base64BlockIDs, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Context context) {
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().commitBlockListWithRestResponseAsync(context, new BlockLookupList().withLatest(base64BlockIDs), null, metadata, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }
}

